from abc import ABCMeta, abstractproperty

import six


@six.add_metaclass(ABCMeta)
class RevisionProblem(object):

    def __init__(self, revision, test_name=None, **kwargs):
        self.revision = revision
        self.test_name = test_name
        for k, v in kwargs.items():
            setattr(self, k, v)

    @abstractproperty
    def template(self):
        pass

    @abstractproperty
    def snippet(self):
        pass

    def __str__(self):
        return self.template.format(self=self)


@six.add_metaclass(ABCMeta)
class IntervalProblem(object):

    def __init__(self, first_revision, last_revision, **kwargs):
        self.first_revision = first_revision
        self.last_revision = last_revision

        for k, v in kwargs.items():
            setattr(self, k, v)

    @abstractproperty
    def template(self):
        pass

    @abstractproperty
    def snippet(self):
        pass

    def __str__(self):
        return self.template.format(self=self)


class UnresolvedProblem(IntervalProblem):
    template = "Unresolved problem by {self.owner} at r{self.first_revision}-r{self.last_revision} for {self.test_name}"

    @property
    def snippet(self):
        problem_url = "https://testenv.yandex-team.ru/?screen=revision_problems&database={self.database}&revision={self.last_revision}".format(self=self)
        return '<a href="{url}" target="_blank">{self.test_name}</a>'.format(self=self, url=problem_url)


class UncheckedInterval(IntervalProblem):
    template = "Unchecked interval {self.first_revision}-{self.last_revision} for {self.test_name}"

    @property
    def snippet(self):
        return "{self.test_name}: {self.first_revision}-{self.last_revision}".format(self=self)


class IgnoredInterval(IntervalProblem):
    template = "Blocked interval {self.first_revision}-{self.last_revision}: {self.comment}"

    @property
    def snippet(self):
        return "{self.first_revision}-{self.last_revision}: {self.comment}".format(self=self)


class CheckTestIsNotOK(RevisionProblem):
    template = "Test {self.test_name} is not in OK state at r{self.revision}"

    @property
    def snippet(self):
        return self.test_name
