from sandbox.projects.release_machine.core import const as rm_const


LAUNCH_INFO_FINAL_STATUS_KEY = 'final_status'
LAUNCH_INFO_STATUS_KEY = 'status'

INITIAL_SLEEP_TIME = 30   # 30 seconds
MAX_SLEEP_TIME = 15 * 60  # 15 minutes
BACKOFF_FACTOR = 1.5   # increase wait time factor
FAIL_THRESHOLD = 2 * 24 * 60 * 60  # 2 days

OUTPUT_NAME = "metrics_launch_fails"
DATETIME_KEY = "datetime"
CHECK_NUM_TEMPLATE = "check_num_{}"

# Default enrichment options for task manual runs
MANUAL_RUNS_ENRICHMENT_QUOTA = {
    rm_const.SearchSubtypes.WEB: {
        "angQuota": "WEB High Priority",
        "labels": "WEB_High_Priority",
    },
}

# Constant message to describe problems with acceptance tests
TEST_WARNING_MESSAGE = (
    "Zero diff, broken wizard check. Please refer to issue UPS-12 (and reopen it) or "
    "report this problem to United Priemka Support chat: {}".format(rm_const.Urls.UPS_INVITE_LINK)
)

TEMPLATE_SOURCE_ARCADIA = "arcadia"               # Load template from the given Arcadia path
TEMPLATE_SOURCE_RESOURCE = "resource"             # Load template from the given resource
TEMPLATE_SOURCE_LAST_RELEASED = "last_released"   # Find latest released resource and load template form it
