# -*- coding: utf-8 -*-

import sandbox.projects.release_machine.components.all as rmc
import sandbox.projects.common.build.parameters as build_params

from sandbox import sdk2
from sandbox.projects.release_machine import yappy as yappy_helper
from sandbox.projects.release_machine import input_params2 as rm_params
from sandbox.projects.release_machine import resources as rm_resources
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine.tasks.LaunchMetrics import const as lm_const


class LaunchMetricsParameters(rm_params.BaseReleaseMachineParameters):
    """LaunchMetrics task parameters"""

    with sdk2.parameters.String("Metrics mode") as metrics_mode_type:
        metrics_mode_type.values.custom = metrics_mode_type.Value("Custom", default=True)
        metrics_mode_type.values.release_machine = "Release machine"

    with metrics_mode_type.value.release_machine:
        with sdk2.parameters.String("Component name", default="", required=True) as component_name:
            rm_params.set_choices(component_name, rmc.get_component_names())
        release_number = sdk2.parameters.Integer("Release number")
        minor_release_number = sdk2.parameters.Integer("Minor release number", default=0, required=False)
        silent_mode = sdk2.parameters.Bool("Disable comments")
        wait_consistency = sdk2.parameters.Bool(
            "Wait Sample and Checked betas consistency (Only for Yappy betas)", default=True
        )
        with wait_consistency.value[True]:
            max_wait_num = sdk2.parameters.Integer(
                "Max amount of attempts of waiting consistency",
                default=yappy_helper.MAX_WAIT_NUM,
            )
        beta_conf_type = sdk2.parameters.String("Beta configuration type")

    with sdk2.parameters.String("Search subtype") as search_subtype:
        search_subtype.values.web = search_subtype.Value(rm_const.SearchSubtypes.WEB, default=True)
        search_subtype.values.images = rm_const.SearchSubtypes.IMAGES
        search_subtype.values.video = rm_const.SearchSubtypes.VIDEO
        search_subtype.values.geo = rm_const.SearchSubtypes.GEO
        search_subtype.values.news = rm_const.SearchSubtypes.NEWS
        search_subtype.values.music = rm_const.SearchSubtypes.MUSIC

    sla_project = sdk2.parameters.String("SLA Project", default=None)

    test_mode = sdk2.parameters.Bool("Test mode", default=False)

    with test_mode.value[True]:
        external_id = sdk2.parameters.String("Launch templates externalId for test", default="295147")

    custom_template_name = sdk2.parameters.String("Use custom template for launch")
    custom_template_descr = sdk2.parameters.String("Use custom template description for launch", required=False)
    template_dir = sdk2.parameters.String("Template dir", default="search/metrics_templates/{search_subtype}")

    template_source = sdk2.parameters.String(
        "Template source",
        choices=[
            (_, _) for _ in [
                lm_const.TEMPLATE_SOURCE_ARCADIA,
                lm_const.TEMPLATE_SOURCE_RESOURCE,
                lm_const.TEMPLATE_SOURCE_LAST_RELEASED,
            ]
        ],
        default_value=lm_const.TEMPLATE_SOURCE_LAST_RELEASED,
    )

    with template_source.value[lm_const.TEMPLATE_SOURCE_ARCADIA]:

        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(
            default_value="arcadia:/arc/trunk/arcadia/"
        )
        arcadia_patch = build_params.ArcadiaPatch()

    with template_source.value[lm_const.TEMPLATE_SOURCE_RESOURCE]:

        template_resource = sdk2.parameters.Resource(
            "Metrics template resource",
            resource_type=rm_resources.METRICS_TEMPLATE_RESOURCE,
        )

    with template_source.value[lm_const.TEMPLATE_SOURCE_LAST_RELEASED]:

        template_resource_release_stage = sdk2.parameters.String(
            "Release stage (stable/testing/prestable/unstable or anything you can think of)",
            default_value="stable",
        )

    launch_template_quota = sdk2.parameters.String("Quota to use")
    ang_quota = sdk2.parameters.String("Ang quota to use in the root of template")
    serp_download_limit = sdk2.parameters.Integer("Limit for serps downloads in seconds")
    optimistic_expected_launch_time_sec = sdk2.parameters.Integer(
        "Expected time of launch run in most optimistic scenario",
        default_value=600,  # assume, that the fastest launch will take more than 10 min
    )

    with sdk2.parameters.Group("Sample (reference) beta parameters") as sample_block:
        # Example: upper-200-10.hamster
        sample_beta = sdk2.parameters.String("Sample (reference) beta hostname")
        sample_extra_params = sdk2.parameters.String("Additional params for sample beta")

    with sdk2.parameters.Group("Checked (new release) beta parameters") as checked_block:
        checked_beta = sdk2.parameters.String("Checked (new release) beta hostname")
        checked_extra_params = sdk2.parameters.String("Additional params for checked beta")

    with sdk2.parameters.Group("Autoclicker") as autoclicker_block:
        enable_autoclicker = sdk2.parameters.Bool("Enable autoclicker")
        autoclicker_retry_count = sdk2.parameters.Integer("Autoclicker retry count", default=5)
        with sdk2.parameters.String("Autoclicker metric name") as autoclicker_metric_name:
            autoclicker_metric_name.values["diff-2-serps-5"] = autoclicker_metric_name.Value(
                "diff-2-serps-5",
                default=True
            )
            autoclicker_metric_name.values["pfound-5"] = "pfound-5"
            autoclicker_metric_name.values["diff-2-esearch"] = "diff-2-esearch"
            autoclicker_metric_name.values["diff-2-serps-or-failed-5"] = "diff-2-serps-or-failed-5"
            autoclicker_metric_name.values["diff-2-serps-empty-or-failed-5"] = "diff-2-serps-empty-or-failed-5"
            autoclicker_metric_name.values["empty-or-failed"] = "empty-or-failed"
        with sdk2.parameters.String("Autoclicker filter") as autoclicker_filter:
            autoclicker_filter.values["onlySearchResult"] = autoclicker_filter.Value(
                "onlySearchResult",
                default=True
            )
            autoclicker_filter.values.true = "true"

    run_findurl = sdk2.parameters.Bool("Manually run queries on betas, then try to FindUrl lost documents")
    with run_findurl.value[True]:
        max_missing_docs_per_basket = sdk2.parameters.Integer(
            "Max amount of documents to send to FindUrl per query basket",
            default=20
        )
        max_queries_per_basket = sdk2.parameters.Integer(
            "Max amount of documents to send to FindUrl per query basket",
            default=50
        )

    scraper_over_yt_pool = sdk2.parameters.String("Scraper over YT pool", default="default")

    fail_threshold = sdk2.parameters.Integer(
        "Time to fail task in seconds ({} hours by default)".format(lm_const.FAIL_THRESHOLD / 60 / 60),
        default=lm_const.FAIL_THRESHOLD,
        description="The task will be forced to fail if the launch runs longer than this amount of seconds"
    )

    ab_experiment_id = sdk2.parameters.String("AB Experiment ID (for A/B Adminka-spawned jobs)", default="")
