# -*- coding: utf-8 -*-
import logging

import sandbox.projects.release_machine.core.task_env as task_env
import sandbox.projects.release_machine.rm_notify as rm_notify
import sandbox.projects.release_machine.components.all as rmc
import sandbox.projects.release_machine.tasks.base_task as rm_bt
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.release_machine.core import const as rm_const
from sandbox.projects.release_machine import security as rm_sec
from sandbox.projects.release_machine.helpers.startrek_helper import STHelper


@rm_notify.notify2()
class ReleaseMachineBranchCheck(rm_bt.BaseReleaseMachineTask):

    class Requirements(task_env.StartrekRequirements):
        disk_space = 2 * 1024  # 2 Gb

    class Parameters(rm_params.BaseReleaseMachineParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)
        release_number = sdk2.parameters.Integer("Release number", required=True)

    def on_execute(self):
        rm_bt.BaseReleaseMachineTask.on_execute(self)
        c_info = rmc.COMPONENTS["release_machine_test"]()
        logging.info("Component info %s", c_info)
        self.token = rm_sec.get_rm_token(self)
        st_helper = STHelper(self.token)
        comment, issue = st_helper.find_comment(
            self.Parameters.release_number, rm_const.TicketGroups.MetricsTest, c_info
        )
        logging.info("Ticket number is %s", issue.key)
        eh.ensure(comment, "Comment doesn't exist")
        comment_text = comment.text
        logging.info("Comment text is %s", comment_text)
        eh.ensure("All metrics are **!!(green)OK!!**" in comment_text, "Comment text is incorrect")
