from itertools import chain


class ChatCheckResult:

    OK = "OK"
    FAIL = "FAIL"

    def __init__(self, name, success=True, message=""):
        self._personal_success = success
        self._name = name
        self._message = message
        self._children = []

    @property
    def name(self):
        return self._name

    @property
    def result(self):
        return self.OK if self.is_ok else self.FAIL

    @property
    def message(self):
        return self._message

    @property
    def is_ok(self):
        return self._personal_success and all([child.is_ok for child in self._children])

    def list_messages(self, failed_only=False):

        if failed_only:
            children = filter(lambda child: not child.is_ok, self._children)
        else:
            children = self._children

        return [self._message] + list(chain(*(child.list_messages() for child in children)))

    def add_result(self, chat_check_result):
        self._children.append(chat_check_result)

    def fail(self, message):
        self._personal_success = False
        self._message = message

    def unfail(self, message):
        self._personal_success = True
        self._message = message

    def to_dict(self):
        return {
            'name': self.name,
            'result': self.result,
            'message': self.message,
            'children': [child.to_dict() for child in self._children],
        }
