from sandbox.projects.common import binary_task
from sandbox.projects.common import decorators
from sandbox.projects.common import error_handlers as eh
from sandbox.projects.release_machine import input_params2 as rm_params
from sandbox.projects.release_machine.tasks.ReleaseMachineSiteMonitoring import test_configs
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.task_env as task_env
import sandbox.projects.release_machine.notify_helper as nh
import sandbox.projects.release_machine.tasks.base_task as rm_bt
import sandbox.projects.resource_types as rt
import sandbox.sdk2 as sdk2


PRODUCTION = "production"
TESTING = "testing"
RELEASE_MACHINE = "release_machine"
CTYPES = [PRODUCTION, TESTING]


class ReleaseMachineSiteMonitoring(rm_bt.BaseReleaseMachineTask):
    """ This task is BINARY ONLY """
    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(rm_params.BaseReleaseMachineParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)
        kill_timeout = 15 * 60  # 15 min
        with sdk2.parameters.String("Service") as service:
            for service_name in test_configs.SERVICES_TO_TEST:
                service.values[service_name] = service.Value(
                    value=service_name,
                    default=(service_name == RELEASE_MACHINE)
                )
        with sdk2.parameters.String("Ctype") as ctype:
            for ctype_name in CTYPES:
                ctype.values[ctype_name] = ctype.Value(ctype_name.capitalize(), default=(ctype_name == PRODUCTION))

    class Context(rm_bt.BaseReleaseMachineTask.Context):
        attempt = 0

    def on_execute(self):
        rm_bt.BaseReleaseMachineTask.on_execute(self)
        results = "test_results"

        if self.Context.attempt < 20:
            self.Context.attempt += 1
            service_config = test_configs.SERVICES_TO_TEST[self.Parameters.service]
            try:
                self._do_test(service_config.import_selenium_tests(), results)
            except Exception as e:
                result_resource = rt.TEST_RESULT(self, "Test results", results)
                sdk2.ResourceData(result_resource).ready()
                msg = "{} {} is broken!".format(self.Parameters.service, self.Parameters.ctype)
                nh.telegram(
                    task=self,
                    message=msg,
                    chat_ids=[rm_const.RM_USERS[service_config.emergency_chat].telegram],
                )
                eh.log_exception(msg, e)
                eh.check_failed(msg)

            raise sdk2.WaitTime(10 * 60)  # 10 min

    @decorators.retries(3)
    def _do_test(self, selenium_test, results):
        selenium_test.test_all(results_folder=results, ctype=self.Parameters.ctype)
