from sandbox import sdk2
from sandbox.common.proxy import NoAuth
from sandbox.common.rest import Client
from sandbox.projects.common import binary_task
from sandbox.projects.release_machine import input_params2 as rm_params
from sandbox.projects.release_machine.components.all import get_component
from sandbox.projects.common.testenv_client import TEClient
from sandbox.projects.release_machine.tasks import base_task as rm_bt
from sandbox.sandboxsdk import environments

import sandbox.projects.release_machine.core.task_env as task_env


class ReleaseGraphResource(sdk2.Resource):
    component_name = sdk2.parameters.String("Component name")
    major = sdk2.parameters.Integer("Major version")
    minor = sdk2.parameters.Integer("Minor version")


class RenderReleaseGraph(rm_bt.BaseReleaseMachineTask):
    class Requirements(task_env.TinyRequirements):
        ram = 4096  # 4GiB or less
        environments = (
            environments.PipEnvironment('graphviz'),
        )

    class Parameters(rm_params.DefaultReleaseMachineParameters):
        _lbrp = binary_task.binary_release_parameters(stable=True)

        kill_timeout = 300

        get_last_status = sdk2.parameters.Bool("Automatically find versions", default=True)
        with get_last_status.value[False]:
            major = sdk2.parameters.Integer("Major version")
            minor = sdk2.parameters.Integer("Mnor version")

        testenv_token = sdk2.parameters.String("Testenv OAuth token valt name", default="common_release_token")
        with rm_params.DefaultReleaseMachineParameters.debug_mode.value[True]:
            use_production_sandbox = sdk2.parameters.Bool("Use production sandbox", default=True)

        with sdk2.parameters.Group("Appearance") as appearance_settings:
            do_print_output = sdk2.parameters.Bool(
                "Print output parameters of the successful job launche",
                default=True,
            )

    def create_release_diagram(self, tests_graph, component_name, major, minor):
        report = """<html>
            <style>
            body {{
                background-color: black;
                color: grey;
                font-family: arial;
            }}
            svg {{
                width: 100% !important;
                height: auto !important;
            }}
            </style>
            <body>
                <h2>{component_name} v{major}-{minor}</h2>
                {svg_data}
            </body>
        </html>
        """.format(component_name=component_name, major=major, minor=minor, svg_data=tests_graph.pipe())

        report_resource = ReleaseGraphResource(
            self,
            "Release graph",
            "release_graph.html",
            component_name=component_name,
            major=major,
            minor=minor,
        )
        report_resource_data = sdk2.ResourceData(report_resource)
        report_resource_data.path.write_bytes(report.encode("utf-8"))

    def on_execute(self):
        rm_bt.BaseReleaseMachineTask.on_execute(self)

        from sandbox.projects.release_machine.tasks.RenderReleaseGraph.lib.graph import create_release_status_diagram

        testenv_helper = TEClient(sdk2.Vault.data(self.Parameters.testenv_token))
        if self.Parameters.debug_mode and self.Parameters.use_production_sandbox:
            sandbox_client = Client(base_url=Client.DEFAULT_BASE_URL, auth=NoAuth())
        else:
            sandbox_client = self.server

        if self.Parameters.get_last_status:
            component_info = get_component(self.Parameters.component_name)
            major = component_info.last_branch_num
            minor = component_info.last_tag_num(major)
        else:
            major = self.Parameters.major
            minor = self.Parameters.minor

        tests_graph = create_release_status_diagram(
            testenv_helper,
            sandbox_client,
            self.Parameters.component_name,
            major=major,
            minor=minor,
            output_format='svg',
            do_print_output=self.Parameters.do_print_output,
        )

        self.create_release_diagram(tests_graph, self.Parameters.component_name, major, minor)
