# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import parameters as sp
from sandbox.projects.release_machine.tasks.ScrapeRequests2 import static as st
from sandbox.projects import resource_types

RESULT_DATA_FILE = 'result_data_file'

FIRST_BETA_INFO_GROUP = "First beta parameters"
SECOND_BETA_INFO_GROUP = "Second beta parameters"
YT_INFO_GROUP = "YT parameters"
QUERIES_INFO_GROUP = "Queries parameters"
RESPONSES_INFO_GROUP = "Responses parameters"
SCRAPER_TOKEN_GROUP = "Scraper token parameters"
SCRAPER_PROFILE_GROUP = "Scraper quota and profiles parameters"
SCRAPER_WAITING_GROUP = "Scraper waiting parameters"
SCRAPER_OVER_YT_GROUP = "Scraper over yt parameters"
PERSONAL_UIDS_GROUP = "Personal uids parameters"

SOY_JOB_ID = "soy_job_id"
WAITING_STATUS = "waiting_status"
PASSIVE_WAITING_COUNT = "passive_waiting_count"
ACTIVE_WAITING = "active_waiting"
PASSIVE_WAITING = "passive_waiting"
MAX_ACTIVE_WAITING = 10 * 60  # In seconds
MAX_PASSIVE_WAITING = 20  # In times
PASSIVE_WAITING_DURATION = 3600 / 2  # In seconds


class FirstBetaHostParameter(sp.SandboxStringParameter):
    name = "beta_host_1"
    description = "Beta hostname"
    required = True
    default_value = "hamster.yandex.ru"
    group = FIRST_BETA_INFO_GROUP


class FirstBetaUserAgentParameter(sp.SandboxStringParameter):
    name = "beta_user_agent_1"
    description = "User-Agent to imitate collections (optional)"
    default_value = ""
    group = FIRST_BETA_INFO_GROUP


class FirstBetaCollectionParameter(sp.SandboxStringParameter):
    name = "beta_collection_1"
    description = "Beta collection name"
    required = True
    choices = [(k, k) for k in st.COLLECTIONS.keys()]
    default_value = "search"
    group = FIRST_BETA_INFO_GROUP


class FirstBetaCgiParameter(sp.SandboxStringParameter):
    name = "beta_cgi_params_1"
    description = 'Additional cgi'
    required = True
    default_value = None
    group = FIRST_BETA_INFO_GROUP


class FirstBetaDumpAllJson(sp.SandboxBoolParameter):
    name = "beta_dump_all_json_1"
    description = (
        "Add cgi-parameter &json_dump=1 (true by default). False only for advanced users! "
        "Because without &json_dump=1, you have to provide all necessary data by specifying in cgi"
    )
    default_value = True
    group = FIRST_BETA_INFO_GROUP


class FirstBetaJsonToStandardFormat(sp.SandboxBoolParameter):
    name = "beta_json_to_standard_format_1"
    description = "Json to standard format, i. e. 'key1.key2.key3' to {'key1': {'key2': {'key3': ..."
    default_value = False
    group = FIRST_BETA_INFO_GROUP


class SecondBetaHostParameter(sp.SandboxStringParameter):
    name = "beta_host_2"
    description = "Beta hostname"
    required = True
    default_value = "hamster.yandex.ru"
    group = SECOND_BETA_INFO_GROUP


class SecondBetaUserAgentParameter(sp.SandboxStringParameter):
    name = "beta_user_agent_2"
    description = "User-Agent to imitate collections (optional)"
    default_value = ""
    group = SECOND_BETA_INFO_GROUP


class SecondBetaCollectionParameter(sp.SandboxStringParameter):
    name = "beta_collection_2"
    description = "Beta collection name"
    required = True
    choices = [(k, k) for k in st.COLLECTIONS.keys()]
    default_value = "search"
    group = SECOND_BETA_INFO_GROUP


class SecondBetaCgiParameter(sp.SandboxStringParameter):
    name = "beta_cgi_params_2"
    description = 'Additional cgi'
    required = True
    default_value = None
    group = SECOND_BETA_INFO_GROUP


class SecondBetaDumpAllJson(sp.SandboxBoolParameter):
    name = "beta_dump_all_json_2"
    description = (
        "Add cgi-parameter &json_dump=1 (true by default). False only for advanced users! "
        "Because without &json_dump=1, you have to provide all necessary data by specifying in cgi"
    )
    default_value = True
    group = SECOND_BETA_INFO_GROUP


class SecondBetaJsonToStandardFormat(sp.SandboxBoolParameter):
    name = "beta_json_to_standard_format_2"
    description = "Json to standard format, i. e. 'key1.key2.key3' to {'key1': {'key2': {'key3': ..."
    default_value = False
    group = SECOND_BETA_INFO_GROUP


class RequestsResource(sp.ResourceSelector):
    name = "req_resource_id"
    description = "Queries in text format"
    resource_type = resource_types.USERS_QUERIES
    required = True
    default_value = None
    group = QUERIES_INFO_GROUP


class OutputTableParameter(sp.SandboxStringParameter):
    name = "mapreduce_output_table"
    description = 'Output table name'
    default_value = 'tmp/GetReportSimultaneousResponses/SimultaneousResponses'
    group = YT_INFO_GROUP


class YtServerParameter(sp.SandboxStringParameter):
    name = "mapreduce_server"
    description = "YT server name"
    default_value = "hahn"
    group = YT_INFO_GROUP


class YtUserParameter(sp.SandboxStringParameter):
    name = "mapreduce_user"
    description = "YT user"
    default_value = "rearrange"
    group = YT_INFO_GROUP


class ScraperPriorityParameter(sp.SandboxIntegerParameter):
    name = "scraper_priority"
    description = "Scraper task priority (200 for production processes)"
    default_value = 100
    group = RESPONSES_INFO_GROUP


class ParserBinaryParameter(sp.LastReleasedResource):
    name = "parser_binary_resource_id"
    description = "Binary of json-parser two_contexts_features_diff"
    resource_type = resource_types.ARCADIA_BINARY_ARCHIVE
    required = False
    default_value = 0


class ScraperTokenGroupParameter(sp.SandboxStringParameter):
    name = "scraper_token_group"
    description = "Group that owns scraper token"
    default_value = "SEARCH-RELEASERS"
    group = SCRAPER_TOKEN_GROUP


class ScraperTokenNameParameter(sp.SandboxStringParameter):
    name = "scraper_token_name"
    description = "Name of scraper token in vault"
    default_value = "ra2_scraper_token"
    group = SCRAPER_TOKEN_GROUP


class UseScraperProfileParameter(sp.SandboxBoolParameter):
    name = "use_scraper_profile"
    description = "Use scraper profile"
    default_value = False
    group = SCRAPER_PROFILE_GROUP


class ScraperProfileTypeParameter(sp.SandboxStringParameter):
    name = 'scraper_profile_type'
    description = 'Profile type in scraper'
    default_value = 'STRICT_CONSISTENCY'
    group = SCRAPER_PROFILE_GROUP


class ScraperProfileVerticalParameter(sp.SandboxStringParameter):
    name = 'scraper_profile_vertical'
    description = 'Profile vertical in scraper'
    default_value = 'WEB'
    group = SCRAPER_PROFILE_GROUP


class ScraperProfileDeviceParameter(sp.SandboxStringParameter):
    name = 'scraper_profile_device'
    description = 'Profile device in scraper'
    default_value = 'DESKTOP'
    group = SCRAPER_PROFILE_GROUP


class ScraperProfileEnvParameter(sp.SandboxStringParameter):
    name = 'scraper_profile_env'
    description = 'Profile environment in scraper'
    default_value = 'HAMSTER'
    group = SCRAPER_PROFILE_GROUP


class ScraperProfileTierParameter(sp.SandboxStringParameter):
    name = 'scraper_profile_tier'
    description = 'Profile tier in scraper'
    default_value = 'TIER0'
    group = SCRAPER_PROFILE_GROUP


class ScraperImportanceParameter(sp.SandboxStringParameter):
    name = 'scraper_importance'
    description = 'Importance (параметр для выбора типа квоты)'
    default_value = "acceptance"
    group = SCRAPER_PROFILE_GROUP


class ScraperQuotaParameter(sp.SandboxStringParameter):
    name = 'scraper_quota'
    description = 'Quota which used for scraper'
    default_value = 'web-ranking-runtime'
    group = SCRAPER_PROFILE_GROUP


class FilterCgi(sp.SandboxBoolParameter):
    name = 'filter_cgi'
    description = 'Filter forbidden cgi for scraper profiles'
    default_value = False


class ScraperOverYtPoolParameter(sp.SandboxStringParameter):
    name = 'scraper_over_yt_pool'
    description = 'Pool for SOY'
    default_value = 'default'


class ScraperActiveWaitingTime(sp.SandboxIntegerParameter):
    name = 'scraper_active_waiting_time'
    description = 'Time that task waits soy job while executing (In seconds)'
    default_value = MAX_ACTIVE_WAITING
    group = SCRAPER_WAITING_GROUP


class ScraperPassiveWaitingCount(sp.SandboxIntegerParameter):
    name = 'scraper_passive_waiting_count'
    description = 'Task goes into WAIT_TIME that amount of times'
    default_value = MAX_PASSIVE_WAITING
    group = SCRAPER_WAITING_GROUP


class ScraperPassiveWaitingTime(sp.SandboxIntegerParameter):
    name = 'scraper_passive_waiting_time'
    description = 'Time that task waits in WAIT_TIME before next check (In seconds)'
    default_value = PASSIVE_WAITING_DURATION
    group = SCRAPER_WAITING_GROUP


SCRAPER_WAITING_PARAMETERS = (
    ScraperActiveWaitingTime,
    ScraperPassiveWaitingCount,
    ScraperPassiveWaitingTime,
)

SCRAPER_PROFILE_PARAMETERS = (
    UseScraperProfileParameter,
    ScraperProfileTypeParameter,
    ScraperProfileVerticalParameter,
    ScraperProfileDeviceParameter,
    ScraperProfileEnvParameter,
    ScraperProfileTierParameter,
)

FORBIDDEN_CGI = {
    "timeout",
    "nocache",
    "waitall",
    "no-tests",
}
