from __future__ import unicode_literals


class RmUserCfg(object):
    __slots__ = ("_allow_tickets_from",)

    def __init__(self, allow_tickets_from=None):
        self._allow_tickets_from = frozenset(allow_tickets_from) if allow_tickets_from is not None else None

    def allow_ticket_following(self, component_name):
        if self._allow_tickets_from is None:
            return True
        return component_name in self._allow_tickets_from


RM_USERS = {
    "borman": RmUserCfg(allow_tickets_from={"quasar_linux", "quasar_android", "quasar_jbl"}),
    "cerevra": RmUserCfg(allow_tickets_from=()),
    "babenko": RmUserCfg(allow_tickets_from=()),
    "ignat": RmUserCfg(allow_tickets_from=()),
    "prime": RmUserCfg(allow_tickets_from=()),
    "max42": RmUserCfg(allow_tickets_from=()),
    "renadeen": RmUserCfg(allow_tickets_from=()),
    "dkvasov": RmUserCfg(allow_tickets_from={"release_machine", "release_machine_test"}),
    "thegeorg": RmUserCfg(allow_tickets_from=()),
}
