from sandbox.projects.common.vcs import arc

ARC_PRESTABLE = 'arcd.test.arc-vcs.in.yandex-team.ru'


class PciExpressArc(arc.Arc):

    def __init__(self, use_prestable=False, *args, **kwargs):
        self.__use_prestable = use_prestable
        super(PciExpressArc, self).__init__(*args, **kwargs)

    def _prepare_command(self, *args, **kwargs):
        extra_params = kwargs.pop('extra_params', [])
        if self.__use_prestable:
            extra_params.extend(['--server', ARC_PRESTABLE, '--pull-server', ARC_PRESTABLE])
        return super(PciExpressArc, self)._prepare_command(extra_params=extra_params, *args, **kwargs)
