from sandbox import sdk2
from sandbox.sdk2.service_resources import SandboxTasksBinary


class YeomanStaterParameters(sdk2.Task.Parameters):

    with sdk2.parameters.Group("Yeoman parameters"):
        use_last_binary = sdk2.parameters.Bool('Use last binary archive', default=True)

        with use_last_binary.value[True]:
            with sdk2.parameters.RadioGroup('Binary release type') as release_type:
                release_type.value.stable = release_type.Value('stable', default=True)
                release_type.value.test = release_type.Value('test')

        with use_last_binary.value[False]:
            custom_tasks_archive_resource = sdk2.parameters.Resource('Task archive resource', default=None)

        yt_proxy = sdk2.parameters.String('YT proxy', default='hahn')
        yt_directory = sdk2.parameters.String('YT directory', default='//home/devtools/yeoman')
        domains = sdk2.parameters.String('Comma-separated list of domains', default='')
        use_state = sdk2.parameters.Bool('Use state', default=True)
        incremental = sdk2.parameters.Bool('Incremental run', default=True)

        solomon_cluster = sdk2.parameters.String('Solomon cluster', default='solomon')

        with sdk2.parameters.Group('Results'):
            yt_result_directory = sdk2.parameters.String('YT result directory')

            clickhouse_url = sdk2.parameters.String('ClickHouse URL')
            clickhouse_database = sdk2.parameters.String('ClickHouse database')
            clickhouse_username = sdk2.parameters.String('ClickHouse username', default='yeoman')
            clickhouse_result_prefix = sdk2.parameters.String('ClickHouse table prefix', default='stats_')


class YeomanStatistics(sdk2.Task):
    class Parameters(YeomanStaterParameters):
        pass

    def on_save(self):
        if self.Parameters.use_last_binary:
            self.Requirements.tasks_resource = SandboxTasksBinary.find(
                attrs={
                    'target': 'repo/yeoman/stater/bin',
                    'released': self.Parameters.release_type or 'stable'
                }
            ).first().id
        else:
            self.Requirements.tasks_resource = self.Parameters.custom_tasks_archive_resource

    def on_execute(self):
        secrets = sdk2.yav.Secret('sec-01d3rrchvs6qnza584y5bgq6f9').data()

        import repo.yeoman.stats.lib.gather as yeoman_stats
        import repo.yeoman.data.lib.utils as yeoman_utils

        yeoman_stats.gather_statistics(
            yt_cluster=self.Parameters.yt_proxy,
            yt_token=secrets['token'],
            yt_directory=self.Parameters.yt_directory,
            domains=self.Parameters.domains.split(',') if self.Parameters.domains else None,
            incremental=self.Parameters.incremental,
            use_state=self.Parameters.use_state,
            solomon_reporter=yeoman_utils.SolomonReporter(self.Parameters.solomon_cluster, secrets['token']),
            yt_result_directory=self.Parameters.yt_result_directory,
            clickhouse_url=self.Parameters.clickhouse_url,
            clickhouse_database=self.Parameters.clickhouse_database,
            clickhouse_username=self.Parameters.clickhouse_username,
            clickhouse_password=secrets['clickhouse_password'],
            clickhouse_result_prefix=self.Parameters.clickhouse_result_prefix,
        )
