# !/usr/bin/env python
# -*- coding: utf-8 -*-
import json
import logging
import requests
from datetime import datetime, timedelta

from sandbox import sdk2


class FLAGS_JSON_SEAREL_STATS(sdk2.Task):
    def on_execute(self):
        self.st_token = sdk2.Vault.data(self.owner, "zomb-prj-10-st-oauth")
        self.stat_token = sdk2.Vault.data(self.owner, "report-stats")

        self.flags_releases_periodicity()

    def upload_data_to_stat(self, data, report_path, scale):
        requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % self.stat_token},
            data={
                'name': report_path,
                'scale': scale,
                'data': json.dumps({'values': data}),
            },
        )

    def flags_releases_periodicity(self):
        st_url = 'http://st-api.yandex-team.ru/v2/issues/?perPage=10000&language=en&filter=queue:SEAREL&filter=resolution:fixed&filter=status:closed&filter=components:40214'
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(self.st_token)
        number_of_releases = dict()
        number_of_releases_week = dict()
        number_of_releases_days = dict()

        out = session.get(st_url)
        json_dump = json.loads(out.text)
        for issue in json_dump:

            release_date = datetime.strptime(issue[u'resolvedAt'][:10], '%Y-%m-%d').date()
            release_date_day = release_date.isoformat()
            release_month = release_date.strftime("%m")
            release_year = release_date.year
            release_m_and_year = str(release_year) + '-' + str(release_month) + '-01'

            if release_m_and_year in number_of_releases:
                number_of_releases[release_m_and_year] = number_of_releases.get(release_m_and_year, 0) + 1
            else:
                number_of_releases[release_m_and_year] = 1

            release_weekday = release_date.weekday()
            first_day_of_the_week = (release_date - timedelta(days=release_weekday)).isoformat()

            if first_day_of_the_week in number_of_releases_week:
                number_of_releases_week[first_day_of_the_week] = number_of_releases_week.get(first_day_of_the_week, 0) + 1
            else:
                number_of_releases_week[first_day_of_the_week] = 1

            if release_date_day in number_of_releases_days:
                number_of_releases_days[release_date_day] = number_of_releases_days.get(release_date_day, 0) + 1
            else:
                number_of_releases_days[release_date_day] = 1

        # добавляем в стат статку по месяцам
        data = []
        for i in number_of_releases:
            item = {
                "fielddate": i,
                "count_of_releases": number_of_releases[i]
            }
            data.append(item)

        logging.info(data)

        report_path = 'Yandex/Report/FlagsStatPeriodicity'
        scale = 'm'
        self.upload_data_to_stat(data, report_path, scale)

        # добавляем в стат статку по неделям
        data_week = []
        for i in number_of_releases_week:
            item = {
                "fielddate": i,
                "count_of_releases": number_of_releases_week[i]
            }
            data_week.append(item)

        logging.info(data_week)

        report_path = 'Yandex/Report/FlagsStatPeriodicity'
        scale = 'w'
        self.upload_data_to_stat(data_week, report_path, scale)

        # добавляем в стат статку по дням
        data_days = []
        for i in number_of_releases_days:
            item = {
                "fielddate": i,
                "count_of_releases": number_of_releases_days[i]
            }
            data_days.append(item)

        logging.info(data_days)

        report_path = 'Yandex/Report/FlagsStatPeriodicity'
        scale = 'd'
        self.upload_data_to_stat(data_days, report_path, scale)
