import os

from sandbox import sdk2
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2
from sandbox.sandboxsdk.svn import Arcadia


CONFIG_WEB_PATH = os.path.join("web", "report", "data", "flags")
CONFIG_WEB_FILENAME = "config_web.json"
RELEASERS = ['alex-ersh', 'robot-testenv', 'mvel']


class ConfigWebJson(sdk2.Resource):
    '''
    config_web.json file from report
    '''
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = RELEASERS


class UpdateConfigWebJson(ReleaseToNannyTask2, sdk2.Task):
    '''
    Get config_web.json file of specific revision and make a resource from it.
    '''

    execution_space = 1000

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("Subversion Parameters") as subversion_block:
            arcadia_url = sdk2.parameters.ArcadiaUrl(
                'path to config_web.json folder',
                default_value=os.path.join(Arcadia.trunk_url(), CONFIG_WEB_PATH),
                required=True,
            )
            revision = sdk2.parameters.String('Revision', required=True)

    def on_execute(self):
        conf_dir = os.path.abspath("config")
        sdk2.svn.Arcadia.checkout(self.Parameters.arcadia_url, conf_dir, revision=self.Parameters.revision)

        resource = sdk2.ResourceData(ConfigWebJson(
            self, "{}@{}".format(CONFIG_WEB_FILENAME, self.Parameters.revision), CONFIG_WEB_FILENAME
        ))

        with open(os.path.join(conf_dir, CONFIG_WEB_FILENAME), 'r') as f:
            resource.path.write_bytes(f.read())

        resource.ready()
