# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.common.types import resource as ctr
from sandbox.sandboxsdk import parameters as sp
from sandbox.projects import resource_types
from sandbox.projects.ReleaseSdchDictionaryPack import SdchWebDictionaryPack


class ApacheBundleParameter(sp.ResourceSelector):
    name = 'apache_bundle'
    description = 'Apache bundle'
    resource_type = resource_types.APACHE_BUNDLE


class Project(sp.SandboxStringParameter):
    required = True
    name = 'project'
    description = 'Project'

    available_projects = ('WEB', 'NEWS', 'IMGS', 'VIDEO', 'YACA')
    choices = [
        ('WEB', available_projects[0]),
        ('NEWS', available_projects[1]),
        ('IMAGES', available_projects[2]),
        ('VIDEO', available_projects[3]),
        ('YACA', available_projects[4]),
    ]
    default_value = choices[0][1]

    project_to_report = {
        available_projects[0]: resource_types.REPORT_CORE_PACKAGE,
        available_projects[1]: resource_types.REPORT_NEWS_CORE_PACKAGE,
        available_projects[2]: resource_types.REPORT_IMAGES_CORE_PACKAGE,
        available_projects[3]: resource_types.REPORT_VIDEO_CORE_PACKAGE,
        available_projects[4]: resource_types.REPORT_YACA_CORE_PACKAGE,
    }

    upperconf_key = {
        available_projects[0]: '',
        available_projects[1]: '-news',
        available_projects[2]: '-images',
        available_projects[3]: '-video',
        available_projects[4]: '-yaca',
    }

    upper_config = {
        available_projects[0]: 'upper_web_rkub',
        available_projects[1]: 'upper_news_rkub',
        available_projects[2]: 'upper_imgs_rkub',
        available_projects[3]: 'upper_video_rkub',
        available_projects[4]: 'upper_yaca_rkub',
    }

    project_to_sdch = {
        available_projects[0]: SdchWebDictionaryPack,
    }


class SDCHDict(sp.ResourceSelector):
    name = 'sdch_dict'
    description = 'SDCH dictionary (will use last stable released if omitted)'
    resource_type = Project.project_to_sdch.values()


class REPORT_INSTANCECTL_CONF(sdk2.resource.Resource):
    """
    Web Report instancectl.conf file
    """
    restart_policy = ctr.RestartPolicy.IGNORE
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = resource_types.report_web_releasers
    # arcadia_build_path = 'web/report/conf/instancectl_conf'
