# -*- coding: utf-8 -*-

import logging
import urllib3
import requests
import json

from datetime import datetime
from sandbox import sdk2

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


class FLAGS_JSON_TIME_STATS(sdk2.Task):
    def on_execute(self):
        self.st_token = sdk2.Vault.data(self.owner, "zomb-prj-10-st-oauth")
        self.stat_token = sdk2.Vault.data(self.owner, "report-stats")
        self.nanny_token = sdk2.Vault.data(self.owner, "flags_json_nanny_token")

        self.flags_json_time_stats()

    def upload_data_to_stat(self, data, report_path, scale):
        requests.post(
            'https://upload.stat.yandex-team.ru/_api/report/data',
            headers={'Authorization': 'OAuth %s' % self.stat_token},
            data={
                'name': report_path,
                'scale': scale,
                'data': json.dumps({'values': data}),
            },
        )

    def flags_json_time_stats(self):
        st_url = 'http://st-api.yandex-team.ru/v2/issues/?perPage=10000&language=en&filter=queue:SEAREL&filter=resolution:fixed&filter=status:closed&filter=components:40214'
        session = requests.Session()
        session.headers['Authorization'] = 'OAuth {}'.format(self.st_token)
        temp_dict = dict()
        searels = session.get(st_url)
        json_searels = json.loads(searels.text)
        for issue in json_searels:
            logging.info(issue['key'])
            comments_req_url = 'https://st-api.yandex-team.ru/v2/issues/{}/comments'.format(issue['key'])
            comments_info = session.get(comments_req_url)
            json_comments = json.loads(comments_info.text)
            for i in json_comments:
                if u'|Nanny tickets|Status|Time|' in i['text']:
                    child_ticket_id = i['text'].split('||\n||')[-1].split(' ')[0][37:]
                    child_ticket_url = 'https://nanny.yandex-team.ru/api/tickets/GetTicket/?id={}'.format(child_ticket_id)
                    child_ticket_session = requests.Session()
                    child_ticket_session.headers['Authorization'] = 'OAuth {}'.format(self.nanny_token)
                    child_ticket_info = child_ticket_session.get(child_ticket_url)
                    json_child_ticket = json.loads(child_ticket_info.text)

                    nanny_ticket_id = json_child_ticket['value']['spec']['releaseId']
                    nanny_req_url = 'https://nanny.yandex-team.ru/api/tickets/GetRelease/?releaseId={}'.format(nanny_ticket_id)
                    nanny_session = requests.Session()
                    nanny_session.headers['Authorization'] = 'OAuth {}'.format(self.nanny_token)
                    nanny_ticket_info = nanny_session.get(nanny_req_url)
                    json_nanny_ticket = json.loads(nanny_ticket_info.text)

                    creationTime = datetime.strptime(json_nanny_ticket['value']['meta']['creationTime'], '%Y-%m-%dT%H:%M:%SZ')
                    endTime = datetime.strptime(json_nanny_ticket['value']['status']['endTime'], '%Y-%m-%dT%H:%M:%SZ')
                    deploy_time = endTime - creationTime
                    temp_dict[creationTime] = [deploy_time, issue['key']]
        # добавляем в стат статку
        deploy_data = []
        for i in temp_dict:
            item = {
                "fielddate": i.strftime("%Y-%m-%d %H:%M:%S"),
                "deploy_time": str(temp_dict[i][0]),
                "searel": str(temp_dict[i][1])
            }
            deploy_data.append(item)

        logging.info(deploy_data)

        report_path = 'Yandex/Report/flags_json_deploy_time'
        scale = 's'
        self.upload_data_to_stat(deploy_data, report_path, scale)
