# -*- coding: utf-8 -*-

import urllib3
import requests
import json

from sandbox import sdk2
from sandbox.projects import resource_types

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


class REPORT_CORE_REQUEST_JSON_CORRECTION_FROM_BETA(sdk2.Task):
    def on_execute(self):
        self.create_source()

    def get_current_revisions(self):
        data = requests.post('https://yappy.z.yandex-team.ru/api/yappy.services.Model/retrieveBeta', json={'name': 'app-host-graphs-web'}, verify=False).text
        srcrwrs = json.loads(data).get("targetState", {}).get("bolverConfiguration", {}).get("params", [])
        unifier = []
        srcrwrs_final = {}

        for i in srcrwrs:
            if i.split(":")[0] not in unifier and i.split(":")[0].split('=', 1)[-1] not in ['SRC_SETUP', 'BEGEMOT_FAILCACHE_STORE']:
                unifier.append(i.split(":")[0])
                srcrwrs_final[i.split(":")[0].split('=', 1)[-1]] = i.split(":")[1] + ':' + i.split(":")[2] + '@0@500'
            else:
                continue

        return srcrwrs_final

    def replace_request_json(self):
        req = requests.get('http://hamster.yandex.ru/viewconfig?name=request.json', verify=False).text
        data = json.loads(req)
        for i in self.get_current_revisions():
            if i in data.keys():
                data[i]["Hosts"] = data[i]["Hosts"].split(" ")[0] + ' ' + self.get_current_revisions()[i]
        return data

    def create_source(self):
        with open('updated_request.json', 'w') as outfile:
            json.dump(self.replace_request_json(), outfile)
        res = resource_types.TEST_ENVIRONMENT_JSON_V2(self, 'updated_request.json', path='updated_request.json')
        sdk2.ResourceData(res).ready()
        self.Context.res_path = res.http_proxy
