# -*- coding: utf-8 -*-

import os
import subprocess

from sandbox import sdk2
from sandbox.common.types.client import Tag
from sandbox.projects.report_renderer.resource_types import RENDERER_MASTER_MEMORY_BENCHMARK_RESULT_DATA

from sandbox.sandboxsdk.environments import PipEnvironment, VirtualEnvironment
from sandbox.common.errors import TaskFailure

from sandbox.projects.resource_types import REPORT_RENDERER_MASTER_MEMORY_BENCHMARK_RESULT as RESULT
from sandbox.projects.common import file_utils as fu


class GenerateBenchmarkReportRendererMasterMemoryPlot(sdk2.Task):
    class Requirements(sdk2.Requirements):
        # Требуемые для построения графика wheel-пакеты есть только для ubuntu 12.04
        client_tags = Tag.LINUX_PRECISE

    class Parameters(sdk2.Task.Parameters):
        json_benchmark_data_resource = sdk2.parameters.LastResource(
            'Renderer to include in bundle',
            resource_type=RENDERER_MASTER_MEMORY_BENCHMARK_RESULT_DATA,
            required=True,
        )

        benchmark_result = sdk2.parameters.ParentResource(
            'Parent result resource',
            resource_type=RESULT,
            required=True,
        )

    def on_execute(self):
        json_benchmark_data_resource = sdk2.ResourceData(self.Parameters.json_benchmark_data_resource)  # synchronizing resource data on disk

        benchmark_result = sdk2.ResourceData(self.Parameters.benchmark_result)  # synchronizing resource data on disk
        benchmark_result.path.mkdir()

        data_path = benchmark_result.path.joinpath('memory_usage.json')
        image_path = benchmark_result.path.joinpath('memory_usage.svg')

        fu.json_dump(data_path, fu.json_load(json_benchmark_data_resource.path))

        with VirtualEnvironment() as venv:
            PipEnvironment("numpy", '1.11.2', use_wheel=True, venv=venv).prepare()
            PipEnvironment("matplotlib", '1.5.1', use_wheel=True, venv=venv).prepare()
            child = subprocess.Popen([
                venv.executable,
                os.path.join(os.path.dirname(__file__), 'generate_plot.py'),
                str(data_path),
                str(image_path),
            ], stderr=subprocess.PIPE)
            (_, err) = child.communicate()
            if child.returncode != 0:
                raise TaskFailure('Script return code is {}. Error output is {}'.format(child.returncode, err))

        benchmark_result.ready()
