# -*- coding: utf-8 -*-

from sandbox.projects.report_renderer.resource_types import RENDERER_MASTER_MEMORY_BENCHMARK_RESULT_DATA
from sandbox.projects.common.BaseTestTask import BaseDolbiloTask
from sandbox.projects.report_renderer.parameters import ReportRendererBundlePackage
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
import sandbox.common.types.client as ctc
from sandbox.sandboxsdk.environments import ctt
from sandbox import sdk2

from sandbox.projects.report_renderer.BenchmarkReportRendererBase.task import BenchmarkReportRendererBase, BenchmarkPlan, Templates
from provider import BenchmarkReportRendererMasterMemoryProvider
from sandbox.projects.resource_types import REPORT_RENDERER_MASTER_MEMORY_BENCHMARK_RESULT as RESULT
from sandbox.projects.common import file_utils as fu
from sandbox.projects.common.report_renderer.utils import default_benchmark_plan, default_templates_package


class MeasurementInterval(parameters.SandboxIntegerParameter):
    """
    Время между выводом статистики потребления памяти в секундах
    Используется в BenchmarkReportRendererMasterMemoryProvider
    """
    name = 'measurement_interval'
    description = 'Amount of seconds between memory measurements'
    default_value = 30


class StatsRequestInterval(parameters.SandboxIntegerParameter):
    """
    Время между запросом unistat-статистики
    Используется в BenchmarkReportRendererMasterMemoryProvider
    """
    name = 'stats_request_interval'
    description = 'Amount of seconds between unistat requests'
    default_value = 5


class BenchmarkReportRendererMasterMemory(BenchmarkReportRendererBase):
    type = "BENCHMARK_REPORT_RENDERER_MASTER_MEMORY"

    client_tags = ctc.Tag.LINUX_BIONIC

    input_parameters = [MeasurementInterval, StatsRequestInterval] + BenchmarkReportRendererBase.input_parameters

    Provider = BenchmarkReportRendererMasterMemoryProvider

    # TODO: Merge this with BenchmarkReportRendererMemory & re-write using sdk2
    def initCtx(self):
        BenchmarkReportRendererBase.initCtx(self)

        plan = default_benchmark_plan()
        if plan is not None:
            self.ctx[BenchmarkPlan.name] = plan.id

        templates = default_templates_package()
        if templates is not None:
            self.ctx[Templates.name] = templates.id

        self.ctx[BaseDolbiloTask.TotalSessions.name] = 1
        self.ctx[BaseDolbiloTask.ExecutorMode.name] = 'finger'
        self.ctx[BaseDolbiloTask.FuckupModeMaxSimultaneousRequests.name] = 8
        self.ctx[BaseDolbiloTask.RequestsLimit.name] = 150000
        self.ctx[BaseDolbiloTask.Circular.name] = True

    def on_execute(self):
        with self.memoize_stage.generateplot:
            BenchmarkReportRendererBase.on_execute(self)
            memory_usage = self.__parse_memory_logs(self.renderer.get_custom_log_file())

            fu.json_dump('memory_usage.json', memory_usage)
            memory_usage_result = self.create_resource(
                'Memory usage data',
                'memory_usage.json',
                RENDERER_MASTER_MEMORY_BENCHMARK_RESULT_DATA
            )

            self.mark_resource_ready(memory_usage_result)

            result = self.create_resource(
                'Memory benchmark of report-renderer bundle {} with templates {}'.format(
                    self.ctx[ReportRendererBundlePackage.name],
                    self.ctx[Templates.name]
                ),
                'result',
                RESULT
            )

            plot_task_class = sdk2.Task["GENERATE_BENCHMARK_REPORT_RENDERER_MASTER_MEMORY_PLOT"]  # SDK2-task
            plot_task = plot_task_class(
                plot_task_class.current,
                description="Generate plot for BenchmarkReportRendererMsaterMemory {}".format(self.id),
                owner=self.owner,
                priority=self.priority,
                json_benchmark_data_resource=memory_usage_result.id,
                benchmark_result=result.id
            )
            plot_task.enqueue()
            self.wait_tasks(plot_task, ctt.Status.Group.BREAK + ctt.Status.Group.FINISH, wait_all=True)
            self.ctx['result_resource_id'] = result.id

    @staticmethod
    def __parse_memory_logs(file_path):
        """
        :param file_path: string
        :return: dict - данные для графика
        """
        res = {
            'keys': [],
            'values': [],
        }
        with open(file_path) as log:
            for line in log:
                values = line.split()
                res['keys'].append(float(values[0]))
                res['values'].append(int(values[1]))
        return res

    @property
    def footer(self):
        if 'result_resource_id' not in self.ctx:
            return 'No results yet'

        result = channel.sandbox.get_resource(self.ctx['result_resource_id'])

        return '<span style="width: 576pt; height: 432pt; display: inline-block; background: url({})"></span>'\
            .format(result.proxy_url + '/memory_usage.svg')
