# -*- coding: utf-8 -*-

import json
import sys


def main():
    # Local import to fix sporadic font loading errors in sandbox.
    import matplotlib.pyplot as plt

    (in_filename, out_filename) = sys.argv[1:]
    with open(in_filename) as in_file:
        data = json.load(in_file)

    _, ax = plt.subplots()
    ax.plot(data['keys'], [float(heap) / 1024.0 / 1024.0 for heap in data['values']])

    ax.set_ylabel('Memory usage, MB')
    ax.set_xlabel('Requests processed')

    plt.savefig(out_filename)


if __name__ == "__main__":
    main()
