# -*- coding: utf-8 -*-
import re
import os

from sandbox.projects.common.report_renderer import ReportRendererProvider
from sandbox.projects.common import file_utils as fu

CUSTOM_LOG = """
'use strict';
var requestsProcessed = 0;

module.exports = function test(write) {
    requestsProcessed += 1;
    if (requestsProcessed % REQUESTS_PER_MEASUREMENT === 0) {
        // Two calls to gc() are intentional
        global.gc();
        global.gc();
        write(requestsProcessed + ' ' + process.memoryUsage().heapUsed + '\\n');
    }
};
"""


class BenchmarkReportRendererMemoryProvider(ReportRendererProvider):
    """
    Запуск report-renderer для бенчмарка памяти рабочих
    Устанавливает одного рабочего
    Добавляет кастомный лог
    """
    @staticmethod
    def _replace_workers(args):
        matcher = r'--workers.\d+'
        workers = '--workers=1'

        if re.search(matcher, args) is None:
            return '{} {}'.format(args, workers)

        return re.sub(matcher, workers, args)

    def _add_custom_log(self, args):
        custom_log = os.path.abspath('custom_log.js')
        fu.write_file(
            custom_log, re.sub(r'REQUESTS_PER_MEASUREMENT', str(self.task.ctx['requests_per_measurement']), CUSTOM_LOG)
        )
        return '{} --custom-log "{}"'.format(args, custom_log)

    @staticmethod
    def _replace_templates_filter(args, filter):
        matcher = r'--templates-filter.[^\s]+'
        templates_filter = '--templates-filter ' + filter

        if re.search(matcher, args) is None:
            return '{} {}'.format(args, templates_filter)

        return re.sub(matcher, templates_filter, args)

    @staticmethod
    def _expose_gc(args):
        args = '--expose_gc {}'.format(args)
        return args

    def get_run_args(self):
        args = super(BenchmarkReportRendererMemoryProvider, self).get_run_args()
        args = self._replace_workers(args)
        args = self._add_custom_log(args)
        args = self._expose_gc(args)
        if self.task.ctx['templates_filter']:
            args = self._replace_templates_filter(args, self.task.ctx['templates_filter'])
        return args

    def get_custom_log_file(self):
        return 'logs/current-report-renderer_custom-{}'.format(self.rr_port)
