# -*- coding: utf-8 -*-

import tarfile
import os
import subprocess

from sandbox import sdk2
from sandbox.common.types.client import Tag
from sandbox.common.errors import TaskFailure

from sandbox.projects.report_renderer.resource_types import REPORT_RENDERER_NODEJS_PACKAGE

TAR_NAME = 'ynode.tar'


# param value must match output param name
class Buildrrnode(sdk2.Task):
    """
        Таск сборки rrnode под linux
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 32768
        client_tags = Tag.LINUX_BIONIC & Tag.INTEL_E5_2660V1

    class Parameters(sdk2.Task.Parameters):
        node_version = sdk2.parameters.String('Version of node.js')

        with sdk2.parameters.Output():
            rrnode_linux = sdk2.parameters.Resource('Static build Node.js for Linux')

        release_to = ['report-renderer']

    @staticmethod
    def create_tar(filenames, tarname=TAR_NAME):
        with tarfile.open(tarname, 'w') as tar:
            for fname in filenames:
                tar.add(fname)

    def on_execute(self):
        if not os.path.isdir('ynode'):
            os.mkdir('ynode')
            os.mkdir('ynode/bin')

        child = subprocess.call([
            os.path.join(os.path.dirname(__file__), 'build.sh'),
            str(self.Parameters.node_version),
            'ynode/bin/ynode',
        ], shell=True, stderr=subprocess.PIPE)
        (_, err) = child.communicate()
        if child.returncode != 0:
            raise TaskFailure('Script return code is {}. Error output is {}'.format(child.returncode, err))

        self.create_tar(['ynode'])

        rrnode_linux = REPORT_RENDERER_NODEJS_PACKAGE(
            self,
            'node.js_{}'.format(self.Parameters.node_version),
            TAR_NAME,
            arch='linux',
            platform='linux',
            target_arch='linux',
            nodejs_version=self.Parameters.node_version,
        )

        sdk2.ResourceData(rrnode_linux).ready()
