# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


class DemoDutyTemplate(sdk2.Task):
    """
    Подготовка шаблона для комментария в демо-задачу
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('startrek_client', custom_parameters=['--no-cache-dir'])]

    class Parameters(sdk2.Task.Parameters):
        filter_id = sdk2.parameters.String('ST filter ID', required=True)
        abc_slug = sdk2.parameters.String('ABC slug', required=True)
        with sdk2.parameters.String('Platform', required=True) as tmpl:
            tmpl.values[''] = tmpl.Value('default', default=True)
            tmpl.values['default'] = 'default'

    @classmethod
    def _test(cls):
        pass

    def on_execute(self):
        self._test()
