# -*- coding: utf-8 -*-

from sandbox import sdk2
from serp.lenour.common_code.update_lenour_graphs import GraphsUpdater, TOKEN_SECRETS


class UpdateLenourGraphs(sdk2.Task):
    """
    Обновление графиков для цели "мягкое переключение".
    @see https://st.yandex-team.ru/FEI-16027
    Задача собирается как бинарная PY3, подробнее о сборке: https://docs.yandex-team.ru/sandbox/dev/binary-task#python3
    """

    class Parameters(sdk2.Parameters):
        yt_token = sdk2.parameters.YavSecret(
            "YT secret identifier",
            default=TOKEN_SECRETS["yt"]
        )
        nanny_token = sdk2.parameters.YavSecret(
            "Nanny secret identifier",
            default=TOKEN_SECRETS["nanny"]
        )
        sandbox_token = sdk2.parameters.YavSecret(
            "Sandbox secret identifier",
            default=TOKEN_SECRETS["sandbox"]
        )
        with sdk2.parameters.Output():
            operation_url = sdk2.parameters.Url("Update query url")

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 1024

        # Нужно для запуске на мультислоте
        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        updater = GraphsUpdater(yt_token=self.Parameters.yt_token.data()["secret"],
                                nanny_token=self.Parameters.nanny_token.data()["secret"],
                                sandbox_token=self.Parameters.sandbox_token.data()["secret"])
        self.Parameters.operation_url = updater.update()
