# -*- coding: utf-8 -*-

import logging

from sandbox.sandboxsdk.channel import channel


def get_all_ancestors(current_layer):
    """
    :param current_layer: list of task ids
    :return: list of task ids
    """
    tree = list(current_layer)
    while current_layer:
        logging.debug('Requesting children of %s', current_layer)
        current_layer = channel.sandbox.list_tasks(parent_id=current_layer, get_id_only=True)
        logging.debug('Children are %s', current_layer)
        tree += current_layer
    logging.debug('No more ancestors. Resulting tree is %s', tree)
    return list(tree)
