# -*- coding: utf-8 -*-

from sandbox.sdk2.parameters import LastReleasedResource
from sandbox.projects.resource_types import (
    CLICKDAEMON_KEYS,
    REPORT_RENDERER_PACKAGE,
    STATBOX_PUSHCLIENT,
)
from sandbox.projects.report_renderer.resource_types import (
    REPORT_RENDERER_BUNDLE,
    REPORT_RENDERER_NODEJS_PACKAGE,
)


class ClickdaemonKeys(LastReleasedResource):
    name = 'CLICKDAEMON_KEYS'
    description = 'Ключи кликдемона'
    resource_type = CLICKDAEMON_KEYS
    attrs = {'released': 'stable'}


class ReportRendererBundlePackage(LastReleasedResource):
    name = 'REPORT_RENDERER_BUNDLE'
    description = 'Пакет с аркадийным Node.js и report-renderer'
    resource_type = REPORT_RENDERER_BUNDLE
    attrs = {'released': 'stable'}


class NodeJSPackage(LastReleasedResource):
    name = 'REPORT_RENDERER_NODEJS_PACKAGE'
    description = 'Пакет с аркадийным Node.JS'
    resource_type = REPORT_RENDERER_NODEJS_PACKAGE
    attrs = {'released': 'stable'}


class ReportRendererPackage(LastReleasedResource):
    name = 'REPORT_RENDERER_PACKAGE'
    description = 'Пакет с report-renderer'
    resource_type = REPORT_RENDERER_PACKAGE
    attrs = {'released': 'stable'}


class StatboxPushclient(LastReleasedResource):
    name = 'STATBOX_PUSHCLIENT'
    description = 'Бинарник пушклиента'
    resource_type = STATBOX_PUSHCLIENT
    attrs = {'released': 'stable'}
