# -*- coding: utf-8 -*-

from sandbox.sdk2 import Attributes
from sandbox.sdk2.resource import AbstractResource, Resource


# TODO use sdk2.Resource when report-renderer_version is not used anymore
class REPORT_RENDERER_BUNDLE(AbstractResource):
    """
        Бандл с аркадийной node.js и report-renderer
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['REPORT_RENDERER']

    nodejs_version = Attributes.String("Bundled ynode version")
    platform = Attributes.String("Bundled ynode target platform")
    report_renderer_version = Attributes.String("Bundled report-renderer version")
    dso = Attributes.Bool("Bundle contains DSOs for Node.js extensions")


# TODO use sdk2.Resource when separate task to build ynode is used and all attributes are listed here
class REPORT_RENDERER_NODEJS_PACKAGE(AbstractResource):
    """ Node JS binary package. """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['REPORT_RENDERER']
    svn_path = Attributes.String('svn_path')


class AHPROXY_EXECUTABLE(Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


class AHPROXY_UNISTAT(Resource):
    any_arch = True
    ttl = 90


class AHPROXY_LOG(Resource):
    any_arch = True
    ttl = 90


class NODEJS_EXECUTABLE(Resource):
    """ Nodejs binary """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    version = Attributes.String("Nodejs version")
    platform = Attributes.String("Target platform")


class RENDERER_CI_TEST_PACKAGE(Resource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['REPORT_RENDERER']


class RENDERER_BENCHMARK_RESULT_DATA(Resource):
    any_arch = True
    ttl = 14


class RENDERER_MEMORY_BENCHMARK_RESULT_DATA(Resource):
    any_arch = True
    ttl = 14


class RENDERER_MASTER_MEMORY_BENCHMARK_RESULT_DATA(Resource):
    any_arch = True
    ttl = 14


class LENOUR_EXECUTABLE(Resource):
    releasable = True
    releasers = ['REPORT_RENDERER']
    executable = True
    auto_backup = True
    version = Attributes.String("Lenour version")
    platform = Attributes.String("Target platform")


class NEW_SERVICE_API_EXECUTABLE(Resource):
    releasable = True
    releasers = ['REPORT_RENDERER']
    executable = True
    auto_backup = True
    version = Attributes.String("API version")
    platform = Attributes.String("Target platform")
