# coding: utf-8

"""
    DEPRECATED module with classes of resources.

    It's not allowed to place NEW resources here. Use your project's folder, please. Details here:
    https://wiki.yandex-team.ru/sandbox/quickstart/#strukturakoda

    See :class:`AbstractResource` for description of class parameters.

    NOTE: Please don't delete or rename existing resource classes.
    Questions? Suggestions? Ask on sandbox@yandex-team.ru maillist!
"""
from __future__ import absolute_import

from sandbox import sdk2
from sandbox.sdk2 import service_resources
from sandbox.common.types import resource as ctr

from .releasers import (
    health_releasers,
    news_releasers,
    jobs_releasers
)
from . import releasers as resource_releasers

# for backward compatibility, do not use it, use sdk2.Resource instead
AbstractResource = sdk2.resource.AbstractResource

images_index_releasers = [
    'ulgen4a',
    'sakhnov',
    'anskor',
    'panovav',
    'sind',
    'igorluk',
    'robot-images-sandbox',
    'ivankol',
    'volynkin',
    'gritsaev',
    'robot-testenv',
    'evseevd',
    'kozlovkr',
    'foxxmary',
    'mrboogie',
    'robot-srch-releaser',
    'wwfq',
]
images_releasers = [
    'krivokon',
    'panovav',
    'ulgen4a',
    'sind',
    'fedorenko',
    'gilazhev',
    'pupatenko',
    'igorluk',
    'sakhnov',
    'anskor',
    'ivankol',
    'fexion',
    'gritsaev',
    'evseevd',
    'krylov-sergey',
    'kozlovkr',
    'foxxmary',
    'mrboogie',
    'yudapav',
    'robot-srch-releaser',
    'ololowl',
    'kapacek',
    'party-up',
] + resource_releasers.multsearch + images_index_releasers
images_ban_releasers = ['anoh', 'robot-images-money', 'robot-images-sandbox'] + resource_releasers.media_sre
images_balancer_releasers = images_releasers
cbir_releasers = ['ulgen4a', 'anskor', 'volynkin', 'anoh'] + resource_releasers.marty
images_rim_releasers = ['pupatenko', 'krivokon', 'kapacek']
images_robot_releasers = ['anskor']
images_taas_releasers = images_releasers + ['anskor']
images_subscribers = ['images-releases']
images_data_subscribers = ['images-data-releases']
images_mrindex_subscribers = images_subscribers + ['images-index']
cbir_index_subscribers = images_subscribers
images_index_subscribers = images_subscribers
images_shardmap_subscribers = images_data_subscribers
images_basesearch_subscribers = images_index_subscribers
images_rim_subscribers = ['images-rim']
images_taas_subscribers = ['images-releases']
images_thumb_subscribers = images_subscribers
images_tags_releasers = images_index_releasers + ['guest', 'klakhman', 'rakhunzy']
images_tags_subscribers = images_tags_releasers

video_thumb_subscribers = ['video-robot-dev', 'videosearch-releases']

jupiter_subscribers = resource_releasers.jupiter_releasers
video_releasers = resource_releasers.video
video_data_releasers = resource_releasers.video_data
video_shardmap_releasers = video_releasers + resource_releasers.video_robot_releasers + resource_releasers.multsearch
video_subscribers = ['videosearch-releases']
video_robot_subscribers = resource_releasers.video_robot_releasers + ['video-monitoring']
video_data_subscribers = ['video-monitoring']
assistant_releasers = [
    'zador',
    'imakunin',
    'putrin',
    'jon2205',
    'riariorovere',
    'petrk',
    'atsepeleva',
    'vi002',
    'mihajlova',
    'akhruslan',
    'a-sidorin',
    'nkodosov',
    'ar7is7',
    'micyril',
    'mike88',
    'skazhenik',
    'g-kostin',
    'ikorobtsev',
    'zubchick',
    'mkamalova',
    'alkapov',
    'stakanviski',
    'pitnails',
    'a-square',
    'e8191',
    'mikailbag',
    'amder',
    'yagafarov',
    'alexanderplat',
    'd-dima',
    'robot-sup',
    'klim-roma',
]
assistant_apphost_releasers = [
    'petrk',
    'akhruslan',
    'zubchick',
    'mkamalova',
    'ran1s',
    'g-kostin',
    'mihajlova',
    'nkodosov',
    'alkapov',
    'vitvlkv',
    'zhigan',
    'sparkle',
    'ershov-ov',
    'yagafarov',
    'alexanderplat',
    'd-dima',
    'klim-roma',
]
iss_releasers = [
    'amich',
    'dkochetov',
    'robosova',
    'crastin',
    'robot-iss-publisher',
    'robot-iss-build-bot',
]
cvdup_releasers = ['volynkin']
cvdup_subscribers = cvdup_releasers
yql_releasers = ['blinkov', 'vvvv', 'wint', 'aozeritsky', 'udovichenko-r', 'a-romanov', 'aneporada', 'romakondakov', 'pskvazh']
yql_subscribers = ['blinkov', 'pskvazh']
yobject_releasers = ['antonchek', 'konovodov']
adult_releasers = ['vdf', 'quasar', 'lkozhinov', 'g-kostin', 'achigin', 'akolosov', 'kolomaxo', 'sneg']
tools_releasers = ['dukeartem', 'intar', 'markov', 'zlo']
freshness_releasers = [
    'trofimenkov',
    'nkmakarov',
    'alex-sh',
    'ustas',
    'melton',
    'albus',
    'iv-ivan',
    'zhevnerchuk',
    'asanikushin',
    'alpustovalova',
    'arcturus',
    'alexchern',
    'polyanskiy-mn'
]
market_report_releasers = ['market-robot', 'nmas', 'a-bocharov']
marketsre = ['asimakov', 'asivolapov', 'dburnazyan', 'dukeartem', 'isonami', 'kemsta', 'slyder', 'strkate',
             'adubrovin', 'aristarkh', 'le087', 'dspushkin', 'dvkhromov', 'e-a-sokolov']
market_kgb_releasers = marketsre + ['axc', 'manushkin', 'nadya73', 'sambuka', 'sildtm', 'vladon', 'ya-spe', 'zaripov-kamil', 'kolun', 'veminaev']
market_pers_releasers = ['robot-market-pers', 'a-danilov', 'valter', 'maratik', 'ukchuvrus', 'korolyov', 'dinyat',
                         'stille']
broadmatch_releasers = ['sashateh', 'apovetkin', 'emurav', 'druxa', 'serkh']
search_priemka_releasers = [
    'xpahos',
    'pmankevich',
    'gotocoding',
    'lebedev-aa',
    'asimonenko18'
]
rtcc_releasers = [
    'robot-maestro',
    'mvel',
    'avitella',
    'lebedev-aa',
    'anoh',
    'mincer',
    'robot-testenv',
    'gritukan',
    'dima-zakharov',
    'aykeron',
]
news_service_config_releasers = news_releasers + [
    'xpahos',
    'irrra',
]
personal_releasers = ['qkrorlqr', 'manokk', 'nikitakart', 'librarian', 'nightnord', 'schizophrenia', 'epar']
personal_data_releasers = personal_releasers + [
    'chikachoff',
    'const',
    'vtenity',
    'riddle',
    'pecheny',
    'zaringleb',
    'norberrt',
    'epar',
    'robot-pers-userdata',
    'robot-atom-banner'
]
apphost_releasers = [
    'qkrorlqr',
    'librarian',
    'manokk',
    'anoh',
    'nbahob',
    'shashkin',
    'mincer',
    'harotobira',
    'pmatsula',
    'robot-ah-releases',
    'elshiko',
    'sharpeye',
    'robot-testenv',
    'dskut',
    'alexandr21',
    'prez',
    'devamax',
    'ssart',
    'mafanasev',
    'vasil-sd',
    'pierre',
    'dstudentsov',
    'anskor',
    'sind',
    'juver',
    'tobo',
    'vlad-kolotvin',
    'shaveinikovds',
    'dmitryno',
    'smalukav',
    'alekseyzotov',
    'feldsherov',
    'robot-srch-releaser',
    'lebedev-aa',
    'volcolac',
    'kozunov',
    'aykeron',
    'smishin',
    'justdev',
    'shtorm941',
    'strokov',
    'jon2205',
    'alexburkov',
    'chepavel',
    'niketeen',
    'doggywolf',
    'halin-george',
    'ialand',
    'k-vukolov',
    'zhalgas',
    'dcnick3',
    'dudkomv',
    'andrey-em',
    'alkapitonov',
    'gvdozd'
]
src_setup_releasers = [
    'alex-ersh',
    'avitella',
    'dima-zakharov',
    'elshiko',
    'kozunov',
    'robot-srch-releaser',
    'vmordovin'
]
ads_quality_releasers = ['robot-ml-engine', 'amitin', 'mstebelev', 'mikari', 'shoutpva', 'fram', 'steninss', 'ilariia']
ads_quality_subscribers = ['amitin', 'robot-ml-engine', 'ilariia']
qloud_releasers = ['bgleb', 'terry', 'xgen', 'kozhapenko', 'lvovich', 'luba239', 'intr13', 'rurikk', 'yumal',
                   'atroynikov']
qloud_subscribers = qloud_releasers
nanny_releasers = ['alonger', 'frolstas', 'nekto0n', 'romanovich', 'nanny-robot', 'reddi', 'disafonov', 'ferenets',
                   'i-dyachkov', 'altynbek']
yt_ops = ["zuci42", "k-malov", "mbabich", "spuzirev", "stunder"]
disk_releasers = ["topright", "ivanov-d-s", "ignition", "kolyann", "robot-disk-cloud", "robot-disk-releaser",
                  "akinfold", "kis8ya", "yak-dmitriy",
                  "c4et4uk", "shirankov", "friendlyevil", "sanya2013", "vadzay", "derovi", "dobrowin", "kolnoochenko", "miroot"]
clickdaemon_releasers = [
    'flack',
    'kaero',
    'avitella',
    'dima-zakharov',
    'kkabulov',
    'mvel',
    'robot-srch-releaser',
    'robot-clickdaemon',
    'robot-morty',
]
report_web_releasers = [
    'robot-srch-releaser',
    'kozunov',
    'ezhi',
    'alex-ersh',
    'mvel',
    'elshiko',
    'avitella',
    'osidorkin',
    'vmordovin',
    'kkabulov',
    'dima-zakharov',
    'mya-engineer',
]
apphost_config_bundle_releasers = apphost_releasers + [
    'robot-ah-releases',
    'robot-testenv',
    'kozunov',
    'savvdm',
    'alex-ersh'
] + report_web_releasers + images_releasers
apphost_config_bundle_imgs_releasers = apphost_config_bundle_releasers + ['anoh', 'nbahob', 'woxalex']
apphost_config_bundle_video_releasers = apphost_config_bundle_releasers + video_releasers

advq_releasers = ['robot-advq-gen1', 'monoid', 'ADVQ']

metrika_releasers = ['presto', 'velom', 'robert', 'frenz']

ads_online_learning_releasers = [
    'shoutpva',
    'fram'
]

common_releasers = [
    'ashishkin',
    'dude',
    'stasis93',
    'zhigalov',
]

sport_news_releasers = [
    'dm-fish',
    'gsat83',
    'stupidhobbit',
    'zvr-s',
    'robot-ynews-releaser',
]

sport_wizard_releasers = freshness_releasers + sport_news_releasers

vh_frontend_releasers = resource_releasers.vh_frontend_releasers
vh_recommender_releasers = resource_releasers.vh_recommender_releasers

CORE_DUMP = service_resources.CoreDump
FILTERED_GDB_TRACEBACK = service_resources.FilteredGdbTraceback
TASK_CUSTOM_LOGS = service_resources.TaskCustomLogs
TASK_LOGS = service_resources.TaskLogs
UNKNOWN_RESOURCE = service_resources.UnknownResource


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOCAL_CMAKE(AbstractResource):
    """
        Файл cmake конфига, применяемый в задачах сборки из arcadia
    """

    auto_backup = True
    releasers = ['mvel', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVENTLOG_DUMP(AbstractResource):
    """
        Файл eventlog лога, может быть прочитан evlogdump-ом
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVENTLOG_JSON_STATS(AbstractResource):
    """
       Выборочная статистика из eventlog'а в формате json
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVENTLOG_FULL_STATS(AbstractResource):
    """
       Полная статистика из eventlog'а в текстовом формате
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENVIRONMENT_CONTEXT(AbstractResource):
    """
        Архив tar.gz со статическим окружением для какой-либо задачи: статические библиотеки, бинарники и т.д.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TCP_DUMP(AbstractResource):
    """
        Ресурс упоминается только в задаче TEST_ANTIROBOT, давное уже не используется (примерно год)
    """
    unused = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENISYS(AbstractResource):
    """
        Genisys bundle
    """
    releasable = True
    executable = False
    auto_backup = True
    releasers = ['torkve', 'SKYNET']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYSTICK(AbstractResource):
    """
        PyStic archive
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYSTICK_MINIMAL(AbstractResource):
    """
        PyStick minimal (pure binary)
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYSTICKER(AbstractResource):
    """
        PyStick toolkit
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SKYCORE_SERVICE(AbstractResource):
    """
    Skycore service
    """
    releasable = True
    executable = False
    auto_backup = True
    releasers = ['SKYNET']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SKYNET_DEPS(AbstractResource):
    """
        Папка с архивами с зависимостями skynet
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SKYNET_PACKAGE(AbstractResource):
    """
        run.py skynet installation binary
    """
    shard = True
    releasable = True
    auto_backup = True
    executable = True
    releasers = ['mocksoul', 'torkve', 'oplachkin', 'okats', 'osol']
    release_subscribers = ['mocksoul']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SKYNET_BINARY(AbstractResource):
    """
        skynet.bin installation binary
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = ['torkve', 'SKYNET']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_CONFIG(AbstractResource):
    """
        Файл конфига базового поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SEARCH_CONFIG(AbstractResource):
    """
        Файл конфига базового поиска видео для основного индекса (VideoTier0)
    """
    releasable = True
    auto_backup = True
    releasers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SEARCH_SSD_CONFIG(AbstractResource):
    """
        Файл конфига базового поиска видео для основного индекса (VideoTier0-ssd) для машинок с SSD дисками
    """
    releasable = True
    auto_backup = True
    releasers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы поиска
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSIONSTORE_PACKAGE(AbstractResource):
    """
        Fusiostore (ex-Orange-distributor) package
    """
    shard = True
    releasable = True
    auto_backup = True

    releasers = ['amich', 'karavashkin', 'kletskov', 'rybalko', 'marchael']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_SEARCH_CONFIG(AbstractResource):
    """
        Файл конфига Fusion
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_OXYGEN_CONFIG(AbstractResource):
    """
        Fusion Oxygen Options config file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_USERDATA_LONG(AbstractResource):
    """Resource for testing and releasing userdata for fusion"""
    auto_backup = True
    releasable = True
    releasers = ['amich', 'marchael', 'karavashkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_EXTERNAL_DATA(AbstractResource):
    """Resource for testing and releasing external for fusion"""
    auto_backup = True
    releasable = True
    releasers = ['amich', 'marchael', 'karavashkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_USERDATA_FAST(AbstractResource):
    """Resource for testing and releasing userdata for fusion"""

    auto_backup = True
    releasable = True
    releasers = ['amich', 'marchael', 'karavashkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_USERDATA_LONG_FRESHFILTER(AbstractResource):
    """Resource for testing and releasing userdata for fusion"""

    auto_backup = True
    releasable = True
    releasers = ['amich', 'marchael', 'karavashkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONOLITH_CONFIG(AbstractResource):
    """
        Standalone distributor (Monolith) config file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOCAL_FUSION_RUNNER(AbstractResource):
    """
        Scripts bundle (.tar.gz) to run local fusion stand
    """
    auto_backup = True
    releasable = True
    releasers = ['karavashkin', 'mvel']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FSTR_INFO(AbstractResource):
    """
        Fstr dumps for formula archive
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INDEXER_REQUESTS_DUMP(AbstractResource):
    """
        Dump of IndexRequests to be fed to indexer
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом основной базы картиночного поиска
    """
    shard = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы основного видеопоиска
    """
    shard = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASE_VIDEO_LOOP_CONFIG(AbstractResource):
    """
        Конфиг instancectl для базовых видео
    """
    releasable = True
    releasers = video_releasers
    release_subscribers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_QUICK_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы быстрого видеопоиска
    """
    shard = True
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_ULTRA_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы ультрабыстрого видеопоиска
    """
    shard = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_ULTRA_THUMB_DATABASE(AbstractResource):
    """
        Папка с шардом ультрабыстрых видео тумбнейлов
    """
    shard = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WRLENDAT_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл wrlendat - утилита для удаления антиспама из базы базового поиска
    """
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AFISHASEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл афишного базового поиска
    """
    releasable = True
    releasers = ['petrk', 'algo', ]
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/afisha/base/afishasearch/afishasearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AFISHASEARCH_INDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексера афишного базового поиска
    """
    any_arch = False
    executable = True
    releasable = True
    releasers = ['petrk', 'algo']
    arcadia_build_path = 'extsearch/afisha/indexer/afishaindexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORTSEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл спортивного базового поиска
    """
    releasable = True
    releasers = ['petrk', 'algo']
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/sport/base/sportsearch/sportsearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORTSEARCH_INDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексера спортивного базового поиска
    """
    any_arch = False
    executable = True
    releasable = True
    releasers = ['petrk', 'algo']
    arcadia_build_path = 'extsearch/sport/indexer/sportindexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers
    arcadia_build_path = 'search/daemons/basesearch/basesearch'
    arcadia_build_name = 'basesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_EXECUTABLE_FUZZY(AbstractResource):
    """
        Исполняемый файл базового поиска с фаззером (SEARCH-2679)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers
    arcadia_build_path = 'search/fuzzing/fuzz_base/fuzz_base'
    arcadia_build_name = 'basesearch_fuzzy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_EXECUTABLE_FUZZY(AbstractResource):
    """
        Исполняемый файл визарда с фаззером (SEARCH-3038)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.wizard_releasers
    arcadia_build_path = 'search/fuzzing/fuzzer/wizard/wizard'
    arcadia_build_name = 'wizard_fuzzy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class METRIKA_NODEJS_PACKAGE(AbstractResource):
    """ Node JS binary package. """
    releasable = True
    auto_backup = True
    releasers = metrika_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class METRIKA_WATCH_BUILD_RESULT(AbstractResource):
    """
        Metrika watch.js build result
    """
    releasable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STAT_COLLECTOR_BINARY(AbstractResource):
    """
        calc_aqua_metrics tool for aqua tests executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STAT_FETCHER_BINARY(AbstractResource):
    """
        calc_aqua_metrics tool for aqua tests executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCE_YT_EXECUTABLE(AbstractResource):
    """
        Бинарная версия mapreduce-yt
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_LOGS_TO_CHECK(AbstractResource):
    """
       Список логов для проверки
    """
    auto_backup = True
    ttl = 720
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_SESSIONS_FRESHDATA_INFO(AbstractResource):
    """
       Информация о местоположении свежих данных для автотестов пользовательских сессий в YT.
       А также список логов, из которых были построены выжимки
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_SESSIONS_PROCESSES_FRESHDATA_INFO(AbstractResource):
    """
       Информация о местоположении свежих выжимок для полного тестирования построения пользовательских сессий в YT.
       А также списки логов, из которых были построены выжимки
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SESSIONS_DIFF_TABLES_LIST(AbstractResource):
    """
       Список таблиц с изменениями результатов построения сессий
    """
    releasers = resource_releasers.user_sessions_releasers
    auto_backup = True
    ttl = 366
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_CONFIG(AbstractResource):
    releasers = ['iamiggor']  # probably remove


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_BETA_LIST(AbstractResource):
    releasers = ['iamiggor']  # probably remove


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_OUTPUT(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_REPORT_LOGS(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_CLICKDAEMON_LOGS(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_RELEV_REGIONS(AbstractResource):
    auto_backup = True
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_COUNTERS_XML(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_REQANS_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_IMGREQANS_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_XMLREQANS_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_VIDEOREQANS_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_ACCESS_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_BLOCKSTAT_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_AQUA_METRICS_MOCK_REDIR_LOG(AbstractResource):
    releasers = ['iamiggor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VERDICT_BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Ресурс для базового поиска для колдунщика в словарях
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['denisbykov', ]
    arcadia_build_path = 'search/daemons/basesearch/basesearch'
    arcadia_build_name = 'verdict_basesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICK_POOL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл click_pool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['druxa', ]
    release_subscribers = ['pavvloff', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WHITEHILL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл whitehill2
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['druxa', ]
    release_subscribers = ['mahaby', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTO_POOL_READER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл proto_pool_reader
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/tools/idx_ops/reader/proto_pool_reader'
    releasers = (
        resource_releasers.base_releasers + resource_releasers.idx_ops_releasers + resource_releasers.prs_ops_releasers + ['robot-srch-releaser']
    )


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POOL_MERGE_FILTER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл pool_merge_filter
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/tools/idx_ops/merge_filter/pool_merge_filter'
    releasers = resource_releasers.base_releasers + resource_releasers.idx_ops_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POOL_CONVERTER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл pool_converter
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/tools/idx_ops/converter/pool_converter'
    arcadia_build_name = 'pool_converter'
    releasers = (
        resource_releasers.base_releasers + resource_releasers.idx_ops_releasers + resource_releasers.prs_ops_releasers + ['robot-srch-releaser']
    )


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BF_DISTR_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл bf_distr
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QCOOKIE_KEYS_BUNDLE(AbstractResource):
    """
        Ключи и прочая машинерия для qcookie
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['elantsev', 'sourcerer']
    release_subscribers = ['kfour', 'elantsev', 'sourcerer']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERY_RMODEL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл query_rmodel
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MN_CUDA_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mn_cuda
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_URL_DUPS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл idx_urldups
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QURL_RATES_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл qurl_rates
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['cherolex', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_URLS_SHARDS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mr_urls_shards
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_BETA_DUMP_DATA_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл userdata_beta_dump_data
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', 'akhropov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_VIEW_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл userdata_view
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'yweb/robot/userdata/userdata_view/userdata_view'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTS_BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового поиска. Включена дефолтная турецкая морфология.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['petrk', 'noiseless']
    arcadia_build_path = 'search/daemons/basesearch/basesearch'
    arcadia_build_name = 'factsbasesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTS_BASESEARCH_EXECUTABLE_UA(AbstractResource):
    """
        Исполняемый файл базового поиска. Кастомная украинская морфология.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['petrk']
    arcadia_build_path = 'search/daemons/basesearch/basesearch'
    arcadia_build_name = 'factsbasesearch_ua'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASEPPBSEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового для поиска по блогам (PPB)
    """
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITE_SUGGEST_WEBDAEMON(AbstractResource):
    """
        Исполняемый файл для site suggest
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['myltsev']
    arcadia_build_path = 'quality/trailer/site_suggest/webdaemon/sitesuggestd'
    arcadia_build_name = 'site_suggest_webdaemon'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_WEBDAEMON(AbstractResource):
    """Демон большого саджеста"""
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.suggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/web_fastcgi_daemon'
    arcadia_build_name = 'suggest-web-daemon'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_CMDLINE_SERVER(AbstractResource):
    """Тестовый бинарник большого саджеста"""
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.suggest_releasers
    arcadia_build_path = 'quality/trailer/suggest/tests/cmdline_server'
    arcadia_build_name = 'cmdline_server'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_WEBDAEMON_CONFIGS(AbstractResource):
    """Configs for SUGGEST_WEBDAEMON"""
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.suggest_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OFFLINE_SEARCH_UPDATE_SERVER(AbstractResource):
    """Сервер по обновлению словарей для оффлайн поиска"""
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['finder', 'amneziya', 'bykanov', 'vsavenkov', 'romario']
    arcadia_build_path = 'quality/trailer/offline_search/server'
    arcadia_build_name = 'offline_search_server'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_DICT(AbstractResource):
    """Словари саджеста"""
    auto_backup = True
    releasers = ['romario', 'svasi', 'artalex', 'sapa', 'vsavenkov', 'bykanov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового поиска для новостей
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['lazy', 'yurifrolov', 'sgrb', 'trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_PLAN(AbstractResource):
    """
        План для долбилки с запросами к базовому поиску
    """
    auto_backup = True
    releasable = True
    releasers = ['mcden', 'okats', 'robot-juba']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_UNISTAT_SIGNALS(AbstractResource):
    """
        List of available unistat signals
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SEARCH_PLAN(AbstractResource):
    """
        План для долбилки с запросами к видео базовому поиску с основной базой
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_QUICK_SEARCH_PLAN(AbstractResource):
    """
        План для долбилки с запросами к видео базовому поиску с быстрой базой
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PURE_DATA(AbstractResource):
    """
        Данные pure (elric@, snow@, mvel@)
        Pantera project
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_QLOSS_EXECUTABLE(AbstractResource):
    """
        Бинарник программы idx_qloss (elric@, kcd@)
        Pantera project
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/panther/tools/idx_qloss/main/idx_qloss'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_QUERY_OUTPUT(AbstractResource):
    """
        Выхлоп idx_query (elric@, snow@, mvel@)
        Pantera project
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_QUERY_EXECUTABLE(AbstractResource):
    """
        Бинарник программы idx_query (elric@, ivansmirn@, mvel@)
        Pantera project
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/panther/tools/idx_query/idx_query'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_EXECUTABLE(AbstractResource):
    """
        Бинарник программы idx_ops
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.idx_ops_releasers
    arcadia_build_path = 'search/tools/idx_ops/main/idx_ops'
    arcadia_build_name = 'idx_ops'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SYM_IDX_OPS_EXECUTABLE(AbstractResource):
    """
        Символы для программы idx_ops
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_VIDEO_EXECUTABLE(AbstractResource):
    """
        Бинарник idx_ops для видео-пулов
    """
    releasable = False
    any_arch = False
    executable = True
    arcadia_build_path = 'extsearch/video/tools/idx_ops/idx_ops_video'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = news_releasers + ['irrra']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRACE_OUT(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQANS_LOG(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROFILE_LOG(AbstractResource):
    """
        profile_log from Report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_DIFF(AbstractResource):
    """
        yabs_diff from Report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ERROR_LOG(AbstractResource):
    """
        error_log from Report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLAIN_TEXT_QUERIES(AbstractResource):
    """
        CGI-запросы на поиск в виде текстового файла (по 1 строке на запрос).
        Запрос начинается с ?, например "?&&lr=177&ag0=d&disable_url=1&gopl=20&gta=_Markers...",
        т.е. имя коллекции, а также host/port не указываются.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MISC_TEXT_QUERIES(AbstractResource):
    """
        Запросы на поиск в виде текстового файла (по 1 строке на запрос)
        <запрос> [TAB <опциональное описание запроса>]
        Каждый запрос начинается cо / <имя коллекции (URL path)>
        Запросы используются для тестирования поисков, отличных от обычных WEB (MISC-ов)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERS_QUERIES(AbstractResource):
    """
        Пользовательские запросы в виде простого текстового файла (по 1 строке на запрос).
        Опционально через табуляцию может указываться код региона (для cgi-параметра &lr=).
        Например: "скачать фильм джанго<tab>213"
        Не путать с PLAIN_TEXT_QUERIES, которые являются cgi-запросами.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQUESTS_FOR_NOAPACHEUPPER(AbstractResource):
    """
        CGI-запросы для поискового сервиса noapacheupper в виде текстового файла (по 1 строке на запрос).
        Запрос по сути состоит из двух cgi параметров client_ctx и gobal_ctx (магия генерируемая репортом)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BINARY_REQUESTS_FOR_NOAPACHEUPPER(AbstractResource):
    """
        CGI или ya-multi-json - запросы для поискового сервиса noapacheupper в виде файла с разметкой
        размерами запроса (записывается ui32 размер запроса, после которого само тело запроса)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GZIPPED_REQUESTS_FOR_NOAPACHEUPPER(AbstractResource):
    """
        CGI-запросы для поискового сервиса noapacheupper в виде сжатого текстового файла (по 1 строке на запрос).
        Запрос по сути состоит из двух cgi параметров client_ctx и gobal_ctx (магия генерируемая репортом)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GZIPPED_BINARY_REQUESTS_FOR_NOAPACHEUPPER(AbstractResource):
    """
        CGI-запросы для поискового сервиса noapacheupper в виде сжатого текстового файла (ui32size separated).
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PATCH_FOR_NOAPACHEUPPER_REQUEST(AbstractResource):
    """
        В связи с витиеватым форматом запросов к noapacheupper патч к ним описывается в формате json
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLAIN_SEARCH_SERPS(AbstractResource):
    """
        search engine serps. format:
        query<TAB>region<TAB>url
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERIES_CACHE(AbstractResource):
    """
        Сохраненный кеш запросов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERYDATA_INDEXER(AbstractResource):
    """
        resource related with FastTier & Orange
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['akhropov', 'xpahos'] + resource_releasers.wizard_releasers + resource_releasers.querysearch_releasers + resource_releasers.geosearch_releasers
    arcadia_build_path = 'yweb/querydata/querydata_indexer/querydata_indexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERYDATA_VIEWER_EXECUTABLE(AbstractResource):
    """
        Dumper for querydata tries
    """
    any_arch = False
    executable = True
    releasable = True
    releasers = resource_releasers.querysearch_releasers + ['akhropov', 'xpahos']
    auto_backup = False
    any_arch = False
    arcadia_build_path = 'yweb/querydata/querydata_viewer/querydata_viewer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOLB_DUMPER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл dolb_dumper-а - утилиты для парсинга ответов кликового из дампов долбилки.
    """
    executable = True
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.querysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class Y_LOCAL_ENV(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUDIOSEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл аудиопоиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'elkalinina', 'nglaz']
    release_subscribers = ['music-search']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MUSICSEARCH_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'nglaz', 'gurrrik', 'alexbool']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MUSIC_MIDDLESEARCH_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'elkalinina', 'nglaz']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FESTSEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл поиска по музыкальным фестивалям
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'nglaz']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMRECSEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл аудиопоиска для распознавания
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'nglaz', 'svirg', 'elkalinina', 'robot-muzsearch']
    release_subscribers = ['music-search-monitoring']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMRECMIDDLESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл среднего аудиопоиска для распознавания
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['singleton', 'nglaz', 'svirg', 'elkalinina', 'robot-muzsearch']
    release_subscribers = ['music-search-monitoring']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TWISNIP_SERVER_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['pervyshev', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TWIREF_SERVER_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['pervyshev', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEXT_SNIPPETS_QUERIES(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCHMODE_QUERIES(AbstractResource):
    """
        Файл с запросами к batch-у
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCHMODE_TESTING_RESULTS(AbstractResource):
    """
        Папка с результатами выполнения batch-а
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_HR_RESPONSES(AbstractResource):
    """
    Файл с ответами базового поиска или метапоиска в текстовом формате (hr=da)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_PROTO_RESPONSES(AbstractResource):
    """
    Файл с ответами базового поиска или метапоиска в бинарном формате (protobuf)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_HR_RESPONSES(AbstractResource):
    """
    Файл с ответами базового поиска или метапоиска в текстовом формате (hr=da)
    с ui32 (response-size-info) разделителями
    (формат разметки запросов аналогичен SEARCH_PROTO_RESPONSES, но данные proto-hr, а не raw proto)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESPONSES_SEARCH_APP_SERVICE(AbstractResource):
    """
        Ответы поискового app_host сервиса (raw)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_RESPONSES_COMPARE_RESULT(AbstractResource):
    """
        Результат сравнения двух выдач базового
    """
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUSION_RESPONSES_COMPARE_RESULT(AbstractResource):
    """
        Результат пофакторного сравнения двух выдач fusion
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_RPS_STATS_COMPARE_RESULT(AbstractResource):
    """
        Сравнение двух RPS-ов и подсчёт pValue
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOAD_LOG(AbstractResource):
    """
        Basesearch loadlog
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOAD_LOG_COMPARE_RESULT(AbstractResource):
    """
        Basesearch loadlog compare result
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VALGRIND_MASSIF_OUTPUT(AbstractResource):
    """
        output of valgrind --tool=massif ...
    """
    auto_backup = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_MEMORY_COMPARE_RESULT(AbstractResource):
    """
        result of compare two VALGRIND_MASSIF_OUTPUT resources
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VALGRIND_MEMCHECK_OUTPUT(AbstractResource):
    """
        xml output of valgrind --tool=memcheck --leak-check=full --xml=yes ...
    """
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBG_DOLBILKA_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLE_USERDOWN_MOCKUP_EXECUTABLE(AbstractResource):
    """
        Utility for userdataown on middlesearch project testing and monitoring
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_INDEX(AbstractResource):
    """
        Userdata folder with indexuserown index, d.c2n and geo.c2p. can be built by robot or manualy
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBG_DOLBILKA_OUTPUT(AbstractResource):
    """

    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBG_DOLBILKA_COMPARE_RESULT(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ESTFEATURES_OUTPUTS_COMPARE_RESULT(AbstractResource):
    """
        Html with formated diff of two estfeatures-pools
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TM_LIMITS_MONITOR_COMPARE_RESULT(AbstractResource):
    """
        Html with formated diff of two text-machine limits monitors
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBG_DOLBILKA_QUERY_URL_PAIRS(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBG_DOLBILKA_QUALITY_LOSS(AbstractResource):
    """
        Выхлоп qloss от dbg_dolbilka (old qloss, deprecated by lamo@ qloss)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTURLS_EXECUTABLE(AbstractResource):
    """
        Бинарник программы tools/printurls (используется в том числе для подсчёта qloss)
    """
    releasable = False
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POOL_COMPARER_EXECUTABLE(AbstractResource):
    """
        Бинарник программы search/tools/idx_ops/comparer
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.idx_ops_releasers + ['ilnurkh', 'gotmanov', ]
    arcadia_build_path = 'search/tools/idx_ops/comparer/pool_comparer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERUN_PACKAGE(AbstractResource):
    """
        yandex-pachage собранный из quality/relev_tools/perun/fml_runner/deploy_package.json
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["ilnurkh", "gotmanov", "qdee", "solozobov"]
    release_subscribers = ["ilnurkh", "qdee", "solozobov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QLOSS_OUTPUT(AbstractResource):
    """
        Quality loss statuses for query/documents
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QLOSS_COMPARE_RESULT(AbstractResource):
    """
        Difference of quality loss statuses
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QLOSS_TEST_DATA(AbstractResource):
    """
        A tbz archive with scripts and queries for qloss
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_OUTPUT(AbstractResource):
    """
        Выхлоп программы idx_ops в режиме serp
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERYSEARCH_BASE_EXECUTABLE(AbstractResource):
    """
    Deprecated.

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.querysearch_releasers


class THUMBS_BAN_QUERYSEARCH_CONFIG(AbstractResource):
    """
        Конфиг кликового сервера для бана тумбнейлов
    """
    releasable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_path = 'extsearch/images/thumbs_ban/querysearch.cfg'
    release_subscribers = images_thumb_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMBS_BAN_QUERYSEARCH_EXECUTABLE(QUERYSEARCH_BASE_EXECUTABLE):
    releasers = images_releasers
    release_subscribers = images_thumb_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMGSEARCH_RTYSERVER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл картиночного rty-сервера
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/saas/base/imagesrtyserver/imagesrtyserver'
    release_subscribers = images_index_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMGSEARCH_SHARD_CHECKER_EXECUTABLE(AbstractResource):
    """
        Утилита для верификации шардов картиночного базового поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/tools/shard_checker/shard_checker'
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGE_AS_QUERY_SERPS(AbstractResource):
    """
        Серпы полученные от поиска картинкой
    """
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESINFO_DAEMON_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл resinfod
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['ezhi', 'nbahob']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESINFO_DAEMON_PLAN(AbstractResource):
    """
        Файл плана долбилки с запросами к resinfod
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESINFO_DAEMON_DATA(AbstractResource):
    """
        Папка с файлами данных для resinfod
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DIR_LIST(AbstractResource):
    """
        Список путей, от которых зависит проект
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_BASESEARCH_EXECUTABLE(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    executable = True
    auto_backup = True
    any_arch = False
    releasers = ['denisbykov', 'igoshkin', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_ENCYCSEARCH_EXECUTABLE(AbstractResource):
    """
        Яндекс.Словари
    """

    releasable = True
    executable = True
    auto_backup = True
    any_arch = False
    releasers = ['denisbykov', 'igoshkin', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_MEANING_LIBRARY(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['galtsev', 'denisbykov', 'igoshkin', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_SPELLING_LIBRARY(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['denisbykov', 'igoshkin', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_ARTICLE_LIBRARY(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['denisbykov', 'igoshkin', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_CLUSTERIZATION_PACKAGE(AbstractResource):
    """
        Яндекс.Словари. deb пакет
    """
    releasable = True
    any_arch = False
    releasers = ['denisbykov', 'igoshkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_MEANING_INDEX(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_SPELLING_INDEX(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_ARTICLE_INDEX(AbstractResource):
    """
        Яндекс.Словари
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SVN_EXECUTABLE(AbstractResource):
    """
        Архив tar.gz с исполняемыми файлами svn
    """
    releasable = False
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz со статически собранными исполняемыми файлами java
    """
    releasable = False
    executable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_LIBRARY(AbstractResource):
    """
       Jar архив.
    """
    releasable = False
    executable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RUBY_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz со статически собранными исполняемыми файлами ruby
    """
    releasable = False
    executable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YCSSJS_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с ycssjs и yuicompressor.jar
       Нужен для сборки шаблонов репорта
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_JDK_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz со статически собранными исполняемыми файлами jdk (Oracle)
    """

    releasable = False
    executable = False
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MERCURIAL_EXECUTABLE(AbstractResource):
    """
        Архив tar.gz с исполняемыми файлами mercurial
    """
    releasable = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVAWRT_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz со статически собранными исполняемыми файлами jdk (WRT)
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANT_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами Ant
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAVEN_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами Maven
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIT_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами для установки системы контроля версий Git
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIT_LFS_ENVIRONMENT(AbstractResource):
    """
       Архив c бинарником/исходникми git-lfs
       https://git-lfs.github.com/
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YQL_RESULT_DUMP(AbstractResource):
    """
       Результаты выполнения YQL запроса
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIT_DEPOT_TOOLS_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами для установки дополнительных git-утилит
       https://commondatastorage.googleapis.com/chrome-infra-docs/flat/depot_tools/docs/html/depot_tools.html
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOPFLI_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами для установки утилиты zopfli
       https://github.com/google/zopfli
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VCDIFF_ENVIRONMENT(AbstractResource):
    """
       Архив с исходниками open-vcdiff
       https://github.com/google/open-vcdiff/archive/master.tar.gz
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TOP_HEAVY_SHOOTINGS(AbstractResource):
    """
        Вложения(патрон, кеш, ...) для топ тяжелых обстрелов
    """

    releasable = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PULSE_PROFILE_LOG(AbstractResource):
    """
        Кастомный лог от report-renderer
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PULSE_HTML_RESPONSES(AbstractResource):
    """
        HTML ответы от RR
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PREFETCHED_REPORT_DATA(AbstractResource):
    """
       Архив с подготовленными для обстрела данными
    """

    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NODE_AND_NPM_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz со статически собранными исполняемыми файлами nodejs и npm
       Также в архиве могут быть установлены пакеты в npm (например, bem)
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERP_TEMPLATE_PROFILER_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с node.js модулем для профайлинга серповых шаблонов
       Модуль self-contain, т.е. содержит в себе всё необходимое для работы (кроме Node.js вестимо)
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FAKECHROOT_ENVIRONMENT(AbstractResource):
    """
       Архив tar.gz с файлами для программы fakechroot
    """
    releasable = False
    executable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERP_TEMPLATE_PROFILER_CONFIG(AbstractResource):
    """
       JS файл с параметрами профайлинга серповых шаблонов,
       для конкретной версии Репорта
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_TEMPLATES_DATA_PACKAGE(AbstractResource):
    """
        Aрхив tar.gz с данными для шаблонов, которые необходимы для
        тестирования скорости шаблонизации поисковых проектов
    """
    uploadable = True
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_TEMPLATES_DATA_DUMP_PLAN(AbstractResource):
    """
        Список запросов для дампа предшаблонизированных данных
    """
    uploadable = True
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SELENIUM_EXECUTABLE(AbstractResource):
    """
        Архив tar.gz с пропатченной библиотекой selenium
    """
    releasable = False
    executable = False
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NPM_MODULE_ENVIRONMENT(AbstractResource):
    """
       Npm модуль
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPARE_UPPER_TAILS(AbstractResource):
    """
       CompareUpperResults
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPARE_UPPER_REPORT(AbstractResource):
    """
       CompareUpperResults
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPARE_UPPER_DUMP(AbstractResource):
    """
       CompareUpperSequential
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAPACHEUPPER_CONFIG(AbstractResource):
    """
        Файл конфига верхнего метапоиска (отделённого от апача)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_CONFIG(AbstractResource):
    """
        Файл конфига среднего поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEARCH_META_UT_EXECUTABLE(AbstractResource):
    """
        middlesearch unittests executable
    """
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/meta/ut/search-meta-ut'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_RANKING_MIDDLESEARCH_EXECUTABLE(sdk2.Resource):
    """
        fresh ranking middlesearch executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.middle_releasers
    arcadia_build_path = 'extsearch/fresh/meta/fresh_ranking_middlesearch/fresh_ranking_middlesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DIRECTMETASEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл метапоиска для Рекламного Шарда
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['alsafr']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MISC_MIDDLESEARCH_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл среднего поиска для news и yaca
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.middle_releasers
    arcadia_build_path = 'search/daemons/misc_middlesearch/misc_middlesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOMETASEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл geometa-поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/meta/daemon/geometasearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODAEMON_EXECUTABLE(AbstractResource):
    """
        Демон для просмотра документных факторов из жука
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/geodaemon/geodaemon'
    arcadia_build_name = 'geodaemon'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOQAAS_EXECUTABLE(AbstractResource):
    """
        Демон для позапросного qloss из жука
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/qloss/qaas/qaas'
    arcadia_build_name = 'qaas'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_TOOLS(AbstractResource):
    """
        Набор тулзов геопоиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_FACTOR_COMPARE(AbstractResource):
    """
        Демон для сравнения факторов на выдаче базовых геопоиска
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOMETASEARCH_CONFIG(AbstractResource):
    """
        Файл конфига geometa-поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOMETASEARCH_REQANS_LOG(AbstractResource):
    """
        Файл reqans-логов geometa-поиска

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOMETASEARCH_OUTPUT(AbstractResource):
    """
        Файл выхллопа (stderr, stdout) geometa-поиска

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_SBS_SOURCES(AbstractResource):
    """
        План для геопоискового SbS + сохраненные серпы
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTMMS_EXECUTABLE(AbstractResource):
    """
        Программа для просмотра companies.mms
    """
    any_arch = False
    executable = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_ORG1_URL_RELATED_OIDS_TRIE(AbstractResource):
    """
        QueryData трай с данными для колдунщика организаций
        см. GEOSEARCH-3235
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_ORG1_RAW_COMPANIES_INFO(AbstractResource):
    """
       Файл с данными из BACKA для формирования запросов к хамстерам
    """
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESS_SNIPPET_DATA(AbstractResource):
    """
       Архив с данными для адресного сниппета на кликовом (fastsnips)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MIDDLESEARCH_INDEX(AbstractResource):
    """
        Данные переранжирований картиночного среднего поиска, релиз вместе с индексом
    """
    shard = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MIDDLESEARCH_PLAN(AbstractResource):
    """
        План обстрела картиночного среднего/промежуточного поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MIDDLESEARCH_PLAIN_TEXT_REQUESTS(AbstractResource):
    """
        Запросы к картиночному среднему/промежуточному поиску в текстовом виде
        Отличаются от PLAIN_TEXT_QUERIES наличием пути в урле (yandsearch или quick)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MIDDLESEARCH_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл картиночного среднего/промежуточного поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers + resource_releasers.middle_releasers
    arcadia_build_path = 'extsearch/images/meta/images_middlesearch/images_middlesearch'
    release_subscribers = images_index_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_CONFIG(AbstractResource):
    """
        Файл конфига видео среднего/промежуточного поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_PLAN(AbstractResource):
    """
        План обстрела видео среднего/промежуточного поиска
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_PLAIN_TEXT_REQUESTS(AbstractResource):
    """
        Запросы к видео среднему/промежуточному поиску в текстовом виде
        Отличаются от PLAIN_TEXT_QUERIES наличием пути в урле (yandsearch или quick)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE(sdk2.Resource):
    """
        Исполняемый файл видео среднего ранжирующего поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'extsearch/video/meta/video_middlesearch/video_middlesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_DATA(AbstractResource):
    """
        Данные переранжирований видео среднего поиска, релиз независимый от индекса
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FRESH_QUERYMARKS_TRIE(AbstractResource):
    """
        Трай с асессорскими оценками запросов для свежести видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fresh_querymarks.trie'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FRESH_QUERYMARKS_PLAIN(AbstractResource):
    """
        Файл с асессорскими оценками запросов для свежести видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fresh_querymarks.plain'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FRESH_QUERYMARKS_VERSION(AbstractResource):
    """
        Файл с временем создания трая с асессорскими оценками запросов для свежести видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fresh_querymarks.version'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FRESH_QUERYMARKS_WIZARDINGS(AbstractResource):
    """
        Файл с переколдовками, которые были использованы для получения нормализаций запросов из трая
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fresh_querymarks.wizardings'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOTOP_URLS(AbstractResource):
    """
        Файл с документами для видеотопа
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videotop.plain'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOTOP_TRIE(AbstractResource):
    """
        Файл с документами для видеотопа в формате trie
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videotop.trie'
    plain_resource_type = VIDEO_MIDDLESEARCH_VIDEOTOP_URLS


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FASTDELIVERY_URLS(AbstractResource):
    """
        Файл с документами для быстрой доставки на среднем
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fastdelivery.plain'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FASTDELIVERY_TRIE(AbstractResource):
    """
        Файл с документами для быстрой доставки на среднем
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'fastdelivery.trie'
    plain_resource_type = VIDEO_MIDDLESEARCH_FASTDELIVERY_URLS


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_TRIE(AbstractResource):
    """
        Файл с партнерами для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.trie'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_VERSION(AbstractResource):
    """
        Файл с версией партнеров для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.version'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_HOSTS(AbstractResource):
    """
        Файл с хостами партнеров для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.hosts'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_KINOPOISK_RAW_DATA(AbstractResource):
    """
        Файл с сырыми данными от Кинопоиска для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.kinopoisk.raw'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_PARTNERS_RAW_DATA(AbstractResource):
    """
        Файл с сырыми данными партнеров для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.partners.raw'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOADV_URLS(AbstractResource):
    """
        Файл с урлами партнеров для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoadv.urls'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOBAN_TRIE(AbstractResource):
    """
        Файл с баном для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoban.trie'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOBAN_VERSION(AbstractResource):
    """
        Файл с версией бана для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoban.version'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOBAN_SOFT404_HASH_VEC(AbstractResource):
    """
        Файл с хешами soft404 урлов для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoban.soft404.vec'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_FASTER_VIDEOBAN_SOFT404_HASH_VEC(AbstractResource):
    """
        Файл с хешами soft404 урлов для видео для faster ban.
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoban.faster.soft404.vec'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_VIDEOBAN_RAW_DATA(AbstractResource):
    """
        Файл с исходными данными для бана видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'videoban_raw.txt'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_ANTIPIRATE_URLS_BAN_GRIMHOLD(AbstractResource):
    """
        Файл экспорта с grimhold для антипиратского бана видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'video.url.ban.querydata.gz'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_URL_BAN(AbstractResource):
    """
        Файл для бана видео урлов
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'urlban.lst'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_SOFT_404_BAN(AbstractResource):
    """
        Файл с soft404 урлами для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'robot_soft404.urls'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_SOFT_404_FASTER_BAN(AbstractResource):
    """
        Файл с faster soft404 урлами для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'robot_faster_soft404.urls'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_HOST_BAN(AbstractResource):
    """
        Файл c хостовым баном для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'query_hostban.ban'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_USER_AGENT_BAN(AbstractResource):
    """
        Файл c баном по юзер агенту для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'query_useragent.ban'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_QUERYURL_BAN(AbstractResource):
    """
        Файл c баном по запросам-урлам для видео
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'queryurl.ban'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_CONTENT_ATTRS_PLAIN(AbstractResource):
    """
        Файл с похостовым списком контентных атрибутов в читаемом формате
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    any_arch = True
    basename = 'contentattrs.lst'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_CONTENT_ATTRS(AbstractResource):
    """
        Файл с похостовым списком контентных атрибутов
    """
    releasable = True
    releasers = video_data_releasers
    release_subscribers = video_data_subscribers
    auto_backup = True
    basename = 'contentattrs.trie'
    release_tag = 'contentattrs-data'
    parameter_name = 'contentattrs_data'
    parameter_description = 'Player whitelist'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_YT_PYTHON_EXECUTABLE(AbstractResource):
    """
        yandex-yt-python in arcadia
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'yt/python/yt/wrapper/bin/yt_make/yt'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CREATE_SESSIONS_YT_PYTHON_EXECUTABLE(AbstractResource):
    """
        standalone yt python for create sessions priemka
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 40
    releasers = resource_releasers.user_sessions_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_URL2FASTBAN_EXECUTABLE(AbstractResource):
    """
        Utility to generate ban files for Yandex.Video service
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'yweb/video/tools/url2fastban/vurl2fastban'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_QUERYDATAINDEXER_EXECUTABLE(AbstractResource):
    """
        Utility to generate ban files for Yandex.Video services
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'yweb/querydata/querydata_indexer/querydata_indexer'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_QUERYDATAVIEWER_EXECUTABLE(AbstractResource):
    """
        Utility to generate ban files for Yandex.Video services
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'yweb/querydata/querydata_viewer/querydata_viewer'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_WEBURL2VIDEO_EXECUTABLE(AbstractResource):
    """
        weburl2video executable for Yandex.Video
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'extsearch/video/tools/weburl2video/weburl2video'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLESEARCH_INDEX(AbstractResource):
    """
        Данные переранжирований видео среднего поиска, релиз вместе с индексом
    """
    shard = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DEEP_CLICK_EXECUTABLE(AbstractResource):
    """
        Video deep click executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'extsearch/video/quality/deep_click'
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_VUSERDATA2_PACKAGE(AbstractResource):
    """
        Video vuserdata2 package
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = False

    package_path = 'packages/debian/video-quality/yandex-search-video-vuserdata2/pkg.json'

    releasers = video_releasers
    release_subscribers = ['pozhilov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_VPRINTWZRD_MR_SHARD(AbstractResource):
    """
        Шард с данными и конфигом визарда для видео
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'search/wizard/data/video_small'
    arcadia_build_artifact = 'search/wizard/data/video_small/search'
    arcadia_build_options = '-DVIDEO_SMALL_SHARD'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_REALTIME_USERDATA_PACKAGE(AbstractResource):
    """
        Video realtime userdata package
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = False
    releasers = video_releasers
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_VIDEOTOP_LST_CONFIG(AbstractResource):
    """
        Videotop urls for index
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = False
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = ['video-monitoring']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_PANTHER_OFFROAD_INDEX_KEY_MODEL(AbstractResource):
    """
        Компрессионная моделька для indexpanther.offroad.key в видео
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_PANTHER_OFFROAD_INDEX_INV_MODEL(AbstractResource):
    """
        Компрессионная моделька для indexpanther.offroad.inv в видео
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAPACHEUPPER_DATA(AbstractResource):
    """
        Данные для 'безапачёвого' верхнего, - директории: pure, rearrange, rearrange.dynamic
    """
    auto_backup = True
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAPACHEUPPER_NEH_CACHE(AbstractResource):
    """
        Кеш с результатами ответов от подисточников 'безапачёвого' верхнего
        (используется для атономного тестирирования сервиса)
    """
    auto_backup = True
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAPACHEUPPER_REQUEST_TIMINGS(AbstractResource):
    """
        Файл с информацией о среднем времени обработки запроса на noapache
        (суммарное время + данные по переранжированиям - формат json)
    """
    auto_backup = True
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAPACHEUPPER_REQUEST_TIMINGS_COMPARE_RESULT(AbstractResource):
    """
        Файл с информацией о сравнении двух наборов времён обработки запроса на noapache
        (формат html)
    """
    auto_backup = True
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_DATA(AbstractResource):
    """
        directory containing two dirs: pure and rearrange
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_DATA_BUNDLE(AbstractResource):
    """

    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_GEO_DATA(AbstractResource):
    """
        directory containing two dirs: pure and rearrange
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_GEO_DATA_BUNDLE(AbstractResource):
    """

    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_CACHEHIT_PLANS(AbstractResource):
    """
        A directory with several middlesearch plans
    """
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_CACHEHIT_STATS(AbstractResource):
    """
        Middlesearch cachehit stats data
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXECUTOR_PROD_STAT(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class METASEARCH_SUBSOURCE_REQUESTS_COMPARE_RESULT(AbstractResource):
    """

    """
    calc_md5 = False
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_TESTING_RESULTS(AbstractResource):
    """
        Папка с результатами обстрела верхнего с репортом
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXECUTOR_STAT(AbstractResource):
    """
        Результаты обстрела долбилкой в текстовом виде (вывод d-dumper)
    """
    restart_policy = ctr.RestartPolicy.DELETE
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXECUTOR_STAT_PHOUT(AbstractResource):
    """
        Результаты обстрела долбилкой в текстовом виде (phout формат)
        Получается, если запустить долбилку с параметром '--phantom'
        При этом, d-dumper не используется
    """
    restart_policy = ctr.RestartPolicy.DELETE
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXECUTOR_DUMP(AbstractResource):
    """
        Результаты обстрела долбилки в бинарном виде
        Файл может быть прочитан с помощью d-dumper
    """
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXECUTOR_GRAPH(AbstractResource):
    """
        xhtml файл с графиком по резултатам обстрела долбилкой
    """
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOLBILKA_RESPONSES(AbstractResource):
    """
        Файл с ответами на запросы по результатам работы долбилки в текстовом виде
    """
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_PERFORMANCE_COMPARE_RESULT(AbstractResource):
    """
        HTML report containing basesearch performance comparison results
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIDDLESEARCH_PERFORMANCE_COMPARE_RESULT(AbstractResource):
    """
        resource with biggest time-diff
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPRESSED_FACTORS_DUMP_EXECUTABLE(AbstractResource):
    """
        Compressed factors decoder (see VIDEOPOISK-6605)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['mvel', 'antoshkka']
    arcadia_build_path = 'search/tools/compressed_factors_decoder/compressed_factors_decoder'
    arcadia_build_name = 'compressed_factors_decoder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOADLOGDUMP_EXECUTABLE(AbstractResource):
    """
        Питонячий скрипт, аннотирующий loadlog и passagelog
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['mvel']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVLOGDUMP_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = (
        ['agri', 'kimkim', 'and42']
        + video_releasers
        + images_releasers
        + resource_releasers.geowizard_releasers
        + resource_releasers.proxywizard_releasers
        + resource_releasers.entitysearch_releasers
        + news_releasers
        + resource_releasers.querysearch_releasers
        + resource_releasers.fastres2_releasers
        + resource_releasers.base_releasers
    )
    arcadia_build_path = 'search/tools/evlogdump/evlogdump'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVLOGCACHEHIT_EXECUTABLE(sdk2.Resource):
    """

    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'search/tools/evlog-cachehit/evlog-cachehit'
    arcadia_build_name = 'evlog_cachehit'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGANALYZE_EXECUTABLE(sdk2.Resource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['kimkim'] + video_releasers + resource_releasers.middle_releasers + images_releasers + resource_releasers.querysearch_releasers + resource_releasers.base_releasers
    arcadia_build_path = 'search/tools/log-analyze/log-analyze'
    arcadia_build_name = 'log_analyze'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVLOGSAMPLE_EXECUTABLE(sdk2.Resource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = (
        ['agri', 'kimkim']
        + video_releasers
        + resource_releasers.middle_releasers
        + images_releasers
        + resource_releasers.querysearch_releasers
        + resource_releasers.proxywizard_releasers
        + resource_releasers.base_releasers
    )
    arcadia_build_path = 'search/tools/evlog-sample/evlog-sample'
    arcadia_build_name = 'evlog_sample'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HASHEM_EXECUTABLE(AbstractResource):
    """

    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FIREHOSE_PROXY_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['pervyshev', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FIREHOSE_FEEDER(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['pervyshev', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HASHEM_TEXT_QUERIES(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HASHEM_RESULTS(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_YWSEARCH_SAMPLE_CFG(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMB_DAEMON_DATABASE(AbstractResource):
    """
        Папка с базой для thumb-daemon
        Файл с базой должен называться thdb
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMB_DAEMON_PLAN(AbstractResource):
    """
        Бинарный файл плана долбилки с запросами к thumb-daemon
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NAMES_MODEL(AbstractResource):
    """
        Файл имен формул в модели
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_RUNNER_ARCHIVE(AbstractResource):
    """
        Архив с настройками и ocr_runner
    """
    any_arch = False
    executable = True
    auto_backup = False
    config_path = 'Configs'
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_NANNY_FOLDER(AbstractResource):
    """
        Папка с ocrdaemon + данными для релиза в nanny
    """
    any_arch = False
    executable = False
    auto_backup = True
    daemon_path = 'ocrdaemon'
    data_path = 'data'
    daemon_config_path = 'data/configs/daemon.cfg'
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = True
    releasers = ['woxalex', 'miryable', 'serge-fedorov', 'maria-burkina', 'themanofsteel']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_TEST_RESULT(AbstractResource):
    """
        Результат работы TEST_OCR_RUNNER
    """
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_TEST_RESULT_INFO(AbstractResource):
    """
        Результат работы TEST_OCR_RUNNER в агрегированном файле
    """
    any_arch = True
    auto_backup = True
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_IMAGE_DATASET(AbstractResource):
    """
        Архив содержащий изображения с разметкой
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OCR_LOG_FOLDER(AbstractResource):
    """
        Папка с логами от ocr_api
    """
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMPROXY_STATIC_DATA(AbstractResource):
    """
        Статические данные тумбнейлерной прокси
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMPROXY_PLAIN_TEXT_REQUESTS(AbstractResource):
    """
        Запросы к тумбнейлерной проксе в текстовом виде
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMPROXY_PLAN(AbstractResource):
    """
        План для обстрела тумбнейлерной прокси при помощи долбилки
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_SSL_CERTS(AbstractResource):
    """
        Директория с тестовыми SSL-сертификатами для балансера.
        Содержит файлы
            public.cert - публичный сертификат
            private.cert - ключ
    """
    public_certificate = 'public.cert'
    private_certificate = 'private.cert'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMPROXY_RESPONSES_COMPARE_RESULT(AbstractResource):
    """
        Директория с диффами ответов тумбнейлерной прокси:
            * текстовый файл с диффами кодов возврата и заголовков
            * tar-архив с различающимися ответами
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMPROXY_LOGS(AbstractResource):
    """
        Директория с логами тумбнейлерной прокси
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMB_DAEMON_REQUESTS(AbstractResource):
    """
        http-запросы к картиночному тумбнейлеру, path+query
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMB_DAEMON_RESPONSES_ARCHIVE(AbstractResource):
    """
        Директория с ответами тумбдемона
            * текстовый файл с кодами возврата и заголовками
            * tar-архив с файлами ответов, названными по запросам
    """
    meta_file = 'meta.txt'
    archive_file = 'data.tar.gz'
    data_dir = 'data'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THUMB_DAEMON_RESPONSES_DIFF(AbstractResource):
    """
        Директория с ответами диффами ответов тумбдемона
            * текстовый файл с диффами кодов возврата и заголовков
            * tar-архив с различающимися ответами
    """
    meta_file = 'meta.txt'
    stats_file = 'stats.txt'
    first_data_dir = 'first_data'
    second_data_dir = 'second_data'
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POETRYLOVER_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['alzobnin', 'regress']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POETRYLOVER_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POETRYLOVER_PLAN(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POETRYLOVER_DATABASE(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REALSEARCH_DATA(AbstractResource):
    """
        Папка с данными для realsearch
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DUMPWORK_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл dumpwork - утилиты для работы с дампами realsearch
    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CPROXY_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл cproxy - утилиты для кеширования обращений по определённому порту на localhost
    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_BUNDLE(AbstractResource):
    """
        resourse with everything required for Online Antirobot release
    """

    any_arch = False
    releasable = True
    auto_backup = True
    releasers = ['ashagarov', 'tyamgin', 'rzhikharevich', 'toshchakov', 'robot-testenv'] + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_DAEMON_EXECUTABLE(AbstractResource):
    """
        antirobot related resource
    """
    any_arch = False
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['dude', 'anelyubin', 'ishfb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_EVLOGDUMP_EXECUTABLE(sdk2.Resource):
    """
        antirobot related resource
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = ['dude', 'anelyubin', 'ishfb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FACTORS_DIFF(AbstractResource):
    """
        antirobot related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_MULTITOOL_FACTORS_DIFF(AbstractResource):
    """
        antirobot related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_MULTITOOL_DAEMON_DIFF(AbstractResource):
    """
        antirobot related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_STAT(AbstractResource):
    """
        antirobot related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_DUMP_LOG(AbstractResource):
    """
        antirobot related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_RND_DATA(AbstractResource):
    """
        antirobot intermediate prepared date for learning
    """
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_TWEAK_PREPARED(AbstractResource):
    """
        antirobot intermediate prepared date for learning
    """
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_TWEAK_SEPARATED(AbstractResource):
    """
        antirobot's each tweak result log
    """
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_TWEAK_LOG(AbstractResource):
    """
        antirobot's all tweaks log
    """
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_KEYS(AbstractResource):
    """
        antirobot keys
    """
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOC_EXECUTABLE(AbstractResource):
    """
        antirobot related resource
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True
    arcadia_build_path = 'contrib/tools/protoc/protoc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MATRIXNET_EXECUTABLE(AbstractResource):
    """
        antirobot and matrixnet test related resource
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    arcadia_build_path = 'quality/relev_tools/matrixnet/cpu_bin/matrixnet'
    releasers = ['apos', 'kirillovs', 'vpdelta', 'annaveronika', 'noxoomo', 'algorc']
    release_subscribers = ['algorc', 'annaveronika', 'kirillovs']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROWSER_DISTRIBUTION_EXPORT_ACCESS_LOG_SQUEEZER_SCRIPT(AbstractResource):
    """
        Python script for squeezing the export-access-log to merge the uids with respect to browser distribution.
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    arcadia_build_path = 'quality/ab_testing/scripts/rem_processes'
    releasers = ['algorc', 'lucius', 'samhan']
    release_subscribers = ['lucius', 'samhan', 'algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNIFIED_GNU_DIFF_FILE(AbstractResource):
    """
        output of `diff a b` command
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USED_LM_FEATURES_BINARY_BASE(AbstractResource):
    """
        Binary base file for searching non-zero url-lm features
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRCOLLECTOR_EXECUTABLE(AbstractResource):
    """
        Бинарник MapReduce, создающий индекс генерализации запросов для Тыквы (Яндекс.Лайт)
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUMPKIN_INDEX(AbstractResource):
    """
        Индекс генерализации запросов Тыквы (Яндекс.Лайт) и связанные файлы.
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUMPKIN_INDEX_ARCHIVE(AbstractResource):
    """
        Архив с данными для генерализации запросов Тыквы (Яндекс.Лайт) (индекс, метаданные и т.п.)
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUMPKIN_QUERIES(AbstractResource):
    """
        Список генерализованных запросов для Тыквы (Яндекс.Лайт). Создаётся при генерации индекса генерализации.
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUMPKIN_RESINFO_DAEMON_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл resinfod для Тыквы (Яндекс.Лайт)
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = ['snow', 'denkoren'] + images_releasers
    arcadia_build_path = 'yweb/webdaemons/resinfod/resinfod'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_PUMPKIN_INDEX(AbstractResource):
    """
        Индекс генерализации запросов Тыквы (Яндекс.Лайт) и связанные файлы.
        Вариaнт для Yandex.Video
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_PUMPKIN_INDEX_ARCHIVE(AbstractResource):
    """
        Архив с данными для генерализации запросов Тыквы (Яндекс.Лайт)
        Вариант для Yandex.Video
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MX_OPS_EXECUTABLE(AbstractResource):
    """
        matrixnet test related resource
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class XFACTOR_YT_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл xfactor-yt
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True
    arcadia_build_path = "quality/relev_tools/xfactor-yt/bin/xfactor-yt"


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INFOTEST_EXECUTABLE(AbstractResource):
    """
        matrixnet test related resource
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MATRIXNET_TEST_POOL(AbstractResource):
    """
    .tar.gz архив с файлами learn.tsv test.tsv config.tsv
    в файле config.tsv содержится shell команда для запуска matrixnet в режими обучения
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MATRIXNET_TESTING_PREDICTIONS(AbstractResource):
    """
        matrixnet test related resource
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MATRIXNET_ALLTESTS_RESULTS(AbstractResource):
    """
    .tar.gz архив с набором файлов предсказаний матрикснета test.tsv.matrixnet
    для разных тестов и разных типов обучения.
    файлы были получены из тасок TEST_MATRIXNET так:
    ./matrixnet -A -f learn.tsv -t test.tsv
    данный ресурс создается таском VALIDATE_MATRIXNET_MODELS
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MATRIXNET_ALLTESTS_DIFF(AbstractResource):
    """
        matrixnet test related resource
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FEATURES(AbstractResource):
    """
        antirobot related resource
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FACTOR_NAMES(AbstractResource):
    """
        antirobot related resource
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FORMULA_BIN(AbstractResource):
    """
        antirobot related resource
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FORMULA_INC(AbstractResource):
    """
        antirobot related resource
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INTLOOKUP_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OTHER_RESOURCE(AbstractResource):
    """
        Используется для ресурсов с коротким сроком жизни
        без определённой структуры и типа. Не рекомендуется
        использовать, если такой ресурс планируется подавать
        на вход другой задаче.

        Запрещено выставлять ресурсам данного типа
        большой (а тем более бесконечный TTL), иначе очень сложно
        разобраться с тем, кто занял всё место на полках Sandbox.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_CACHE_MISS_STATS(AbstractResource):
    """
        SEARCH-1506
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENCYC_REPORT(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RUSLANG_SLOVAR(AbstractResource):
    """

    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VERDICT_REPORT(AbstractResource):
    """

    """
    releasable = True
    releasers = ['denisbykov', ]
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_RESOURCE(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_SPIDER(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_ZORRO(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_FUT(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_GETURL(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_COMM_CREATE(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_BUNDLE(AbstractResource):
    """

    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQ_TEXT_3(AbstractResource):
    """
        Запросы в reqText3 формате.
        !!! DEPRECATED !!! Use USERS_QUERIES instead!
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AG_SILVER_SEARCHER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл ag (the silver searcher, https://github.com/ggreer/the_silver_searcher)
    """
    executable = True
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['mvel', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RAW_PROFILE_STAT(AbstractResource):
    """
        Сырые данные профилирования (выхлоп профилировщика)
        Читабельным является только для аркадийного профайлера,
        а в случае gperftools это бинарный файл
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROFILE_STAT(AbstractResource):
    """
        Аннотированный профиль в читабельном виде
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SVG_PROFILE_STAT(AbstractResource):
    """
        Аннотированный профиль в формате SVG
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PDF_PROFILE_STAT(AbstractResource):
    """
        Аннотированный профиль в формате PDF
        На практике показал себя неважно, используется только в экспериментальном режиме
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALLGRIND_PROFILE_STAT(AbstractResource):
    """
        Аннотированный профиль в callgrind-формате, понимаемом KCacheGrind
    """
    share = False
    ttl = 40


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROFILE_STATS_DIFF(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROFILE_RESULTS(AbstractResource):
    """
        Directory with artefacts from profilers
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMOTE_WIZARD(AbstractResource):
    """
        wizard related resource
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers
    arcadia_build_path = 'web/daemons/wizard/wizard'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RESPONSES_RESULT(AbstractResource):
    """
        wizard tests' output in cgi format
    """
    any_arch = True
    responses_for_revision = sdk2.parameters.Integer('Revison number')


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD(AbstractResource):
    """
        wizard related resource
    """
    releasable = False
    executable = True
    any_arch = False
    arcadia_build_path = 'tools/printwzrd/printwzrd'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD_CONFIG(AbstractResource):
    """
        Config files for printwizard, generated from search/wizard/data/wizard/conf
    """
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_UNITTEST(AbstractResource):
    """
        wizard related resource
    """
    releasable = False
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMOTE_WIZARD_PLAN(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMOTE_WIZARD_CONFIG(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD_OUTPUT(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD_DIFF(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STOP_WORDS_FILE(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_DATA(AbstractResource):
    """
        wizard related resource
    """
    releasable = True
    auto_backup = True
    releasers = ('regress', 'nglaz', 'robot-freshness', 'robot-srch-verticals')


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_DATA_COMPILER(AbstractResource):
    """
        wizard related resource
    """
    any_arch = False
    auto_backup = True
    executable = True
    arcadia_build_path = 'dict/gazetteer/compiler/gztcompiler'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MUSIC_WIZARD_DATA_CONVERTER(AbstractResource):
    """
        wizard related resource
    """
    any_arch = False
    auto_backup = True
    arcadia_build_path = 'yweb/music/convert_wizard_data/convert_wizard_data'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_PACKAGE(AbstractResource):
    """
        wizard related resource
    """
    any_arch = False
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RUNTIME_PACKAGE(AbstractResource):
    """
        wizard related resource
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RUNTIME_PACKAGE_UNPACKED(AbstractResource):
    """
        wizard related resource with no .tar archive
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RUNTIME_PACKAGE_PATCHED(AbstractResource):
    """
        wizard related resource (patched)
    """
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RUNTIME_PACKAGE_UNPACKED_PATCHED(AbstractResource):
    """
        wizard related resource with no .tar archive (patched)
    """
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMMER_CACHE_INIT_LIST(AbstractResource):
    """
        Initilizer list for lemmer cache, JIRA: REQWIZARD-476
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_PACKAGE_SHARD(AbstractResource):
    """
        wizard related resource
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_SHARD(AbstractResource):
    """
        wizard related resource
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers
    arcadia_build_path = 'search/wizard/data/wizard/'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RUNTIME_SHARD(AbstractResource):
    """
        wizard related resource
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geowizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_MONITORING_INFO(AbstractResource):
    """
        wizard related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_CONFIG(AbstractResource):
    """
        wizard related resource: main wizard config
    """
    releasable = True
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_ANTIROBOT_CONFIG(AbstractResource):
    """
       wizard related resource: config for antirobot wizard
   """
    releasable = True
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_GEO_CONFIG(AbstractResource):
    """
       wizard related resource: config for geo wizard
   """
    releasable = True
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_REALTIME_CONFIG(AbstractResource):
    """
       wizard related resource: config for realtime related tests
   """
    releasable = True
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RSYA_CONFIG(AbstractResource):
    """
       wizard related resource: config for realtime related tests
   """
    releasable = True
    arcadia_build_path = 'search/wizard/data/wizard/conf'


# configs below are legacy copies of original, required for REQWIZARD-830, should not be used anymore
class WIZARD_CONFIG_NEW(WIZARD_CONFIG):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_GEO_CONFIG_NEW(WIZARD_GEO_CONFIG):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_ANTIROBOT_CONFIG_NEW(WIZARD_ANTIROBOT_CONFIG):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_REALTIME_CONFIG_NEW(WIZARD_REALTIME_CONFIG):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_RSYA_CONFIG_NEW(WIZARD_RSYA_CONFIG):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARDYT(AbstractResource):
    """
        wizard reducer resource
    """
    any_arch = False
    arcadia_build_path = 'tools/wizard_yt/wizard_reducer/'
    auto_backup = True
    executable = True
    releasable = False
    build_output_dir = 'wizard_reducer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_EXECUTABLE(AbstractResource):
    """
        entitysearch daemon executable
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_DAEMON_CHECKER_TOOL(AbstractResource):
    """
       Checker tool for daemon
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_GZT_COMPILER_TOOL(AbstractResource):
    """
       Gzt compiler with built-in es gztprotos
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_DBSUBSET_EXECUTABLE(AbstractResource):
    """
        entitysearch dbsubset tool
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_REMOTE_DATA(AbstractResource):
    """
        entitysearch related resource
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_CONVERTER(AbstractResource):
    """
        entitysearch convertor tool
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_CONFIG(AbstractResource):
    """
        entitysearch config
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_DATA(AbstractResource):
    """
        entitysearch data
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_REALTIME(AbstractResource):
    """
        entitysearch realtime data
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_GAZETEER(AbstractResource):
    """
        entitysearch gazetteer
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_TRIE(AbstractResource):
    """
        entitysearch trie
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_OBJECT_IDS_LIST(AbstractResource):
    """
       list of entitysearch object ids
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_TOOL_SCRIPT(AbstractResource):
    """
       any script for entitysearch service
    """
    releasable = True
    executable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.entitysearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_APPHOST_REQUESTS(AbstractResource):
    """
       entitysearch apphost request contexts
    """
    releasable = False
    executable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_APPHOST_RESPONSES(AbstractResource):
    """
       entitysearch apphost responses
    """
    releasable = False
    executable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ENTITY_SEARCH_DIFF(AbstractResource):
    """
       entitysearch diff html
    """
    releasable = False
    executable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_ATT_UDF(AbstractResource):
    """
        Cобранный набор UDF для Att Kiwi
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_ATT_MISC_DATA(AbstractResource):
    """
        Различные, неклассифицированные данные которые требуются
        части UDF в Att Kiwi. Поставляются регулярным процессом
        в WebSpam.
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_ATT_UDF_DATA(AbstractResource):
    """
        Данные, необходимые для UDF, работающих в Att Kiwi
        Устаревший.
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_MIDDLE_TRIE(AbstractResource):
    """
        trie файлы с банами владельцев, масок или документов.
        Поставляется регулярным процессом в webspam.
    """
    any_arch = True
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIINFRARECOUNT_RULEMAP(AbstractResource):
    """
        rulemap правил в mr-deduce для пересчета на орках
        Используется на орках, поставляются регулярным процессом в webspam.
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_OTHER_EXECUTABLE(AbstractResource):
    """
        antispam related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['galtsev', 'sandbox', 'abv']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_RESULT_BAN(AbstractResource):
    """
        результат проверки банов антиспама на выдаче
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_ERF(AbstractResource):
    """
        сохраненные файлы для проверки ерфов антиспама на выдаче
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEAMCITY_RESOURCE(AbstractResource):
    """
        Resource created by a processs in Teamcity. It can be build result (release, package, or
        something else.
    """

    auto_backup = True
    releasable = True
    releasers = ["karavashkin", "amich", "dmitko", "vlegeza", "onotole", "mkulemin", "olegsenin"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEAMCITY_TARBALL(AbstractResource):
    """
        Resource with tarball file(s) created by a process in Teamcity
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEAMCITY_RESOURCE_PLAIN(AbstractResource):
    """
        content of the corresonding TEAMCITY_RESOURCE
    """

    auto_backup = True
    releasable = True
    releasers = ["karavashkin", "amich", "dmitko"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INDEX_REQUESTS_DUMP(AbstractResource):
    """
        Dump of IndexRequests (input data for rtindexer)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUALITY_USER_PROFILES(AbstractResource):
    """
        resource related with FastTier & Orange
    """
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YTEST_DATA(AbstractResource):
    """
        resource related with FastTier & Orange & Indexer
    """
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_BINARY_ARCHIVE(AbstractResource):
    """
        Archive with binaries built by BUILD_ARCADIA_BINARY
    """
    any_arch = True
    executable = False
    share = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCE_EXECUTABLE(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    releasable = True
    auto_backup = True
    releasers = ['akhropov', 'f0b0s', 'shakurov', 'a-romanov', 'alexpetrov', 'stunder', 'xpahos', 'dcherednik']
    arcadia_build_path = 'quality/mapreduce/mapreduce'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAP_REDUCE_UTILS_ARCHIVE(AbstractResource):
    """
        Tar архив с утилитами mapreduce
    """
    any_arch = False
    executable = False
    releasable = True
    auto_backup = True
    releasers = ['kozunov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_BOUNDS(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_bounds/mr_bounds'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_CAT(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_cat/mr_cat'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_CP(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_cp/mr_cp'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_DATA_MANIP(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_data_manip/mr_data_manip'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_DIFF(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_diff/mr_diff'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_DU(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_du/mr_du'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_FIND(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_find/mr_find'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_GET_KEYS(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_get_keys/mr_get_keys'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_GREP(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_grep/mr_grep'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_HEAD(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_head/mr_head'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_HIST(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_hist/mr_hist'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_LS(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_ls/mr_ls'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_MV(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_mv/mr_mv'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_RM(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_rm/mr_rm'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SET_OPS(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_set_ops/mr_set_ops'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SAMPLE(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_sample/mr_sample'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SORT(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_sort/mr_sort'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_TOUCH(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_touch/mr_touch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_UNIQ(AbstractResource):
    """
        mapreduce resource
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_uniq/mr_uniq'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_WC(AbstractResource):
    """
        mapreduce resource
    """

    any_arch = False
    executable = True
    auto_backup = True
    releasers = []
    arcadia_build_path = 'quality/mr_apps/mr_wc/mr_wc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_PACKAGE(AbstractResource):
    """
        Пакет репорта
    """

    releasable = True
    executable = True
    auto_backup = True
    releasers = report_web_releasers + ['robot-serp-bot']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_CORE_PACKAGE(REPORT_PACKAGE):
    """
        Архив со скриптами репорта
    """
    executable = False
    releasers = REPORT_PACKAGE.releasers + ['nbahob']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_IMAGES_CORE_PACKAGE(REPORT_CORE_PACKAGE):
    """
        Архив со скриптами картиночного репорта
    """
    releasers = REPORT_CORE_PACKAGE.releasers + ['tkatliarova', 'alex-k', 'nerevar', 'zomb-report-images', 'yurich',
                                                 'anoh', 'anskor', 'fexion', 'evseevd']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_VIDEO_CORE_PACKAGE(REPORT_CORE_PACKAGE):
    """
        Архив со скриптами видео репорта
    """
    releasers = REPORT_CORE_PACKAGE.releasers + ['juver', 'shaveinikovds', 'alex0512']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_YACA_CORE_PACKAGE(REPORT_CORE_PACKAGE):
    """
        Архив со скриптами репорта каталога
    """
    releasers = REPORT_CORE_PACKAGE.releasers + ['anoh']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_TEMPLATES_PACKAGE(REPORT_PACKAGE):
    """
        Архив с шаблонами вёрстки репорта
    """
    restart_policy = ctr.RestartPolicy.IGNORE
    releasers = [
        'robot-serp-bot', 'sanity', 'rudeshko', 'zumra6a', 'blond', 'timofey-em', 'mrmlnc', 'vitkarpov', 'dexig', 'gurugray', 'qfox', 'vitoshnev', 'mishanga', 'asterx', 'konovailk', 'st-lukas'
    ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_IMAGES_TEMPLATES_PACKAGE(REPORT_PACKAGE):
    """
        Архив с шаблонами вёрстки картинок
    """
    releasers = ['tkatliarova', 'sanity', 'sbmaxx', 'nerevar', 'alex-k', 'nbahob', 'invntrm',
                 'mokcrimea', 'dndushkin', 'yurich', 'beam', 'robot-serp-bot', 'webmisha']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_VIDEO_TEMPLATES_PACKAGE(REPORT_TEMPLATES_PACKAGE):
    """
        Архив с шаблонами вёрстки video
    """
    releasers = REPORT_IMAGES_TEMPLATES_PACKAGE.releasers + REPORT_TEMPLATES_PACKAGE.releasers + ['xescoder', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_CRYPROX_PAYLOAD(AbstractResource):
    """
        Файл от cryprox для инъекции в report-renderer (FEI-7273)
    """
    releasable = True
    auto_backup = True
    releasers = ['kaero', 'arikon', 'flack', 'asterx', 'slava-b', 'mcheshkov', 'sotius', "frimuchkov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_PACKAGE(AbstractResource):
    """
        Пакет Node.js сервиса рендеринга репорта
    """
    releasable = True
    auto_backup = True
    releasers = ['REPORT_RENDERER']
    svn_path = sdk2.Attributes.String('svn_path')


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_NEWS_PACKAGE(AbstractResource):
    """
        Пакет новостного репорта
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXP_APP_PACKAGE(AbstractResource):
    """
        Пакет со статикой для экспеременатальной версии поискового приложения. Обращаться к sharrp@
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['sharrp', 'alex-k', 'levchuk', 'noiseless', 'robot-serp-bot'] + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MEDIAPORTRAITS_FRONTEND_PACKAGE(AbstractResource):
    """
        Фронтенд Медиапортретов на nodejs
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['trofimenkov', 'alex-sh', 'greyevil']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MEDIAPORTRAITS_FRONTEND_DEPS_PACKAGE(AbstractResource):
    """
        Либы и данные для фронтенда Медиапортретов на nodejs
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['trofimenkov', 'alex-sh', 'greyevil']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_NEWS_CORE_PACKAGE(REPORT_NEWS_PACKAGE):
    """
        Архив со скриптами новостного репорта
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_NEWS_TEMPLATES_PACKAGE(REPORT_NEWS_PACKAGE):
    """
        Архив с шаблонами вёрстки новостного репорта
        Deprecated: в пользу ресурсов REPORT_NEWS_TEMPLATES_PACKAGE_DESKPAD, REPORT_NEWS_TEMPLATES_PACKAGE_TOUCH
    """
    releasers = REPORT_NEWS_PACKAGE.releasers + ['alsun', 'axlerk', 'baymer', 'seles', 'irrra', 'robot-serp-bot']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = report_web_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_INFECTED_HOSTS(AbstractResource):
    """

    """
    releasable = True
    releasers = report_web_releasers
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_MUSICHOST_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_HTML_CONFIG(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_HTARCLOOKUP(AbstractResource):
    """

    """
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_PLAN(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HILITEDAEMON_RECOGNIZER_DICT(AbstractResource):
    """

    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_EXECUTABLE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = clickdaemon_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_KEY(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_TEMPLATE(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_PLAN(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_LOG(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QEMU_IMAGE(AbstractResource):
    """
        QEMU_IMAGE project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['ekilimchuk', 'panoff']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QEMU_STATIC_DEB(AbstractResource):
    """
        Statically built qemu package
    """
    releasable = True
    releasers = ['max7255', 'ekilimchuk', 'sivanichkin', 'basic']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QEMU_ID_DSA_FILE(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QEMU_SKYNET_PATCH(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEOSEARCH_EXECUTABLE(AbstractResource):
    """
        videosearch related resources
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'extsearch/video/base/videosearch/videosearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEORTYSERVER_EXECUTABLE(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = video_releasers
    arcadia_build_path = 'extsearch/video/base/videortyserver/videortyserver'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_GENERATOR(AbstractResource):
    """
        Поисковая генерилка конфигов, директория с исходными файлами
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats', 'mcden'] + images_releasers + resource_releasers.marty
    release_subscribers = ['kimkim', 'sereglond', 'robot-gencfg', 'osol']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_GENERATOR_REPO(AbstractResource):
    """
        Репозиторий (какой-то один из нескольких) поисковой генерилки
    """
    releasable = True
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'osol', 'okats'] + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_GENERATOR_SERVICE(AbstractResource):
    """
        Сервис поисковой генерилки, фактически только скрипт для деплоя
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'osol', 'okats'] + resource_releasers.marty
    release_subscribers = ['kimkim', 'sereglond', 'robot-gencfg']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_ARCHIVE(AbstractResource):
    """
        Поисковая генерилка конфигов, tar-архив с исходными файлами и выводом
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats', 'mcden'] + images_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_SEARCHERLOOKUP(AbstractResource):
    """
        Searcherlookup.conf как отдельный ресурс
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats', 'mcden'] + images_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_GENERATOR_CONFIGS(AbstractResource):
    """
        Tarball с конфигами для всех инстансов
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats', 'mcden'] + images_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_GENERATOR_GENERATED(AbstractResource):
    """
        Tarball со всем, что генерит генерилка (содержимое generated и w-generated)
    """
    releasable = True
    auto_backup = True
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats', 'mcden'] + images_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_BUILD_LOGS(AbstractResource):
    """
        Логи, полезны при сломанном таске
    """
    releasable = False
    auto_backup = False
    releasers = ['sandbox', 'kimkim', 'sereglond', 'robot-gencfg', 'kulikov', 'vmordovin', 'alximik', 'basic', 'osol',
                 'okats'] + images_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_MAIL_DIR(AbstractResource):
    """
        Директория с письмами, которые нужно послать админам
    """
    releasable = False
    auto_backup = True
    releasers = [
        'sandbox',
        'sereglond',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'alximik',
        'basic',
        'osol',
        'okats',
    ] + images_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_STARTREK_DIR(AbstractResource):
    """
        Директория с комментами, которые пойдут в таски startrek-а
    """
    releasable = False
    auto_backup = True
    releasers = [
        'sandbox',
        'sereglond',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'alximik',
        'basic',
        'osol',
        'okats',
    ] + images_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFIG_NANNY_DIR(AbstractResource):
    """
        Директория с комментами, которые пойдут в таски няни
    """
    releasable = False
    auto_backup = True
    releasers = [
        'sandbox',
        'sereglond',
        'robot-gencfg',
        'kulikov',
        'vmordovin',
        'basic',
        'osol',
        'okats',
    ] + images_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_SRC_TGZ(AbstractResource):
    """
        Архив с репозиторием исходного кода генерилки
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_DB_TGZ(AbstractResource):
    """
        Архив с репозиторием данных генерилки
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_BALANCER_TGZ(AbstractResource):
    """
        Архив с репозиторием исходного когда генератора для балансера
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_BALANCER_CONFIGS_TGZ(AbstractResource):
    """
        Архив со сгенеренными конфигами для балансера
    """
    releasable = True
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_BINUTIL_LUA_CHECKER(AbstractResource):
    """
        Staticaly linked lua binary to test balancer configs
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_BINUTIL_MMETA_CHECKER(AbstractResource):
    """
        Staticaly linked binary to test mmeta/int configs
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_DB_CACHE(AbstractResource):
    """
        Resource with content of db/cache directory
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_ANNOUNCE_FILE(AbstractResource):
    """
        Resource with what will be announced to gencfg-support
    """
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_NANNY_SERVICES(AbstractResource):
    """Resources with cached nanny services info"""
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats', 'osol', 'sereglond']


class CLICKHOUSE_GRAPHS_BUNDLE(AbstractResource):
    """Resource with bundle for clickhouse graphs backend"""
    releasable = False
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats', 'osol', 'sereglond']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXTENDED_INFO(AbstractResource):
    """
        Используется пока что только для нестабильных diff-ов базового, idx_ops и долбилки,
        должен быть переименован в UNSTABLE_DIFF. Так как дифф нестабильный,
        стоит удалять ресурс при перезапуске таска. Иначе будем ловить EXCEPTION в случае,
        когда второй раз таск выполнится успешно.
    """
    share = False
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MICROFORM_TOOL_EXECUTABLE(AbstractResource):
    """

    """
    any_arch = False
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCH_QLOSS_UNMIRROR_TRIE_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCH_QLOSS_URL_DOCID_LOOKUPER_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCH_QLOSS_DOCID_URL_LOOKUPER_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCH_URL_DOCID_INDEXER_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_ROBOT_TARGET_LIST(AbstractResource):
    """

    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_ROBOT_RESULT_ARCHIVE(AbstractResource):
    """
        Архив с бинарниками и библиотеками для робота
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['aavdonkin', 'bort', 'rdna', 'kletskov', 'qwerty', 'zagevalo', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_ROBOT_RESULT_FOLDER(AbstractResource):
    """
        Папка с бинарниками и библиотеками для робота
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['aavdonkin', 'bort', 'rdna', 'kletskov', 'qwerty', 'zagevalo', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENERIC_ROBOT_BINARY(AbstractResource):
    """
        Отдельный бинарник робота
    """
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INFO_REQUESTS_TEST_LOGS(AbstractResource):
    """

    """
    calc_md5 = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MYSQL_DATABASE(AbstractResource):
    """

    """
    auto_backup = True
    calc_md5 = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_BUNDLE(AbstractResource):
    """
        конфиги рантайм облака
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = rtcc_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_BUNDLE_PRIEMKA(AbstractResource):
    """
        конфиги рантайм облака
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = ['elantsev', 'robot-maestro']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_LOGS(AbstractResource):
    """
        RunTime Cloud Config Generator logs
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_CACHE(AbstractResource):
    """
        кеш генератора конфигов верхнего метапоиска
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = rtcc_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_REPORTS(AbstractResource):
    """
        отчеты генератора конфигов верхнего метапоиска
    """
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_ST_CODE(AbstractResource):
    """
        Архив с кодом RtCC-ST (система анализа данных и принятия решений)
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers + ['robot-maestro', 'teamcity', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_ST_VENV(AbstractResource):
    """
        Виртуальное окружение python (virtualenv) для запуска RtCC-ST
    """
    shard = True
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers + ['robot-maestro', 'teamcity', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTCC_SOURCES_TREE_ARCHIVE(AbstractResource):
    """
        Архив с архивом сервиса для редактирования источников RtCC (RtCC ST)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = search_priemka_releasers + ['robot-maestro', 'teamcity', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APACHE_BUNDLE(AbstractResource):
    """
        Архив из httpd + perl-модули, в формате tar.gz
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = report_web_releasers + ['elantsev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_TOOL_CONVERTER_EXECUTABLE(AbstractResource):
    """
        Extractor json requests from raw service request)
    """
    executable = True
    releasable = True
    auto_backup = False
    any_arch = False
    releasers = resource_releasers.noapacheupper_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTO2HR_EXECUTABLE(AbstractResource):
    """
        Convertor search service response protobuf format to proto-hr
    """
    executable = True
    releasable = False
    auto_backup = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_SHARD(AbstractResource):
    """
        Шард для SERP API
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = ['ipaulo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_UPPER_DEBUG_FILE(AbstractResource):
    """
        Файл с дебаг-информацией для верхнего.
    """
    executable = False
    any_arch = False
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_APACHE_DEBUG_FILE(AbstractResource):
    """
        Файл с дебаг-информацией для апача.
    """
    executable = False
    any_arch = False
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DSINDEXER_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LIBPROF_SO_BINARY(AbstractResource):
    """

    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANNOTATE_PROFILE_SCRIPT(AbstractResource):
    """
        Script 'annotate_profile.pl' for annotating arcadia profiler raw output
    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GPERFTOOLS_PROFILER_SO_BINARY(AbstractResource):
    """
        Google Performance Tools (gperftools) profiler DLL
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ["mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GPERFTOOLS_PPROF_SCRIPT(AbstractResource):
    """
        Google Performance Tools (gperftools) pprof tool (for annotating profile, etc)
    """
    executable = True
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ["mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BREAKPAD_INIT_SO(AbstractResource):
    """
        Google Breakpad Initializer shared library
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["alonger", "alximik", "mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BREAKPAD_SYMBOLS_DUMPER(AbstractResource):
    """
        Google Breakpad symbols dumper (dump_syms binary)
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["alonger", "alximik", "mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BREAKPAD_MINIDUMP_STACKWALK(AbstractResource):
    """
        Google Breakpad minidump parser
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["alonger", "alximik", "mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CCACHE_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WINE_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GDB_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GDB66_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DUMMY_SERVER_EXECUTABLE(AbstractResource):
    """

    """
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UNITTEST(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_FML_UNITTEST(AbstractResource):
    """
        SAAS FML related resource
    """
    releasable = True
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_TEST(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MULTITESTER(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MULTI_CONFIGS(AbstractResource):
    """
        RTYServer related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_CONFIGS(AbstractResource):
    """
        RTYServer related resource
    """
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_DICT(AbstractResource):
    """
        RTYServer related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MAPS_USER_IF(AbstractResource):
    """
        RTYServer related resource
    """
    auto_backup = True
    releasable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "nsofya", "ivanov-andrey", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MAPS_USER_IF_ENV(AbstractResource):
    """
        RTYServer related resource
    """
    auto_backup = True
    releasable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "nsofya", "ivanov-andrey", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_INDEX_DIR(AbstractResource):
    """
        RTYServer related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR(AbstractResource):
    """
        RTYServer graph_info
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR_PRODUCTION_RUS(AbstractResource):
    """
        RTYServer production graph_info for russia
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_WITH_HISTORY_DIR_PRODUCTION_RUS(AbstractResource):
    """
        RTYServer production graph_info with traffic history for russia.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR_PRODUCTION_TURKEY(AbstractResource):
    """
        RTYServer production graph_info for turkey
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR_PRODUCTION_AND(AbstractResource):
    """
        RTYServer production graph_info for and_mpro
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR_PRODUCTION_IRAN(AbstractResource):
    """
        RTYServer production graph_info for iran
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_WITH_HISTORY_DIR_PRODUCTION_IRAN(AbstractResource):
    """
        RTYServer production graph_info with traffic history for iran
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_DIR_PRODUCTION_RUS_AND_TURKEY(AbstractResource):
    """
        RTYServer production graph_info for joing russia and turkey
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GARDEN_EXPORT(AbstractResource):
    """
        Data exported from Garden for build RTYServer graph
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_GRAPH_FAKE_CONNECTIONS(AbstractResource):
    """
        Transfer points for RTYServer graph
    """
    releasable = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.saas_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_LF(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.saas_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_EXECUTABLE(AbstractResource):
    """
        RTYServer for search releases
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ["svshevtsov", ] + resource_releasers.base_releasers
    arcadia_build_path = 'saas/rtyserver/rtyserver'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_CONFIG2JSON(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_LOG_PROCESSORS(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_PRINTKEYS(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_AMMO_FACTORY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_RTYSERVER_EMULATOR(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_TEST_MODEL(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "nsofya", "svshevtsov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_EVLOGDUMP(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_CONFIG_PATCHER(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_DISTRIBUTOR_CLIENT(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    releasers = ["svshevtsov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_DEPLOY_MANAGER(AbstractResource):
    """
        RTYServer cluster manager
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = resource_releasers.saas_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_FMLTASK(AbstractResource):
    """
        RTYServer fml-interacting tool
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "amich", "osidorkin", "varvar4ik", "salmin", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_CRAWLER(AbstractResource):
    """
        RTYServer crawler
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_UTILS_ROADS_GRAPH(AbstractResource):
    """
        RTYServer roads graph
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "nsofya", "gorokhov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_FERRYMAN_SERVER(AbstractResource):
    """
        SAAS Ferryman server
    """
    releasable = True
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_FERRYMAN_WORKER(AbstractResource):
    """
        SAAS Ferryman worker
    """
    releasable = True
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CORES_VIRTUAL_ENV(AbstractResource):
    """
    venv archive for cores deps
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", "borman", "alonger", "mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CORES_CODE_TAR(AbstractResource):
    """
    cores source
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", "borman", "alonger", "mvel"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_PLOTS_VIRTUAL_ENV(AbstractResource):
    """
    venv archive for saas plots deps
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_PLOTS_CODE_TAR(AbstractResource):
    """
    saas plots source
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_MONITOR_VIRTUAL_ENV(AbstractResource):
    """
    venv archive for saas monitor deps
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAAS_MONITOR_CODE_TAR(AbstractResource):
    """
    saas monitor source
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["anikella", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RABBITMQ_DATA(AbstractResource):
    shard = True
    releasable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STATBOX_PUSHCLIENT(AbstractResource):
    """
        Statbox Push Client
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'logbroker/push-client'
    releasers = ['aneporada', 'aozeritsky', 'artgromov', 'xifos', 'stunder', 'andreyst', 'nkbolg', 'robot-logbroker-ci']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_WDS_CLIENT(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISTRIBUTOR(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'yweb/realtime/distributor/monolith/monolith'
    arcadia_build_name = 'distributor'
    releasers = resource_releasers.base_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_CLIENT_LIBS(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    executable = False
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MODELS(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    executable = False
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "yrum", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_MODELS_SHARD(AbstractResource):
    """
        RTYServer related resource
    """
    shard = True
    releasable = True
    executable = False
    releasers = ["iddqd", "ivanmorozov", "anikella", "svshevtsov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_TESTS_STAT(AbstractResource):
    """
        RTYServer related resource
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTY_RELATED(AbstractResource):
    """
        RTYServer related resource (any type)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTY_RELATED_EXEC(AbstractResource):
    """
        RTYServer related resource (any binary)
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_SEARCHPROXY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.saas_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_SEARCHPROXY_UT(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_COMMON_PROXY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ["iddqd", "ivanmorozov", "nsofya", "svshevtsov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_COMMON_PROXY_GEOSUGGEST(AbstractResource):
    """
        RTYServer related resource. Common proxy for Geosuggest
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ["iddqd", "ivanmorozov", "nsofya", "svshevtsov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_COMMON_PROXY_VIOLETTA(AbstractResource):
    """
        RTYServer related resource. Common proxy for Violetta
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ["iddqd", "ivanmorozov", "nsofya" "svshevtsov", "sandbox"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_SERVICES_APPS(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ["iddqd", "ivanmorozov", "anikella"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_INDEXER_PROXY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.saas_releasers + resource_releasers.base_releasers
    arcadia_build_path = 'saas/indexerproxy/indexerproxy'
    arcadia_build_name = 'rtyserver_indexerproxy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_COVERAGE_RES(AbstractResource):
    """
        RTYServer resource data for coverage
        catalog must include:
        - arcadia directory
        - release directory
    """
    releasable = False
    any_arch = False
    executable = False
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_EXECUTABLE(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['nkmakarov', 'alex-sh', 'iv-ivan', 'asanikushin']
    release_subscribers = ['iv-ivan', 'nkmakarov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MANGO_BINARIES(AbstractResource):
    """
        Mango binaries
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = False
    releasers = ['dfyz', 'drsmith', 'dmikhalev', 'zhnick']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MANGO_DATA(AbstractResource):
    """
        Mango data required for trigger work
    """
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RPM_INDEXERPROXY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['juliyas', 'iddqd', 'ivanmorozov', 'ntatarinov', 'anikella']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RPM_SEARCH_PROXY(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['juliyas', 'iddqd', 'ivanmorozov', 'ntatarinov', 'anikella']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_AMMO(AbstractResource):
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX(AbstractResource):
    """
        IEX binary
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_CONTENTLINE_LEARNER(AbstractResource):
    any_arch = False
    executable = False
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_CONTENTLINE_SBS(AbstractResource):
    any_arch = False
    executable = False
    auto_backup = False
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_CONTENTLINE_MODEL(AbstractResource):
    any_arch = False
    executable = False
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_CONTENTLINE_DATA4SBS(AbstractResource):
    any_arch = False
    executable = False
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_TESTS(AbstractResource):
    any_arch = True
    releasable = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_RESULTS(AbstractResource):
    any_arch = True
    releasable = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RPM_IEX(AbstractResource):
    """
        IEX RPM
    """
    releasable = True
    any_arch = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_DICTS(AbstractResource):
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_GRAMMAR_PATCH(AbstractResource):
    """
        Grammar patch for reviews
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_REMORPH_GRAMMARS(AbstractResource):
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_DICTS_COMPILER(AbstractResource):
    releasable = False
    any_arch = False
    executable = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_REMORPH_COMPILER(AbstractResource):
    releasable = False
    any_arch = False
    executable = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_GZT_COMPILER(AbstractResource):
    releasable = False
    any_arch = False
    executable = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_OUR_REMORPH_GRAMMARS(AbstractResource):
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_DEB(AbstractResource):
    """
        IEX Debian package
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_CONFIG(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_DIFF_RESPONSE(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_FUNC_TEST_RESULT(AbstractResource):
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IEX_DIFF_FUNC_RESULTS(AbstractResource):
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SANITIZER(AbstractResource):
    """
        Sanitizer binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SANITIZER_FUNC_TEST_RESULT(AbstractResource):
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SANITIZER_DIFF_FUNC_RESULTS(AbstractResource):
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RPM_RTYSERVER(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['juliyas', 'iddqd', 'ivanmorozov', 'ntatarinov', 'anikella']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RPM_RTYSERVER_CONFIG(AbstractResource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['juliyas', 'iddqd', 'ivanmorozov', 'ntatarinov', 'anikella']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PAGERANK(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRBINS_FOLDER(AbstractResource):
    """
        Папка с бинарниками pagerank
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['zagevalo', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PREPARAT(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REFCOUNTER(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LINKDUMP(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOPS(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REDIRECT(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRPARSE(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MESHD(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GRAPHD(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MESHSTORED(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MESHSTORECL(AbstractResource):
    """

    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MESHWEB(AbstractResource):
    """
        MESH web interface
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCALC(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCALCWORKER(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCOMPASS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWFEED(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWFEED_ARCHIVE(AbstractResource):
    """
        kwfeed archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['serxa', 'rdna']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWGENE(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWHEN(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMETA(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWNEST(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWWORM(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'single', 'qwerty', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMKTORRENT(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMKTORRENT_ARCHIVE(AbstractResource):
    """
        kiwi make-torrent archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['rdna', 'serxa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOC_ARCHIVE(AbstractResource):
    """
        kiwi make-torrent archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['attach', 'serxa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWWORM_RES(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWWORM_ARCHIVE_RES(AbstractResource):
    """
        kiwi make-torrent archive
    """
    releasable = True
    any_arch = False
    releasers = ['attach', 'serxa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_PROTOS_PYTHON_BUILD(AbstractResource):
    """
        build of yweb/robot/kiwi/protos/python
    """
    uploadable = True
    releasable = True
    any_arch = True
    releasers = ['alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class URLTOOWNER_BIN(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOBIN(AbstractResource):
    """
        kiwi related resource
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOBINS(AbstractResource):
    """
        directory with protobins
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOBIN_DIFFS(AbstractResource):
    """
        directory with protobin diffs
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALCBIN(AbstractResource):
    """
        kiwi related resource
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOBIN_DIFF(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FANCY_DIFF(AbstractResource):
    """
        kiwi related resource
    """
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTOBIN_DIFF_ARCHIVE(AbstractResource):
    """
        kiwi make-torrent archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['attach', 'serxa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MULTIPB_CONVERT(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MULTIPB_CONVERT_ARCHIVE(AbstractResource):
    """
        kiwi make-torrent archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['attach', 'serxa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRACKER(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWLOADER(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWPERSSTAT(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRANS(AbstractResource):
    """
        deprecated by KWMQBUILD
    """
    deprecated = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMQBUILD(AbstractResource):
    """
        kiwi meta-query builder binary
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['serxa', 'rdna', 'fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMQBUILD_ARCHIVE(AbstractResource):
    """
        kiwi meta-query builder archive
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['serxa', 'rdna']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRANS_ARCHIVE(AbstractResource):
    """
        deprecated by KWMQBUILD_ARCHIVE
    """
    deprecated = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BALANCER(AbstractResource):
    """
        kiwi and other mbus programs related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['alexnick', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWRICH(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCLOMP(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXTCALCSUBSCRIBER(AbstractResource):
    """
        kiwi and other mbus programs related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['alexnick', 'wint']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWMETAQUERY(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWBINTAR(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['fomichev', 'davenger', 'wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTESTS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWEXECBENCH(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWKIWITESTS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCOMMONTESTS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWOSSA(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMBMON(AbstractResource):
    """
        kiwi related resource
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['wint', 'ssvspb', 'stunder']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWSITATESTS(AbstractResource):
    """
        sita related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWGEMINITESTS(AbstractResource):
    """
        gemini related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUKROPTESTS(AbstractResource):
    """
        ukrop related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTEST_DATA(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWORNITHOLOGY(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUNITTESTS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUDFS(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUDFS_DATA(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUDFS_QUERY(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWUDFS_REPLY(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWASSESSMENTSEXPORT(AbstractResource):
    """
        kiwi related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRIGGER_ARCHIVE(AbstractResource):
    """
        Архив с kiwi-триггерами
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['rdna', 'zagevalo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRIGGER_FOLDER(AbstractResource):
    """
        Папка с kiwi-триггерами
    """
    releasable = True
    any_arch = False
    releasers = ['rdna', 'zagevalo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_QUERY_SCRIPT(AbstractResource):
    """
        Query script for testing KiWi triggers
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMRUNITTESTS(AbstractResource):
    """
        kikimr related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMRMRUNITTESTS(AbstractResource):
    """
        kikimr related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMRRTMRUNITTESTS(AbstractResource):
    """
        kikimr related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMR(AbstractResource):
    """
        kikimr related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMRTESTS(AbstractResource):
    """
        kikimr related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FETCHERUNITTESTS(AbstractResource):
    """
        zora related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMR_MAPREDUCE(AbstractResource):
    """
        mapreduce related resource
    """
    uploadable = True
    releasable = False
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMR_PERF_TOOL(AbstractResource):
    """
        mapreduce related resource
    """
    uploadable = True
    releasable = False
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMR_CANONICALC(AbstractResource):
    """
        mapreduce related resource
    """
    uploadable = True
    releasable = False
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMR_TESTS(AbstractResource):
    """
        mapreduce related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMR_SCHEME(AbstractResource):
    """
        mapreduce related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMRUNITTESTS(AbstractResource):
    """
        mapreduce related resource
    """
    releasable = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIKIMR_CLUSTER_LOGS(AbstractResource):
    """
        kikimr cluster logs resource
    """
    releasable = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MUSCA(AbstractResource):
    """
        musca (multi-url status checker [asynchronous]) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITA(AbstractResource):
    """
        sita (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITACONFPROD(AbstractResource):
    """
        sita config (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITACONFSB(AbstractResource):
    """
        sita config (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITACONFINTRA(AbstractResource):
    """
        sita config (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITACL(AbstractResource):
    """
        sita (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DCACHE(AbstractResource):
    """
        sita (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DCACHECL(AbstractResource):
    """
        sita (cheburashka) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['familom', 'wint', 'ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_CASTOR(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_POLLUX(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_LOOKUP(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_INDEXER(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CREATE_INDEX_TEST(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINICL(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_GEMINICL(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SUPER_DUPS_TEST(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUPER_DUPS_TEST(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['ssvspb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINITEST_DATA(AbstractResource):
    """
        gemini related resource
    """
    releasable = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITATEST_DATA(AbstractResource):
    """
        sita (cheburashka) related resource
    """
    releasable = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_BINARY(AbstractResource):
    """
        Base class for binary files used in Ukrop Project.
    """
    releasable = True
    releasers = ['achelnokov', 'bazil', 'egoregor', 'elsol', 'ksjuchi', 'imeln', 'lazy', 'olegsenin', 'rdna',
                 'robot-testenv']
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_COMPILESLICES_MR(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_BACKUPDUMPER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_CRUTCH_MRAGENT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_FACTORS_HANDLER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_FIND_FRESH(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_FRESH(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_FRESHCLIENT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_GEMINI_LOOKUP(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_GETBORDERS(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_HOSTLIST(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_PRINTHISTORECS(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_SPYLOGPARSER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_ZONEADDER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_LOOKUP(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_MK_TORRENT_DEL_LIST(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_MR_INDEX(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_UPREPARAT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_UBERGEN(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_PROTOBIN2MR(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_SPLITBYURL(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_VIEWS_CLIENT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_MR_FETCHED_COUNTER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_MR_TOP_HOST_CRAWL_MON(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_EXPORTRANK(AbstractResource):
    """
        ukrop related resource. fml for rebuild exportRank
    """
    uploadable = True
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_EXPORTRANK_TR(AbstractResource):
    """
        ukrop related resource. fml for rebuild exportRank
    """
    uploadable = True
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_DATA(AbstractResource):
    """
        ukrop related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_KIWI_DATA(AbstractResource):
    """
        local ukrop kiwi related resource
    """
    releasable = False
    executable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_ARRANGE_CRAWLATTEMPT_LOGS(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_ARRANGE_SAMPLES(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_UPLOAD_PREPARAT_TO_MR(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_ACTUALIZE_KIWI_EXPORT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_UNPACK_HOSTDATA(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_SPLIT_DATA(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_RTCUSTOMFILTER(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CRAWL_CONFIGS_GENERATOR(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_FORMAT(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_BUILD_TRIE(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_UNPACK_SAMPLES(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UKROP_CALCQUALITY(UKROP_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_ANTISYN(AbstractResource):
    """
        Antisyn-files from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/antisyn)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_BAD_WORDS_WEIGHTS(AbstractResource):
    """
        File bad_words_weights.txt from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/bad_words_weights.txt)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_FORCES_INFO(AbstractResource):
    """
        File forces_info from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/forces_info)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_PURE_TRIE(AbstractResource):
    """
        File pure.trie from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/pure.trie)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_SEOLNK(AbstractResource):
    """
        Directory seolnk/ from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/seolnk)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WALRUS_TPL_SHOP(AbstractResource):
    """
        Directory shop/ from walrus template host.
        (rsync://walrus.yandex.ru/berkanavt/dbspider/config/shop)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_DATABASE_GOOGLE_DATA(AbstractResource):
    """
        Files from ya host:
        /Berkanavt/database/catalog/link_adult.dict.bin
        /Berkanavt/database/catalog/link_porno.dict.bin
        /Berkanavt/database/catalog/new_direct.dict.bin
        /Berkanavt/database/catalog/temp/porno.txt
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BRASERO_GEO_2CP_DATA(AbstractResource):
    """
        File from brasero host:
        rsync://brasero.fb.yandex.ru/yaca/current/src/cat/c2p/geo.c2p
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_CATALOG_DATA(AbstractResource):
    """
        Files from ya host:
        /Berkanavt/catalog/geoa.c2p
        /Berkanavt/catalog/clatrbase_config,
        /Berkanavt/catalog/common.c2p,
        /Berkanavt/catalog/filter.obj,
        /Berkanavt/catalog/product.words,
        /Berkanavt/catalog/spl-grp.cfg,
        /Berkanavt/catalog/mirrors.trie,

    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_URLMENU_TRIE(AbstractResource):
    """
        Files from ya host:
        /Berkanavt/catalog/urlmenu.trie
    """
    any_arch = True
    auto_backup = True
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_DATA_FILTER_TRIE(AbstractResource):
    """
        Files from ya host:
        /Berkanavt/catalog/filter.trie
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_FILTER_SO(AbstractResource):
    """
        File from ya host:
        "/Berkanavt/filter/filter.so"
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_GLOBALCONFIG_DATA(AbstractResource):
    """
        Files from ya host:
        "dbspider/globalconfig/rus.filter.so"
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_USERDATA(AbstractResource):
    """
        Files from ya host:
        "userdata/wordhost_clicks.gz"
        "userdata/wordhost_rank.gz"
        "userdata/wordhost_yabar.gz"
        "userdata/reg_map.bin"
        "userdata/meta"rus.filter.so"
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_MS_USERDATA(AbstractResource):
    """
        Files from svn+ssh://arcadia.yandex.ru/arc/tags/middle/data/current-stable
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_OPTIONS(AbstractResource):
    """
        OxygenOptions.cfg (#MEDIASRE-272)
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.multsearch
    release_subscribers = resource_releasers.media_sre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD_DATA(AbstractResource):
    """
        Binaries and scripts to put in shard as-is
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OMNIDEX_MODEL(AbstractResource):
    """
        scheme and table models for omni index (formerly omnidex) archiver
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_CPU_USAGE_TABLE(AbstractResource):
    """

    """
    releasable = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABAR_WORD_CREATE_INDEX(AbstractResource):
    """
        Исполняемый файл программы yabar_word_create_index
        Создает trie из однословных факторов по Яндекс Бару для использования
            в колдунщике для использования в базовом поиске.
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGMUX_COLLECTOR(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['xpahos', 'stunder', 'alximik', 'rlipovsky', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGMUX_COLLECTOR_NG(AbstractResource):
    """
        Resource for storing new logmux collector binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['xpahos', 'stunder', 'rlipovsky', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGMUX_STORAGE_NG(AbstractResource):
    """
        Resource for storing new logmux storage binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['xpahos', 'stunder', 'rlipovsky', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGSPLITTER(AbstractResource):
    """
        Resource for storing logsplitter binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['xpahos', 'stunder', 'rlipovsky', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGIMPORTER(AbstractResource):
    """
        Resource for storing logimporter binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['xpahos', 'stunder', 'rlipovsky', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DATAWORK(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUT(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GETURL(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGICALDOCS(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGSUBS(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPIDER(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class XSLTPROC(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZORA(AbstractResource):
    """
        fetcher related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZORACL(AbstractResource):
    """
        fetcher related resource
    """
    any_arch = False
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REAL_TIME_INDEXER_TEST_DATA(AbstractResource):
    """
        Data for testing rtindexer in automatic mode.
        Use int TeamCity
    """
    any_arch = True
    executable = False
    calc_md5 = True
    restart_policy = ctr.RestartPolicy.RESET


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BSCONFIG(AbstractResource):
    """
        BSConfig script
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['ekilimchuk', 'nekto0n', 'alximik', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_PLOT(AbstractResource):
    """
        Autocheck statistics plot.
    """
    calc_md5 = False
    auto_backup = True
    share = False
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_PLOT_DATA(AbstractResource):
    """
        Autocheck data used for plots.
    """
    calc_md5 = False
    auto_backup = True
    share = False
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_NM_FILES(AbstractResource):
    """
        Nms of binary files.
    """
    calc_md5 = False
    auto_backup = True
    share = False
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIRROR_SCHEDULER(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_CHECKER(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FETCHER(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SCHEDULER2(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIRROR_SPIDER(AbstractResource):
    """
        mirror-spider related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BATCHRESOLVER(AbstractResource):
    """
        mirror-spider related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MDBUTIL(AbstractResource):
    """
        mirror-spider related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZSPROXY(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FILTER_BUILD(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAKE_FILTER(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIRRMANIP(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MKCYHASH(AbstractResource):
    """
        mirror-scheduler related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PAGECMP(AbstractResource):
    """
        mirror-spider related resource
    """
    releasable = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_NEWS_RESULT_ARCHIVE(AbstractResource):
    """
        Архив с бинарниками и библиотеками для новостей
    """
    releasable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_PACKAGE(AbstractResource):
    """
        Архив для выкатывания на новостной индексатор
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_YT_PACKAGE(NEWS_INDEXER_PACKAGE):
    """
        Облегчённый пакет для использования на YT
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_PACKAGE_UNPACK(NEWS_INDEXER_PACKAGE):
    """
        Пакет в виде распакованной директории для деплоя в облаке
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_YT_PACKAGE_UNPACK(NEWS_INDEXER_YT_PACKAGE):
    """
        В виде директории для деплоя в облако
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_STATIC_FILE(AbstractResource):
    """
        Файл, который генерится на индексаторе для репорта
    """
    releasable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCHIVER_TOOL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл tools/archiver
    """
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELEV_FML_UNUSED_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл tools/relev_fml_unused
    """
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DYNAMIC_MODELS_ARCHIVE(AbstractResource):
    """
        Архив с моделями, который может быть подгружен базовым или средним поиском при запуске
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = resource_releasers.all_dynamic_models_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DYNAMIC_MODELS_ARCHIVE_BASE(DYNAMIC_MODELS_ARCHIVE):
    """
        Архив с моделями, который может быть подгружен базовым поиском при запуске.
        Содержит только L1+L2 модели.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DYNAMIC_MODELS_ARCHIVE(AbstractResource):
    """
        Архив с динамическими моделями базового поиска видео
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = video_releasers + ['robot-fml-sandbox']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MIDDLE_DYNAMIC_MODELS_ARCHIVE(AbstractResource):
    """
        Архив с динамическими моделями среднего поиска видео
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = video_releasers + ['robot-fml-sandbox']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PERL_MODULES(AbstractResource):
    """
        Архив с бинарными модулями для новостного индексатора.
        Собирать его в сандбоксе сейчас нельзя т. к. нужно точное совпадение версии перла с индексатором
        В будущем либо эти модули станут не нужны, либо для их сборки будем носить перл с собой
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_DATA(AbstractResource):
    """
        Архив с дополнительными данными для новостного индексатора.
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_BACKOFFICE_DATA(AbstractResource):
    """
        Архив с дополнительными данными для новостной итерации про агентства, словари и настройки из бэкофиса.
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE(AbstractResource):
    """
        Сторадж с новостями.
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MEDIA_STORE(AbstractResource):
    """
        Директория со store-базами с медиа материалами: картинки, видео, внешние ссылки.
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_HOL_WWW(AbstractResource):
    """
        Содержимое /hol/www на новостном индексаторе
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NINJA_EXECUTABLE(AbstractResource):
    """
        Ninja executable.
        http://martine.github.com/ninja/
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CMAKE_EXECUTABLE(AbstractResource):
    """
        CMake executable.
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['rnefyodov', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PIC_ROBOT(AbstractResource):
    """
        Собранный картиночный робот для новостей
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_BINS(BUILD_NEWS_RESULT_ARCHIVE):
    """
        Собранные бинарники и скрипты для индексатора
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_INDEXER_BINS(BUILD_NEWS_RESULT_ARCHIVE):
    """
        Бинарники для индексатора, связанные с работой с индексом
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SCRIPTS(AbstractResource):
    """
        Скрипты для новостного индексатора
    """
    releasable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_CUSTOM_BINS(AbstractResource):
    """
        Остальные бинарники, собираемые вне сандбокса
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_VIRTUALENV(AbstractResource):
    """
        Virtualenv с питоном для новостей
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PYTHON(AbstractResource):
    """
        Бинарник питона из аркадии для новостей
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RANK_SLICES(AbstractResource):
    """
        Срезы для обучения ранжирования новостей
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_UNDUP_SERVER_EXECUTABLE(AbstractResource):
    """
        Бинарник для поиска дублей по тексту
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = ['sgrb', 'yurifrolov', 'lazy', 'alximik', 'trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_DEHTMLD_EXECUTABLE(AbstractResource):
    """
        Сервер отдачи полных текстов над стораджем
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = ['trofimenkov', 'noiseless', 'ekilimchuk', 'lazy', 'sgrb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_FEED_FINDER_EXECUTABLE(AbstractResource):
    """
        Сервер поиска фидов
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = ['sgrb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERP_COLLECTOR_URLS(AbstractResource):
    """
        Список URLs для таска SERP_COLLECTOR
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    restart_policy = ctr.RestartPolicy.RESET
    releasers = None
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERP_COLLECTOR_LOOT(AbstractResource):
    """
        Архив с выкачанными таском SERP_COLLECTOR данными
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = None
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERP_COLLECTOR_TEMP_LOOT(AbstractResource):
    """
        Архив с выкачанными одним субтаском SERP_COLLECTOR данными
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True
    restart_policy = ctr.RestartPolicy.DELETE
    releasers = None
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ARCHIVE_WORKER_SHARD(AbstractResource):
    """
        Шард для процесса, готовящего новостные архивы
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = ['yurifrolov', 'lazy', 'alximik', 'sgrb']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GSTIC_ARCHIVE(AbstractResource):
    """
        Static uClibc-enabled GCC
    """
    releasable = False
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THIRDPARTY_BINUTILS(AbstractResource):
    """
        Binutils archive (source distribution)
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THIRDPARTY_GCC(AbstractResource):
    """
        GCC archive (source distribution)
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THIRDPARTY_UCLIBC(AbstractResource):
    """
        uClibc archive (source distribution)
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THIRDPARTY_LINUX_KERNEL(AbstractResource):
    """
        Linux kernel (source distribution)
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GCC_TOOLKIT(AbstractResource):
    """
        Gcc Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["pg", "somov", 'rnefyodov', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLANG_TOOLKIT(AbstractResource):
    """
        Gcc Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["pg", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ICC_TOOLKIT(AbstractResource):
    """
        Intel C++ Compiler Toolkit
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GCC_BUILD_DIR(AbstractResource):
    """
        GCC Build directory
    """
    releasable = False
    auto_backup = False
    calc_md5 = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SCRIPT_BUILD_RESULT(AbstractResource):
    """
        Script build result
    """
    releasable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CROSS_MSVC_TOOLKIT(AbstractResource):
    """
        Cross MSVC Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['kakabba', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GDB_TOOLKIT(AbstractResource):
    """
        GDB Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["pg", "somov", "eigenein", 'rnefyodov', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_OUTPUT(AbstractResource):
    """
        Build output
    """
    any_arch = True
    auto_backup = False
    restart_policy = ctr.RestartPolicy.DELETE
    releasable = False
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_OUTPUT_HTML(AbstractResource):
    """
        Build output
    """
    restart_policy = ctr.RestartPolicy.IGNORE
    releasable = False
    auto_backup = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_BLOAT_OUTPUT(AbstractResource):
    """
        ya bloat output
    """
    releasable = False
    auto_backup = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_LOGS(AbstractResource):
    """
        Build logs
    """
    restart_policy = ctr.RestartPolicy.IGNORE
    releasable = False
    auto_backup = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GOSKY_BINARY(AbstractResource):
    """
        gosky compiled binary for posix platform.
    """
    any_arch = False
    releasable = True
    auto_backup = True
    executable = True
    releasers = ['torkve']
    release_subscribers = ['torkve']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESSNIP_SEARCH(AbstractResource):
    """
        address snippets searcher binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['my34']
    release_subscribers = ['my34']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESSNIP_INDEX(AbstractResource):
    """
        address snippets searcher binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['my34']
    release_subscribers = ['my34']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESSNIP_SEARCH_CONFIG(AbstractResource):
    """
        Файл конфига базового поиска address snippets
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESSNIP_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы поиска address snippets
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRESSNIP_SEARCH_PLAN(AbstractResource):
    """
        План для долбилки с запросами к базовому поиску address snippets
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AQUA_TEST_RESULT(AbstractResource):
    """
        AQUA_TEST test results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GOLOVAN_CONFIG(AbstractResource):
    """
        golovan yasm.conf
    """
    releasable = False
    any_arch = True
    executable = False
    releasers = ['nobus']
    release_subscribers = ['nobus']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALEMATE(AbstractResource):
    """
        Alemate project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALEMATE_CLIENT(AbstractResource):
    """
        Alemate client archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALEMATE_SHARD(AbstractResource):
    """
        Alemate project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALEMATE_DOCS(AbstractResource):
    """
        Alemate documentations dir
    """
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YADNS_DATA(AbstractResource):
    """
        YaDNS data lua scripts and static files
    """
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['reddog', 'nuraev', 'cepera']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INSTANCECTL(AbstractResource):
    """
        Watchdog for search instances
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers

# Do not add new resource classes in this deprecated module, please. See module description above for details.


class INSTANCECTL_SSHD(AbstractResource):
    """
        sshd for runtime cloud instances
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INFORMANT(AbstractResource):
    """
        tar.gz file with informant
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['nekto0n', 'alximik', 'alonger', 'romanovich', u'nanny-robot', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_START(AbstractResource):
    """
        Start script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_STATUS(AbstractResource):
    """
        Check instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_NOTIFY(AbstractResource):
    """
        Vanilla iss_hook_notify script for INSTANCECTL
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_STOP(AbstractResource):
    """
        Stop instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_INSTALL(AbstractResource):
    """
        Install instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_UNINSTALL(AbstractResource):
    """
        Uninstall instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_HOOK_REOPENLOG(AbstractResource):
    """
        Reopen log script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_START_HOOK(AbstractResource):
    """
        Start script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CHECK_HOOK(AbstractResource):
    """
        Check instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_STOP_HOOK(AbstractResource):
    """
        Stop instance script for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_JDK(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_JDK_PRESTABLE(ISS_JDK):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_JNA_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CASSANDRA_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_JOLOKIA_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CASSANDRA_CONFIG_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CACHER_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CACHER_CONFIG_PRESTABLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CACHER_SERVICE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['marchhare', 'ekilimchuk']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CAPPER_JAR(AbstractResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTER_API_JAR(AbstractResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTER_API_CONFIG(AbstractResource):
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IssScript(AbstractResource):
    any_arch = True
    auto_backup = True
    executable = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTER_API_HOOK_STATUS(IssScript):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTER_API_HOOK_STOP(IssScript):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JDK_MUX_SCRIPT(IssScript):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OOM_KILLER_SCRIPT(IssScript):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_STUB_EXECUTABLE(AbstractResource):
    """
        Base search stub executable
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['nekto0n', 'alximik', 'alonger', 'romanovich', 'kimkim', 'osol']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NANNY(AbstractResource):
    """
        Nanny project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AWACS(AbstractResource):
    """
        awacs project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ITS(AbstractResource):
    """
        ITS project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOREST_BUNDLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOREST_BUNDLE_SHARD(AbstractResource):
    shard = True
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOLOCK_BUNDLE(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOLOCK_CONFIG_PRESTABLE(AbstractResource):
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APACHE_DRILL_TAR_GZ(AbstractResource):
    """
        Apache Drill release tar gz bundle.
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['nekto0n', 'alximik', 'romanovich', u'nanny-robot']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NANNY_SHARD(AbstractResource):
    """
        Nanny project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AWACS_SHARD(AbstractResource):
    """
        awacs project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ITS_SHARD(AbstractResource):
    """
        Instance Tune System project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HTTP_GRIDFS(AbstractResource):
    """
        HTTP-GridFS project resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HTTP_GRIDFS_SHARD(AbstractResource):
    """
        HTTP-GridFS project shard (access to GridFS via HTTP)
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTERSTATE(AbstractResource):
    """
        CLUSTERSTATE project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['alximik', 'osol', 'okats', ] + resource_releasers.marty
    release_subscribers = ['osol', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTERSTATE_SHARD(AbstractResource):
    """
        CLUSTERSTATE project shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['alximik', 'osol', 'okats', ] + resource_releasers.marty
    release_subscribers = ['osol', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLUSTERSTATE_BUNDLE(AbstractResource):
    """
        Skynet python + standard clusterstate venv + src tree
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = [
        'mcden',
        'sereglond',
        'robot-gencfg',
        'okats',
    ] + resource_releasers.marty
    release_subscribers = ['osol', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDMAP(AbstractResource):
    """
        SHARDMAP
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['alximik', 'osol', 'basic', 'mkulemin', 'shuster', 'steela', 'ermolovd', 'imeln', 'okats', 'osidorkin',
                 'mcden', 'grmammaev', 'zagevalo'] + resource_releasers.marty
    release_subscribers = ['osol', 'talion']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPLICAMAP(AbstractResource):
    """
        REPLICAMAP
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['alximik', 'osol', 'basic', 'mkulemin', 'shuster', 'steela', 'ermolovd', 'imeln', 'okats', 'osidorkin',
                 'mcden', 'grmammaev', 'zagevalo', 'robot-jupiter-night'] + resource_releasers.marty
    release_subscribers = ['osol', 'talion']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_BASE_SHARDMAP(AbstractResource):
    """
        Fast images tier base shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus', 'anskor', 'robot-images-sandbox', 'robot-images', 'realtim']
    release_subscribers = images_data_subscribers
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_BASE_SHARDMAP_DEPLOY_LOGS(AbstractResource):
    """
        Base deploy logs
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_ULTRA_THUMB_SHARDMAP(AbstractResource):
    """
        Video thumbnail shardmap for ultra circuit
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['robot-video', 'robot-video-acc', 'asdfx90210', 'matveieff', 'mago-nn', 'nextus', 'mnikulin', 'robot-images']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_ULTRA_BASE_SHARDMAP(AbstractResource):
    """
        Video base shardmap for ultra circuit
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus', 'mnikulin']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_THUMB_SHARDMAP(AbstractResource):
    """
        Video thumbnail shardmap
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['nextus', 'robot-video', 'asdfx90210']
    release_subscribers = ['nextus']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_THUMB_SHARDMAP(AbstractResource):
    """
        Fast images tier base shardmap
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['nextus', 'anskor', 'robot-images-sandbox', 'robot-images', 'realtim']
    release_subscribers = images_data_subscribers
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_THUMB_ISS_SHARDMAP(AbstractResource):
    """
        Images related quick thumbnails shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus']
    release_subscribers = ['nextus']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_CBIR_SHARDMAP(AbstractResource):
    """
        Fast images tier base shardmap
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['nextus', 'anskor', 'robot-images-sandbox', 'robot-images', 'realtim']
    release_subscribers = images_data_subscribers
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_BASE_SHARDMAP(AbstractResource):
    """
        Images base shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = images_releasers + ['robot-images-st']
    release_subscribers = images_shardmap_subscribers
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_THUMB_SHARDMAP(AbstractResource):
    """
        Images related queries click shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus', 'anskor', 'robot-images-sandbox', 'robot-images']
    release_subscribers = images_data_subscribers
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_QUICK_THUMB_SHARDMAP(AbstractResource):
    """
        Images related quick thumbnails shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus']
    release_subscribers = ['nextus']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SHARDMAP_CBIR_QUICK_RESOURCE(AbstractResource):
    """
        Images related quick cbir shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nextus']
    release_subscribers = ['nextus']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_BASE_SHARDMAP(AbstractResource):
    """
        Video base shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = video_shardmap_releasers
    release_subscribers = None
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_BASE_SHARDMAP_EXPERIMENTAL(AbstractResource):
    """
        Video base shardmap experimental tier (2%)
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = video_shardmap_releasers
    release_subscribers = None
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_BASE_ACC_SHARDMAP(AbstractResource):
    """
        Video base acceptance shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = video_shardmap_releasers
    release_subscribers = None
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_MMETA_SHARDMAP(AbstractResource):
    """
        Video mmeta shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = video_shardmap_releasers
    release_subscribers = None
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCNEWS_SHARDMAP(AbstractResource):
    """
        Arcnews shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['robot-ynews', 'yurifrolov', 'sgrb', 'k-vukolov', 'cosyx']
    release_subscribers = ['yurifrolov']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NISHOOTER(AbstractResource):
    """
        nishooter tools archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['darkk', 'ivaxer']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NISHOOTER_FRONT_SHARD(AbstractResource):
    """
        nishooter.yandex-team.ru project shard
    """
    shard = True
    releasable = True
    any_arch = False  # due to `tornado` and `pymongo`
    executable = False
    auto_backup = True
    releasers = ['darkk', 'ivaxer']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOKEEPER_ARCHIVE(AbstractResource):
    """
        Tar with Zookeeper .jar and its scripts
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WEBRUCHKA(AbstractResource):
    """
        Webruchka project
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['nekto0n', 'alximik', 'alonger', 'romanovich', ]
    release_subscribers = ['alximik', 'alonger', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NETSTAT(AbstractResource):
    """
        Networc statistics collecting
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['nekto0n', 'alximik', 'alonger', 'romanovich', ]
    release_subscribers = ['alximik', 'alonger', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEHC_EXECUTABLE(AbstractResource):
    """
        nehc executable.
    """

    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PANOPTICON_SURVEY(AbstractResource):
    """
        archive with json panopticon survey
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOOP(AbstractResource):
    """
        Скрипт для запуска верхнего метапоиска под bsconfig
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['angi', 'kfour', 'basic']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VALGRIND(AbstractResource):
    """
        valgrind build
    """
    releasable = True
    auto_backup = True
    releasers = ["pg", "and42"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_FACTOR_DETAILS(AbstractResource):
    """
        rearrange acceptance test factors details
    """
    calc_md5 = False
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_LOGS_DIFF(AbstractResource):
    """
        Diff of AUTOCHECK_LOGS resources.
    """
    auto_backup = True
    calc_md5 = False
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_EXTERNAL_BINARIES(AbstractResource):
    """
        binaries, required in Social Users and Social Crawler, from other projects,
        that is - zoracl, mapreduce, mr_wc, etc.
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_UID_LIST(AbstractResource):
    """
        Yandex user Id в виде простого текстового файла
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RESPONSES(AbstractResource):
    """
        ответы верхнего
    """
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SNIPMETRICS_EXECUTABLE(AbstractResource):
    """
        snipmetricsapp binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['my34']
    release_subscribers = ['my34']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_TOOLS_ARCHIVE(AbstractResource):
    """
        tar-архив с бинарниками Peoplesearch
    """
    any_arch = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_TOOL(AbstractResource):
    """
        бинарник для peoplesearch
    """
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_USERS_CONFIG(AbstractResource):
    """
        конфиг для Social Users
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_CRAWLER_CONFIG(AbstractResource):
    """
        конфиг для Social Users
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_USERS_METAPROFILE_CONFIG(AbstractResource):
    """
        конфиг для Social Users make_metaprofile
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DATA_RUNTIME_CACHE(AbstractResource):
    """
        кэш sfront (архив папки data.runtime)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_DATA_RUNTIME_ITEM_SOURCE(AbstractResource):
    """
        источники одного модуля для генерации данных data.runtime
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_DATA_RUNTIME_ITEM(AbstractResource):
    """
        данные data.runtime для одного модуля.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_DATA_RUNTIME(AbstractResource):
    """
        полный набор данных data.runtime
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['pingvin', 'nbahob', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WEB_REPORT_DATA_RUNTIME_BUNDLE(AbstractResource):
    """
        данные data.runtime для разных версий веб репорта, собранные в одном бандле
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['owlet', 'denon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMGS_REPORT_DATA_RUNTIME_BUNDLE(AbstractResource):
    """
        данные data.runtime для разных версий картиночного репорта, собранные в одном бандле
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['nbahob', 'owlet', 'denon', 'anskor', 'fexion', 'krylov-sergey', 'ololowl']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_REPORT_DATA_RUNTIME_BUNDLE(AbstractResource):
    """
        данные data.runtime для разных версий репорта видео, собранные в одном бандле
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['nbahob', 'owlet', 'denon'] + video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YACA_REPORT_DATA_RUNTIME_BUNDLE(AbstractResource):
    """
        данные data.runtime для разных версий репорта каталога, собранные в одном бандле
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['nbahob', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REPORT_DATA_RUNTIME_BUNDLE(AbstractResource):
    """
        данные data.runtime для разных версий новостного репорта, собранные в одном бандле
    """
    auto_backup = True
    releasable = True
    releasers = REPORT_PACKAGE.releasers + ['gennadiy', 'sgrb', 'k-vukolov', 'yurifrolov', 'errorf', 'robot-ynews']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_RESULT(AbstractResource):
    """
        folder with testing logs and results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YSERVER_2011_03_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл yserver 2011.03
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['dmilideev', 'mesherin', 'amich']
    arcadia_build_path = 'search/daemons/yserver/yserver'
    arcadia_build_name = 'yserver_2011_03'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOBASESEARCH_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл базового поиска для карт (новый)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/base/geobasesearch/geobasesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOBASESEARCH_CONFIG(AbstractResource):
    """
        Файл конфига basesearch
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/kernel/config/business'
    arcadia_build_name = 'geobasesearch.cfg'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_RATINGS(AbstractResource):
    """
        Рейтинги организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_DETAILED_RATINGS(AbstractResource):
    """
        Рейтинги организаций с детализацией по отдельным отзывам
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_COMPUTED_RATINGS(AbstractResource):
    """
        Рейтинги организаций, рассчитанные по машинно обученной формуле
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_COMPUTED_RAW_RATINGS(AbstractResource):
    """
        Сырое число машинно обученного рейтинга
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


class BUSINESS_REVIEW_COUNTS(sdk2.Resource):
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_PHOTOS(AbstractResource):
    """
        Экспорт фотографий организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_SNIPPET_PHOTOS(AbstractResource):
    """
        Сниппетный экспорт фотографий организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_TRANSIT_INDEX(AbstractResource):
    """
        Индекс базового поиска по маршрутам общественного транспорта
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_LIST(AbstractResource):
    """
        Список пермалинков похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_HYPOTHESES(AbstractResource):
    """
        Список гипотез похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_HYPOTHESES_TABLE(AbstractResource):
    """
        Таблица с гипотезами похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_PREPARAT(AbstractResource):
    """
        Препарат пользовательских данных для обучения похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_MODEL(AbstractResource):
    """
        matrixnet.info - модель для похожих организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_EXPORT(AbstractResource):
    """
        Экспорт похожих организаций для заливки на SaaS.
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_ABSTRACT_ID_LIST(AbstractResource):
    """
        Список id сущностей геопоиска (рубрик, организаций, сетей, geoid, и т. д.), по одному в строке
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_RUBRIC_ID_LIST(GEOSEARCH_ABSTRACT_ID_LIST):
    """
        Список id рубрик геопоиска
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_GEOID_LIST(GEOSEARCH_ABSTRACT_ID_LIST):
    """
        Список geoid
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUSINESS_COMPUTED_FILTERS(AbstractResource):
    """
        Предпосчитанные фильтры ППО
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_DRUG_STOP_LIST(AbstractResource):
    """
        Слова, по которым не выделяем лекарства из запроса. GEOSEARCH-4339.
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOWEBANNINDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексатора вебовского аннотационного индекса
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/web_annotation/indexer-web-annotation'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOWEBANNMRFILTER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл фильтра вебовского аннотационного индекса в MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/web_annotation_ops/mr_filter/mr_filter'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOBUSINESSDATAFILTER_EXECUTABLE(AbstractResource):
    """
        Исполняемые файлы фильтров входных данных индексатора ппо
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOADVERTINDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексатора рекламы
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/advert_menu_tags/yandex-geosearch-indexer-advert'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEO_FAST_FEATURES_INDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексатора быстрофичей ППО
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/fast_features/yandex-geosearch-indexer-fast-features'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPOIINDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл индексатора POI
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/indexer/poi/yandex-geosearch-indexer-poi'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPERSONALIZATION_EXTRACTOR_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл сборщика данных для факторов для режима рекоммендаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/personal_factors/extractor/extractor'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPERSONALIZATION_SQUEEZER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл построения выжимок из данных для факторов для режима рекоммендаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/personal_factors/squeezer/squeezer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPERSONALIZATION_AGGREGATOR_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл аггрегации выжимок из данных для факторов для режима рекоммендаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/personal_factors/aggregator/aggregator'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPERSONALIZATION_SERIALIZER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл аггрегации выжимок из данных для факторов для режима рекоммендаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/personal_factors/serializer/serializer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOPERSONALIZATION_MONITOR_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл подсчёта статистик для мониторинга персональных факторов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/personal_factors/monitor/monitor'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALTAY_SOCIAL_LINKS_EXTRACTOR_EXECUTABLE(AbstractResource):
    """
        Тулза для извлечения профилей организаций в соцсетях из снапшота справочника в YT
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/altay_urls_extractor'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_PROFILES_MERGER_FROM_AURORA_EXECUTABLE(AbstractResource):
    """
        Тулза для забора и мерджа апдейта профилей организаций в соцсетях из авроры
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/merge_from_aurora'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_PROFILES_FACTS_EXTRACTOR_EXECUTABLE(AbstractResource):
    """
        Тулза для извлечения фактов из профилей организаций в соцсетях
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/extract_facts'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_ACTUAL_PROFILES_BUILDER_EXECUTABLE(AbstractResource):
    """
        Тулза для составления сниппета событий для организаций
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/build_actual_profiles'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_EVENTS_SNIPPET_BUILDER_EXECUTABLE(AbstractResource):
    """
        Тулза для составления сниппета событий для организаций
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'search/geo/tools/social_links/build_saas_snippets'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SVD_GENERATOR_EXECUTABLE(AbstractResource):
    """
        Генератор svd файлов экспорта идексатора организаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/generatesvd/generatesvd'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_RELEVANT_URLS_EXTRACTOR_EXECUTABLE(AbstractResource):
    """
        Извлекатор урлов из индексных файлов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/extracturls/extracturls'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_USERFEATURES_EXECUTABLE(AbstractResource):
    """
        Расчёт пользовательских фичей геопоиска по user_sessions
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'yweb/maps/tools/calc_user_features/'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DUMP_TO_INDEXERPROXY_EXECUTABLE(AbstractResource):
    """
        Заливатор данных из YT в kv-saas
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'rtline/tools/dump_to_indexerproxy/dump_to_indexerproxy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_HYPOS_SPRAV_EXECUTABLE(AbstractResource):
    """
        Расчёт гипотез похожих организаций из данных справочника
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/similar_orgs/hypotheses/from_backa/hypotheses_from_backa'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_HYPOS_PREPARAT_EXECUTABLE(AbstractResource):
    """
        Расчёт гипотез похожих организаций из препарата пользовательских данных
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SIMILAR_ORGS_PROCESS_PREPARAT_EXECUTABLE(AbstractResource):
    """
        Предобработка препарата пользовательских данных по похожим организациям
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/similar_orgs/process_preparat/process_preparat'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_SIMILAR_ORGS_EXECUTABLE(AbstractResource):
    """
        Расчёт ранжированного списка похожих организаций по гипотезам
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/similar_orgs/calc_similar_orgs/calc_similar_orgs'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CREATE_SIMILAR_ORGS_LEARN_EXECUTABLE(AbstractResource):
    """
        Расчёт обучающего пула для похожих организаций
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/similar_orgs/create_learn_pool/create_similar_orgs_learn'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CREATE_SIMILAR_ORGS_EXPORT_EXECUTABLE(AbstractResource):
    """
        Создание экспорта похожих организаций для заливки на SaaS
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/similar_orgs/upload_to_yt/prepare_for_upload'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_BUSINESS_RATING_EXECUTABLE(AbstractResource):
    """
        Расчёт машинно обученного рейтинга ППО
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/rating/calc_rating/calc_rating'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ORGS_RATING_MODEL(AbstractResource):
    """
        matrixnet.info - модель для расчёта рейтинга организаций
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_MAIN_RUBRIC_EXECUTABLE(AbstractResource):
    """
        Расчёт главной рубрики для ППО
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/main_rubric_classifier/classifier/main_rubric_classifier'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAIN_RUBRIC_MODEL(AbstractResource):
    """
        matrixnet.info - модель для расчёта главной рубрики организации
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ORGS_MAIN_RUBRICS_BIN(AbstractResource):
    """
        Бинарник с главными рубриками организаций. Формат - THashMap<TString, TVector<std::pair<TRubricId, float>>>
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ORGS_MAIN_RUBRICS_TXT(AbstractResource):
    """
        Текстовый файл с главными рубриками организаций.
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SVD_EXPORT(AbstractResource):
    """
        SVD Экспорт, созданный из последней базы ППО
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SHLIB_RELEVANCE_MINIMAL(AbstractResource):
    """
        Бинарник libyandex-maps-arcadia-relevance-minimal.so
    """
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'yweb/maps/libs/relevance_minimal/libyandex-maps-arcadia-relevance-minimal.so'
    arcadia_build_name = 'maps_shlib_relevance_minimal'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS(AbstractResource):
    """
        Карточный индекс business
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_DUMMY(AbstractResource):
    """
        Карточный индекс business (only for timestamp purposes)
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_WIZARD_DATA(AbstractResource):
    """
        Карточный индекс business (то, что требуется визарду)
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_ARCHIVE(AbstractResource):
    """
        Карточный индекс business, зархивированный
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_SOURCE(AbstractResource):
    """
        Исходные данные для построения карточного индекса business
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_POI_COMPANIES(AbstractResource):
    """
        ТРЦ из companies2.xml экспорта Справочника
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_COMPANY_URLS(AbstractResource):
    """
        Урлы компаний из экспорта справочника для фильтрации факторов организаций
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_BUSINESS_SOURCE_ARCHIVE(AbstractResource):
    """
        Исходные данные для построения карточного индекса business,
        только запакованные в архив. База backa, например.
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_ADVERT(AbstractResource):
    """
        Карточный индекс advert
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers + ['robot-geoadv']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_ADVERT_RESOURCE(AbstractResource):
    """
        Карточный индекс advert
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_ADVERT_ARCHIVE(AbstractResource):
    """
        Карточный индекс advert упакованный как tar.gz
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_ADVERT_SOURCE(AbstractResource):
    """
        Исходные данные для построения карточного индекса advert (advert_infos.xml)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_RANKING_MODELS(AbstractResource):
    """
        Формулы ранжирования геопоиска
    """
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TYCOON_AUX_ADVERTS_SOURCE(AbstractResource):
    """
        DEPRECATED: выпилить после реализации API для контент-менеджеров
        Дополнительный ресурс с рекламными объявлениями
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TYCOON_ADVERTS(AbstractResource):
    """
        DEPRECATED: выпилить после перехода на sdk2 задачу TycoonAdverts с ресурсом TYCOON_ADS
        Экспорт рекламных объявлений для индексации в ГеоПоиске
    """
    releasable = True
    releasers = resource_releasers.tycoon
    ttl = 7


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_FAST_FEATURES_ARCHIVE(AbstractResource):
    """
        Индекс быстрофичей, упакованный как tar.gz
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_FAST_FEATURES_SOURCE(AbstractResource):
    """
        Исходные данные по быстрофичам (.pb)
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_GEOCODER(AbstractResource):
    """
        Карточный индекс geocoder
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_GEOCODER_ARCHIVE(AbstractResource):
    """
        Карточный индекс geocoder упакованный как tar.gz
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_WIKI(AbstractResource):
    """
        Карточный индекс wiki
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_WIKI_ARCHIVE(AbstractResource):
    """
        Карточный индекс wiki упакованный как tag.gz
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SEARCH_CONFIG_BASE(AbstractResource):
    """
        Файл конфигурации для источника Business
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SEARCH_CONFIG_GEOCODER(AbstractResource):
    """
        Файл конфигурации для источника Geocoder
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SEARCH_CONFIG_WIKI(AbstractResource):
    """
        Файл конфигурации для источника Wiki
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SEARCH_CONFIG_REFRESH(AbstractResource):
    """
        Файл конфигурации для источника Refresh
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_SEARCH_PACKAGES_LIST(AbstractResource):
    """
        Список карточных пакетов для установки на хосты
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_STATIC_EXPERIMENTAL_FEATURES(AbstractResource):
    """
        Дополнительные факторы, тестируемые в данный момент
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_ANNOTATIONS_TSV(AbstractResource):
    """
        Аннотации геопоиска в текстовом формате
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_INDEXANN_HOST_DATA(AbstractResource):
    """
        Аннотации геопоиска в виде протобуфов TIndexAnnHostData
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_STATIC_DOC_FACTORS(AbstractResource):
    """
        Статические факторы организаций в виде протобуфов TObjectStaticFactors
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_QUERYREC_DATA(AbstractResource):
    """
        Данные для query recognizer
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_GEO_USER_FACTORS(AbstractResource):
    """
        Карточные пользовательские факторы для геопоиска (статические и динамические)
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_STATIC_EVENTS_DISTANCE_FACTORS(AbstractResource):
    """
        Статистики по расстояниям от организации до ll/ull и спанам для кликов и показов в картах
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WEB_USER_FACTORS(AbstractResource):
    """
        Поисковые пользовательские факторы геопоиска (динамические)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WEB_URLS_BUSINESS(AbstractResource):
    """
        Список урлов (канонизированных) индекса Business, для которых геопоиску интересны факторы ранжирования; gzipped
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WEB_URLS_POI(AbstractResource):
    """
        Список урлов (канонизированных) индекса Poi, для которых геопоиску интересны факторы ранжирования; gzipped
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WEB_INDEXANN(AbstractResource):
    """
        Аннотационный индекс веба для геопоиска
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WEB_USER_FACTORS_FILTERED(AbstractResource):
    """
        Поисковые пользовательские факторы геопоиска для компаний из Справочника
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_GEO_HOST_FACTORS(AbstractResource):
    """
        Host factors and spam lists
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_GEO_HOST_FACTORS_FILTERED(AbstractResource):
    """
        Host factors and spam lists for backa companies
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_MARKET_FEEDS(AbstractResource):
    """
        Market feeds list for geosearch indexing
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_POI(AbstractResource):
    """
        Карточный индекс POI
    """
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_POI_SOURCE_WIKI_ARCHIVE(AbstractResource):
    """
        Архив экспорта данных старой НК
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_GEOSRC(AbstractResource):
    """
        Geocoder export in GEOSRC format.
        https://wiki.yandex-team.ru/maps/dev/core/geocoder/export/
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_GEOSRC_REGION(AbstractResource):
    """
        Geocoder export in GEOSRC format (single region)
        https://wiki.yandex-team.ru/maps/dev/core/geocoder/export/
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_POI_SOURCE_POISRC(AbstractResource):
    """
        XML-файлы экспорта POISRC в gzip.
        https://wiki.yandex-team.ru/maps/dev/core/geocoder/poisrc/
    """
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_POI_SOURCE_EXTRA(AbstractResource):
    """
        Внешние данные (Navteq, OSM, Google, агрегаторы, ...)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_WIZARD_ORG_NAV_DATA(AbstractResource):
    """
        Данные для правила org_nav в геопоисковом визарде
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_DATABASE_POI_SOURCE_URLS(AbstractResource):
    """
        Auxiliary URLs for POIs (tab-separated: id, url).
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_PYLIB(AbstractResource):
    """
        compiled python library for Social Users and Social Crawler
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_USERS(AbstractResource):
    """
        archive with social users environment
    """
    any_arch = False
    executable = False
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTOR_TESTS_RESULT(AbstractResource):
    """
        Результат работы тестов FACTOR_CONFIG
    """
    share = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTOR_CONFIG(AbstractResource):
    """
    py.test tests for Rearrange and Tdi
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MEMCACHED(AbstractResource):
    """
        memcached для новостных морд
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MEMCACHED_SOURCE(AbstractResource):
    """
        Исходные коды memcached и библиотек
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX(AbstractResource):
    """
        nginx для новостных морд
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX_LIBRARIES_SOURCE(AbstractResource):
    """
        Исходные коды библиотек для сборки nginx
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NGINX_SOURCE(AbstractResource):
    """
        Исходные коды nginx
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REDIS_SERVER(AbstractResource):
    """
        redis-server для "моих новостей"
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lazy', 'sgrb', 'trofimenkov', 'nieko']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REDIS_SERVER_SOURCE(AbstractResource):
    """
        Исходный код redis-server для "моих новостей"
    """
    releasable = True
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['lazy', 'sgrb', 'trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_BUNDLE(AbstractResource):
    """
        переранжирования для верхнего метапоиска (tar.gz)
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = resource_releasers.noapacheupper_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_DATA(AbstractResource):
    """
        переранжирования для верхнего метапоиска (неархивированные)
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = resource_releasers.noapacheupper_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_SHARD(AbstractResource):
    """
        шард с переранжированиями для верхнего метапоиска
    """
    shard = True
    releasable = True
    auto_backup = True
    releasers = resource_releasers.noapacheupper_releasers
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_DYNAMIC_DATA(AbstractResource):
    """
        динамические переранжирования для верхнего метапоиска (неархивированные)
    """
    executable = False
    releasable = True
    auto_backup = True
    releasers = resource_releasers.all_rearrange_data_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_REGRESSION_TEST_DATA(AbstractResource):
    """
        папка с данными для теста Robot Regression Test
    """
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_REGRESSION_TEST_DIFF(AbstractResource):
    """
        папка с данными для теста Robot Regression Test
    """
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_REGRESSION_TEST_BINARIES(AbstractResource):
    """
        бинарники для Robot Regression Test
    """
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THDB_EXECUTABLE(AbstractResource):
    """
        Утилита для работы с базой картиночных тумбов на диске
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/thdb/thdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SUGGEST_EXECUTABLE(AbstractResource):
    """
        демон для генерации свежего саджеста
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_FOOTBALL_EXECUTABLE(AbstractResource):
    """
        REARR-912
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUNIT_TEST_RESULT_BUNDLE(AbstractResource):
    """
        jUnit test results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUNIT_REPORT(AbstractResource):
    """
        jUnit report
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECT_REPORT_PERFORMANCE(AbstractResource):
    """
        CollectReportPerformance test results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REPORT_PERFORMANCE(AbstractResource):
    """
        TestReportPerformance test results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REPORT_CONTEXT(AbstractResource):
    """
        TestReportContext test results
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CM_WORKER(AbstractResource):
    """
        Clustermaster worker
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.jupiter_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CM_MASTER(AbstractResource):
    """
        Clustermaster master
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.jupiter_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CM_SOLVER(AbstractResource):
    """
        Communism solver
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = resource_releasers.jupiter_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_PACKAGE(AbstractResource):
    """
        Пакеты .deb/.tgz/.txz для WMConsole
    """
    releasable = True
    releasers = ['WEBMASTER', 'lester', 'avhaliullin', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_URLS_CACHE_BASE(AbstractResource):
    """
        sqlite3 файлы с ключами к MDS для урловых, ссылочных, etc архивов
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = ['WEBMASTER', 'robot-webmaster', 'lester']
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_URLS_CACHE_TEST_URLS(WMCONSOLE_URLS_CACHE_BASE):
    """
        sqlite3 файлы с ключами к MDS для урловых архивов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_URLS_CACHE_TEST_LINKS(WMCONSOLE_URLS_CACHE_BASE):
    """
        sqlite3 файлы с ключами к MDS для ссылочных архивов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_URLS_CACHE_PROD_URLS(WMCONSOLE_URLS_CACHE_BASE):
    """
        sqlite3 файлы с ключами к MDS для урловых архивов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMCONSOLE_URLS_CACHE_PROD_LINKS(WMCONSOLE_URLS_CACHE_BASE):
    """
        sqlite3 файлы с ключами к MDS для ссылочных архивов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_REQUESTS_TABLE(AbstractResource):
    """
       http://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/podborformul/kosher-pool-file-format
       Table:
       request-id \t additional parameters, started with &
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_REQUESTS_TABLE_FOR_MICROSHARD_COMPARISON(FML_REQUESTS_TABLE):
    """
       Like FML_REQUESTS_TABLE, but a separate resource
       to be released for COMPARE_MICROSHARDS_RUN_IDX_OPS
    """

    releasable = True
    releasers = ['kartynnik', 'qwerty']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_RATINGS_TABLE(AbstractResource):
    """
       Aka ratings.tsv.gz on FML
       http://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/podborformul/kosher-pool-file-format
       Table:
       request-id \t ranking-url \t rating
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_QUERIES_TABLE(AbstractResource):
    """
       Aka queries.tsv.gz on FML
       http://wiki.yandex-team.ru/jandekspoisk/kachestvopoiska/podborformul/kosher-pool-file-format
       Table:
       request-id \t query-text \t region-id [ \t domain [ \t LEARN/TEST] ]
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_EST_FEATURES_TSV_OUTPUT(AbstractResource):
    """
       idx_ops tsv output in estfeatures2f mode
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_EST_FEATURES_PROTOBUF_OUTPUT(AbstractResource):
    """
       idx_ops protobuf output in estfeatures2f mode
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_EST_FEATURES_PROTOBUF_FINAL_OUTPUT(AbstractResource):
    """
       idx_ops protobuf output (final format) in estfeatures2f mode
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELEV_PARAMETERS_LIST(AbstractResource):
    """
        List of relevance parameters. Watch &relev=.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELEV_PARAMETERS_TABLE(AbstractResource):
    """
       Table:
       <header>
       query \t lr \t additional parameters \t <list of relevance parameters values>
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNITYBOT_PACKAGE(AbstractResource):
    """
        Package of unitybot
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["snowball"]
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISTBUILDBOT_PACKAGE(AbstractResource):
    """
        Package of distbuildbot
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["snowball"]
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANOTIFYBOT_PACKAGE(AbstractResource):
    """
        Package of unitybot
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["snowball"]
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDATAWORK(AbstractResource):
    """
        idatawork
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INDEXARCH(AbstractResource):
    """
        indexarch
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PAGEFACTORS(AbstractResource):
    """
        pagefactors
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UIDSYNC(AbstractResource):
    """
        uidsync
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DUMPIPROTO(AbstractResource):
    """
        dumpiproto
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMTREEUP(AbstractResource):
    """
        Утилита робота, которая в дереве урлов для веб мастеров устанавливает правильное количество урлов на поиске
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WMFILTER(AbstractResource):
    """
        dump urls srchdocs.pfc
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENSEARCHHASH(AbstractResource):
    """
        Утилита для создания роботного хэша урла
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FBDOCIDS(AbstractResource):
    """
        Утилита для создания фэйсбучных урлов и хэшей
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NSSCANNER(AbstractResource):
    """
        Утилита для выкачивания ns-ов
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KMR(AbstractResource):
    """
        Утилита для создания маскотных карм
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KARMAFR(AbstractResource):
    """
        Утилита для работы с кармами
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DATA_RUNTIME_DUMP(AbstractResource):
    """
        archive with data_runtime folder contents
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    restart_policy = ctr.RestartPolicy.DELETE  # что делать с ресурсом в момент перезапуска таска
    releasers = None
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELSEARCH_LIBREPORT(AbstractResource):
    """
        Бинарник librelsearch_report.so - кастомный репорт для базового поиска связанных запросов
    """
    releasable = True
    executable = True
    auto_backup = True
    any_arch = False
    releasers = ['boger', 'noiseless', ]
    arcadia_build_path = 'cv/related-search/libreport/librelsearch_report.so'
    arcadia_build_name = 'relsearch_libreport'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELSEARCH_BASE_EXECUTABLE(AbstractResource):
    """
        Бинарник relatedsearch - базовый поиск связанных запросов
    """
    releasable = True
    executable = True
    auto_backup = True
    any_arch = False
    releasers = ['boger', 'noiseless', ]
    arcadia_build_path = 'search/daemons/relatedsearch/relatedsearch'
    arcadia_build_name = 'relsearch_basesearch'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VISUAL_CPP_COMPILER_TOOLKIT(AbstractResource):
    """
        MS VC Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ["nalpp", ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YMAKE_BINARY(AbstractResource):
    """
        ymake utility binary
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YATOOL_BINARY(AbstractResource):
    """
        yatool as a binary
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YATOOL(AbstractResource):
    """
        yatool archive
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YMAKE(AbstractResource):
    """
        ymake utility
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_BINARY(AbstractResource):
    """
        python utility binary
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_PROJECT_BINARY(AbstractResource):
    """
        fast_diff as a binary
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLATFORM_MAPPING(AbstractResource):
    """
        json with links to resources by platforms
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FAST_DIFF_BINARY(AbstractResource):
    """
        fast_diff as a binary
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON(AbstractResource):
    """
        python utility
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_KIWI_RULES(AbstractResource):
    """
        storing antispam rules for kiwi
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['robot-aspam-uploader', 'bikulov', 'akindyakov', 'robot-antispam']
    release_subscribers = ['bikulov', 'akindyakov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_OWNERS_INFO_TRIE(AbstractResource):
    """
        owners info from antispam for images
        IMAGES-9408
    """
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_PORNO_TEXT_MODEL(AbstractResource):
    """
        storing model for PornoClassifierTrigger in KiWi
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SPOK_METRICS_BINARY(AbstractResource):
    """
        storing fresh spok metrics binary
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGODB_SOURCES_ARCHIVE(AbstractResource):
    """
        Архив tar.gz с исходниками mongodb http://www.mongodb.org/
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ATLAS_SOURCES_ARCHIVE(AbstractResource):
    """
        Архив tar.gz с исходниками ATLAS http://math-atlas.sourceforge.net/
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SCONS_SOURCES_ARCHIVE(AbstractResource):
    """
        Архив tar.gz с исходниками scons http://sourceforge.net/projects/scons/files/scons/
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LIBUNWIND_SOURCES_ARCHIVE(AbstractResource):
    """
        Архив tar.gz с исходниками libunwind http://download.savannah.gnu.org/releases/libunwind/
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_SET(AbstractResource):
    """
        Киви сет для поднятия тестов: kiwi бинарники, nest база и список ключей-урлов
    """
    any_arch = False
    auto_backup = True
    releasers = ['alexeyche', 'attach', 'rdna']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_SEG(AbstractResource):
    """
        Киви сегмент для поднятия тестов. Сделан при помощи local_kiwi.sh
    """
    any_arch = False
    auto_backup = True
    releasers = ['alexeyche', 'attach', 'rdna']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_DATA_SNAPSHOT(AbstractResource):
    """
        Набор протобуфов в бинарном формате для оценённых документов
    """
    any_arch = True
    auto_backup = True
    releasers = ['alexeyche', 'qwerty', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIWI_DUMP(AbstractResource):
    """
        Набор протобуфов в бинарном формате скаченных с Giwi
    """
    any_arch = True
    auto_backup = True
    releasers = ['alexeyche', 'qwerty', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIWI_DUMP_PATCH(AbstractResource):
    """
    """
    any_arch = True
    auto_backup = True
    releasers = ['alexvin', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_DUMP(AbstractResource):
    """
        Набор протобуфов в бинарном формате скаченных с Kiwi
    """
    any_arch = True
    auto_backup = True
    releasers = ['alexeyche', 'qwerty', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_DUMP(AbstractResource):
    """
        Набор протобуфов в бинарном формате скаченных с Yt
    """
    any_arch = True
    auto_backup = True
    releasers = ['alexeyche', 'qwerty', 'zhenyok', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_EXPORT_SAMPLES(AbstractResource):
    """
        html-pages from export monitoring OXYGEN-1136
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_OUT(AbstractResource):
    """
        Выход теста TEST_KIWI_TRIGGERS
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_REGRESSION_OUT(AbstractResource):
    """
        Выход теста TEST_KIWI_TRIGGERS
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_REGRESSION_VALGRIND_OUT(AbstractResource):
    """
        Выход теста TEST_KIWI_TRIGGERS
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_REGRESSION_CHECK_FORMATS_OUT(AbstractResource):
    """
         TEST_KIWI_TRIGGERS
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPARE_ROBOT_TRIGGER_STABLE_RESULT(AbstractResource):
    """
        Выход COMPARE_ROBOT_TRIGGERS_STABLE
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWTRIGGERS_VALGRIND_COMPARE_DIFF_RESOURCE(AbstractResource):
    """
        Выход KWTRIGGERS_VALGRIND_COMPARE_DIFF_RESOURCE
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_REGRESSION_CHECK_FORMATS_DIFF(AbstractResource):
    """
        KIWI_TRIGGERS_REGRESSION_CHECK_FORMATS_DIFF
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_DIFF(AbstractResource):
    """
        Дифф теста TEST_KIWI_TRIGGERS
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_PLAN_DIFF(AbstractResource):
    """
        Дифф теста TestKiwiPlan
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESEARCH_EXTERNAL_PY_PACKS(AbstractResource):
    """
        архив с внешними пакетами Python для PEOPLESEARCH
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_PRELOAD_TIME_LIB(AbstractResource):
    """
        Сошка для заморозки времени
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_DUMP_TOOL(AbstractResource):
    """
        Бинарник для дампа выхода TEST_KIWI_TRIGGERS
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_R_TOOL(AbstractResource):
    """
        R с дефолтными пакетами
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_DUMP_TOOLS(AbstractResource):
    """
        Бинарники для дампа выхода TEST_KIWI_TRIGGERS
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOWNLOAD_PROTOBINS_TOOLS(AbstractResource):
    """
        Набор бинарников и конфигов для работы скрипта check/robotcheck/kiwi/download_protobins.py
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_STATISTICS(AbstractResource):
    """
         build statistics.
    """
    calc_md5 = False
    any_arch = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_TARGET_UID_MAP(AbstractResource):
    """
         target -> uid map.
    """
    calc_md5 = False
    any_arch = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_DIR_GRAPH(AbstractResource):
    """
         dir graph.
    """
    calc_md5 = False
    any_arch = True
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_DIR_GRAPH(AbstractResource):
    """
         dir graph.
    """
    calc_md5 = False
    any_arch = True
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_CSV_STAT(AbstractResource):
    """
         build statistics.
    """
    calc_md5 = False
    any_arch = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YMAKE_RESULTS(AbstractResource):
    """
        ymake build result.
    """
    calc_md5 = False
    any_arch = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_RESULTS_XML(AbstractResource):
    """
        Deprecated. Use AUTOCHECK_METATEST_RESULTS.
        AUTOCHECK_BUILD results JUnit XML.
    """
    any_arch = True
    auto_backup = True
    calc_md5 = False
    executable = False
    restart_policy = ctr.RestartPolicy.DELETE
    release_subscribers = None
    releasable = False
    releasers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_METATEST_RESULTS(AUTOCHECK_RESULTS_XML):
    """
        Not used.
        AUTOCHECK_BUILD integration with Test Environment metatests engine.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_RESPONSIBILITY_RESULT(AbstractResource):
    """
       AUTOCHECK_RESPONSIBILITY results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_DISMISSED_OWNERS_RESULT(AbstractResource):
    """
       AUTOCHECK_DISMISSED_OWNERS results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_CMAKELISTS_UNREACHABILITY_RESULT(AbstractResource):
    """
       AUTOCHECK_CMAKELISTS_UNREACHABILITY results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_CLANG_WARNING_RESULT(AbstractResource):
    """
        AUTOCHECK_CLANG_WARNING results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_CMAKELISTS_UNREACHABILITY_FRESHNESS(AbstractResource):
    """
       AUTOCHECK_CMAKELISTS_UNREACHABILITY cmakelists freshness
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REVIEW_BOARD_GROUPS_RESULT(AbstractResource):
    """
       REVIEW_BOARD_GROUPS results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMORPH_DATA_COMPILER(AbstractResource):
    """
        Компилятор правил реморф
    """
    any_arch = False
    auto_backup = True
    executable = True
    arcadia_build_path = 'tools/remorphc/remorphc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZDATA_PATCH(AbstractResource):
    """
        Файлик с патчем для правил Report (дифф)
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORTRULE_PATCH_ZIP(AbstractResource):
    """
        Файлик с новыми данными для правил Report в архиве zip
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_TEST_REQUESTS(AbstractResource):
    """
        Файлик с запросами для прогона через газеттир
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD_FULL_LOG(AbstractResource):
    """
        Исходный лог принтвизарда
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTWZRD_SIMPLE_LOG(AbstractResource):
    """
        Отформатированный лог принтвизарда
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REPORT_UNIT(AbstractResource):
    """
        вывод юнит тестов репорта
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REPORT_UNIT_COVERAGE(AbstractResource):
    """
        Покрытие репорта юнит тестами
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REPORT_UNIT_COVERAGE_BY_COMMIT(AbstractResource):
    """
        Покрытие репорта юнит тестами, по модулям которые изменились после коммита
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_TOOLS_DEB(AbstractResource):
    """
        PERS_TOOLS Debian package
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_RERANK_SERVICE_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_RERANK_SERVICE_INSTANCECTL_PROD_LOOP_CONF(AbstractResource):
    """
        Watchdog for rerankd instances
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_CONFIG_RERANKD_DATA_UPDATER(AbstractResource):
    """
        Watchdog for rerankd instances
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_SPLIT_SRC_DATA_BINARY(AbstractResource):
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_CANDIDATES(AbstractResource):
    """
        Atom candidate lists
    """
    releasable = True
    releasers = personal_data_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_RERANK_SERVICE_DATA(AbstractResource):
    """
        Atom updatable data bundle
    """
    releasable = True
    releasers = personal_data_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_RERANK_SERVICE_FMLS(AbstractResource):
    """
        Atom formulas bundle
    """
    releasable = True
    releasers = personal_data_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERF_TEST_SERVANT_DATA(AbstractResource):
    """
        perftest servant response data
    """
    releasable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_RERANK_SERVICE_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_BIGB_PROXY_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_QUERYSEARCH_PROXY_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_QUERYSEARCH_ATOM_PROXY_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_RTMR_PROXY_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_APPHOST_RTMR_BOOST_PROXY_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_SRC_MOCK_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_FRONT_SERVICE_BUNDLE(AbstractResource):
    """
        Atom related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_PROMOLIB_NGINX_CONFIG(AbstractResource):
    """
        NGINX config template for Promolib proxy
    """
    executable = False
    readable = True
    releasable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_PROMOLIB_NGINX_LOOP_CONF(AbstractResource):
    """
        loop.conf for NGINX Promolib proxy
    """
    executable = False
    readable = True
    releasable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_PROMOLIB_NGINX_ISS_HOOK_NOTIFY(AbstractResource):
    """
        iss_hook_notify for NGINX Promolib proxy
    """
    executable = False
    readable = True
    releasable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_RERANK_SERVICE_SHARD(AbstractResource):
    """
        Atom related resource
    """
    shard = True
    releasable = True
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE(AbstractResource):
    """
        src_setup bundle
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers + video_releasers + src_setup_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE_WEB(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = APP_HOST_SRC_SETUP_BUNDLE.releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE_ATOM(APP_HOST_SRC_SETUP_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE_IMGS(APP_HOST_SRC_SETUP_BUNDLE):
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE_NEWS(APP_HOST_SRC_SETUP_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BUNDLE_VIDEO(APP_HOST_SRC_SETUP_BUNDLE):
    releasers = apphost_releasers + video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_ABSTRACT_CONFIG(AbstractResource):
    """
        Abstract config
    """
    executable = False
    readable = True
    releasable = True
    auto_backup = True
    releasers = apphost_config_bundle_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_EVENT_LOG_FILTER_EXECUTABLE(AbstractResource):
    """
        app_host event_log_filter tool
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_GENERATOR_EXECUTABLE(AbstractResource):
    """
        app_host graph_generator tool
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SMOKE_TEST_EXECUTABLE(AbstractResource):
    """
        app_host smoke_test tool
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SMOKE_TEST_REPORT(AbstractResource):
    """
        app_host smoke_test report
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_BENCHMARK_TEMPLATE(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup benchmark template
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_NEWS(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup NEWS config bundle
    """
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_ATOM(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup ATOM config bundle
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_WEB(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup WEB config bundle
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + src_setup_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_IMGS(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup IMGS config bundle
    """
    release_subscribers = images_subscribers
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + src_setup_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_CONFIG_BUNDLE_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup VIDEO config bundle
    """
    releasers = apphost_releasers + video_releasers + src_setup_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup loop.conf for production
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + news_releasers + personal_releasers + video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_TESTING_LOOP_CONF(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for testing
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    """
        src_setup loop.conf for production
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + news_releasers + personal_releasers + video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_TESTING_LOOP_CONF_VIDEO(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for testing
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF_WEB(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for production
    """
    releasers = APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF.releasers + ['avitella']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_TESTING_LOOP_CONF_WEB(APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF):
    """
        src_setup loop.conf for testing
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_INSTANCECTL_CONF(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host instancectl.conf for production
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + news_releasers + personal_releasers + video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_WEB(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_ATOM(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_VIDEO(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_IMGS(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_NEWS(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_PRODUCTION_APP_HOST_JSON_COMMON(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host graph_name_mapping.txt
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_WEB(APP_HOST_GRAPH_NAME_MAPPING):
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + report_web_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_IMGS(APP_HOST_GRAPH_NAME_MAPPING):
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + images_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_VIDEO(APP_HOST_GRAPH_NAME_MAPPING):
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + apphost_config_bundle_video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_NEWS(APP_HOST_GRAPH_NAME_MAPPING):
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + ['gennadiy'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_ATOM(APP_HOST_GRAPH_NAME_MAPPING):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_NAME_MAPPING_COMMON(APP_HOST_GRAPH_NAME_MAPPING):
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + common_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_ISS_HOOK_NOTIFY(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host iss_hook_notify
    """
    executable = True
    readable = True
    releasable = True
    auto_backup = True
    releasers = apphost_config_bundle_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_TESTING_INSTANCECTL_CONF(APP_HOST_PRODUCTION_INSTANCECTL_CONF):
    """
        app_host instancectl.conf for testing
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE(AbstractResource):
    """
        app_host http_adapter with related tools
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_ISS_HOOK_NOTIFY(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host iss_hook_notify
    """
    executable = True
    readable = True
    releasable = True
    auto_backup = True
    releasers = apphost_config_bundle_releasers + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_ATOM(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_WEB(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_IMGS(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_VIDEO(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_COMMON(APP_HOST_HTTP_ADAPTER_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_BUNDLE_NEWS(APP_HOST_HTTP_ADAPTER_BUNDLE):
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_ATOM(APP_HOST_ABSTRACT_CONFIG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_WEB(APP_HOST_ABSTRACT_CONFIG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_IMGS(APP_HOST_ABSTRACT_CONFIG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_COMMON(APP_HOST_ABSTRACT_CONFIG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_CONFIG_BUNDLE_NEWS(APP_HOST_ABSTRACT_CONFIG):
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_HTTP_ADAPTER_LOOP_CONF(AbstractResource):
    """
        loop.conf for app_host's http_adapter
    """
    auto_backup = True
    releasable = True
    releasers = apphost_releasers + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE(AbstractResource):
    """
        app_host with related tools
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_WEB(APP_HOST_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_NEWS(APP_HOST_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_VIDEO(APP_HOST_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_IMGS(APP_HOST_BUNDLE):
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_ATOM(APP_HOST_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BUNDLE_COMMON(APP_HOST_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_TOOLS_BUNDLE(AbstractResource):
    """
        app_host tools: servant_client, converter, etc.
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = apphost_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_NEWS(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host NEWS config and graphs
    """
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_WEB(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host WEB config and graphs
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_ATOM(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host ATOM config and graphs
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_COMMON(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host COMMON config and graphs
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_TEMPLATES(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host graphs templates used to generate bundles
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + personal_releasers + apphost_config_bundle_video_releasers \
                + apphost_config_bundle_imgs_releasers + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_SRC_SETUP_TEMPLATES(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host graphs templates used to generate bundles
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + personal_releasers + apphost_config_bundle_video_releasers \
                + apphost_config_bundle_imgs_releasers + news_releasers + ["avitella", "robot-testenv"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_VIDEO(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host ATOM config and graphs
    """
    releasers = apphost_config_bundle_video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG_BUNDLE_IMGS(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host IMGS config and graphs
    """
    releasers = apphost_config_bundle_imgs_releasers
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_CONFIG(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host main config
    """
    releasers = APP_HOST_ABSTRACT_CONFIG.releasers + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BACKENDS_CONFIG(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host backends config
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_DNSCACHE_CONFIG(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host dnscache config
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BACKENDS_GENERATOR_CONFIG(APP_HOST_ABSTRACT_CONFIG):
    """
        app_host config for backends config generator
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_CONFIG_BUNDLE(AbstractResource):
    executable = False
    releasable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_CONFIG_ISS_HOOK_INSTALL(AbstractResource):
    executable = False
    releasable = True
    auto_backup = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_TEST_SERVANTS(AbstractResource):
    """
        app_host test servants
    """
    any_arch = False
    executable = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BENCHMARK_PLAN(AbstractResource):
    """
       Dolbilka requests for synthetics tests app_host
    """
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_GRAPH_CONFIG(AbstractResource):
    """
       app_host graph config
    """
    executable = False
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BENCHMARK_CONFIG(AbstractResource):
    """
       app_host benchmark config
    """
    executable = False
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APP_HOST_BENCHMARK_TESTS(AbstractResource):
    """
        app_host json result with map of benchmark tasks
    """
    executable = False
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNISTAT_RESPONSE(AbstractResource):
    """
        unistat response (/golovan, /admin?action=stats)
    """
    executable = False
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BENCHMARK_METRICS(AbstractResource):
    """
        aggregated metrics
    """
    executable = False
    any_arch = True
    releasers = personal_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STORE_FILE_RESOURCE(AbstractResource):
    """
        Arbitrary, backed up file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESS_EXECUTABLE(AbstractResource):
    """
        Бинарник прослойки для поиска по людям
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['nkmakarov', 'alex-sh', 'iv-ivan', 'asanikushin']
    release_subscribers = ['iv-ivan', 'nkmakarov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESS_CONFIG(AbstractResource):
    """
        Файл конфига прослойки для поиска по людям (peopless)
    """
    releasable = True
    auto_backup = True
    releasers = ['nkmakarov', 'alex-sh', 'iv-ivan', 'asanikushin']
    release_subscribers = ['iv-ivan', 'nkmakarov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESS_PLAN(AbstractResource):
    """
        Бинарный файл плана долбилки с запросами к peopless
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PEOPLESS_RESPONSES(AbstractResource):
    """
        Файл с ответами прослойки поиска по людям (peopless)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HTTPCACHE_EXECUTABLE(AbstractResource):
    """
        Бинарник фейкового http сервера для поиска по людям
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['botay']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HTTPCACHE_CONFIG(AbstractResource):
    """
        Файл конфига фейкового http сервера для поиска по людям
    """

    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HTTPCACHE_REQANSFILE(AbstractResource):
    """
        Файл с запросами и ответами для фейкового http сервера
    """

    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_ENVIRONMENT_JSON(AbstractResource):
    """
        Файл с результатами метатеста, предназначенный для передачи в Test Environment
    """
    auto_backup = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_ENVIRONMENT_JSON_V2(AbstractResource):
    """
        Файл с результатами метатеста, предназначенный для передачи в Test Environment
    """
    auto_backup = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_EMULATION_JSON(AbstractResource):
    """
        Файл с результатами эмуляции
    """
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_ENVIRONMENT_METATEST_LOGS(AbstractResource):
    """
        Файл с логами тестов, запускаемых внутри метатеста
    """
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CORPUS_TEXT(AbstractResource):
    """
        Text corpus (JSON).
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CORPUS_TAGS(AbstractResource):
    """
        Tagged text corpus (JSON).
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_OPTIMIZER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл оптимайзера для генератора конфигов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'okats']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GOLOVAN_AGENT(AbstractResource):
    """
        Packages of Golovan agent
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["tmnt"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_CONFIG(AbstractResource):
    """
        Файл генератора конфига online-роботоловилки
    """
    any_arch = True
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['kfour', 'dude', 'anelyubin', 'ishfb']
    release_subscribers = ['antirobots']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_FORMULAS(AbstractResource):
    """
        Папка с формулами online-роботоловилки
    """
    any_arch = True
    executable = False
    auto_backup = True
    releasable = True
    releasers = [
        'ashagarov',
        'bikulov',
        'ulyanov',
        'rzhikharevich',
        'robot-antirobot'
    ]
    release_subscribers = ['antirobots']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIROBOT_DATA(AbstractResource):
    """
        Папка с импортируемыми данными online-роботоловилки
    """
    any_arch = True
    executable = False
    auto_backup = False
    releasable = True
    releasers = [
        'sandbox',
        'ashagarov',
        'bikulov',
        'ulyanov',
        'rzhikharevich',
        'robot-antirobot'
    ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TSNET_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл tsnet
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TSNET2_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл tsnet2
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TS_CALC_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл ts_calc
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TS_CALC2_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл ts_calc2
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TS_CALC2_CLIENT_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл ts_calc2_client
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TS_EVLOGDUMP_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл ts_evlogdump
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIDSEARCH_DESCR_CLEANER(AbstractResource):
    """
        Библиотека очистки описаний мобильных приложений для детского поиска
    """
    any_arch = False
    executable = False
    auto_backup = True
    releasable = True
    releasers = ['solar', 'inikifor']
    release_subscribers = ['kidzproject']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_FILE_DIFF_RESOURCE(AbstractResource):
    """
        Holds diff for fresh tests
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_COMPARE_DIFF_RESOURCE(AbstractResource):
    """
        Holds diff for fresh tests
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZORA_YACONTEXT_COMPARE_DIFF_RESOURCE(AbstractResource):
    """
        Holds diff for fresh tests
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TEST_OUTPUT(AbstractResource):
    """
        Holds all output for fresh tests (for TestEnv)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZORA_YACONTEXT_TEST_OUTPUT(AbstractResource):
    """
        Holds all output for fresh tests (for TestEnv)
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AGGREGATIONS_TEST_OUTPUT(AbstractResource):
    """
        Holds all output for aggregations test
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WORD_WHT_TRIE(AbstractResource):
    """
        File wordwht.trie.
    """
    uploadable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAGENT_RELEASE_DEBIAN(AbstractResource):
    """
        MRAgent release Fleur debian package
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAGENT_RELEASE_TAR(AbstractResource):
    """
        MRAgent release Fleur tar package
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_CLEANUP_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для очистки роботной базы на MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/cleanup/cleanup'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_IMAGEDB_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для слияния роботной базы на MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mkimagedb/mkimagedb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_LINKDB_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для построения ликовой базы из экспортов kiwi.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/linkdb/main/linkdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_URLDB_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для построения базы urldb
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mkurldb/mkurldb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_CRCDB_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для построения базы crcdb
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mkcrcdb/mkcrcdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_EXECUTABLE(AbstractResource):
    """
       Исполняемый файл для построения базы rimdb
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_rim_releasers
    release_subscribers = images_rim_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/builder/rim_builder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_TOOLS(AbstractResource):
    """
      Утилиты для работы с базой rimdb
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_rim_releasers
    release_subscribers = images_rim_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/rimdb/tools/rim_tools'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_WORD_TFIDF_TRIE(AbstractResource):
    """
       Rimdb words trie
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = images_rim_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_RESOURCES(AbstractResource):
    """
       Files used by rimdb builder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = images_rim_releasers
    release_subscribers = images_rim_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_EVALUATION(AbstractResource):
    """
       Rim DB evaluation tool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_rim_releasers
    release_subscribers = images_rim_subscribers
    arcadia_build_path = 'extsearch/images/tools/nirvana/rim/evaluation/rim_evaluation'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RIMDB_TEST_RESOURCES(AbstractResource):
    """
       Rimdb files using in unit tests
    """
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PICKMRLINK_EXECUTABLE(AbstractResource):
    """
       Открывалка для линковой базы
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/tools/pickmrlink/pickmrlink'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_KWWORM_EXECUTABLE(AbstractResource):
    """
        kwworm
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'yweb/robot/kiwi/kwworm/kwworm'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_ZORACL_EXECUTABLE(AbstractResource):
    """
        zoracl
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'yweb/robot/zoracl/main/zoracl'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_UKROP_PRINT_UDF_EXECUTABLE(AbstractResource):
    """
        UkropPrintUdf
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/tools/UkropPrintUdf/UkropPrintUdf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_ESCAPE_EXECUTABLE(AbstractResource):
    """
        escape - tool to call EscapeC and UnescapeC
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/tools/escape/escape'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SITACL_EXECUTABLE(AbstractResource):
    """
        sitacl
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'yweb/robot/sita/client/sitacl'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PROTOC_EXECUTABLE(AbstractResource):
    """
        protoc
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'contrib/tools/protoc/protoc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DUMPTREC_EXECUTABLE(AbstractResource):
    """
        dumptrec
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/tools/dumptrec/main/dumptrec'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DUMPTRACE_EXECUTABLE(AbstractResource):
    """
        dumptrace
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/robot/tools/dumptrace/dumptrace'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_VIEWERS(AbstractResource):
    """
       Вьюверы картинок.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = images_releasers
    arcadia_path = 'extsearch/images/robot/scripts/imgview/viewers'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MDSPUSH_EXECUTABLE(AbstractResource):
    """
       Отправлялка тумбнейлов в MDS
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/mds/tools/mdspush/mdspush'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_UPLOADSAAS_EXECUTABLE(AbstractResource):
    """
       Отправлялка документов в saas
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/saas/tools/upload/uploadSaas'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_INDEX_LOCATION(AbstractResource):
    """
       ресурс хранит YT-сервер и путь до некоторого индекса
    """
    releasable = True
    auto_backup = True
    releasers = images_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GLOBALCONFIG_TOWNS(AbstractResource):
    """
        File from /Berkanavt/dbspider/globalconfig/towns
    """
    uploadable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWCALC_STAT(AbstractResource):
    """
        Statistics of triggers from kwcalc
    """
    uploadable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRIGGER_STAT(AbstractResource):
    """
        Statistics of trigger from kwcalc
    """
    uploadable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWRSS_STAT(AbstractResource):
    """
        Rss statistics from KIWI_TRIGGERS_REGRESSION task
    """
    uploadable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_TRIGGER_STAT(AbstractResource):
    """
        Stat of triggers signatures and new/lost triggers from KIWI_TRIGGERS_REGRESSION task
    """
    uploadable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_KIWI_TRIGGERS_TEST_STAT(AbstractResource):
    """
        Stat of in.query scripts
    """
    uploadable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_TEST_DATA(AbstractResource):
    """
        KIWI triggers test data in.query, test.query, in.calcbin, out.protobin
    """
    uploadable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DCRON_SCRIPTS(AbstractResource):
    """
       DCron scripts bundle in .tar archive
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['marchael', 'ekilimchuk', 'amich', 'robot-testenv', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUENTAO(AbstractResource):
    """
       Quentao project
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = [
        'alximik',
        'robot-testenv',
        'alonger',
        'dldmitry',
        'yoschi',
        'rocco66',
        'flagist',
    ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROTON_RELEASE(AbstractResource):
    """
       Proton/yvsh project
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['ekilimchuk', 'okats', 'osol']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_PROJECT(AbstractResource):
    """
        Custom arcadia project (build).
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_PROJECT_TGZ(ARCADIA_PROJECT):
    """
        Custom arcadia project (build).
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_PROJECT_SYMBOLS(AbstractResource):
    """
        Custom arcadia project (symbols).
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_CHANGELOG(AbstractResource):
    """
        Custom arcadia project changelog.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_WIKI_CHANGELOG(AbstractResource):
    """
        Custom arcadia project changelog (in wiki formatting).
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMORPH(ARCADIA_PROJECT):
    """
        Remorph (complete build).
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMORPH_CHANGELOG(ARCADIA_CHANGELOG):
    """
        Remorph release changelog.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMORPH_RULES(AbstractResource):
    """
        Remorph rules pack.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TASK_COUNTER_RESOURCE(AbstractResource):
    """
        Ресурс для хранения счетчиков задач каждого типа в состоянии UNKNOWN
    """
    restart_policy = ctr.RestartPolicy.IGNORE
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_CACHER_DISTRIBUTION(AbstractResource):
    """
    Resource for resharing ISS Cacher prepared in Teamcity
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['abcdenis', ]
    release_subscribers = ['abcdenis', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ISS_SHARDS(AbstractResource):
    """
    Console utility for managing shards via iss shard tracker
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class THRIFT_COMPILER_EXECUTABLE(AbstractResource):
    """
    Thrift api compiler
    """
    any_arch = False
    executable = True
    releasable = True
    releasers = iss_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_SPACE_OVERLORD_DISTRIBUTION(AbstractResource):
    """
    Resource for resharing Disk Space Overlord installers
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['abcdenis', ]
    release_subscribers = ['abcdenis', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLAINTEXT_WIZARDED_QUERIES_GZ(AbstractResource):
    """
        <queryid> \t <search CGI string> for feeding into 'idx_ops docidpool'; gzipped
    """
    calc_md5 = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQ_TEXTS_IDS(AbstractResource):
    """
        <queryid> \t <query text> \t <region id>
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOCIDS_QUERYISDS_TEXT(AbstractResource):
    """
        <queryid> \t <docid> for feeding into 'idx_ops docidpool'
    """
    calc_md5 = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BANNERIDS_QUERYIDS_TEXT(AbstractResource):
    """
        <queryid> \t <bannerid> for feeding into bannerid2localdocid (and then to idx_ops)
    """
    calc_md5 = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BANNERID2DOCID_EXECUTABLE(AbstractResource):
    """
        Helper program for building direct click pools from directtier bases
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['spev', 'mlevin', 'b-alex']
    arcadia_build_path = 'specsearches/directtier/factorextract/bannerid2localdocid'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLAIN_TEXT_FEATURES_TABLE(AbstractResource):
    """
        gzipped table with search features
    """
    calc_md5 = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_TEST_PACKAGE(AbstractResource):
    """
        Samogon test package.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_YANDEX_TEAM_PACKAGE(AbstractResource):
    """
        Samogon service package.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_OTHER_RESOURCE(AbstractResource):
    """
        other resource for samogon.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta", "deniskuzin"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_HELLOWORLD(AbstractResource):
    """
        resource with helloworld samogon service.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_BUNDLE(AbstractResource):
    """
        resource with samogon bundle.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["avitella", "chegoryu", "pg", "alonger", "i-dyachkov", "frolstas", "altynbek", "reddi", "bromigo"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_PORTO_LAYER(AbstractResource):
    """
        resource with image for porto
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta", "deniskuzin"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TESTENV_DB_PACKAGE(AbstractResource):
    """
        testenv-db package
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TESTENV_STREAM_PROCESSOR_PACKAGE(AbstractResource):
    """
        testenv-db package
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SALMON_SYSMOND_PACKAGE(AbstractResource):
    """
        sysmond binary for samogon.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ELASTICSEARCH_PACKAGE(AbstractResource):
    """
        Elasticsearch tarball.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta", "nkey"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOGSTASH_PACKAGE(AbstractResource):
    """
        Logstash tarball.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta", "nkey"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIBANA_PACKAGE(AbstractResource):
    """
        KIBANA tarball.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta", "nkey"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAMOGON_INIT_PACKAGE(AbstractResource):
    """
        Package for preparing host for samogon.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ["maxuta"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CYCOUNTER_FILES(AbstractResource):
    """
        CyCounter files, SEPE-7369, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'schizophrenia']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class G2LD_LIST(AbstractResource):
    """
        g2ld.list, SEPE-7379, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'schizophrenia']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FILTER_TOOLS(AbstractResource):
    """
        binaries/scripts for filter.trie and mirrors.trie, SEPE-14778
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'schizophrenia', 'lexeyo', 'zagevalo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FILTER_TRIE(AbstractResource):
    """
        filter.trie, SEPE-7389, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'schizophrenia', 'lexeyo', 'zagevalo', 'robot-kwyt', 'gous32', 'iceflame', 'lester', 'robot-webmaster']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MIRRORS_TRIE(AbstractResource):
    """
        mirrors.trie, SEPE-7389, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'schizophrenia', 'lexeyo', 'zagevalo', 'robot-kwyt', 'gous32', 'iceflame', 'lester', 'robot-webmaster']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_KIWI_TOOL(AbstractResource):
    """
        ya для запуска и обслуживания киви, остальные функции не должны работать
    """
    auto_backup = True
    any_arch = False
    calc_md5 = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_OPS_ANN_INDEX_PATCH(AbstractResource):
    """
        patch файл для сборки idx_ops с аннотационным индексом.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_POOL_STATS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл fml_pool_stats
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', 'sancho']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NNINDEXER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл nnindexer
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'cv/sigtools/nnindexer/nnindexer'
    releasers = ['strepetarh', 'slesarev', 'peterdemin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_QUERY_DIFF(AbstractResource):
    """
        Query diff for geosearch development
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLOT_SERVICE(AbstractResource):
    """
        Сервис построения графиков
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_GOLOVAN_EXTEVLOGPROC_EXECUTABLE(AbstractResource):
    """
        extevlogproc (external eventlog processor)
        is used on geosearch servers (ADDRS) as data source for Golovan agent
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRIECOMPILER_EXECUTABLE(AbstractResource):
    """
        triecompiler
    """
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'tools/triecompiler/triecompiler'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_WHEEL(AbstractResource):
    """ `.whl` file with python package in wheel format """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["korum", "ashurpin", "yetty", "serik", "aguschin"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_EGG(AbstractResource):
    """ `.egg` file with python package in egg format """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["korum", "ashurpin", "yetty", "serik", "aguschin"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NODEJS_PACKAGE(AbstractResource):
    """ Node JS binary package. """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["korum", "ashurpin", "yetty"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NODEJS_MODULE(AbstractResource):
    """ Node JS module. """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["korum", "ashurpin", "yetty"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_SEARCH(AbstractResource):
    """
        serpapi searcher binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['alikulin', 'my34']
    release_subscribers = ['alikulin', 'my34']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_INDEX(AbstractResource):
    """
        serpapi searcher binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['alikulin']
    release_subscribers = ['alikulin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_SEARCH_CONFIG(AbstractResource):
    """
        Файл конфига базового поиска serpapi
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_SEARCH_DATABASE(AbstractResource):
    """
        Папка с шардом базы поиска serpapi
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERPAPI_SEARCH_PLAN(AbstractResource):
    """
        План для долбилки с запросами к базовому поиску serpapi
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FIX_QUERIES_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл fix_queries
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INFECTED_SERP_MASKS(AbstractResource):
    """
        infected_serp_masks, SEPE-7377, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CY_HASH(AbstractResource):
    """
        cy.hash, SEPE-7889, SEPE-7325
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ['mixas', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ERF(AbstractResource):
    """
        factordiff (factor statistics monitor) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['severeone']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTORSTATS(AbstractResource):
    """
        factordiff (factor statistics monitor) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['severeone']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTORTAGS(AbstractResource):
    """
        factordiff (factor statistics monitor) related resource
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['severeone']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OPENSSL_SOURCE(AbstractResource):
    """
    Open SSL library source code
    """
    releasable = True
    any_arch = True
    releasers = ["korum", "ashurpin", "yetty"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERF_SOURCE(AbstractResource):
    """
    Serf library source code
    """
    releasable = True
    any_arch = True
    releasers = ["korum", "ashurpin", "yetty"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPILER_DEPENDENCIES_DIFF(AbstractResource):
    """
        ymake-gcc dependencies diff
    """
    uploadable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPILER_DEPENDENCIES_DIFF_RESULT(AbstractResource):
    """
        ymake-gcc dependencies diff result
    """
    uploadable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_FROM_REVIEW_BOARD_RESULT(AbstractResource):
    """
        result of autocheck started from review board
    """
    uploadable = True
    any_arch = True
    share = False
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AUTOCHECK_FROM_REVIEW_BOARD_DIFF(AbstractResource):
    """
        arcadia diff from review board
    """
    uploadable = True
    any_arch = True
    share = False
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWDUMPWORK(AbstractResource):
    """
        Oxygen related resource
    """

    releasable = True
    releasers = ['kostik', 'alexeyche']
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_TRIES(AbstractResource):
    """
        Resource with mirrors.trie and poly.tries from gemini
    """

    releasable = True
    releasers = ['osado', 'alexeyche', 'mcden', 'zagevalo', 'marvelstas']
    executable = False
    any_arch = True
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_UPLOAD_TEST_URL_LIST(AbstractResource):
    """
        URL list for uploaded Kiwi attribute test
    """

    uploadable = True
    any_arch = True
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_UPLOAD_TEST_CONFIGS(AbstractResource):
    """
        Queries for uploaded Kiwi attribute test
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_UPLOAD_TEST_STATIC_DATA(AbstractResource):
    """
        Static data typically downloaded by o2.recipe-downloader
    """
    uploadable = True
    any_arch = True
    releasable = True
    releasers = ['kartynnik', 'qwerty']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_UPLOAD_TEST_MICROSHARD(AbstractResource):
    """
        Microshard built from tested Kiwi uploaded data
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWWORM_DUMP_SPLITTER(AbstractResource):
    """
        A program to split kwworm output based on tuple name prefix
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWWORM_DUMP_MERGER(AbstractResource):
    """
        A program to merge kwworm output
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAH_ENV(AbstractResource):
    """
        environment to run noah server
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NOAH_TEST_OUTPUT_DIFF(AbstractResource):
    """
        Diff of noah test outputs
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BIKE_TEST_OUTPUT_DIFF(AbstractResource):
    """
        Diff of bike test outputs
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COMPARE_PROTOBINS_OUTPUT(AbstractResource):
    """
        Diff of bike test outputs
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_CLIENT(AbstractResource):
    """
        raw unpacked yandex-yt-python package
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_LOCAL(AbstractResource):
    """
        prepared raw binaries and libs for local YT
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_LOCAL_TEST(AbstractResource):
    """
        Demo release
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['alximik', 'ignat']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_NIGHTLY_COMPRESSION_SCRIPTS(AbstractResource):
    """
        Scripts for nightly compression on YT clusters (used by Nanny).
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['asaitgalin', 'ignat']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEVIATION_BINARY(AbstractResource):
    """
        A program to calculate factor changes for two shards
    """
    uploadable = True
    executable = True
    any_arch = False
    releasable = True
    releasers = ['kartynnik', 'qwerty']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEVIATION_INPUT(AbstractResource):
    """
        An idx_ops output preparsed and sorted for DEVIATION_BINARY
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEVIATION_OUTPUT(AbstractResource):
    """
        Results of microshard comparison
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_DYNAMIC_MODELS(AbstractResource):
    """
        MatrixNet dynamic .info models used by basesearch
    """
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_DYNAMIC_MODELS_FOR_SHARD_COMPARISON(BASESEARCH_DYNAMIC_MODELS):
    """
        MatrixNet dynamic .info models used by idx_ops in shard comparison
    """

    releasable = True
    releasers = ['kartynnik', 'qwerty']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_CM_SCRIPTS(AbstractResource):
    """
        Картиночные clustermaster-скрипты для построения индекса и около него
    """
    share = False
    arcadia_path = 'yweb/webscripts/images'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_DOCID_VIEWER(AbstractResource):
    """
        Исполняемый файл для просмотра содержимого inputdoc и metadoc по docid и imageurl
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/viewers/docid_viewer/docid_viewer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_THDB(AbstractResource):
    """
        Исполняемый файл для слияния базы тумбов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/thdb/thdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_INDEXBUILDER(AbstractResource):
    """
       Исполняемый файл для индексации на MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/indexbuilder/main/indexbuilder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_XDELTA(AbstractResource):
    """
       Исполняемый файл. Делает бинарные дельты между картиночными индексами.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'contrib/tools/xdelta3/xdelta3'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_INPUT(AbstractResource):
    """
       Исполняемый файл копирует входные данные
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/input/input'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_INPUTDOC(AbstractResource):
    """
       Исполняемый файл для построения inputdoc
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/inputdoc/inputdoc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_METADOC(AbstractResource):
    """
       Исполняемый файл для построения metadoc
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/metadoc/main/metadoc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_SHARDPREPARER(AbstractResource):
    """
         Исполняемый файл для подготовкки файлов для shardwirter-a
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/shardpreparer/main/shardpreparer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_INDEXDELTA(AbstractResource):
    """
       Исполняемый файл для построение дельт
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/indexdelta/indexdelta'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_INDEXMERGE(AbstractResource):
    """
       Исполняемый файл для слияния дельты с предыдущим индексом для получения нового стейта
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/indexmerge/indexmerge'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_DOCCOUNTER(AbstractResource):
    """
       Исполняемый файл для подсчета документов на шарде.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/doccounter/doccounter'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_NNINDEXER(AbstractResource):
    """
       Исполняемый файл для индексации CBIR.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'cv/sigtools/nnindexer/nnindexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_COPYDOCATTRS(AbstractResource):
    """
       Исполняемый файл для индексации CBIR.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/copydocattrs/copydocattrs'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_DATATRIE(AbstractResource):
    """
       Исполняемый файл для построения траев с данными от антиспама и host status.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/datatrie/datatrie'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_SEMIDUPS(AbstractResource):
    """
       Исполняемый файл для конвертации базы полудублей в подходящий формат.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mksemidupsdb/mksemidupsdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_PLANNER(AbstractResource):
    """
       Исполняемый файл для пересечения баз
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/planner/planner'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_RATEDCONVERT(AbstractResource):
    """
       Исполняемый файл для конвертации файла с урлами документов в файл с бинарными хешами
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/ratedconvert/ratedconvert'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_REMAPINDEX(AbstractResource):
    """
       Исполняемый файл для index remap
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/remapindex/remapindex'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_SELECTIONRANK(AbstractResource):
    """
       Исполняемый файл для selectionrank
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/selectionrank/selectionrank'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_SHARDWRITER(AbstractResource):
    """
       Исполняемый файл для записи шардов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/shardwriter/main/shardwriter'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_TEST_INPUT_FILES(AbstractResource):
    """
        Входные данные для всевозможных автоматических тестов.
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_TEST_CONFIG(AbstractResource):
    """
        Каталог config для картиночного индекса на MR.
        Для всевозможных автоматических тестов.
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_DUMP(AbstractResource):
    """
       Преимущественно текстовый дамп для тасков IMAGES_TEST_MRINDEX. Каталог с несколькими файлами.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_DIFF(AbstractResource):
    """
       Преимущественно текстовый diff для тасков IMAGES_TEST_MRINDEX. Каталог с несколькими файлами.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL(AbstractResource):
    """
       Исполняемый файл для скачивания базы из MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers + ['osol'] + resource_releasers.marty
    release_subscribers = images_mrindex_subscribers + ['osol']
    arcadia_build_path = 'extsearch/images/robot/shard_tool/shard_tool'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CLUSTER_STATE(AbstractResource):
    """
      Состояние кластера shard_tool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers + ['osol'] + resource_releasers.marty
    release_subscribers = images_mrindex_subscribers + ['osol']
    arcadia_build_path = 'extsearch/images/robot/cluster_state/cluster_state'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_EMPTY_INSTALL_SCRIPT(AbstractResource):
    """
        Файл пустого скрипта инсталяции шарда
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/shard_tool/scripts/empty_install.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG(AbstractResource):
    """
        Файл конфига для shard_tool
    """
    releasable = True
    releasers = images_index_releasers + ['osol'] + resource_releasers.marty
    release_subscribers = images_mrindex_subscribers + ['osol']

    arcadia_path = 'extsearch/images/robot/shard_tool/configs/config.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG_IMGSBASE(AbstractResource):
    """
        Файл shard_tool конфига для большой картиночной базы
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/configs/shard_tool/imgsbase.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG_IMGSCBR(AbstractResource):
    """
        Файл shard_tool конфига для большой картиночной сибири
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/configs/shard_tool/imgscbr.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG_IMGSRIM(AbstractResource):
    """
        Файл shard_tool конфига для RIM базы
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/configs/shard_tool/imgsrim.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG_IMGS_COMMERCIAL_DATA(AbstractResource):
    """
        Файл shard_tool конфига для картиночных коммерческих данных
    """
    releasable = True
    releasers = ['anoh', 'shashkin']
    release_subscribers = ['images-releases']

    arcadia_path = 'extsearch/images/robot/index/configs/shard_tool/imgscd.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARDTOOL_CONFIG_IMGSTH(AbstractResource):
    """
        Файл shard_tool конфига для большой картиночных тумбов
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/configs/shard_tool/imgsth.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_IMTUB_INSTALL_SCRIPT(AbstractResource):
    """
        Файл скрипта инсталяции быстрых шардов имтубов
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/fast-imtub-install.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_IMTUB_INSTALL_SCRIPT(AbstractResource):
    """
        Файл скрипта инсталяции больших шардов имтубов
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-imtub-install.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FULL_IMTUB_INSTALL_SCRIPT(AbstractResource):
    """
        Файл скрипта инсталяции полных шардов имтубов
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/full-imtub-install.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_IMTUB_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда быстрых тумбов (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/fast-imtub-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SHARD_UNINSTALL_SCRIPT(AbstractResource):
    """
        Файл скрипта деинсталляции шарда картиночных поисковых баз
    """
    releasable = True
    readable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/shard-uninstall.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_INSTALL_SCRIPT(AbstractResource):
    """
        Файл скрипта инсталяции индекса (слияния дельты)
    """
    releasable = True
    readable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-index-install.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда большого индекса (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-index-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_META_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда среднего метапоиска (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-meta-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_CBIR_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда быстрой сибири (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/fast-cbir-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда быстрого индекса (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/fast-index-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_IMTUB_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда больших тумбов (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-imtub-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_CBIR_SHARD_BUILDER(AbstractResource):
    """
        Создание шарда большой сибири (скачивание с MR, копирование файлов)
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers

    arcadia_path = 'extsearch/images/robot/index/scripts/index-download/main-cbir-shard-builder.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_IMTUB_DOWNLOAD(AbstractResource):
    """
        Создание шарда быстрых тумбов (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/fast_imtub/fast_imtub_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_DOWNLOAD(AbstractResource):
    """
        Создание шарда большого индекса (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_index/main_index_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_META_DOWNLOAD(AbstractResource):
    """
        Создание шарда среднего метапоиска (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_mmeta/main_mmeta_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_CBIR_DOWNLOAD(AbstractResource):
    """
        Создание шарда быстрой сибири (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/fast_cbir/fast_cbir_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_DOWNLOAD(AbstractResource):
    """
        Создание шарда быстрого индекса (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/fast_index/fast_index_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_IMTUB_DOWNLOAD(AbstractResource):
    """
        Создание шарда больших тумбов (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_imtub/main_imtub_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_CBIR_DOWNLOAD(AbstractResource):
    """
        Создание шарда большой сибири (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_cbir/main_cbir_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_RIM_DOWNLOAD(AbstractResource):
    """
        Создание шарда RIM (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_rim/main_rim_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_COMMERCIAL_DATA_DOWNLOAD(AbstractResource):
    """
        Создание шарда коммерческих данных (скачивание с MR, копирование файлов)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['anoh', 'shashkin']
    release_subscribers = ['images-releases']
    arcadia_build_path = 'extsearch/images/robot/index/index_download/main_commercial_data/main_commercial_data_download'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_STATISTICS(AbstractResource):
    """
       Исполняемый файл для подсчета статистики по индексу.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/statistics/main/statistics'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_FACTORDIFF(AbstractResource):
    """
       Исполняемый файл для подсчета диффа факторов по индексу.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/factordiff/factordiff'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_TRACEROUTE(AbstractResource):
    """
       Исполняемый файл для подсчета потерь качества на разных стадиях построения индекса.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/traceroute/traceroute'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_CBIR(AbstractResource):
    """
       Исполняемый файл для подготовки данных для CBIR.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/cbir/main/cbir'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_CBIR_INDEXER(AbstractResource):
    """
       Исполняемый файл для подготовки индекса CBIR.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/cbir_indexer/main/cbir_indexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_IMGTRIEBUILDER(AbstractResource):
    """
       Исполняемый файл для построения tries с данными от антиспама.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/imgtriebuilder/imgtriebuilder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_IDXTHUMB(AbstractResource):
    """
       Исполняемый файл для подготовки тумбов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/imtub/idxthumb/idxthumb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_MKIMTUB_TAAS(AbstractResource):
    """
       Исполняемый файл для подготовки тумбов TaaS.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/imtub/mkimtub_taas/mkimtub_taas'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_TAAS_MKTHDB(AbstractResource):
    """
       Исполняемый файл для работы с базой тумбов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mkthdb/mkthdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_TAAS_CRAWLER(AbstractResource):
    """
       Исполняемый файл для прокачки тумбов по урлам.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/crawler/taas_crawler/taas_crawler'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_EXPORT2UKROP(AbstractResource):
    """
       Исполняемый файл для экспорта урлов из индекса в укроп.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/export2ukrop/export2ukrop'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_FEEDBACK(AbstractResource):
    """
       Исполняемый файл для логирования стейтов урлов, которые попали в индекс.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/feedback/feedback'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_TAAS_BACKOFFICE(AbstractResource):
    """
       Исполняемый файл бэкофиса TaaS.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/backoffice/taas_backoffice'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_TAAS_CLIENT(AbstractResource):
    """
       Исполняемый файл клиентская утилита TaaS.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/client/taascl'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_ADMIN(AbstractResource):
    """
       Исполняемый файл - админская утилита для управления регистрацией в TaaS.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/admin/taas_admin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DAEMON(AbstractResource):
    """
       Исполняемый файл TaaS-демон выполняющий задачи по загрузке/удалению тумбов из аватарницы.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/daemon/taas_daemon'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_SERVICE(AbstractResource):
    """
       Исполняемый файл вспомогательная серверная утилита TaaS.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/service/taas_service'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DAEMON_CONFIG(AbstractResource):
    """
        Файл конфига для taas_daemon
    """
    releasable = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers

    arcadia_path = 'extsearch/images/robot/taas/daemon/configs/config.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DASHBOARD(AbstractResource):
    """
        Исполняемый файл дашборда задач TaaS
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_build_path = 'extsearch/images/robot/taas/dashboard/taas_dashboard'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DASHBOARD_CONFIG(AbstractResource):
    """
        Файл конфига taas_dashboard
    """
    releasable = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_path = 'extsearch/images/robot/taas/dashboard/configs/config.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DASHBOARDS_TEMPLATES(AbstractResource):
    """
        Jinja2 шаблоны taas_dashboard
    """
    releasable = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_path = 'extsearch/images/robot/taas/dashboard/templates'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAAS_DASHBOARDS_STATIC_RESOURCES(AbstractResource):
    """
       Статические ресурсы taas_dashboard
    """
    releasable = True
    releasers = images_taas_releasers
    release_subscribers = images_taas_subscribers
    arcadia_path = 'extsearch/images/robot/taas/dashboard/static'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_USERDB_USERSESSIONS(AbstractResource):
    """
        Исполняемый файл для парсинга дневных сессий.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/sessionparser/sessionparser'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_USERDB_MERGESTATE(AbstractResource):
    """
        Исполняемый файл для агрегации дневных сессий.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/mergestate/main/mergestate'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_USERDB_FASTLOGSPARSER(AbstractResource):
    """
        Исполняемый файл для парсинга быстрых сессий.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/fastlogsparser/main/fastlogsparser'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_USERDATA_STATISTICS(AbstractResource):
    """
        Исполняемый файл для статистики дневных сессий.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/statistics/statistics'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_USERDATA_CONVERTER(AbstractResource):
    """
        Исполняемый файл для статистики дневных сессий.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/userdb_converter/userdb_converter'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_USERFACTORS(AbstractResource):
    """
        Исполняемый файл для построения пользовательских факторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/userfactors2/main/userfactors2'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_ANNDATA(AbstractResource):
    """
        Исполняемый файл для построения аннотационных факторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/anndata/main/anndata'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_CLICKSIM(AbstractResource):
    """
        Исполняемый файл для построения click similarity векторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/click_sim/main/click_sim'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_STREAMS(AbstractResource):
    """
        Исполняемый файл для аггрегации пользовательских данных.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/streams/streams'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_MOBILENESS(AbstractResource):
    """
        Исполняемый файл для базы мобильности картиночных страниц.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/mobileness/mobileness'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_BIGTHUMBS(AbstractResource):
    """
        Исполняемый файл для базы факторов больших тумбов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/bigthumbs/bigthumbs'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_HOSTFACTORS(AbstractResource):
    """
        Исполняемый файл для построения хостовых факторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/hostfactors/hostfactors'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_PAGEFACTORS(AbstractResource):
    """
        Исполняемый файл для построения страничных факторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/pagefactors/pagefactors'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FACTORS_TOLOKA_TOP_REQUESTS(AbstractResource):
    """
        Исполняемый файл для построения страничных факторов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/toloka_top_requests/toloka_top_requests'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_USERDOC(AbstractResource):
    """
        Исполняемый файл для построения userdoc для индекса.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/userdoc/userdoc'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_USERTRIE(AbstractResource):
    """
        Исполняемый файл для построения usertrie для индекса.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/usertrie/usertrie'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_PORNOBAN(AbstractResource):
    """
        Исполняемый файл для построения стейта бана.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/pornoban/pornoban'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_CLEANUP(AbstractResource):
    """
        Исполняемый файл для очистки баз.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/cleanup/cleanup'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_ID2URL(AbstractResource):
    """
        Исполняемый файл для построения таблицы соответсвия id к урлам.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/id2url/id2url'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_STATISTICS_PRETTY_PRINT(AbstractResource):
    """
       Питоновский скрипт для вывода статистики
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/index/statistics/pretty_print.py'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_SPOK_SHARE(AbstractResource):
    """
       Питоновский скрипт для публикации статистики SPOK-а
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_path = 'extsearch/images/robot/index/statistics/statface/SPOK_share.py'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_RATEDINDEX(AbstractResource):
    """
       Исполняемый файл для построения индекса из оцененных документов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/index/ratedindex/ratedindex'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_IDXCONVERT(AbstractResource):
    """
       Исполняемый файл для построения пантерных индексных файлов indexpanther
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'search/panther/tools/idx_convert/idx_convert'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MRDB_HOSTDB(AbstractResource):
    """
       Исполняемый файл для построения базы хостов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/hostdb/mkhostdb/mkhostdb'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MRDB_BAN404(AbstractResource):
    """
       Исполняемый файл для обновления базы бана 404х урлов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/ban404/ban404'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MRDB_BADCLICKS(AbstractResource):
    """
       Исполняемый файл для обновления базы бана плохих кликов
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/tools/badclicks/badclicks'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_ROTATE(AbstractResource):
    """
       Исполняемый файл для ротации стейтов индекса на MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/indexrotate/indexrotate'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MRDB_NASTY_IMAGES(AbstractResource):
    """
       Исполняемый файл для построения факторов бана жести
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'yweb/antiporno/nastyimage/ni_build/ni_build'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_TABLE(AbstractResource):
    """
        Файл с таблицей скачанной с MapReduce в формате с subkey и lenval
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_BUNDLE(AbstractResource):
    """
       Базовый класс бандла для бинарей картинок
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SEARCH_BASE_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания большого картиночного индекса
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_IMTUB_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания больших картиночных имтубов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_META_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания шарда среднего метапоиска
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_CBIR_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания шарда большой сибири
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания быстрого картиночного индекса
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_IMTUB_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания быстрых картиночных имтубов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_CBIR_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для скачивания шарда быстрой сибири
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для построения большого картиночного индекса
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл для построения быстрого картиночного индекса
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_ULTRA_INDEX_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл с mrindex конфигом для ультры
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_COMMERCIAL_DATA_DEPLOY_BUNDLE(IMAGES_BUNDLE):
    """
       Бандл картиночных коммерческих данных
    """
    releasers = ['anoh', 'shashkin', 'evseevd', 'wwfq']
    release_subscribers = ['images-releases', 'evseevd']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_MODEL(AbstractResource):
    """
        Yane matrixnet model
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_POOL(AbstractResource):
    """
        Yane matrixnet pool
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_DATA(AbstractResource):
    """
        Data for dict/nerlib.
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_TOOLS(AbstractResource):
    """
        Collection of Yane tools
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_TSV(AbstractResource):
    """
        File in tsv-format, which is used to learn or calc quality of Yane
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_CONFIG(AbstractResource):
    """
        Yane configuration file for data preparation. Python dict format
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANE_MARKUP_DIFF_XLS(AbstractResource):
    """
        Yane diff in markup and classification
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGO_DB_DUMP(AbstractResource):
    """
        Dump of mongodb created with mongodump
    """
    readabale = False
    realeaseable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SNAPPY_LIBRARY(AbstractResource):
    """
        snappy library and dev files
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['antix', 'noiseless', 'qwizzy', 'squirrel', 'sivanichkin', 'basic']
    release_subscribers = ['golovan-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FFI_LIBRARY(AbstractResource):
    """
        ffi library and dev files
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MYSQLCLIENT_LIBRARY(AbstractResource):
    """
        mysqlclient library and dev files
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MYSQLSERVER_PACKAGE(AbstractResource):
    """
        mysql server package
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGO_PACKAGE(AbstractResource):
    """
        mongo package
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel', 'azee']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGO_TOOLS_ARCHIVE(AbstractResource):
    """
        Mongo tools archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGODUMP_BINARY(AbstractResource):
    """
        mongodump binary
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGO_SHARD(AbstractResource):
    """
        mongo package shard
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OPENSSL_LIBRARY(AbstractResource):
    """
        openssl library and dev files
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['dldmitry', 'noiseless', 'qwizzy', 'squirrel']
    release_subscribers = ['juggler-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LIBRA_LIBRARY(AbstractResource):
    """
        libra.so library
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['vdmit', 'lucius']
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BLOCKSTAT_DICT(AbstractResource):
    """
        blockstat.dict file
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['vdmit', 'lucius']
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UATRAITS_BROWSER_XML(AbstractResource):
    """
        uatraits browser.xml file
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['vdmit', 'lucius', 'k900']
    release_subscribers = None


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_BLOCKSTAT_DICT(AbstractResource):
    """
        Yet another blockstat.dict
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_DEV(AbstractResource):
    """
        python-dev files
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = ['antix', 'noiseless']
    release_subscribers = ['golovan-dev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NGINX_BINARY(AbstractResource):
    """
        Nginx static binary.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['noiseless', 'qwizzy', 'squirrel', 'ekilimchuk', 'sivanichkin', 'basic', 'dldmitry']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REDIS_PACKAGE(AbstractResource):
    """
        Redis binary package.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['noiseless', 'qwizzy', 'squirrel', 'ekilimchuk', 'sivanichkin', 'basic', 'dldmitry']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZLIB_SOURCE(AbstractResource):
    """
        Исходные коды zlib
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['antix', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PCRE_SOURCE(AbstractResource):
    """
        Исходные коды pcre
    """
    releasable = False
    any_arch = True
    auto_backup = True
    executable = False
    releasers = ['antix', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGODB_UTILS(AbstractResource):
    """
        staticly linked mongo utils (like mongodump, mongorestore)
    """
    releasable = False
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PORTABLE_PYPY(AbstractResource):
    """
        Portable PyPy
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_REQUESTS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл test_requests
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARDS_DIFF(AbstractResource):
    """
        Diff between two Oxygen shards
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD(AbstractResource):
    """
        Oxygen shard with document and host index
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIWIBRANCHES(AbstractResource):
    """
        build executable for giwibranches
    """
    uploadable = True
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['kolesov93', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TEST_HOST_LIST(AbstractResource):
    """
        HOST list for GetHerf test
    """
    uploadable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KW_GET_HERF_DUMP(AbstractResource):
    """
        Dump for GetHerfTest
    """
    any_arch = True
    auto_backup = True
    releasers = ['plekhova', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_SHARD(AbstractResource):
    """
        Java JDK shard built from original sources
    """
    shard = True
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['librarian', 'schizophrenia']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_ARCHIVE(AbstractResource):
    """
        Java JDK archive from official site
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['librarian', 'schizophrenia']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_COLLECT_BAD_URLS_LISTS(AbstractResource):
    """
        Collected urls lists for each trigger and branch
    """
    uploadable = True
    any_arch = True
    releasers = ['cmogilko', 'attach', 'alexeyche']
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_COLLECT_BAD_URLS_LEVELDB_BINARY(AbstractResource):
    """
        Leveldb binary so file
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['cmogilko', 'attach', 'alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_COLLECT_BAD_URLS_DB(AbstractResource):
    """
        Levedb database for collected urls
    """
    uploadable = True
    any_arch = True
    releasers = ['cmogilko', 'attach', 'alexeyche']
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_COLLECT_BAD_URLS_HOSTS(AbstractResource):
    """
        Kiwi hosts list
    """
    uploadable = True
    any_arch = True
    releasers = ['cmogilko', 'attach', 'alexeyche']
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHOOT_LOG_PREPARE(AbstractResource):
    """
        Препарат логов для обстрела SERP-25506 .
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_REPORT_PERFORMANCE_CACHE(AbstractResource):
    """
        Кеш запросов к репортудля обстрела SERP-25506 .
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SAMPLE_POOL_EXECUTABLE(AbstractResource):
    """
        mr_sample_pool, see BUKI-2265
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/relev_tools/mr_sample_pool/mr_sample_pool'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_FILTER_BY_POOL_EXECUTABLE(AbstractResource):
    """
        Downsample anything with query/url/region keys to contain only data relevant to pool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/relev_tools/mr_filter_by_pool/mr_filter_by_pool'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_SAMPLE_MIRRORS_EXECUTABLE(AbstractResource):
    """
        mr_sample_mirrors, see BUKI-2265
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'robot/mirror/mr_sample_mirrors/mr_sample_mirrors'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRINTKEYS_EXECUTABLE(AbstractResource):
    """
        printkeys
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'tools/printkeys/printkeys'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_RUNTIME(AbstractResource):
    """
        ontodb runtime virtualenv tgz
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    shard = True
    releasers = ['denisbykov', 'belalex', 'nataxane', 'sokirko']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_ROBOT(AbstractResource):
    """
        OntoDB robot files
    """
    releasable = True
    any_arch = False
    releasers = [
        'phil-grab',
        'konovodov',
        'robot-ontodb',
        'yourmary',
        'alzobnin',
        'evgen',
        'ivansukharev',
    ]
    release_subscribers = releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_FIXES_VIEWER(AbstractResource):
    """
        ontodbfixes virtualenv tgz
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    shard = True
    releasers = ['denisbykov', 'belalex', 'nataxane', 'sokirko']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_CLARINET(AbstractResource):
    """
        clarinet virtualenv tgz
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['denisbykov', 'belalex', 'nataxane', 'daflight']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_CLARINET_CRCA(AbstractResource):
    """
        Offline CRCA binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['denisbykov', 'belalex', 'nataxane', 'daflight']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_CARDS_MAIN_DELTA(AbstractResource):
    """
        ontodb cards snapshot (main_delta minibase)
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['denisbykov', 'belalex', 'sokirko']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONTODB_CARDS_PATCH(AbstractResource):
    """
        diff cards for running patched beta
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['nataxane']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_TABLES_ARCHIVE(AbstractResource):
    """
        Sampled tables of userdata state
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_TABLES_DIFF_DESCR(AbstractResource):
    """
        Text dumps of userdata diff between two runs
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_INDEX_FRAGMENT(AbstractResource):
    """
        Some files produced by userdata_prep
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERDATA_INDEX_FRAGMENT_DIFF_DESCR(AbstractResource):
    """
        List of files that differ in two USERDATA_INDEX_FRAGMENT-s
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROJECT_SOURCES_PACKAGE(AbstractResource):
    """
       Create package with sources
    """
    any_arch = True
    auto_backup = True
    calc_md5 = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KWDUMPWORK_INPUT_DATA_AND_CONFIGS(AbstractResource):
    """
        Oxygen microshard dump and config files for kwdumpwork
    """
    uploadable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVLAB_DATA(AbstractResource):
    """
        Computer vision datasets, trained models, etc...
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVLAB_MODEL(AbstractResource):
    """
        Trained neural network models
    """
    auto_backup = True
    # restart_policy = ctr.RestartPolicy.IGNORE  # TODO: Dropped temporary till upload fix.


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_SLOVARI_OSP_BIN_DEB(AbstractResource):
    """
        yandex-slovari-osp-bin.deb package
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = False
    calc_md5 = True
    deprecated = False
    restart_policy = ctr.RestartPolicy.RESET
    releasers = ['tsyplenkov', 'glepha']
    release_subscribers = ['tsyplenkov', 'glepha', 'pavlyuklp']
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_SLOVARI_OSP_BIN_CHANGES(AbstractResource):
    """
        yandex-slovari-osp-bin.changes file
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = False
    calc_md5 = True
    deprecated = False
    restart_policy = ctr.RestartPolicy.RESET
    releasers = ['tsyplenkov', 'glepha']
    release_subscribers = ['tsyplenkov', 'glepha', 'pavlyuklp']
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OPENSSL_EXECUTABLE(AbstractResource):
    """
       openssl binary
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD_PRINTERS(AbstractResource):
    """
        Oxygen shard printers to print diff
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EVLOG2STATS_EXECUTABLE(AbstractResource):
    """
    Конвертер из eventlog'a в csv сигналы для yasm
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = [
        'gavrilovp',
        'petrk',
        'stakanviski',
        'galaxycrab',
        'radix',
        'koplyarov',
        'rufrozen',
        'deep',
        'kamchii',
        'pazdnikov',
        'fyodor',
        'grand',
        'qqq',
        'vladon',
        'algolix',
        'alborisov',
        'yazevnul',
        'juliana-zh',
        'lpshka',
        'ustas',
        'maxim98',
        'savvdm',
        'mvel',  # anti-disaster mode
    ] + resource_releasers.fastres2_releasers
    arcadia_build_path = 'extsearch/wizards/core/tools/evlog2stat/evlog2stat'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_TV_CFG_STATICS(AbstractResource):
    """
        Конфиг со статикой для прослойки тв сниппета.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_TV_CFG_FACTORS(AbstractResource):
    """
        Конфиг с опциями SAAS &calc= для прослойки тв сниппета.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_TV_DATA_REGIONS(AbstractResource):
    """
        Данные/конфиг с цепочками регионов для прослойки тв сниппета.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_WEATHER_TRANSLATIONS(AbstractResource):
    """
        JSON с переводами для WeatherProxyWizard (в няню)
    """
    auto_backup = True
    releasable = True
    releasers = ['petrk']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_CANON_ANSWERS(AbstractResource):
    """
        Ресурс с каноническими ответами источников для тестов диффов
        Генерится бинарником canon
    """
    releasable = True
    releasers = ['petrk', 'algolix', 'pazdnikov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_ANSWERS(AbstractResource):
    """
        Ресурс с ответами бинарников проксей
    """
    releasable = True
    releasers = ['petrk', 'algolix', 'pazdnikov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_TANK(AbstractResource):
    """
    `.tar.gz` archive with Yandex.Tank source code
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEW_YANDEX_TANK(AbstractResource):
    """
    `.tar.gz` archive with Yandex.Tank source code
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_TANK_BINARY(AbstractResource):
    """
    `tar.gz` with binaries of `phantom` entry to use in YANDEX_TANK
    """
    any_arch = False
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_TANK_MONITORING_CONFIG(AbstractResource):
    """
    Custom config with monitoring settings for Yandex.Tank
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_TANK_LOAD_CONFIG(AbstractResource):
    """
    Custom config for Yandex.Tank
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SCHEDULER(AbstractResource):
    """
        Oxygen scheduler resource
    """

    releasable = True
    releasers = ['spacelord', 'severeone']
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SCHEDULER_CONFIG(AbstractResource):
    """
        Config files for Oxygen scheduler
    """
    uploadable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD_MAP(AbstractResource):
    """
        Oxygen shard map
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD_MAPS_DIFF(AbstractResource):
    """
        Diff between two Oxygen shard maps
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOKEEPER_POM_XML(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['librarian', 'schizophrenia', 'alximik', 'noiseless', 'nekto0n', 'alonger', 'romanovich']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZOOKEEPER_BINARY(AbstractResource):
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['librarian', 'schizophrenia', 'alximik', 'noiseless', 'nekto0n', 'alonger', 'romanovich']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FORMULA_DEVIATION_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл deviation-mr
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_ENVIRONMENT_UI(AbstractResource):
    """
        Собранный новый gui Test Environment.
    """
    auto_backup = True
    releasable = True
    releasers = ['alexeykruglov', 'deniskuzin', 'evilj0e', 'blackheart']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOLOMON_JSON_STAT_PUSH(AbstractResource):
    """
        JSON files with pushed statistics
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERCONA_XTRABACKUP(AbstractResource):
    """
        Percona xtrabackup
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['noiseless', 'qwizzy', 'squirrel', 'ekilimchuk', 'sivanichkin', 'basic']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERCONA_XTRADB_CLUSTER(AbstractResource):
    """
        Percona xtradb cluster
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['noiseless', 'qwizzy', 'squirrel', 'ekilimchuk', 'sivanichkin', 'basic']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERF_KIWI_TRIGGERS_CANONICAL(AbstractResource):
    """
        JSON files with exports based perf kiwi triggers canonical results
    """
    auto_backup = True
    ttl = 365


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERF_KIWI_TRIGGERS_CANONICAL_USUAL(AbstractResource):
    """
        JSON files with usual perf kiwi triggers canonical results
    """
    auto_backup = True
    ttl = 365


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERF_KIWI_TRIGGERS_REPORT(AbstractResource):
    """
        file with perf kiwi triggers report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COVERAGE_KIWI_TRIGGERS_REPORT(AbstractResource):
    """
        file with coverage kiwi triggers report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KIWI_TRIGGERS_REPORT(AbstractResource):
    """
        file with perf kiwi triggers report
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_MICROSHARD_DUMP(AbstractResource):
    """
        Oxygen microshard dump (document and host)
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STAT_OF_KIWI_PLAN(AbstractResource):
    """
        statistics gathered from kiwi hen plan in json
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BIATHLON_PROXY_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл прослойки для колдунщика Биатлона
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = False
    releasers = sport_wizard_releasers
    release_subscribers = sport_wizard_releasers
    ttl = 180


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_WIZARD_DATA(AbstractResource):
    """
        Файл c данными о спортивных событиях для прослойки спортивных колдунщиков
    """

    auto_backup = True
    releasable = True
    releasers = ['atsepeleva', 'ustas', 'sandbox', 'robot-freshness', 'robot-srch-verticals']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_WIZARD_DEVICE_IDS_DATA(AbstractResource):
    """
        Файл c данными о мобильных device_id (для генерации спортивных пуш-уведомлений)
    """

    auto_backup = True
    releasable = True
    releasers = ['ustas', 'sandbox', 'robot-freshness']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_WIZARD_OLYMP_PERSONS(AbstractResource):
    """
        Файл c данными о спортсменах для Олимпиады
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_PUSH_API(AbstractResource):
    """
        Web-приложение, реализующее api для генерации пушей спортивных событий
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['ustas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_PUSHES_SENT_LOG(AbstractResource):
    """
        Лог отправки спортивных пушей
    """
    auto_backup = True
    releasable = True
    releasers = ['ustas']
    ttl = 60


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FIVE_PUSHES_SENT_LOG(AbstractResource):
    """
        Лог отправки пушей для проекта "Дай пять"
    """
    readable = True
    auto_backup = True
    releasable = True
    releasers = ['ustas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class READAHEAD_EXECUTABLE(AbstractResource):
    """
        Python script for setting correct readahead
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['kimkim', 'osol']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_ERFDATA(AbstractResource):
    """
        Files from ya host:
        /Berkanavt/erfdata and /Berkanavt/userdata/lowfreqwords.trie
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONOTOLE_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл onotole
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONOTOLE3_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл onotole3
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POOL_URLS_HELPER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл pool_urls_helper
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TV_SNIP_DATA_BUILD_CLASS_DATE_TGZ(AbstractResource):
    """
        Class::Date for mr sideloading
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TV_SNIP_DATA_BUILD_GMAKE(AbstractResource):
    """
        gmake-3.81 for tv snip data building
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TV_SNIP_DATA_BUILD_GMAKE_SOURCES(AbstractResource):
    """
        gmake-3.81 sources for tv snip data building
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TV_SNIP_DATA_BUILD_GEOBASE_PM(AbstractResource):
    """
        http://geobase.yandex.ru/geobase.pm for tv snip data building
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['petrk', 'noiseless']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_BASE(AbstractResource):
    """
        Oxygen base built by o2 package
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['zagevalo', 'alexeyche', 'mcden']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_LOCAL_BINARIES(AbstractResource):
    """
        Oxygen binaries for local use
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_LOCAL_TOOLS(AbstractResource):
    """
        Oxygen tooles for local use
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_WEB_BOT_JSON_REPORT(AbstractResource):
    """
       Results of running upper logs tests web bot in json format.
    """
    auto_backup = True
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_WEB_BOT_HTML_SEARCH_RESPONSE(AbstractResource):
    """
        HTML search response of upper logs tests (single test case).
    """
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_OUTPUT(AbstractResource):
    """
        Results of running upper_logs_tests tool.
    """
    auto_backup = True
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_HTML_REPORT(AbstractResource):
    """
        Resuls of running upper_logs_tests tool in human-readable (html) format.
    """
    auto_backup = True
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_CONFIG(AbstractResource):
    """
        Конфиг для прокси колдунщиков
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_PLAIN_QUERIES(AbstractResource):
    """
        Запросы для тестов прокси колдунщиков в виде списка url к проксе
        без указания хоста и порта, но с указанием коллекции: /yandsearch?...
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_RESPONSES_COMPARE_RESULT(BASESEARCH_RESPONSES_COMPARE_RESULT):
    """
        Результат сравнения двух выдач proxy wizard'a
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROXY_WIZARD_RESPONSES_RESULT(AbstractResource):
    """
        Результат сравнения двух выдач proxy wizard'a
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_CONFIG(AbstractResource):
    """
        Файл конфигурации экспериментов
    """
    auto_backup = True
    releasable = True
    releasers = ['robot-eksperimentus',
                 'valgushev',
                 'rkam',
                 'buryakov',
                 ] + resource_releasers.marty
    release_subscribers = ['valgushev', 'rkam', 'samhan', 'buryakov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_CONFIG_SINK(AbstractResource):
    """
        Файл конфигурации экспериментов для тестинга
    """
    auto_backup = True
    releasable = True
    releasers = ['robot-eksperimentus',
                 'valgushev',
                 'rkam',
                 ] + resource_releasers.marty
    release_subscribers = ['valgushev', 'rkam', 'samhan', 'buryakov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_USER_LOG(AbstractResource):
    """
        File containing part of a user log.
    """
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPPER_LOGS_TESTS_EXECUTABLE(AbstractResource):
    """
        upper_logs_tests
    """
    auto_backup = True
    any_arch = False
    executable = True
    releasers = ['yuliy']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class METRICS_LAUNCH_DIFF(AbstractResource):
    """
        Директория с результатами тестирования metrics launch
    """
    calc_md5 = False
    any_arch = True
    executable = False
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class XML_SEARCH_DIFF(AbstractResource):
    """
        HTML с результатами тестирования xml поиска
    """
    calc_md5 = False
    any_arch = True
    executable = False
    auto_backup = True
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GALERA_LOAD_BALANCER(AbstractResource):
    """
        Galera Load Balancer
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['noiseless', 'qwizzy', 'squirrel', 'ekilimchuk', 'sivanichkin', 'basic']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODB_BUILDER_EXECUTABLE(AbstractResource):
    """
        Бинарник для GeoDB билдера (для релиза данных для kernel/geodb)
    """
    releasable = False
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODB_DATA(AbstractResource):
    """
        kernel/geodb data
    """
    auto_backup = True
    releasable = True
    releasers = ['petrk', 'yourmary', 'ustas', 'alpustovalova', 'ityrov', 'robot-srch-verticals']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HEARTBEAT_SERVER(AbstractResource):
    """
        Образ heartbeat_server
    """
    releasable = True
    releasers = ['ekilimchuk', 'marchhare', 'sivanichkin', 'oplachkin', 'torkve', 'mocksoul']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERSONALSEARCH_SERVER(AbstractResource):
    """
        Образ personalsearch_server
    """
    releasable = True
    releasers = ['okkk', 'tabolin', 'dpotapov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HEARTBEAT_UI(AbstractResource):
    """
        Образ heartbeat_ui
    """
    releasable = True
    releasers = ['ekilimchuk', 'marchhare', 'sivanichkin', 'oplachkin', 'torkve', 'mocksoul']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_BASES_DIFF(AbstractResource):
    """
        Diff between two Oxygen bases
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOPHOS_DEB_PACKAGE(AbstractResource):
    """
        Deb пакет с антивирусным движком sophos'a
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOPHOS_VIRUS_DIR(AbstractResource):
    """
        папка с частично завирусованными файлами для тестирования на ней производительности движка sophos
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_CONFIG(AbstractResource):
    """
        Oxygen config file
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REALFEED_DATA(AbstractResource):
    """
        Resource to store files data from realfeed01 machine.
        Files:
            exportrank.info, tr_exportrank.info
            j-owners-spm.lst
            clon.h2g.trie.idx, clon.h2g.trie.dat
            spl-grp.cfg
            2ld.list
            j-owners-spm.lst
            ungrouped.list,
            wordwht.trie
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_CATALOG(AbstractResource):
    """
        Oxygen catalog data
    """
    any_arch = True
    releasable = True
    releasers = ['severeone', 'kartynnik']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SHARD_STATIC_DATA(AbstractResource):
    """
        Oxygen shard static data
    """
    any_arch = True
    releasable = True
    releasers = ['severeone', 'kartynnik']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIWIKEY(AbstractResource):
    """
        Oxygen related resource
    """

    releasable = True
    releasers = ['severeone', 'kostik', 'ermolovd', 'osado']
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTORSTATS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл factorstats
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_BASE_BACKGROUND(AbstractResource):
    """
        Oxygen base build folder
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOBASE3_SNAPSHOT(AbstractResource):
    """
        Снепшот для геобазы, версия 3
        В случае чего писать на rcss-admin@
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNITSCONVERTER_INDEXFAST(AbstractResource):
    """
        Быстрый индекс для конвертора валют currency.txt
        В случае чего писать на rcss-admin@
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_PERSONAL_REDISBACKUP(AbstractResource):
    """
        Бекап редиса.
        Принадлежность к шарду хранится в аттрибуте redis_shard.
        Владелец: bykanov@
    """
    releasable = False
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MYSQL_BACKUP(AbstractResource):
    """
        Бекап новостных баз в поисковом облаке
        владелец: feliksas@
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MONGO_BACKUP(AbstractResource):
    """
        Бекап новостных баз в поисковом облаке
        владелец: feliksas@
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEMIEMPTY_DIRECTORY(AbstractResource):
    """
        Директория с пустым файлом.
        В нее можно писать данные, и iss не будет ее удалять.
        В случае чего писать на rcss-admin@
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BLENDER_FML_CONFIG_PATCHER_SCRIPT(AbstractResource):
    """
        Script to modify search/web/rearrs_upper/rearrange.dynamic/blender/fml_config.json
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXP_MR_EXECUTABLE(AbstractResource):
    """
        Experiments adminka project archive
    """
    releasable = False
    executable = True
    auto_backup = False
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['samhan']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXP_MR_SERVER(AbstractResource):
    """
        Experiments adminka project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['samhan', 'valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXP_MR_SERVER_SHARD(AbstractResource):
    """
        Experiments adminka shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['samhan', 'valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_ADMINKA(AbstractResource):
    """
        Experiments adminka project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_ADMINKA_UTILS_GEO(AbstractResource):
    """
        Experiments adminka util for geo
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_ADMINKA_UTILS_SQUEEZE(AbstractResource):
    """
        Experiments adminka squeeze_geobase.py
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_ADMINKA_ENV(AbstractResource):
    """
        Experiments adminka virtualenv
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENTS_ADMINKA_GEO(AbstractResource):
    """
        Geo-extract for experiments adminka
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SWITCH_ADMINKA(AbstractResource):
    """
        Switch adminka project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['myltsev']
    release_subscribers = ['myltsev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SWITCH_ADMINKA_SHARD(AbstractResource):
    """
        Switch adminka shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['myltsev']
    release_subscribers = ['myltsev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONSYS_CODE(AbstractResource):
    """
        Архив с кодом monsys (система анализа данных и принятия решений)
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['kfour', 'teamcity', 'robot-maestro']
    release_subscribers = ['kfour']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONSYS_VIRTUAL_ENVIRONMENT(AbstractResource):
    """
        Виртуальное окружение python (virtualenv) для запуска monsys
    """
    shard = True
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['kfour', 'teamcity', 'robot-maestro']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONSYS_VIRTUAL_ENVIRONMENT_ARCHIVE(AbstractResource):
    """
        Архив с виртуальным окружением python (virtualenv) для запуска monsys
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = [
        'kfour',
        'robot-maestro',
    ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONSYS_CONFIGURATION(AbstractResource):
    """
        Конфигурационный файл monsys.
        Вынесен в отдельный ресурс для независимой выгрузки в производство конфигураций и кода.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['kfour', 'teamcity', 'robot-maestro']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GET_LAST_RESOURCE_SCRIPT(AbstractResource):
    """
        Скрипт для получения последнего релизного ресурса указанного типа в папку инстанса (автор - @bykanov)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['bykanov', 'amich', 'xpahos', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PREPARE_ARCANAVT_SCRIPT(AbstractResource):
    """
        Скрипт для создания папки arkanavt при настройке репорта-апача-верхнего
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['amich', 'xpahos', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENERATE_APACHE_HTTPD_CONF_SCRIPT(AbstractResource):
    """
        Скрипт для создания httpd конфига репорта-апача-верхнего
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['amich', 'xpahos', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_ARCHIVE(AbstractResource):
    """
        Tar archive with Maestro
        More info: https://wiki.yandex-team.ru/jandekspoisk/sepe/stability/projects/searchpriemka/maestro/
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_DUMMY_SERVICE(AbstractResource):
    """
        Maestro Dummy Service executable
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_DUMMY_FILE(AbstractResource):
    """
        Maestro Dummy File
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_DUMMY_ANOTHER_FILE(AbstractResource):
    """
        Maestro Dummy Another File
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_DUMMY_FOLDER(AbstractResource):
    """
        Maestro Dummy Folder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAESTRO_CONTOURS_INFO(AbstractResource):
    """
        Json file with information about priemka contours for RTCC
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOXYGEN_TOOL_EXECUTABLE(AbstractResource):
    """
        Doxygen tool
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DOXYGEN_CONFFILE_TEMPLATE(AbstractResource):
    """
        Doxygen configuration file template
    """
    releasable = True
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPLOG_DAEMON_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл explog daemon
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['samhan', 'atayan1'] + resource_releasers.marty
    release_subscribers = ['samhan']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPLIT_POOL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл split_pool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['smikler', 'ksenon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPLIT_PROTO_POOL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл split_proto_pool
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['smikler', 'ksenon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROTOR(AbstractResource):
    """
        rotor related resource
    """
    releasable = True
    executable = True
    any_arch = False
    releasers = ['stanly', 'knuzhdin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROTOR_WL_BUILDER(AbstractResource):
    """
        Binary for buil Rotor white lists
    """
    executable = True
    any_arch = False
    restart_policy = ctr.RestartPolicy.RESET


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROTOR_WHITE_LIST(AbstractResource):
    """
        Rotor white lists
    """
    executable = False
    any_arch = True
    restart_policy = ctr.RestartPolicy.RESET


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARD_CONF(AbstractResource):
    """
        Конфиг bsconfig-шарда
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['mixas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARD_INSTALL_SCRIPT(AbstractResource):
    """
        Скрипт для установки bsconfig-шарда на машинках
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['mixas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARD_INSTALLER_SCRIPT(AbstractResource):
    """
        Ещё один скрипт для установки bsconfig-шарда на машинках
        (из технических соображений нужны два разных типа ресурса)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = ['mixas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESTORE_UNIMPL_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл proto_pool_restore_unimpl
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['sinay', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CANONICAL_TEST_DATA(AbstractResource):
    any_arch = True
    share = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INPUT_TEST_DATA(AbstractResource):
    any_arch = True
    share = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOSTSLICES_WHITE(AbstractResource):
    """
        White patterns for ukrop
        Compile and use with arcadia/yweb/robot/ukrop/hostslices
        Ukrop attr 189 WhiteHostSlices
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOSTSLICES_MP3(AbstractResource):
    """
        Mp3 patterns for ukrop
        Compile and use with arcadia/yweb/robot/ukrop/hostslices
        Ukrop attr 269 MP3HostSlices
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOSTSLICES_MP3REF(AbstractResource):
    """
        Mp3 referers patterns for ukrop
        Compile and use with arcadia/yweb/robot/ukrop/hostslices
        Ukrop attr 270 MP3RefererHostSlices
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOSTSLICES_LYRICS(AbstractResource):
    """
        Lyrics patterns for ukrop
        Compile and use with arcadia/yweb/robot/ukrop/hostslices
        Ukrop attr 184 LyricsHostSlices
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERVICE_SANDBOX_OUTDATED_TASK_TYPES_REPORTS(AbstractResource):
    """
    SERVICE_SANDBOX_OUTDATED_TASK_TYPES results
    """
    calc_md5 = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JQ_EXECUTABLE(AbstractResource):
    """
        jq executable.
        See http://stedolan.github.io/jq/ to know more about jq.
    """
    any_arch = False
    executable = True
    auto_backup = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TMUX_EXECUTABLE(AbstractResource):
    """
        Terminal multiplexer (aka Tmux) executable.
        See http://tmux.sourceforge.net to know more about Tmux.
    """
    any_arch = False
    executable = True
    auto_backup = True
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CACHE_DAEMON(AbstractResource):
    """
        simple cacher by vmordovin@
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['vmordovin', 'elshiko', 'alex-ersh', 'dima-zakharov', 'kozunov', 'feldsherov', 'robot-morty']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_NAIL_DAEMON_EXECUTABLE(AbstractResource):
    """
        Naildaemon видеопоиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'extsearch/images/daemons/naildaemon/naildaemon'
    release_subscribers = video_thumb_subscribers
    releasers = resource_releasers.video_thumb_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_NAIL_DAEMON_CONFIG(AbstractResource):
    """
        Конфиг видео-naildaemon (профили тумбов)
    """
    releasable = True
    arcadia_path = 'yweb/webscripts/video/thumbnails/naildaemon-configs/thumb.cfg'
    release_subscribers = video_thumb_subscribers
    releasers = resource_releasers.video_thumb_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_NAIL_DAEMON_MAIN_CONFIG(VIDEO_NAIL_DAEMON_CONFIG):
    """
        Конфиг видео-naildaemon (параметры для основного индекса)
    """
    arcadia_path = 'yweb/webscripts/video/thumbnails/naildaemon-configs/main-config.txt'
    release_subscribers = video_thumb_subscribers
    releasers = resource_releasers.video_thumb_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_NAIL_DAEMON_ULTRA_CONFIG(VIDEO_NAIL_DAEMON_CONFIG):
    """
        Конфиг видео-naildaemon (параметры для ультра индекса)
    """
    arcadia_path = 'yweb/webscripts/video/thumbnails/naildaemon-configs/ultra-config.txt'
    release_subscribers = video_thumb_subscribers
    releasers = resource_releasers.video_thumb_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class O2_ITERATE_LOADER(AbstractResource):
    """
        o2.iterate_load_bin
    """
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZALIVATOR(AbstractResource):
    """
        zalivator
    """
    executable = True
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZALIVATOR_OUTS(AbstractResource):
    """
         zalivator outs
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ZALIVATOR_OUTS_DIFF(AbstractResource):
    """
         zalivator outs diff
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESOURCES_CONF(AbstractResource):
    """
        json с id'шниками протестированных ресурсов для триггеров и oxygen'а
    """
    any_arch = True
    releasable = True
    releasers = ["alexeyche", "isafarov", "kostik", "zhenyok", ]
    release_subscribers = ['alexeyche']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DIAPRINTKEYS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл diaprintkeys
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.stories_releasers
    arcadia_build_path = 'tools/diaprintkeys/diaprintkeys'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TIMELINE(AbstractResource):
    """
        Timeline project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['ivaxer', 'teamcity', 'robot-switter']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TIMELINE_SHARD(AbstractResource):
    """
        Shard with Timeline virtual environment archive
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['ivaxer', 'teamcity', 'robot-switter']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONGODB_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mongod
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KAFKA_ARCHIVE(AbstractResource):
    """
        Tar with Apache Kafka and its scripts
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KAFKA_HTTP_PROXY_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл kafka-http-proxy
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WEIGHTS_UNPACKER_EXECUTABLE(AbstractResource):
    """
        Python-скрипт, распаковывающий веса L7-балансера
        См. https://st.yandex-team.ru/SWAT-1230
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_SVN_DATA(AbstractResource):
    """
    файлы из svn которые нужны oxygen для построения базы
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = ["alexeyche", "zhenyok"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_BROWSE_COMP_FACTOR_DATA_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/comp_factor_data/user_browse_comp_factor_data'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_BROWSE_FEATURES_DATA_MANIP_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/data_manip/user_browse_features_data_manip'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABAR_CLEANING_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/antifraud/yabar_cleaning/yabar_cleaning'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABAR_CLEANING_BY_OLDFRAUDS_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/antifraud/yabar_cleaning_by_oldfrauds/yabar_cleaning_by_oldfrauds'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_BROWSE_COMM_CACHE_MANIP_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/comm_cache_manip/user_browse_comm_cache_manip'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_BROWSE_PREP_ANTISPAM_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_browse/prep_antispam/user_browse_prep_antispam'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USER_COUNTERS_COMP_FACTOR_DATA_EXECUTABLE(AbstractResource):
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['akhropov']
    arcadia_build_path = 'quality/user_counters/comp_factor_data/user_counters_comp_factor_data'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_STABILITY_YA_PACKAGE(AbstractResource):
    """
        Package for external stability calculations (USEREXP-3684)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_SPU_TEST_YA_PACKAGE(AbstractResource):
    """
        Package type for spu in rem sandbox (USEREXP-4550)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_EMS_VIEWER_YA_PACKAGE(AbstractResource):
    """
        Package type for ems in rem sandbox (USEREXP-4550)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAFEBROWSING_API_DATA(AbstractResource):
    """
    Safebrowsing API virus data: SBA list info, fullhash tries, SBA chunk files
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SAFEBROWSING_API_CODE(AbstractResource):
    """
    Safebrowsing API source code bundle for runtime cloud deployment.
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SNOWDEN_ARCHIVE(AbstractResource):
    """
        Snowden archive for Samogon.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA5BIN_PRESTABLE(AbstractResource):
    """
        'geodata5.bin' binary datafile for libgeobase5's users in PRESTABLE-environment; maybe used for ABT
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA5BORDERS_TESTING(AbstractResource):
    """
        'geodata5-borders/*.border' container with all known regions' borders for GEODATA5BIN_TESTING binary
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA5BORDERS_STABLE(AbstractResource):
    """
        'geodata5-borders/*.border' container with all known regions' borders for GEODATA5BIN_STABLE binary
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA5BORDERS_VIEWER(AbstractResource):
    """
        'geodata5-borders-viewer/*' container with viewer's related scripts/configs
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA3BIN_STABLE(AbstractResource):
    """
        'geodata3.bin' binary datafile for libgeobase3/ARCADIA users in STABLE-environment
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATATZDATA_STABLE(AbstractResource):
    """
        '/usr/share/geobase/zones*' datafiles for libgeobase* timezone-getter in STABLE-environment
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REGIONAL_UNITS_STABLE(AbstractResource):
    """
        '/usr/share/regional-units-*' datafiles for libregional-units (contrib/libs/regional-units) in STABLE-environment
    """
    any_arch = True
    executable = False
    releasable = True
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA_ZONES(AbstractResource):
    """
        'zones2 directory' for use in geosearch tests, no update cycle, hope will be substituded by official zones data
    """
    any_arch = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEODATA_VERSIONS(AbstractResource):
    """
        history of supported formats of geodata; purpose: testing and build support
    """
    any_arch = True
    executable = False
    releasable = False
    releasers = ['dieash', 'robot-geobase']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCE_PROD_PACKAGE(AbstractResource):
    """
        tarball with mapreduce binary deb-package for production
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['stunder', 'dcherednik', 'wint', 'xpahos', 'ilsuhov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCE_DEV_PACKAGE(AbstractResource):
    """
        tarball with mapreduce binary deb-package for development
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['stunder', 'dcherednik', 'wint', 'xpahos', 'ilsuhov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCE_TEST_PACKAGE(AbstractResource):
    """
        tarball with mapreduce binary deb-package for tests
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['stunder', 'dcherednik', 'wint', 'xpahos', 'ilsuhov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAPPS_PROD_PACKAGE(AbstractResource):
    """
        tarball with mrapps utilities deb-package for production
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['stunder', 'dcherednik', 'wint', 'xpahos', 'ilsuhov', 'qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAPPS_DEV_PACKAGE(AbstractResource):
    """
        tarball with mrapps utilities deb-package for development
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['stunder', 'dcherednik', 'wint', 'xpahos', 'ilsuhov', 'qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_MAPPER_INPUT(AbstractResource):
    """
        Input data to test oxygen mappers.
    """
    any_arch = True
    executable = False
    releasable = False
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BIKE_TEST_DATA(AbstractResource):
    """
        Canonized data for oxygen bike test
    """
    any_arch = True
    executable = False
    releasable = False
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_SUPPORT_BINARY(AbstractResource):
    """
        Jars for sitesearch-support daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_MANAGER_BINARY(AbstractResource):
    """
        Jars for sitesearch-manager daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_SUGGEST_BINARY(AbstractResource):
    """
        Jars for sitesearch-suggest daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_SEARCHER_BINARY(AbstractResource):
    """
        Jars for sitesearch-searcher daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_VIEWER_BINARY(AbstractResource):
    """
        Jars for sitesearch-viewer daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_PERIODIC_BINARY(AbstractResource):
    """
        Jars for sitesearch-periodic daemon
    """
    releasable = True
    any_arch = False
    releasers = ['avhaliullin', 'aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_UTILS(AbstractResource):
    """
        Binaries for optionsl use alongside oxygen
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['alexeyche', 'mcden', 'zagevalo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WRITE_KIWI_ATTR_BIN(AbstractResource):
    """
        write_kiwi_attr binary
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['alexeyche', 'mcden', 'zagevalo']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPREDUCELIBPPY_PACKAGE(AbstractResource):
    """
        Directory with files for mapreducelib.py package
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REMCLIENT_PACKAGE(AbstractResource):
    """
        Directory with files for rem client package
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLOUD_TAGS_SERVER_ARCHIVE(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['trofimenkov', 'alex-sh', 'panoff']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLOUD_TAGS_SERVER_BINARY(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['trofimenkov', 'alex-sh', 'panoff']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLOUD_TAGS_NIRVANA_BERNSTEIN_BINARY(AbstractResource):
    """

    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['trofimenkov', 'alex-sh', 'panoff']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MR_PACKET_LIB_PACKAGE(AbstractResource):
    """
        Directory with files for mr_packet_lib package
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AURORA_BUNDLE_VENV(AbstractResource):
    """
        Virtualenv containing Aurora
    """
    releasable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AURORA_PYTHON_BUNDLE(AbstractResource):
    """
        Python bundle for building Aurora
    """
    releasable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AURORA_BACKUP_TASKS_META(AbstractResource):
    """
        Archive with mongodump output that contains only tasks metainformation.
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AURORA_BACKUP_MAIN(AbstractResource):
    """
        Archive with mongodump output that contains full db excluding execution and execution_preview collections.
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AURORA_BACKUP_EXECUTIONS(AbstractResource):
    """
        Archive with mongodump output that contains only executions collection(execution_preview not included).
    """
    releasable = False
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIRTUALENV(AbstractResource):
    """
        Virtualenv with debian packages, wheels and python packages
    """
    releasable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_CONFIG(AbstractResource):
    """
        Файл конфига slave_newsd
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_STATE(AbstractResource):
    """
        Дамп состояния slave_newsd
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_ARCHIVE_SHARD(AbstractResource):
    """
        Архивный шард slave_newsd
    """
    share = True
    shard = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWSD_STATEWORK(AbstractResource):
    """
        Утилита для создания архивного шарда slave_newsd
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'yweb/news/daemon/statework'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_RESPONSES_COMPARE_RESULT(AbstractResource):
    """
        Результат сравнения двух выдач slave_newsd
    """
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_APPHOST_REQUESTS(AbstractResource):
    """
       slave_newsd apphost request contexts
    """
    releasable = False
    executable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_APPHOST_REQUESTER(AbstractResource):
    """
       Binary to send apphost requests to slave_newsd
    """
    releasable = True
    executable = True
    any_arch = False
    arcadia_build_path = 'yweb/news/tools/apphost_requester'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SLAVE_NEWSD_APPHOST_RESPONSES(AbstractResource):
    """
       slave_newsd apphost responses
    """
    releasable = False
    executable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROUTERD_REQUESTS(AbstractResource):
    """
       routerd apphost request contexts
    """
    releasable = False
    executable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROUTERD_RESPONSES(AbstractResource):
    """
       routerd apphost responses
    """
    releasable = False
    executable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROUTERD_RESPONSES_COMPARE_RESULT(AbstractResource):
    """
        Результат сравнения двух выдач routerd
    """
    share = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWSD_EVLOGDUMP_EXECUTABLE(AbstractResource):
    """
    Вьювер для eventlog для slave_newsd
    """
    releasable = True
    auto_backup = True
    executable = True
    releasers = ['msherbakov', 'sgrb', 'yurifrolov', 'gennadiy', 'cosyx']
    arcadia_build_path = 'yweb/news/daemon/slave/evdump'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SEARCH_SHARD(AbstractResource):
    """
        News search shard
    """
    releasable = True
    share = True
    shard = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SEARCH_SHARD_BUILDER(AbstractResource):
    """
        Tool for building a basesearch shard from YT tables
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'yweb/news/mr_indexer/shard_builder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MR_INDEXER(AbstractResource):
    """
        Tool for building search index from news documents
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'yweb/news/mr_indexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_AMMO_GENERATOR(AbstractResource):
    """
        Tool for gathering tank ammo from YT
    """
    auto_backup = True
    executable = True
    arcadia_build_path = 'yweb/news/news_ammo_generator/news_ammo_generator'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_AMMO(sdk2.Resource):
    """
        News ammofile
    """
    auto_backup = True
    executable = False
    share = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_LOADTEST_LXC_CONTAINER(sdk2.Resource):
    """
        Tarball with LXC image
    """
    __default_attribute__ = sdk2.parameters.String

    any_arch = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_BINARY(AbstractResource):
    """
        Base class for binary files used in Lemur Project.
    """
    releasable = False
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_LINKPROCESSOR(LEMUR_BINARY):
    deprecated = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_EXPORT_TO_PQ(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_MERGER(LEMUR_BINARY):
    deprecated = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_UPLOAD_FROM_KIWI(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_MRAGENT(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_PREPARE_ANTISPAMSEOMARK(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_PROCESS_LOGS(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_URLVIEWS(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_COUNTERS_DIFF_TOOL(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_TRANSFERPROCESSOR(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_CLEANING_BOT(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_YT_SENDER(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_YTIO(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_SELECTION_RANK_LEARN(LEMUR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_LEMUR_VINTAGE_OUT(AbstractResource):
    """
        lemur vintage test output
    """
    releasable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_LEMUR_VINTAGE_COMPARE_OUT(AbstractResource):
    """
        lemur vintage compare test output
    """
    releasable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LEMUR_VINTAGE_MAP_TEST_DATA(AbstractResource):
    """
        input test data for lemur vintage map
    """
    releasable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UZOR_BINARY(AbstractResource):
    """
        Base class for binary files used in Uzor Project.
    """
    releasable = True
    releasers = ['lazy', 'olegsenin', 'rdna', 'robot-testenv', 'svirg']
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UZOR_SERVER_BIN(UZOR_BINARY):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MOBILE_APPS_SERVICE(AbstractResource):
    """
        tar.gz with daemon, scripts and virtual env
    """
    releasable = False
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_SOURCE(AbstractResource):
    """
        compressed python source
    """
    releasable = True
    any_arch = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GREENBOX_VIRTUALENV(AbstractResource):
    """
        compressed rellocatable python virtualenv
    """
    releasable = True
    any_arch = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GREENBOX_BUNDLE(AbstractResource):
    """
        tar.gz with virtualenv and greenbox package
    """
    releasable = True
    any_arch = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_BUNDLE(AbstractResource):
    """
        Archived relocatable virtualenv.
    """
    any_arch = False
    auto_backup = False
    releasable = True
    releasers = search_priemka_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_BUNDLE2(sdk2.Resource):
    """
        Archived relocatable virtualenv (SDK2).
    """
    any_arch = False
    auto_backup = False
    releasable = True
    releasers = search_priemka_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GIT_BINARY(sdk2.Resource):
    """
        Git binary.
    """
    any_arch = False
    auto_backup = False
    releasable = True
    releasers = search_priemka_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_VIRTUALENV(AbstractResource):
    """
        Archived relocatable virtualenv used as a source for BuildPythonBundle2 task.
    """
    any_arch = False
    auto_backup = False
    releasable = True
    releasers = search_priemka_releasers + resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GO(AbstractResource):
    """
        Archived relocaatable Go environment.
    """
    any_arch = False
    auto_backup = False
    releasable = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REX_BIN(AbstractResource):
    """
        Rex binary.
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARTYR_BIN(AbstractResource):
    """
        Martyr binary.
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LOOP_CONF(AbstractResource):
    """
        Configuration file for instancectl.
    """
    auto_backup = True
    releasable = True
    releasers = ['pmankevich', 'lebedev-aa']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LIBPQ_SO(AbstractResource):
    """
        Client library for PostgreSQL queries.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PYTHON_EXTERNAL_LIBRARIES(AbstractResource):
    """
        External libraries used to build python from sources.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_MARKER_URLS(AbstractResource):
    """
        Список маркерных улров для oxygen тестов
    """
    any_arch = True
    executable = False
    releasable = False
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OXYGEN_FACTORS_HISTORY(AbstractResource):
    """
        json с историей значений факторов по маркерным запросам и урлам
    """
    any_arch = True
    executable = False
    releasable = False
    uploadable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_AMMO(AbstractResource):
    """
        Патроны для регрессии (KPI графиков производительности) геопоиска
    """
    uploadable = True
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPECSEARCH_PERL_BUNDLE(AbstractResource):
    """
        Perl bundle для индексатора колдунов
    """
    executable = False
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = resource_releasers.proxywizard_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_FRONT_AMMO(AbstractResource):
    """
        Амуниция для atom front
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_RERANK_AMMO(AbstractResource):
    """
        Амуниция для atom rerankd
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERS_ATOM_RERANK_CONTEXTS(AbstractResource):
    """
        Готовые аппхостовые контексты для atom rerankd
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ATOM_SRC_TESTS_DATA(AbstractResource):
    """
        Тестовые данные для источников под Атомом
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YA_PACKAGE(AbstractResource):
    """
        Ресурс ya package
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.experiment_releasers + [
        'mekagem', 'karavashkin',
        'robot-testenv', 'dmitko', 'yabsstartrek',
    ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_DYNAMIC_FORMULA(AbstractResource):
    """
        rearrange dynamic formulas (matrixnet, reg_tree and bundles)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_FORMULA(AbstractResource):
    """
        rearrange formulas (matrixnet, reg_tree and bundles)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_WIZARD_REQUESTS_RU(AbstractResource):
    """
        resource for russian news wizard requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_WIZARD_LOST_REQUESTS(AbstractResource):
    """
        resource for russian news wizard requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_WIZARD_REQUESTS_TR(AbstractResource):
    """
        resource for turkish news wizard requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_POPULARITIES(AbstractResource):
    """
        resource for sport object popularities FRESHNESS-2079
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPORT_POPULARITY_EXPLANATIONS(AbstractResource):
    """
        resource for sport object popularities with explanations FRESHNESS-2079
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MOS_RU_NEWS(AbstractResource):
    """
        resource for mos.ru news
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VOICE_MARKUP_SOUNDS(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGEST_DAEMONS_STUB(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARD_STABILITY_CONTRIBUTIONS(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_TRANSLITS(AbstractResource):
    """
        resource for market transliterations data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REQUESTS_JSON(AbstractResource):
    """
        resource for market requests data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_EXP_REQUESTS_JSON(AbstractResource):
    """
        resource for market requests data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SUGGESTS_XML(AbstractResource):
    """
        resource for market suggests xml data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SUGGESTS_RECIPE_XML(AbstractResource):
    """
        resource for market suggests recipe xml data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VOICE_SUGGESTER_INDEX_RU(AbstractResource):
    """
        resource for russian voice suggester
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_RU(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_RU_JSON(AbstractResource):
    """
        resource for russian trend requests json data
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_RU(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_RU(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_RU_JSON(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_RU_JSON(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_UA(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_UA(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_KZ(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_KZ(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_BY(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_BY(AbstractResource):
    """
        resource for trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_RU_ML(AbstractResource):
    """
        resource for russian trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_RU_NOFILTER(AbstractResource):
    """
        resource for russian trend requests without filtration
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_RU_NOFILTER_ML(AbstractResource):
    """
        resource for russian trend requests without filtration
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_TR(AbstractResource):
    """
        resource for turkish trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_TR_ML(AbstractResource):
    """
        resource for turkish trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_TR_NOFILTER(AbstractResource):
    """
        resource for turkish trend requests without filtration
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_TRENDS_TR_NOFILTER_ML(AbstractResource):
    """
        resource for turkish trend requests without filtration
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_SOCIAL_TRENDS_TR(AbstractResource):
    """
        resource for turkish trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_NEWS_TRENDS_TR(AbstractResource):
    """
        resource for turkish trend requests
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_QUERIES_SAMPLE(AbstractResource):
    """
        fresh queries sample
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ETHOS_BLACK_MODEL(AbstractResource):
    """
        resource for ethos news cliassifier
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ETHOS_YELLOW_MODEL(AbstractResource):
    """
        resource for ethos news cliassifier
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEPELIB_DIST(AbstractResource):
    """
        sepelib distribution
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = nanny_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NANNY_MONGODB(AbstractResource):
    """
        folder with mongodb static utils
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMGS_EFIR_MONGODB(AbstractResource):
    """
        folder with mongodb static utils
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_BUNDLE_DEBIAN(AbstractResource):
    """
        Debian-пакет с бандлом аркадийной node.js и report-renderer
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["kaero", "asterx", "flack", "slava-b", "mcheshkov", "sotius", "frimuchkov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_CONFIG(AbstractResource):
    """
        Абстрактный класс для описания всех конфигов report-renderer
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ["kaero", "asterx", "flack", "librarian", "slava-b", "sotius", "frimuchkov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_PRODUCTION_LOOP_CONFIG(REPORT_RENDERER_CONFIG):
    """
        Конфиг instancectl для production (с запуском push-client / logmux и правильными настройками)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_TESTING_LOOP_CONFIG(REPORT_RENDERER_CONFIG):
    """
        Конфиг instancectl для testing
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_PUSH_CLIENT_CONFIG(REPORT_RENDERER_CONFIG):
    """
        Конфиг push-client.yml (Содержит логическое описание логов и их приёмников)
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_COLLECTOR_DEPLOYMENT_CONFIG(REPORT_RENDERER_CONFIG):
    """
        Конфиг logmux
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_COLLECTOR_TUNING_CONFIG(REPORT_RENDERER_CONFIG):
    """
        Конфиг logmux
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_BENCHMARK_CONFIG(AbstractResource):
    """ Benchmark config for report-renderer """
    executable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_BENCHMARK_PLAN(AbstractResource):
    """ Dolbilka requests for report-renderer """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_BENCHMARK_COMPARISON_RESULT(AbstractResource):
    """ Comparison of two report-renderer benchmark results  """
    any_arch = True
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_LOG(AbstractResource):
    """ report-renderer log """
    any_arch = True
    executable = False
    ttl = 14


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_BLOCKSTAT_LOG(REPORT_RENDERER_LOG):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_MEMORY_BENCHMARK_RESULT(AbstractResource):
    """ Результаты бенчмарка памяти worker-процесса report-renderer """
    any_arch = True
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_RENDERER_MASTER_MEMORY_BENCHMARK_RESULT(AbstractResource):
    """ Результаты бенчмарка памяти master-процесса report-renderer """
    any_arch = True
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class V8_HEAP_SNAPSHOT(AbstractResource):
    any_arch = True
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class V8_COMPRESSED_HEAP_SNAPSHOT_DIR(AbstractResource):
    any_arch = True
    ttl = 90


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_FRONTEND_HEATMAP(AbstractResource):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_SERVER_CONFIGURATOR_CACHE(AbstractResource):
    """Stored cache used by yabs/server/libs/config"""
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_SERVER_B2B_TRUNK_BUILD(AbstractResource):
    """
        Resource for smoke tests day to day
        Attributes:
            version = (XXXXXX.XXXXXX)
            data = (YYYYMMDD)
    """
    auto_backup = True
    ttl = 14


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_SERVER_B2B_REQUESTS_MONGODUMP(AbstractResource):
    """
        MongoDump with requests for smoke stands
        Attributes:
            data = (YYYYMMDD)
    """
    auto_backup = True
    ttl = 14


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_SURF_DATA(AbstractResource):
    """
    Contents of yandex-surf-data debian package.
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIVIRUS_WRAPPERS_DATA(AbstractResource):
    """
    Wrapper thru layers middle data: source host -> target host
    """
    auto_backup = True
    any_arch = False
    ttl = 7


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_DOLBILO_BUNDLE(AbstractResource):
    """
        Bundle with sample base, sample basesearch and sample dolbilo. To get all-in-one
    """
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_GENERATED_BALANCER_CONFIGS(AbstractResource):
    """
        Directory with all generated balancer configs
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'kfour', 'keepclean', 'moridin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRS_INTERSECTOR_EXECUTABLE(AbstractResource):
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YACATALOG_XML(AbstractResource):
    """
        YaCatalog.xml: rubrics tree definition
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ROBOT_URLRULES(AbstractResource):
    """
        Various lists of domains that require non-standard behaviour of content system:
        currently contains 2ld.list, ungrouped.list, areas.lst
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IPREG_SET(AbstractResource):
    """
        Directory containing various versions of IPREG (IP to region) file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEO_STAT(AbstractResource):
    """
        geo.stat file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOST_CFG(AbstractResource):
    """
        host.cfg file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOMAP_CONTENTS(AbstractResource):
    """
        Partial contents of brasero::yaca/current/misc/geomap/
        Contains geoBase.c2CountryRegion and geo.c2CountryCity
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOA_C2P(AbstractResource):
    """
        geoa.c2p: region tree used by current robot database
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CV_IMAGEPARSER(AbstractResource):
    """
       Исполняемый файл обработки картинок.
    """
    releasable = True
    releasers = cvdup_releasers
    release_subscribers = cvdup_subscribers
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'cv/sigtools/imparsertest/imparsertest'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CV_RAW_COCAINE_LIBRARY(AbstractResource):
    """
        Dynamic library for computer vision cocaine workers
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CV_RAW_COCAINE_HEADERS(AbstractResource):
    """
        Dynamic library headers for computer vision cocaine workers
    """
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_PBUILDER_IMAGE(AbstractResource):
    """
        The result of pbuilder --create
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RAZLADKI(AbstractResource):
    """
        Razladki project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['aptakhin', 'bondra']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RAZLADKI_SHARD(AbstractResource):
    """
        Razladki shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['aptakhin', 'bondra']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RAZLADKI_VIRTUALENV_PACKAGE(AbstractResource):
    """
        Virtualenv like package with razladki packages
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.experiment_releasers
    release_subscribers = ['aptakhin', 'bondra']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ABGAME_BACKEND_PACKAGE(AbstractResource):
    """ Abgame backend """
    releasable = True
    auto_backup = True
    releasers = ["redwaan", "jakwuh"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ABGAME_FRONTEND_PACKAGE(AbstractResource):
    """ Abgame frontend """
    releasable = True
    auto_backup = True
    releasers = ["ftdebugger", "jakwuh"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ABGAME_FRONTEND_TESTING_PACKAGE(AbstractResource):
    """ Abgame testing frontend """
    releasable = True
    auto_backup = True
    releasers = ["ftdebugger", "jakwuh"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_FRONTEND_PACKAGE(AbstractResource):
    """ PDB frontend """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_FRONTEND_TESTING_PACKAGE(AbstractResource):
    """ PDB frontend """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_FRONTEND_CHROME_EXTENSION(AbstractResource):
    """
        PDB frontend chrome extension
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_FRONTEND_SIZE(AbstractResource):
    """ PDB frontend size """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_NODEJS_PACKAGE(AbstractResource):
    """ Node JS binary package. """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_PHANTOMJS_PACKAGE(AbstractResource):
    """ Phantom JS binary package. """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_HOT_FRONTEND_PACKAGE(AbstractResource):
    """ HOT frontend """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_HOT_FRONTEND_TESTING_PACKAGE(AbstractResource):
    """ HOT frontend """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IDX_QDUMP_EXECUTABLE(AbstractResource):
    """
        panther guts dumper
        Бинарник программы idx_qdump (elric@, snow@)
        Pantera project
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True
    arcadia_build_path = 'search/panther/tools/idx_qdump/idx_qdump'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WIZARDED_POOL_REQUESTS(AbstractResource):
    """
        wizard processed requests with cgi fields: qtree, user_request, etc
    """
    any_arch = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PANTHER_GUTS(AbstractResource):
    """
        tar archive with tsv files
        Pantera project
    """
    any_arch = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLAIN_TEXT(AbstractResource):
    """
        Текстовые данные для различных нужд
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_USERDATA_PACKAGE(AbstractResource):
    """
        Debian package with userdata programs and scripts and data
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_MISCDATA_PACKAGE(AbstractResource):
    """
        Debian package with md_prep program and scripts and data to run it
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_USER_COUNTERS_PACKAGE(AbstractResource):
    """
        Debian package with user_counters programs and scripts and data
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_USER_BROWSE_PACKAGE(AbstractResource):
    """
        Debian package with user_browse programs and scripts and data
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_USER_SEARCH_PACKAGE(AbstractResource):
    """
        Debian package with user_search programs and scripts and data
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_DATA_UPDATER_PACKAGE(AbstractResource):
    """
        Debian package with data updater script for various userdata subsystems
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class USERFEAT_SAMPLERS_PACKAGE(AbstractResource):
    """
        Debian package with userfeat data sampling programs
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BKHT_SAMOGON_APP_CODE(AbstractResource):
    """
        Архив с кодом BkhtNannyApp - бессмысленного приложения bkht@ для тестирования Няни.
    """
    releasable = True
    auto_backup = True
    any_arch = True
    releasers = ['bkht']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BKHT_TICKERS_APP_CODE(AbstractResource):
    """
        Архив с кодом BkhtTickersApp - очередного бессмысленного приложения bkht@.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['bkht']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BKHT_TICKERS_APP_VIRTUAL_ENVIRONMENT(AbstractResource):
    """
        Виртуальное окружение python (virtualenv) для запуска BkhtTickersApp
    """
    shard = False
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['bkht', 'teamcity']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_PLOT_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл fml_plot
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_CQN_MAIN(AbstractResource):
    """
        cqn-main application
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_CQN_FRONT(AbstractResource):
    """
        static jars for cqn front-end
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovalenko', 'kerfitd', 'elfadina']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ADMIN_MAIN(AbstractResource):
    """
        news-admin main backend application
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ADMIN_API(AbstractResource):
    """
        news-admin api for external services
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ADMIN_TMS(AbstractResource):
    """
        news-admin task management system
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ADMIN_SEARCHER(AbstractResource):
    """
        news-admin searcher application
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ADMIN_TOOLS(AbstractResource):
    """
        news-admin natools backend
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PARTNER_MAIN(AbstractResource):
    """
        backend for news partner interface
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PARTNER_SYNC(AbstractResource):
    """
        data synchronizer for news partner interface
    """
    auto_backup = True
    releasable = True
    releasers = ['alex-kovaleko', 'kefitd', 'elfadina', 'semenovma'] + news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HG_TOOLKIT(AbstractResource):
    """
        Mercurial Toolkit
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['somov', 'rnefyodov', 'pg']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HG_SERVER(AbstractResource):
    """
        Hg with a server configuration
    """
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = ['nslus', 'pulkit']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEMANTIC_YT_MAPPER_BINARY(AbstractResource):
    """
        Jars for validator-yt-mapper daemon
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'lester']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEMANTIC_MF_VERIFIER_BINARY(AbstractResource):
    """
        Jars for mf-verifer daemon
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'lester']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SEMANTIC_PUBLIC_API_BINARY(AbstractResource):
    """
        Jars for semantic-public-api service
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'lester']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REVIEW_BOARD_PACKAGE(AbstractResource):
    """
        Samogon package с сервисом Review Board
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GITHUB_EXTAPI_PACKAGE(AbstractResource):
    """
        Package with ext api for GHE
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package с сервисом Arcadia
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_HG_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package с сервисом Arcadia hg
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_HG_SERVER_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package с сервисом Arcadia hg
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_SVN_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package с сервисом Arcadia svn
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITERTOOL(AbstractResource):
    """
       Исполняемый файл для скачивания базы из MR
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['osol', 'okats']
    release_subscribers = ['osol', 'okats']
    arcadia_build_path = 'infra/shardtool/shardtool'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_CATFILTER_FROZEN_DATA(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_YACATALOG(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_YACATALOG_COMPOSITE(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_YACATALOGU_PM(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_GEOADRESA(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUPITER_MIRRORS_WITHOUT_HTTP_TRIE(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARP_EYE_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл sharp_eye
    """
    releasable = False
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class M2NSORT_EXECUTABLE(AbstractResource):
    """
        m2nsort
    """
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'yweb/robot/m2nsort/main'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CATFILTER_BUNDLE(AbstractResource):
    """
        Bundle of binaries to build filter.trie
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.jupiter_releasers
    release_subscribers = jupiter_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CY_LST(AbstractResource):
    """
        cy.lst: list of hi-TYC domains that require some special treatment in userdata
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_IBM_ENVIROMENT(AbstractResource):
    """
        IBM JDK Enviroment tarball
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERSONAL_SEARCH_DAEMON(AbstractResource):
    """
        Personal search services daemons bundles (tar.gz)
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERSONAL_SEARCH_SEARCHMAP(AbstractResource):
    """
        Personal search services daemons bundles (tar.gz)
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASESEARCH_PERFTEST_BUNDLE(AbstractResource):
    """
         Bundle with sample database, sample basesearch, sample d-executor and other utilities to run baseseach perfomance testing.
    """
    auto_backup = True
    executable = False
    releasers = ['kimkim']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_DIST(AbstractResource):
    """
        Jars for Vaas
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_CUSTOM_CONFIG(AbstractResource):
    """
        Custom config for Vaas
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers + ['artalex']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUSH_AMMO(AbstractResource):
    """
        Push ammo
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUSH_DBM_DIST(AbstractResource):
    """
        Jars for push
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_JDK_DIST(AbstractResource):
    """
        Jdk for Vaas
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_CONFIG(AbstractResource):
    """
        Vaas configs
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_AMMO(AbstractResource):
    """
        Vaas ammo
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIEWPORTESE_DIST(AbstractResource):
    """
        Viewports jars for Vaas
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE(AbstractResource):
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_TEST_ISS_LOOP_CONF_FOR_BUNDLE(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_ISS_HOOK_STATUS(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_ISS_HOOK_INSTALL(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_CONFIG_BUNDLE(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_CONFIG_BUNDLE_WITH_LOOPS(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_DOWNLOAD_BUNDLE(VPS_PROD_ISS_LOOP_CONF_FOR_BUNDLE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_CHECK_DOCUMENTS(AbstractResource):
    """
         Storage for results of freshness test
    """
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_PRIEMKA_INDEX(AbstractResource):
    releasable = False
    any_arch = True
    releasers = ['zhnick']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_PRIEMKA_AMMO(AbstractResource):
    releasable = False
    any_arch = True
    releasers = ['zhnick']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_BINARY(AbstractResource):
    """
        Market Report binary file
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_report_releasers
    arcadia_build_path = 'market/report/report_base/report_bin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_KD_DUMPER_BINARY(AbstractResource):
    """
        Log dumper for kapital.py binary file
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_report_releasers
    arcadia_build_path = 'market/tools/develop/kapital/dumper/kd_dumper'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_INDEX(AbstractResource):
    """
        Market Report index
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_PLAN(AbstractResource):
    """
       Dolbilka requests for Market Report
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_PLAIN_TEXT_QUERIES(AbstractResource):
    """
        Market Report queries
        Differ from PLAIN_TEXT_QUERIES in "/yandsearch?..."
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_CONFIG_GENERATOR(AbstractResource):
    """
        Config generator file for Market Report
    """
    releasable = True
    auto_backup = True
    releasers = market_report_releasers
    arcadia_build_path = 'market/report/configs/generator'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_REPORT_CONFIG_TEMPLATE(AbstractResource):
    """
        Config template for Market Report
    """
    releasable = True
    auto_backup = True
    releasers = market_report_releasers
    arcadia_build_path = 'market/report/configs/generator/etc/template.cfg'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_NGINX_BINARY(AbstractResource):
    """
        Nginx static binary with additional configure options.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEB_PACKAGE_TAR(AbstractResource):
    """
        Tarball with deb packages
    """
    releasable = True
    auto_backup = True
    releasers = ['mkulemin', 'olegsenin', 'vlegeza', 'saku', 'amich', 'onotole']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALLURE_REPORT(AbstractResource):
    """
        Allure Report
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALLURE_RESULTS(AbstractResource):
    """
        Allure Results
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALLURE_COMMANDLINE(AbstractResource):
    """
        Allure Command Line Tool
    """

    releasable = True
    executable = False
    auto_backup = True
    any_arch = True
    releasers = ['charlie']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PHANTOM_REQUESTS(AbstractResource):
    """
        phantom ammos
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HAMSTERWHEEL_EXECUTABLE(AbstractResource):
    """
        hamsterwheel
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True
    arcadia_build_path = 'tools/snipmake/download_contexts/hamsterwheel/hamsterwheel'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HAMSTERWHEEL_QUERIES(AbstractResource):
    """
       hamsterwheel input files with user queries
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BUILD_ARCADIA_CONTRIB_RESULTS(AbstractResource):
    """
        Build Arcadia Contrib Results
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HAMSTER_REQUEST_EXECUTABLE(AbstractResource):
    """
        hamster_request
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_IMPORT_TRIE(AbstractResource):
    """
       Images mrindexer import.trie.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_ADULT_RATED_URLS(AbstractResource):
    """
       Images adult rated urls by tolokers for mrindexer.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RATED_URLS(AbstractResource):
    """
       Images rated urls for mrindexer.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RATED_URL_HASHES(AbstractResource):
    """
       Images rated url hashes (in binary format) for mrindexer.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_RATED_PAGE_URLS(AbstractResource):
    """
       Images rated page urls for mrindexer.
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_CONFIG(AbstractResource):
    """
        Каталог config для картиночного индекса на MR
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_CONFIG_CHECKER(AbstractResource):
    """
        Исполняемый файл для тестирования консистентности конфига картиночного индекса
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/tools/config_checker/config_checker'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_SHARDWRITER_CONFIG(AbstractResource):
    """
        Каталог config для быстрого картиночного индекса на MR
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_CM_SCRIPT(AbstractResource):
    """
        Картиночный CM скрипт
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_CM_SCRIPT(IMAGES_CM_SCRIPT):
    """
        CM скрипт для главного картиночного индекса
    """
    arcadia_build_path = 'extsearch/images/robot/scripts/cm/build/main_index/mrindex_main.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_CM_SCRIPT(IMAGES_CM_SCRIPT):
    """
        CM скрипт для быстрого картиночного индекса
    """
    arcadia_build_path = 'extsearch/images/robot/scripts/cm/build/fast_index/mrfast_main.sh'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_HOSTS_LISTS(AbstractResource):
    """
        hostlist для картиночного CM
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MAIN_INDEX_HOSTS_LIST(IMAGES_HOSTS_LISTS):
    """
        hostslist для главного индекса
    """
    arcadia_path = 'extsearch/images/robot/scripts/cm/mrhosts.list'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_FAST_INDEX_HOSTS_LIST(IMAGES_HOSTS_LISTS):
    """
        hostslist для быстрого индекса
    """
    arcadia_path = 'extsearch/images/robot/scripts/cm/mrfasthosts.list'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_EMPTY_RELEASEABLE_RESOURCE(AbstractResource):
    """
        Пустой ресур для релиза. Необходим для того, чтобы можно было релизит таски,
        у которых нет ресурсов, но есть подтаски с ресурсами
    """
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DASHBOARD_EXECUTABLE(AbstractResource):
    """
        Dashboard индекса
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = images_index_releasers
    release_subscribers = images_index_subscribers
    arcadia_build_path = 'extsearch/images/robot/viewers/images_dashboard'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DASHBOARD_CONFIG(AbstractResource):
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_index_subscribers

    arcadia_path = 'extsearch/images/robot/viewers/images_dashboard/config.json'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DASHBOARD_STATIC(AbstractResource):
    releasable = True
    releasers = images_index_releasers
    release_subscribers = images_index_subscribers

    arcadia_path = 'extsearch/images/robot/viewers/images_dashboard/view'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ASSESSED_DOCS_LIST(AbstractResource):
    """
        List of assessed docs
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FREON_SCRIPTS(AbstractResource):
    """
        Freon directory with scripts for Nirvana
    """
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SENTRY_VIRTUALENV(AbstractResource):
    """
        Virtualenv с питоном для sentry
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUICK_REARRANGE_RULES_DATA(AbstractResource):
    """
        Data for rearrange rules that used in QUICK middlesearch
    """
    releasable = True
    auto_backup = True
    releasers = ["epar", "melton", "mnzhkv", "nkmakarov", "polyanskiy-mn", "zhevnerchuk", "robot-testenv"]
    release_subscribers = ["epar", "zhevnerchuk"]
    arcadia_build_path = "extsearch/fresh/meta/rearrange_data"


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MEMCACHED_BINARY(AbstractResource):
    """
        Memcached binany
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REFRESH_TESTING_CONFIGS(AbstractResource):
    """
        Ресурсы для теста refresh
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_QUERYDATA_INDEXER_EXECUTABLE(AbstractResource):
    """
    querydata_indexer executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.bno_releasers
    arcadia_build_path = 'yweb/querydata/querydata_indexer/querydata_indexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_URL2DOCID_EXECUTABLE(AbstractResource):
    """
    url2docid executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.bno_releasers
    arcadia_build_path = 'yweb/querydata/tools/url2docid/url2docid'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_GEMINICL_EXECUTABLE(AbstractResource):
    """
    gemini client executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.bno_releasers
    arcadia_build_path = 'robot/gemini/client/geminicl'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_MAPREDUCE_EXECUTABLE(AbstractResource):
    """
    mapreduce client executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.bno_releasers
    arcadia_build_path = 'quality/mapreduce/mapreduce'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_NEWS_HOSTS(AbstractResource):
    """
    list of hosts
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.bno_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_HOST_TO_APP(AbstractResource):
    """
    list of hosts
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.bno_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BNO_QUERYDATA_TRIE(AbstractResource):
    """
    Query data trie
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.bno_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEMPLATER(AbstractResource):
    """
    Configuration preparation system For instancectl
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['mkulemin', 'olegsenin', 'vlegeza', 'saku', 'amich', 'onotole', 'reddog']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEMPLATER_ISS_HOOK_INSTALL(AbstractResource):
    """
        Install instance script wrapper for INSTANCECTL (used by iss agent)
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = ['mkulemin', 'olegsenin', 'vlegeza', 'saku', 'amich', 'onotole']
    release_subscribers = []


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BLENDER_LIBBLNDR(AbstractResource):
    """
        blender python bindings library
    """
    releasable = True
    any_arch = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_ISEG_FRONTEND(AbstractResource):
    """
        iseg.yandex.ru
    """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['ftdebugger']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_CAUTH_EXPORT_OWNERS(AbstractResource):
    """
        File with pairs (<groupname> <comma-separated list of group owners>)
    """

    any_arch = True
    auto_backup = False
    executable = False
    releasable = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'osol']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_CAUTH_EXPORT_HOSTS(AbstractResource):
    """
        File with xml, listing hosts for every gencfg group
    """

    any_arch = True
    auto_backup = False
    executable = False
    releasable = True
    releasers = ['kimkim', 'sereglond', 'robot-gencfg', 'osol']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_HOSTS_DATA(AbstractResource):
    """
        File with information about each host, encoded with msgpack and gzipped
    """

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_WHEELS(AbstractResource):
    """
        File with all gencfg wheels, as tar.gz
    """

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENCFG_BIN_UTILS(AbstractResource):
    """
        File with gencfg binutils, as tar.gz
    """

    any_arch = True
    auto_backup = True
    executable = False
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFD_BIN(AbstractResource):
    '''
        confd static binary
    '''
    executable = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ETCD_BIN(AbstractResource):
    """
        Etcd binary
    """
    any_arch = False
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ETCDCTL_BIN(ETCD_BIN):
    """
        Etcdctl binary
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ETCD_PKG(AbstractResource):
    """
        Archive with etcd and etcdctl binaries
    """
    any_arch = False
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPDATE_DATASOURCES_BIN(AbstractResource):
    """
        Update_datasource binary
    """
    any_arch = False
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONFD_CONFIGS(AbstractResource):
    """
        Configs for confd
    """
    releasable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOADDR_LEARN_CORPUS(AbstractResource):
    """
        Non-annotated corpus for learning matrixnet model which assigns weights to GeoAddr answers
    """
    releasable = True
    releasers = ['yurakura', 'grand']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOADDR_LEARN_MARKUP(AbstractResource):
    """
        Annotated corpus for learning matrixnet model which assigns weights to GeoAddr answers
    """
    releasable = True
    releasers = ['yurakura', 'grand']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RTSEARCH_DUMP(AbstractResource):
    """
    State dump for news rtsearch
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JETTY_BINARY(AbstractResource):
    """
        Jetty static binary build by eclipse.org .
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['vkiryliuk']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVDUP_IMAGEREDUCE(AbstractResource):
    """
       Исполняемый файл для склейки дубликатов картинок.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = cvdup_releasers
    release_subscribers = cvdup_subscribers
    arcadia_build_path = 'cv/semidup2/imagereduce/imagereduce'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVDUP_TESTTOOL(AbstractResource):
    """
       Исполняемый файл для синтетических тестов дубликатов картинок.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = cvdup_releasers
    release_subscribers = cvdup_subscribers
    arcadia_build_path = 'cv/semidup2/testtool/testtool'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVDUP_IMAGEPARSER_CONFIG(AbstractResource):
    """
        Файл конфига парсера для тестирования дубликатов
    """
    releasable = True
    auto_backup = True
    arcadia_path = 'cv/semidup2/testconfig/imparser.config'
    releasers = cvdup_releasers
    release_subscribers = cvdup_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVDUP_TEST_IMAGE_SET(AbstractResource):
    """
        Набор JPEG файлов для тестирования
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CVDUP_TEST_RESULT(AbstractResource):
    """
        JSON файл с результатами тестирования склейки дубликатов
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SERVICE_TEMPLATE_VIRTUAL_ENVIRONMENT_TAR(AbstractResource):
    """
        Архив с виртуальным окружением (python virtualenv) для запуска service template
    """
    shard = True
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['kartvep', 'oxcd8o', 'aesdana', 'nikkraev', 'isharov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YQL_CLI_LINUX(AbstractResource):
    """
        YQL client: https://wiki.yandex-team.ru/yql/userguide/cli/
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yql_releasers
    release_subscribers = yql_subscribers
    arcadia_build_path = 'yql/cli/bin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YQL_CLI_DARWIN(AbstractResource):
    """
        YQL client: https://wiki.yandex-team.ru/yql/userguide/cli/
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yql_releasers
    release_subscribers = yql_subscribers
    arcadia_build_path = 'yql/cli/bin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YQL_CLI_WINDOWS(AbstractResource):
    """
        YQL client: https://wiki.yandex-team.ru/yql/userguide/cli/
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yql_releasers
    release_subscribers = yql_subscribers
    arcadia_build_path = 'yql/cli/bin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PQ2SAAS_BINARY(AbstractResource):
    releasable = True
    executable = True
    releasers = ['robot-carsharing', 'svshevtsov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class APPSFLYERD_BINARY(AbstractResource):
    releasable = True
    executable = True
    releasers = ['werat', 'carabas']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUSHITD_BINARY(AbstractResource):
    releasable = True
    executable = True
    releasers = ['werat', 'carabas', 'deathnik']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_PACKAGE(AbstractResource):
    """
        Пакет с сервером REM
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_CLIENT_LIB_PACKAGE(AbstractResource):
    """
        Пакет с клиентсокой библиотекой REM
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_TOOL_PACKAGE(AbstractResource):
    """
        Пакет с rem-tool
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_EXECUTOR(AbstractResource):
    """
        Код, выполняющий пакет задач REM внутри таска Sandbox
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_ADDED_FILE(AbstractResource):
    """
        Файл, добавленные через AddFiles
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_ADDED_FILE_SET(AbstractResource):
    """
        Файлы, добавленные через AddFiles
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_EXECUTION_SNAPSHOT(AbstractResource):
    """
        Состояние выполняющегося REM-пакета
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_STDERRS(AbstractResource):
    """
        STDERR от запущенных джобов
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_GRAPH_UPDATE(AbstractResource):
    """
        ...
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_EXECUTION_RESULTS(AbstractResource):
    """
        Логи от успешно выполненного REM-пакета
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REM_JOBPACKET_PYTHON(AbstractResource):
    """
        Python Virtual Environment for REM JobPacket
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TDI_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл смешивания результатов поисковых запросов-экспериментов в один результат
        (app_host service)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.noapacheupper_releasers
    arcadia_build_path = 'search/daemons/tdi/tdi'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQUESTS_FOR_TDI_APP_SERVICE(AbstractResource):
    """
        Запросы для поискового app_host сервиса tdi.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESPONSES_TDI_APP_SERVICE(AbstractResource):
    """
        Ответы для поискового app_host сервиса tdi.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REPORT_DATA(AbstractResource):
    """
        Данные для новостного репорта
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REPORT_DATA_PROD(NEWS_REPORT_DATA):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REPORT_DATA_EXP(NEWS_REPORT_DATA):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_REPORT_DATA_DIFF(NEWS_REPORT_DATA):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_BAD_YANDEXUIDS(AbstractResource):
    """
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_L_COOKIE_KEYS(AbstractResource):
    """
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_UATRAITS_BROWSER_XML(AbstractResource):
    """
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STABLE_NEWS_APACHE_BUNDLE(AbstractResource):
    """
        Проверенная и одобренная Новостями версия APACHE_BUNDLE
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STABLE_NEWS_APP_HOST_BUNDLE(AbstractResource):
    """
        Проверенная и одобренная Новостями версия APP_HOST_BUNDLE
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STABLE_NEWS_APP_HOST_PRODUCTION_INSTANCECTL_CONF(AbstractResource):
    """
        Проверенная и одобренная Новостями версия APP_HOST_PRODUCTION_INSTANCECTL_CONF
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STABLE_NEWS_APP_HOST_SRC_SETUP_BUNDLE(AbstractResource):
    """
        Проверенная и одобренная Новостями версия APP_HOST_SRC_SETUP_BUNDLE
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class STABLE_NEWS_APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF(AbstractResource):
    """
        Проверенная и одобренная Новостями версия APP_HOST_SRC_SETUP_PRODUCTION_INSTANCECTL_CONF
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_COLLECTOR_DEPLOYMENT_CONF(AbstractResource):
    """
        Config for collector deployment in news upper service
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_COLLECTOR_TUNING_CONF(AbstractResource):
    """
        Config for collector tuning in news upper service
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_GENERATE_APACHE_HTTPD_CONF_SCRIPT(AbstractResource):
    """
        Скрипт для создания httpd конфига новостного репорта-апача-верхнего
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_GET_DATA_RUNTIME_SCRIPT(AbstractResource):
    """
        Скрипт для получения данных для новостного репорта из релизов в Sandbox
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_GET_LAST_RESOURCE_SCRIPT(AbstractResource):
    """
        Скрипт для получения последнего релизного ресурса указанного типа в папку инстанса (автор - @bykanov)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APACHE_HTTPSEARCH_WATCHDOG(AbstractResource):
    """
        Скрипт для запуска апача новостей (с поддержкой ISS)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APACHECTL_SCRIPT(AbstractResource):
    """
        Скрипт для запуска апача новостей Next-Gen (с поддержкой ISS и HBF)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PREPARE_ARCANAVT_SCRIPT(AbstractResource):
    """
        Скрипт для создания папки arkanavt при настройке news upper (apache)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_QUOTES_PREPARE_ARCANAVT_SCRIPT(AbstractResource):
    """
        Скрипт для создания папки arkanavt при настройке news quotes
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SLAVE_NEWSD_CONF(AbstractResource):
    """
        Конфиг для slave_newsd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APACHE_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса новостного репорта-апача-верхнего
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE_REPLICATOR_INSTANCECTL_CONF(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE_REPLICATOR_CONFIG_TESTING(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE_REPLICATOR_CONFIG_PRODUCTION(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса новостного репорта-апача-верхнего
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX_MIME_TYPES(AbstractResource):
    """
        Конфиг instancectl для инстанса новостного репорта-апача-верхнего
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX_ISS_HOOK_NOTIFY(AbstractResource):
    """
        Конфиг instancectl для инстанса новостного репорта-апача-верхнего
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SLAVE_NEWSD_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса slave_newsd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_QUOTES_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса app_host_quotes
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_ROUTERD_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса app_host_routerd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_DUMPERD_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса app_host_dumperd
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_MAKE_LOGS_LYNKS_SCRIPT(AbstractResource):
    """
        Скрипт для правки путей до логов для новостного upper (apache)
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PUSH_CLIENT_CONF(AbstractResource):
    """
        Config for push client in news upper service
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PUSH_CLIENT_PRIEMKA_CONF(AbstractResource):
    """
        Config for push client in news upper acceptance service
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NOAPACHE_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса новостного noapache
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRIEMKA_NOAPACHE_INSTANCECTL_CONF(AbstractResource):
    """
        Конфиг instancectl для инстанса noapache для web-imgs-video-yaca-etc.
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRIEMKA_APPHOST_INSTANCECTL_CONF(AbstractResource):
    """
        Пропатченный конфиг instancectl для инстанса app_host в searchpriemka
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRIEMKA_SRCSETUP_INSTANCECTL_CONF(AbstractResource):
    """
        Пропатченный конфиг instancectl для инстанса src_setup в searchpriemka
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRIEMKA_REPORT_INSTANCECTL_CONF(AbstractResource):
    """
        Пропатченный конфиг instancectl для web-imgs-video-yaca репортов
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = search_priemka_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PYTHON3(AbstractResource):
    """
        Python 3 for News
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CV_COLLAGE_DETECTOR_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл collage_detector
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'cv/imageproc/smartcrop/collage_detector/collage_detector'
    releasers = ['volynkin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BLENDER_EXPERIMENT_SETUP(AbstractResource):
    """
        Set of rearrange parameters for blender back experiment
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTOR_NAMES_TXT(AbstractResource):
    """
        `idx_ops factor-names` working result
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FACTOR_BORDERS_TXT(AbstractResource):
    """
        `idx_ops factor-borders` file
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TARCVIEW_EXECUTABLE(AbstractResource):
    """
        Утилита для дампа протобуфных indexarc-файлов из индекса картиночного базового поиска
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/tools/tarcview/images_tarcview'
    release_subscribers = images_index_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONITORING_PYTHON_CLIENT_EXECUTABLE(AbstractResource):
    """
        Клиент сервера мониторинга на питоне
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    arcadia_path = 'extsearch/images/functionality/monit_robot_process/monit_client/monit_client.py'
    releasers = ['anskor', 'anoh', 'shashkin']
    release_subscribers = ['anskor', 'anoh', 'augolubtsov', 'ilnaz', 'redwaan']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONITORING_CLIENT_EXECUTABLE(AbstractResource):
    """
        Клиент сервера мониторинга
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'extsearch/images/functionality/monit_robot_process/monit_client/bin'
    releasers = ['anskor', 'anoh', 'shashkin']
    release_subscribers = ['anskor', 'anoh', 'augolubtsov', 'ilnaz', 'redwaan']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_ACCEPTANCE_CONFIG(AbstractResource):
    """
        Config file for REARRANGE_ACCEPTANCE_2 tests
    """
    any_arch = True
    arcadia_path = "sandbox/projects/release_machine/tasks/RearrangeAcceptance2/config/config"
    auto_backup = True
    releasable = True
    releasers = ["alex-sh", "epar", "nkmakarov"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRS_UNRATER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл prs_unrater
    """
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_THUMBS_PLAN(AbstractResource):
    """
        План обстрела тумбового контура для проверок консистентности
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_CBIR_PLAN(AbstractResource):
    """
        План обстрела поиска по картинке для проверок адекватности
    """
    any_arch = True
    executable = False
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD(AbstractResource):
    """
        Conveyor dashboard project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_SHARD(AbstractResource):
    """
        Conveyor dashboard shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_FRONT(AbstractResource):
    """
        Conveyor dashboard project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_FRONT_SHARD(AbstractResource):
    """
        Conveyor dashboard shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_FRONT_PROXY_MONOLITH_PACKAGE(AbstractResource):
    """
        Conveyor dashboard front proxy monolith package
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_CACHER(AbstractResource):
    """
        Conveyor dashboard project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_CACHER_SHARD(AbstractResource):
    """
        Conveyor dashboard shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_BUSINESS_LOGIC(AbstractResource):
    """
        Conveyor dashboard project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CONVEYOR_DASHBOARD_BUSINESS_LOGIC_SHARD(AbstractResource):
    """
        Conveyor dashboard shard
    """
    shard = True
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NIRVANA_WORKFLOW_SNAPSHOT(AbstractResource):
    """
        Conveyor dashboard shard
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_CONVEYOR_AUTO_FORMULAS_SNAPSHOT(AbstractResource):
    """
        fml conveyor auto-formulas snapshot
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_CONVEYOR_FML_PROCESS_TEMPLATES_LIST_REPORT(AbstractResource):
    """
        fml conveyor fml_process_template conveyor/setup report
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_CONVEYOR_FORMULA_COMMIT_REPORT(AbstractResource):
    """
        fml conveyor formula_commit report
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_CONVEYOR_FORMULA_COMMIT_REPORT_EXTENDED(AbstractResource):
    """
        fml conveyor formula_commit extended report
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRAIN_MATRIXNET_ON_CPU_MR_LOCAL_OP(AbstractResource):
    """
        Train matrixnet on cpu MR LOCAL Nirvana operation id holder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRAIN_MATRIXNET_ON_CPU_MR_MS_OP(AbstractResource):
    """
        Train matrixnet on cpu MR MS Nirvana operation id holder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRAIN_MATRIXNET_ON_CPU_TSV_LOCAL_OP(AbstractResource):
    """
        Train matrixnet on cpu TSV LOCAL Nirvana operation id holder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TRAIN_MATRIXNET_ON_CPU_TSV_MS_OP(AbstractResource):
    """
        Train matrixnet on cpu TSV MS Nirvana operation id holder
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['algorc', 'kirillovs', 'annaveronika', 'vitekmel']
    release_subscribers = ['algorc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_INVINDEX_OFFROAD_MODEL_ARCHIVE(AbstractResource):
    """
        Архив с компрессионными offroad-модельками для аннотационного индекса в картинках
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'rymis']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PANTHER_OFFROAD_INDEX_MODEL_ARCHIVE(AbstractResource):
    """
        Архив с компрессионными offroad-модельками для indexpanther.offroad.(key|inv) в картинках
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PANTHER_OFFROAD_INDEX_KEY_MODEL(AbstractResource):
    """
        Компрессионная моделька для indexpanther.offroad.key в картинках
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PANTHER_OFFROAD_INDEX_INV_MODEL(AbstractResource):
    """
        Компрессионная моделька для indexpanther.offroad.inv в картинках
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PANTHER_COUNTS_KEY_BOUNDS(AbstractResource):
    """
        Список ключей, определяющих границы отрезков для группировки тонких ключей.
        Используется для ускорения при формировании порций panther counts.
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'v01d']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_PANTHER_FREQUENT_KEYS(AbstractResource):
    """
        Список часто встречающихся ключей, используется при построении пантеры.
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'v01d']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SHARD_TO_SSD(AbstractResource):
    """
    Script for copying shard to ssd with persistent locking
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.multsearch


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PC_QUERYDATA_INDEXER_EXECUTABLE(AbstractResource):
    """
        querydata_indexer executable for pairwise clicks process
    """
    executable = True
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = ['robot-fast-clicks', 'olegator']
    arcadia_build_path = 'yweb/querydata/querydata_indexer/querydata_indexer'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISEO_FAKELINKS_DIR(AbstractResource):
    """
        prototext + protobin файлы с фейковыми ссылками.
        ISSUE: ANTISEO-151
    """
    readable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABRO_TEST_RESOURCE(AbstractResource):
    """
    Resource used in Yandex.Browser tests
    """
    executable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YOBJECT_EXECUTABLE(AbstractResource):
    """
        Yobject (Yandex.Kartochka) backend binary
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = yobject_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YOBJECT_DATA(AbstractResource):
    """
        Yobject (Yandex.Kartochka) backend data
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = yobject_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YOBJECT_CONFIG(AbstractResource):
    """
        Yobject (Yandex.Kartochka) config
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = yobject_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YOBJECT_DUMP(AbstractResource):
    """
        Yobject (Yandex.Kartochka) responce and log dump
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = yobject_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YOBJECT_DIFF(AbstractResource):
    """
        Yobject (Yandex.Kartochka) responce and log diff
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = yobject_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CBIR_COMPARER_EXECUTABLE(AbstractResource):
    """
        Утилита для оценки похожести картинок со стандартного входа
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/tools/cbircomparer/cbir_comparer'
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_QUERY_FILTER_EXECUTABLE(AbstractResource):
    """
        Утилита для фильтрации запросов с атрибутами
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_releasers
    arcadia_build_path = 'extsearch/images/tools/query_filter/query_filter'
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GRIMHOLD_BANS_ENCRYPTED(AbstractResource):
    """
        Grimhold bans
        Attributes:
            date = (YYYY-MM-DD)
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = adult_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERF_STATS_WIZARD_DATA(AbstractResource):
    """
    Данные для Rerf stats wizard.
    См. https://github.yandex-team.ru/performance/perf-stats-wizard
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADULT_HOST_LIST(AbstractResource):
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = adult_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_YTSTAT_BASE(AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['abordonos', 'alesap', 'danilgrig', 'keyd', 'say', 'yabsstartrek']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_YTSTAT_COLLECTOR(YABS_YTSTAT_BASE):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_YTSTAT_SANDBOX(YABS_YTSTAT_BASE):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["say", "nyaapa", "kiwi", "yabsstartrek"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_YTSTAT_SUPERVISOR(YABS_YTSTAT_BASE):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["say", "yabsstartrek"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_YTSTAT_LB_READER(YABS_YTSTAT_BASE):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ["say", "nyaapa", "kiwi", "inngonch", "radolga", "yabsstartrek"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ITERATION_DATA(AbstractResource):
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_PERS_DATA(AbstractResource):
    """
       Data for news personalization
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['robot-ynews', 'yurifrolov', 'sgrb', 'quick']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class QUERY_SURPLUS(AbstractResource):
    """
        Data which contain queries and surplus for some intent
        Tab-separated format, first field is a query, second - surplus value
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_SERVER_PREDICT_LOAD_EXECUTABLE(AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    calc_md5 = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BS_RELEASE_RTB(AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = [
        'yabsstartrek',
        'rmcf',
        'fdrstrok',
        'vstromov',
        'mirage',
        'robot-yabs-rt',
        'robot-cache-proxy',
    ]
    restart_policy = ctr.RestartPolicy.DELETE
    ttl = 42


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REARRANGE_RULE_OBJECT(AbstractResource):
    """
        Object for rearrange rule (trie, text file, etc.)
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ML_ENGINE_DUMP(AbstractResource):
    """
        Архив с дампом линейной модели или matrixnet
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TOOLS_CAAS_BACKEND_CONFIG(AbstractResource):
    """
        Конфигурация бекэндов для CaaS
    """
    auto_backup = True
    releasers = tools_releasers
    ttl = 365


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TOOLS_CAAS_PROXY_CONFIG(AbstractResource):
    """
        Конфигурация прокси для CaaS
    """
    auto_backup = True
    releasers = tools_releasers
    ttl = 365


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LINEAR_MODEL_BINARY_DUMP(AbstractResource):
    """
        Бинарный дамп линейной модели
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LINEAR_MODEL_SHARDING_BASE(AbstractResource):
    """
        Pibf key-value storage ns_value->base_no
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TOP_MUSCIANS_LIST(AbstractResource):
    """
        File with top musician count by ppb_post_logs
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DBMERGE_TOOL(AbstractResource):
    """
        gemini dbmerge binary
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.wizard_releasers
    arcadia_build_path = 'robot/gemini/mr/dbmerge'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ALTAY_UNIFIER_API(AbstractResource):
    """
        unifier api
    """
    auto_backup = True
    releasable = True
    releasers = ['elfadina']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_METRICS_API_SCRIPT(AbstractResource):
    """
        Скрипт extsearch/images/functionality/tools/metrics_api.py.
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['anoh', 'robot-imgrq', 'robot-img-ontosearch']
    arcadia_path = 'extsearch/images/functionality/tools/metrics_api.py'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_STATE_ACCEPTOR_SCRIPT(AbstractResource):
    """
        Скрипт extsearch/images/functionality/tools/accept_state.py
    """
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['anoh', 'robot-imgrq', 'robot-img-ontosearch']
    arcadia_path = 'extsearch/images/functionality/tools/accept_state.py'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POOL_SAMPLER_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл pool_sampler
    """
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_BSCATALOGIA_IMAGE(AbstractResource):
    """
        Образ porto контейнера для проекта bscatalogia
    """
    auto_backup = True
    releasable = True
    releasers = ['smishin', 'zheglov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_BSCATALOGIA_DICTIONARIES(AbstractResource):
    """
        Словари yabs_bscatalogia
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FLAME_GRAPH_BUNDLE(AbstractResource):
    """
        Bundle with flame-graph tools
    """
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GPROF2DOT_BUNDLE(AbstractResource):
    """
        Bundle with gprof2dot tools
    """
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FLAME_GRAPH_STACKS_FILE(AbstractResource):
    """
        Collapsed stacks
    """
    releasable = False
    any_arch = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FLAME_GRAPH_SVG(AbstractResource):
    """
        Flame graph SVG output. Should be backed up as they are small.
    """
    releasable = False
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FML_MX_OPS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл mx_ops
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['qdeee']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEMINI_SAMPLED_DATA(AbstractResource):
    """
        Sampled data for Gemini data base merge testing
    """
    auto_backup = True
    ttl = 365


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SCRAPER_CLI_EXECUTABLE(AbstractResource):
    """
        Scraper command line interface
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['vdf', 'lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TICKENATOR(AbstractResource):
    """
        Tickenator tgz(virtualenv + bins)
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.marty


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS(AbstractResource):
    """
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = freshness_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_EXTERNAL(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_FEATURES(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_METRICS(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_NEWS_WIZARD(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_POOLS(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_SPOK(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_KWWORM(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_GEMINICL(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_YT_CLI(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_BINS_INFRA(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_LIBLEMMER_PYTHON(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESHNESS_SCRIPTS(FRESHNESS_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RELEASABLE_DUMMY(AbstractResource):
    """
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = freshness_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAPPS_PROD_TARBALL(AbstractResource):
    """
        tarball as opposed to MRAPPS_PROD_PACKAGE
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['trofimenkov', 'nkmakarov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MRAPPS_DEV_TARBALL(AbstractResource):
    """
        tarball as opposed to MRAPPS_DEV_PACKAGE
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['trofimenkov', 'nkmakarov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_CONFIG_AUTOPLAYER(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_CONFIG_UNBAN(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_RKN_BAN(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_INDEX_INFO(AbstractResource):
    """
        Video index state info (includes doc, search attrs, etc.)
        intended to validate index correctness. Used in acceptance.
    """
    releasable = True
    executable = False
    auto_backup = True
    releasers = ['robot-video-acc', 'matveieff', 'tolich', 'mago-nn', 'robot-video']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_SEARCHAPI_BINARY(AbstractResource):
    """
        Jars for sitesearch-searchapi service
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VPS_CACHE_DIST(AbstractResource):
    """
        Jars for Vaas Cache
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_MR_CATALOGIA(AbstractResource):
    """
        Tar archive with all data needed to run catalogia on YAMR.
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_MR_CATALOGIA_EXTERNAL(AbstractResource):
    """
        Tar archive with some extras to build BROADMATCH_MR_CATALOGIA.
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_MR_CATALOGIA_RAW(AbstractResource):
    """
        Tar archive of raw data from production catalogia.
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_COMPTRIE_BUILDER(AbstractResource):
    """
        Subphraser init data to comptrie builder
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_CATEGORIZATION_COMPTRIE(AbstractResource):
    """
        Subphraser comptrie data
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_CATEGORIZATION_SUBPHRASER(AbstractResource):
    """
        Subphraser data
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_CATEGORIES_SUPPRESSION_DICT(AbstractResource):
    """
        Preprocessed categories suppression dict
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BROADMATCH_FORECAST_DICTS(AbstractResource):
    """
        Dicts for broadmatch forecasts
    """
    auto_backup = True
    releasable = True
    releasers = broadmatch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_RECOMMENDER_WORD_2_VEC(AbstractResource):
    """
        Word2vec data for Video recommender
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['vvp']
    release_subscribers = ['vvp']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DOCBASE_NO_INDEX_HOST_DB(AbstractResource):
    """
        NoIndex HostDB
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DOCBASE_SPAMWHITELIST(AbstractResource):
    """
        Spamwhitelist
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = video_subscribers
    arcadia_path = 'yweb/webscripts/video/canonize/config'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DOCBASE_CANONIZATION_CONFIG(AbstractResource):
    """
        Canonization configs
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = video_subscribers
    arcadia_path = 'yweb/webscripts/video/canonize/config'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SERIALS_TXT(AbstractResource):
    """
        List of serials for video robot
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SERIALS_TRIE(AbstractResource):
    """
        Serials for video robot
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_TIC_OVER30(AbstractResource):
    """
        fltic_over30.txt
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_SERIALSYNS_TRIE(AbstractResource):
    """
        Synonyms of serials for video robot
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DOCBASE_MASK_TRIE(AbstractResource):
    """
        Spam calculator mask_export.trie
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_DOCBASE_OWNER_TRIE(AbstractResource):
    """
        Spam calculator owner_export.trie
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.video_robot_releasers
    release_subscribers = video_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_NANNY_CACHE(AbstractResource):
    """
        Служебные файлы для таска ADDRS_LOAD
    """
    auto_backup = True
    releasable = True
    releasers = ['GEOSEARCH_PROD']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_LOAD_STATISTICS(AbstractResource):
    """
        Статистика по стрельбам из таска ADDRS_LOAD
    """
    auto_backup = True
    releasable = True
    releasers = ['GEOSEARCH_PROD']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_BUSINESS_SHARD(AbstractResource):
    """
        SaaS-ный шард для addrs business
    """
    auto_backup = True
    releasable = True
    releasers = ['GEOSEARCH_PROD']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_BUSINESS_SHARDMAP(AbstractResource):
    """
        SaaS-ный шард для addrs business
    """
    auto_backup = True
    releasable = True
    releasers = ['GEOSEARCH_PROD']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_INDEXER_DATA(AbstractResource):
    """
        Данные для addrs_indexer
    """
    auto_backup = True
    releasable = True
    releasers = ['GEOSEARCH_PROD']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADDRS_DYNAMIC_MODELS_ARCHIVE(AbstractResource):
    """
        Архив с динамическими моделями базового и среднего геопоиска
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TESTENV_DB_BACKUP(AbstractResource):
    """
        Дамп базы данных Testenv
    """
    auto_backup = True
    releasable = True
    releasers = ['artanis']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PRISM_DB_BACKUP(AbstractResource):
    """
        Дамп базы данных mongodb PRISM
    """
    auto_backup = True
    releasable = True
    releasers = ['artanis']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REVIEWBOARD_DB_BACKUP(AbstractResource):
    """
        Дамп базы данных ReviewBoard
    """
    auto_backup = True
    releasable = True
    releasers = ['artanis']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POETRYLOVER_SHARDMAP(AbstractResource):
    """
        PoetryLover shardmap
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = ['regress', 'robot-muzsearch']
    shardmap = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LM_MATCHER_STATE(AbstractResource):
    """
        Архив с состоянием модели lm_matcher
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LB_SAAS_RESPONSES(AbstractResource):
    """
        TSV с сырыми ответами от SaaS лингвобустинга
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTIMALWARE_SOPHOS_UDF(AbstractResource):
    """
        Built SophosAV UDF for Kiwi
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOPHOS_ENGINE_AND_DATABASES(AbstractResource):
    """
        Latest Sophos Antivirus engine, virus databases and updates and
        archived copy of everything (needed for sav-download tool)
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YACONTEXT_ROBOTSTXT_DB_YANDEXBOT(AbstractResource):
    """
        Latest robots.txt database for YandexBot user agent
    """
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_ASSISTANT_DATA(AbstractResource):
    """
        market/guruassistant related resource
    """
    releasable = True
    releasers = market_kgb_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_ASSISTANT_AUTO_WHEELS(AbstractResource):
    """
        market/guruassistant related resource
        required to build MARKET_GURU_ASSISTANT_DATA
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_TARANTINO_DATA(AbstractResource):
    """
        market/tarantino related resource
    """
    releasable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_DATA_CATEGORY(AbstractResource):
    """
        market/gurudaemon related resource
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_MBO_MODEL_PARAMETERS(AbstractResource):
    """
        market/backoffice related resource
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_MBO_PARAMSDUMP(AbstractResource):
    """
        market/guruassistant related binary
        required to build MARKET_GURU_ASSISTANT_DATA
    """
    releasable = False
    executable = True
    any_arch = False
    arcadia_build_path = 'market/assistant/assistantbase/mbo_parameter_dump/mbo_parameter_dump'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_ENUMSDUMP(AbstractResource):
    """
        market/guruassistant related binary
        required to build MARKET_GURU_ASSISTANT_DATA
    """
    releasable = False
    executable = True
    any_arch = False
    arcadia_build_path = 'market/gurudaemon/bin/enumsdump/enumsdump'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_ASSISTANT_PRINTGURUASS(AbstractResource):
    """
        market/guruassistant related binary
        required to build MARKET_GURU_ASSISTANT_DATA
    """
    releasable = False
    executable = True
    any_arch = False
    arcadia_build_path = 'market/assistant/printguruass/printguruass'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_ASSISTANT_BIN(AbstractResource):
    """
        market/guruassistant server
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/assistant/guruassistant/guruassistant-bin'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_TARANTINO_BIN(AbstractResource):
    """
        market/tarantino server
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/tarantino/tarantino-server'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_TARANTINO_CACHEPINGER_BIN(AbstractResource):
    """
        market/tarantino cachepinger
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/tarantino/cachepinger'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_CATALOGER_BIN(AbstractResource):
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/cataloger'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_CATALOGER_BIN_ONLINE(MARKET_CATALOGER_BIN):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_CATALOGER_PLAN(AbstractResource):
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_BIN(AbstractResource):
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/gurudaemon'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_BIN_ONLINE(MARKET_GURU_BIN):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_BUKER_BIN(AbstractResource):
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = market_kgb_releasers
    arcadia_build_path = 'market/buker'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_BUKER_BIN_ONLINE(MARKET_BUKER_BIN):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_BUKER_PLAN(AbstractResource):
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_CATALOGER_DATA(AbstractResource):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_GURU_DATA(AbstractResource):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_BUKER_DATA(AbstractResource):
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_TEMPLATER_CONFIG(AbstractResource):
    """
        Market templater configurations
    """
    releasable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SERVICE_CONFIG(AbstractResource):
    """
        Market configurations of service
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SERVICE_INSTANCECTL_CONFIG(AbstractResource):
    """
       Market configuration of instancectl
    """
    releasable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SERVICE_INSTALL_SCRIPT(AbstractResource):
    """
       Market script to install services
    """
    releasable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_DOCKER_RESOURCE(AbstractResource):
    """
        Market sources for docker building
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GOLANG_SOURCES(AbstractResource):
    """
        Clear sources of golang
    """
    releasable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_QUOTES_EXECUTABLE(AbstractResource):
    """
        News.Quotes daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_ROUTERD_EXECUTABLE(AbstractResource):
    """
        News.Routerd daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_APPHOST_DUMPERD_EXECUTABLE(AbstractResource):
    """
        News.Dumperd daemon for AppHost
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SYM_NEWS_APPHOST_QUOTES_EXECUTABLE(NEWS_APPHOST_QUOTES_EXECUTABLE):
    """
        Symbols for News.Quotes daemon
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SYM_NEWS_APPHOST_ROUTERD_EXECUTABLE(NEWS_APPHOST_ROUTERD_EXECUTABLE):
    """
        Symbols for News.Routerd daemon
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SYM_NEWS_APPHOST_DUMPERD_EXECUTABLE(NEWS_APPHOST_DUMPERD_EXECUTABLE):
    """
        Symbols for News.Dumperd daemon
    """
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_CATALOG_INDEXER_BINARY(AbstractResource):
    """
        Jars for sitesearch-searchapi service
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LM_DUMP_TSV(AbstractResource):
    """
        Архив с дампом линейной модели в tsv-формате
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LM_MATCHER_INDEX(AbstractResource):
    """
        Индекс для lm_matcher
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESOURCES_TO_YT_PACKAGE(AbstractResource):
    """
        Package с бинарником кода заливки ресурсов в Yt
    """
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UGC_CASSANDRA(AbstractResource):
    """
        Касандра для UGC
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['petrk', 'galaxycrab', 'radix', 'juliana-zh']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UGC_JAVA(AbstractResource):
    """
        JDK + Smth related для кассандры в UGC
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = ['petrk', 'galaxycrab', 'radix', 'juliana-zh']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROJECT_STUB_NODEJS_PACKAGE(AbstractResource):
    """
        Project Stub пакет с приложением на NodeJS
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROJECT_STUB_NODEJS_ARTIFACT(AbstractResource):
    """
        Project Stub пакет с артефактами сборки и прогонки тестов
    """
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class WEBVISOR_BINARY(AbstractResource):
    """
        Webvisor jar-binary
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TECARD_PACKAGE(AbstractResource):
    """
        Test Environment Card
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TESTENV_CHARTS_EXPORT(AbstractResource):
    """
        Charts exported from Testenv.
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ICOOKIE_DAEMON_EXECUTABLE(AbstractResource):
    """
        Executable icookiedaemon
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['valgushev']
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ICOOKIE_DAEMON_ARCHIVE(AbstractResource):
    """
        Archive with icookiedaemon
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['valgushev']
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ICOOKIE_BLACKLIST_ARCHIVE(AbstractResource):
    """
        Archive with icookie blacklist
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = ['valgushev']
    release_subscribers = ['valgushev']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEMPLAR_NODE_MODULES_BUNDLE(AbstractResource):
    """
        Templar and node_modules bundle
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTYSERVER_SEARCH_DATABASE(AbstractResource):
    """
      Папка с шардом базы rtyserver'а
    """
    auto_backup = True
    shard = True
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ACTIVEMQ_DIST(AbstractResource):
    """
        ActiveMQ distrubution
    """
    releasable = True
    any_arch = False
    executable = False
    releasers = resource_releasers.vps_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GENERATE_LM_DUMPS_BINARY(AbstractResource):
    """
        Binary program for generating binary linear model dumps
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ads_quality_releasers
    release_subscribers = ads_quality_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAKE_LM_SHARDING_BASE_BINARY(AbstractResource):
    """
        Binary program for generating linear model sharding base
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ads_quality_releasers
    release_subscribers = ads_quality_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VWDUMP_BINARY(AbstractResource):
    """
        vwdump binary program
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ads_quality_releasers
    release_subscribers = ads_quality_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LM_DUMPS_LIST(AbstractResource):
    """
        List with linear models dumps resource_ids
    """
    releasable = True
    auto_backup = True
    releasers = ads_quality_releasers
    release_subscribers = ads_quality_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITESEARCH_CATALOG_INDEXER_ZORA_BINARY(AbstractResource):
    """
        Rds zora for sitesearch-indexer service
    """
    releasable = True
    any_arch = False
    releasers = ['aleksart', 'iceflame']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CLICKDAEMON_KEYS(AbstractResource):
    """
        Clickdaemon keys
    """
    releasable = True
    any_arch = True
    auto_backup = True
    releasers = clickdaemon_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NORMALIZE_REQUESTS_EXECUTABLE(AbstractResource):
    """
        Requests normalizer executable
    """
    releasable = True
    executable = True
    any_arch = False
    arcadia_build_path = 'tools/normalize_requests/normalize_requests'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNPACKRICHTREE(AbstractResource):
    """a tool that makes qtrees readable"""
    any_arch = False
    executable = True
    arcadia_build_path = 'tools/unpackrichtree/unpackrichtree'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UNPACKREQBUNDLE(AbstractResource):
    """a tool that makes reqbundle readable"""
    any_arch = False
    executable = True
    arcadia_build_path = 'quality/relev_tools/lboost_ops/unpackreqbundle/unpackreqbundle'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPERIMENT_BINS(AbstractResource):
    """
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LTV_BINS(EXPERIMENT_BINS):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HG_BUNDLE(AbstractResource):
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TWEMPROXY_PACKAGE(AbstractResource):
    """
        twemproxy binary package.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KOMUTATOR_EXECUTABLE(AbstractResource):
    """
        Komutator executable
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = ['stakanviski', 'fyodor', 'denisbykov', 'qqq', 'nataxane', 'koplyarov', 'rufrozen', 'kamchii']
    release_subscribers = releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAIL_PYTHON_HAMON(PYTHON_WHEEL):
    """DEPRECATED in favor of MAIL_PYTHON_USER_EVENTS"""
    releasers = PYTHON_WHEEL.releasers + ["prez", "elsid", "dskut", "robot-dogwalker"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAIL_PYTHON_USER_EVENTS(PYTHON_WHEEL):
    """
        `.whl` file with python package "mail-user-events" for maildev team.
        Distinct resource type is needed for REM, because it doesn't support
        search by attributes.
    """
    releasers = PYTHON_WHEEL.releasers + ["prez", "elsid", "dskut", "kremenkov", "robot-dogwalker"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAIL_PYTHON_SCARAB(PYTHON_WHEEL):
    """
        `.whl` file with python package "scarab" for maildev team.
        Distinct resource type is needed for REM, because it doesn't support
        search by attributes.
    """
    releasers = PYTHON_WHEEL.releasers + ["prez", "elsid", "dskut", "robot-dogwalker"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_STATIC_PACKAGE(AbstractResource):
    """
        Архив со статикой
    """
    any_arch = True
    releasable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEO_VOICE_METRICS_BINARY(AbstractResource):
    """
        Compiled voice metrics binary
    """
    executable = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RKN_VIEWER(AbstractResource):
    """
        Дистрибутив приложения для news-rkn.viewer.yandex-team.ru
    """
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DSSM_MODEL(AbstractResource):
    """
        Dssm models
    """
    readable = True
    releasable = True
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_FASTANNDATA(AbstractResource):
    """
        Исполняемый файл для добавления аннотационных данных из большого индекса.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'extsearch/images/robot/userdata/fastanndata/main/fastanndata'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_MR_INDEX_FASTMATCHERMR(AbstractResource):
    """
        Исполняемый файл для склеивания полудубликатов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_index_releasers
    release_subscribers = images_mrindex_subscribers
    arcadia_build_path = 'cv/semidups/fastmatcher/fastmatchermr/fastmatchermr'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANALYZETHIS_IPREG(AbstractResource):
    """
        Ashmanov's ips as IPREG file
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VH_MESSAGE_TEMPLATES(AbstractResource):
    """
        html шаблоны
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VH_LUA_TEMPLATES(AbstractResource):
    """
        lua шаблоны
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROMO_STATIC(AbstractResource):
    """
        Static for promo pages
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HG_EXTERNAL(AbstractResource):
    """
        Resource uploaded during Hg history filtration
    """
    releasable = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PGO_PROFILE_RESOURCE(AbstractResource):
    """
        Профиль PGO
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REPORT_CHECK_AUTOTEST_STATUS(AbstractResource):
    """
        список тасков репорта (в стартреке) без автотестов
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LBOOST_OPS_EXECUTABLE(AbstractResource):
    """
        Main executable for lingboost expansions quality tests
    """
    any_arch = False
    executable = True
    releasable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GOLANG_PACKAGE(AbstractResource):
    """
        Golang distributive
    """
    releasable = True
    any_arch = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQWIZARD_REALTIME_DATA(AbstractResource):
    """
        Realtime data for reqwizard
    """
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQWIZARD_REALTIME_DATA_REPORT(REQWIZARD_REALTIME_DATA):
    """
        Realtime data for reqwizard Report rule
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class REQWIZARD_REALTIME_DATA_REARRMARKER(REQWIZARD_REALTIME_DATA):
    """
        Realtime data for reqwizard RearrMarker rule
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_CMS_VIRTUAL_ENV(AbstractResource):
    """
    venv archive for yt cms deps
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = yt_ops


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_CMS_CODE_TAR(AbstractResource):
    """
    yt cms source
    """
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = yt_ops


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_COMPRESSED_CONFIGS_ROOT(AbstractResource):
    """
        tar.gz конфигов различных окружений Я.Диска
    """
    releasable = True
    auto_backup = True
    releasers = disk_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_COMPRESSED_RESOURCE_STABLE(DISK_COMPRESSED_CONFIGS_ROOT):
    """
        tar.gz for stable env
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_COMPRESSED_RESOURCE_PRESTABLE(DISK_COMPRESSED_CONFIGS_ROOT):
    """
        tar.gz for prestable env
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_COMPRESSED_RESOURCE_TESTING(DISK_COMPRESSED_CONFIGS_ROOT):
    """
        tar.gz for testing env
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_COMPRESSED_RESOURCE_APPLICATION(DISK_COMPRESSED_CONFIGS_ROOT):
    """
        tar.gz for compressed application stuff
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_MARKET_REPORT_MONEY_RESULT_JSON(AbstractResource):
    """
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAROCK_ABGAME_MONGO_BACKUP(AbstractResource):
    """
        Бекап базы abgame в поисковом облаке
        владелец: redwaan@
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CUSTOM_PROTODIFF_SKIP_FIELDS(AbstractResource):
    """
        JSON with unnecessary for comparing field names for protodiff tools.
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YACONTEXT_TRAGIC_PHRASES(AbstractResource):
    """
        Список трагичных фраз для блокировки рекламы.
    """
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NIRVANA_ONLINE_LEARNING_STATE(AbstractResource):
    """
    State of the online learning process. Contains all necessary information about prevous models
    and all information required to continue online learning process
    """
    auto_backup = True  # бекапить ресурс сразу после создания
    restart_policy = ctr.RestartPolicy.RESET  # что делать с ресурсом в момент перезапуска таска FIXME: неясно, правильно ли это
    releasers = ads_quality_releasers  # список людей, которые имеют права на релиз ресурсов данного типа
    release_subscribers = ads_quality_subscribers  # список людей, которым придёт уведомление при релизе ресурса данного типа


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NIRVANA_ONLINE_LEARNING_NEW_GRAPHS(AbstractResource):
    """
    Something something
    """
    auto_backup = True  # бекапить ресурс сразу после создания
    restart_policy = ctr.RestartPolicy.RESET  # что делать с ресурсом в момент перезапуска таска FIXME: неясно, правильно ли это
    releasers = ads_quality_releasers  # список людей, которые имеют права на релиз ресурсов данного типа
    release_subscribers = ads_quality_subscribers  # список людей, которым придёт уведомление при релизе ресурса данного типа


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_LEARNING_FEATURE_MAP(AbstractResource):
    """
    Something something
    """
    auto_backup = True  # бекапить ресурс сразу после создания
    restart_policy = ctr.RestartPolicy.RESET  # что делать с ресурсом в момент перезапуска таска FIXME: неясно, правильно ли это
    releasers = ads_quality_releasers  # список людей, которые имеют права на релиз ресурсов данного типа
    release_subscribers = ads_quality_subscribers  # список людей, которым придёт уведомление при релизе ресурса данного типа


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_LEARNING_DUMP_TXT(AbstractResource):
    """
    Something something
    """
    auto_backup = True  # бекапить ресурс сразу после создания
    restart_policy = ctr.RestartPolicy.RESET  # что делать с ресурсом в момент перезапуска таска FIXME: неясно, правильно ли это
    releasers = ads_quality_releasers  # список людей, которые имеют права на релиз ресурсов данного типа
    release_subscribers = ads_quality_subscribers  # список людей, которым придёт уведомление при релизе ресурса данного типа


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_FLOWKEEPER_BINARY(AbstractResource):
    """Program ads/nirvana/online_learning/run_flowkeeper"""
    releasable = True
    auto_backup = True  # бекапить ресурс сразу после создания
    releasers = ads_online_learning_releasers
    release_subscribers = ads_online_learning_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_GRAPH_LAUNCHER_BINARY(AbstractResource):
    """Program ads/nirvana/online_learning/graph_launcher"""
    releasable = True
    auto_backup = True
    releasers = ads_online_learning_releasers
    release_subscribers = ads_online_learning_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ONLINE_GRAPH_LAUNCHER_CREATE_DUMP_TXT_BINARY(AbstractResource):
    """Program ads/nirvana/online_learning/graph_launcher"""
    releasable = True
    auto_backup = True
    releasers = ads_online_learning_releasers
    release_subscribers = ads_online_learning_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YASAP_PDB_QUALITY_DP(AbstractResource):
    """
        DP web-server.
    """
    any_arch = False
    executable = True
    auto_backup = True
    releasable = True
    releasers = resource_releasers.collections_releasers
    arcadia_build_path = 'yweb/yasap/pdb/quality/dp/app'
    arcadia_build_name = 'dp'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_RESPONSES_ARCHIVE(AbstractResource):
    """
        Директория с ответами произвольного Http-сервиса
            * текстовый файл с кодами возврата и заголовками
            * tar-архив с файлами ответов, названными по запросам
    """
    meta_file = 'meta.txt'
    archive_file = 'data.tar.gz'
    data_dir = 'data'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_ODIN(AbstractResource):
    """
    project archive
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['alximik', 'k-malov']
    release_subscribers = ['k-malov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADVQUICK_BINARY(AbstractResource):
    """
        Advquick static binary.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADVQUICK_DATABASE(AbstractResource):
    """
        Advquick akitaregs database
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADVQ_BINARY(AbstractResource):
    """
        Advq static binary.
    """
    releasable = True
    any_arch = False
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADVQ_PHITS_DATABASE(AbstractResource):
    """
        Advq phits database
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADVQ_SUMHITS_DATABASE(AbstractResource):
    """
        Advq sumhits database
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POKAZOMETER_BINARY(AbstractResource):
    """
        Pokazometer (advq whale) binary
    """
    releasable = True
    any_arch = False
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POKAZOMETER_DATABASE_CLICKS(AbstractResource):
    """
        Pokazometer (advq whale) database - click_hits*
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class POKAZOMETER_DATABASE_SHOWS(AbstractResource):
    """
        Pokazometer (advq whale) database - hits_by_region_cost
    """
    releasable = True
    any_arch = True
    auto_backup = True
    ttl = 'inf'
    releasers = resource_releasers.direct_sre + advq_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DIRECT_SECRETS_ARC(AbstractResource):
    """
        Архив для хранения зашифрованных файлов Директа
    """
    releasable = True
    releasers = resource_releasers.direct_sre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_EXPERIMENTS_TAGS_YA_PACKAGE(AbstractResource):
    """
        Package for sending experiments tags to Razladki (USEREXP-3614)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_PRODUCTS_STATISTICS_YA_PACKAGE(AbstractResource):
    """
        Package for sending ABT products statistics to Razladki (USEREXP-4279)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_TESTS_DELAYS_YA_PACKAGE(AbstractResource):
    """
        Package for sending tests delays to Razladki (USEREXP-3925)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class AB_TESTING_PICOLERA_PACKAGE(AbstractResource):
    """
        Package for sending [not only] starred metrics to Razladki (USEREXP-4150)
    """
    any_arch = True
    releasable = True
    releasers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SELECTIONRANK_KIT(AbstractResource):
    """
        Selection rank kit format
    """
    readable = True
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PROD_SELECTIONRANK_KIT(AbstractResource):
    """
        For convinient production updates
    """
    readable = True
    any_arch = True
    executable = False
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HBASE_ARCHIVE(AbstractResource):
    """
        Tar with Hbase database
    """
    auto_backup = True
    releasers = ['hvost239', 'kgorelov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HITROBOT_MSI(AbstractResource):
    """
        Hitrobot's installer
    """
    readable = True
    calc_md5 = False
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMP_NGINX(AbstractResource):
    """
        nginx для Yandex AMP Cacher
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMP_BACKEND(AbstractResource):
    """
        backend для Yandex AMP Cacher
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMP_CLOUD_INSTANCE_WRAPPER(AbstractResource):
    """
        для Yandex AMP Cacher
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMP_JS_LIBRARY(AbstractResource):
    """
        для Yandex AMP Cacher
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = False
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAMP_JS_LIBRARIES_BUNDLE(AbstractResource):
    """
        для Yandex AMP Cacher
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = False
    releasers = ['trofimenkov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RESULT_CHECKER_ERRORS(AbstractResource):
    """
        отчеты об ошибках от таска WEB_RESULT_DATA_CHECKER
    """
    releasable = False
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BOTANIK_SITE_REACHABILITY_YT(AbstractResource):
    """
        [SEARCHSPAM-11006] Простукивалка забаненных хостов
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_PDEBUILD_RUN_BIN(AbstractResource):
    """
        market/pdebuild-run server
    """
    releasable = True
    executable = True
    any_arch = False
    auto_backup = True
    releasers = marketsre
    arcadia_build_path = 'market/sre/services/pdebuild-run'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ST_TASK_OOPS_100_JSON(AbstractResource):
    """
        json with (group -> instances) mapping
    """
    releasable = False
    executable = False
    any_arch = True
    auto_backup = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_RFSD(AbstractResource):
    """
        RemoteFS daemon binary, compiled statically
    """
    any_arch = False
    releasers = marketsre
    executable = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COVERAGE_REPORT(AbstractResource):
    """
        Coverage report
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_INDEX_I2T_V4_CLUSTERS(AbstractResource):
    """
        Список кластеров для фактора i2t v4, записанный через NFastTier::TBinaryProtoWriter<NKMeans::TFloatVector>
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'krivokon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_INDEX_I2T_V5_CLUSTERS(AbstractResource):
    """
        Список кластеров для фактора i2t v5, записанный через NFastTier::TBinaryProtoWriter<NKMeans::TFloatVector>
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'krivokon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_INDEX_T2T_CLUSTERS(AbstractResource):
    """
        Список кластеров для фактора t2t, записанный через NFastTier::TBinaryProtoWriter<NKMeans::TFloatVector>
    """
    executable = False
    auto_backup = True
    any_arch = True
    releasable = True
    releasers = images_releasers + ['kcd', 'ulgen4a', 'panovav', 'agorodilov', 'krivokon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SDC_RESOURCES(AbstractResource):
    """
        Data for selfdriving car project
    """
    auto_backup = True
    restart_policy = ctr.RestartPolicy.IGNORE
    share = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FUZZ_CORPUS_DATA(AbstractResource):
    any_arch = True
    share = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OFFLINE_METRICS_ONLINE_LEARNING_STATE(AbstractResource):
    """
        State for computing metrics
    """
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEMON_CAT_BINARY(AbstractResource):
    """
        demon_cat executable (tool to parse user_sessions and retrieve useful information)
        https://a.yandex-team.ru/arc/trunk/arcadia/yweb/antiporno/yt_tools/demon_cat
    """
    arcadia_build_name = 'demon_cat'
    arcadia_build_path = 'yweb/antiporno/yt_tools/demon_cat/demon_cat/bin'
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['yazevnul', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEMON_CAT_CONFIGS(AbstractResource):
    """
        demon_cat executable configs
        https://a.yandex-team.ru/arc/trunk/arcadia/yweb/antiporno/yt_tools/demon_cat
    """
    arcadia_build_name = 'demon_cat'
    arcadia_build_path = 'yweb/antiporno/yt_tools/demon_cat/demon_cat/bin'
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['yazevnul', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEMON_CAT_BINARY_LAUNCHER(AbstractResource):
    """
        wrapper around demon_cat executable (to download all external files)
        https://a.yandex-team.ru/arc/trunk/arcadia/yweb/antiporno/yt_tools/demon_cat
    """
    arcadia_build_name = 'launcher'
    arcadia_build_path = 'yweb/antiporno/yt_tools/demon_cat/demon_cat/launcher'
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['yazevnul', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEMON_CAT_DAILY_LAUNCHER(AbstractResource):
    """
        demon_cat daily launcher
        https://a.yandex-team.ru/arc/trunk/arcadia/yweb/antiporno/yt_tools/demon_cat
    """
    arcadia_build_name = 'demon_cat'
    arcadia_build_path = 'yweb/antiporno/yt_tools/demon_cat/demon_cat/launcher'
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['yazevnul', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DEMON_CAT_DAILY_LAUNCHER_CONFIG(AbstractResource):
    """
        demon_cat daily launcher config
        https://a.yandex-team.ru/arc/trunk/arcadia/yweb/antiporno/yt_tools/demon_cat
    """
    auto_backup = True
    releasable = True
    releasers = ['yazevnul', ]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FLEUR_TASK_RUNNER(AbstractResource):
    """
        Sandbox task runner built from devtools/fleur library
    """
    auto_backup = True
    releasable = True
    releasers = ["dmitko", "cepera"]


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPEECHKIT_DATASET(AbstractResource):
    """
        Learning datasets for Yandex.SpeechKit projects
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NANPU_SAMOGON_PACKAGE(AbstractResource):
    """
        Nanpu plugin for samogon
    """
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_MARKUP_ARCHIVATOR(AbstractResource):
    """
        Архиватор разметки на YT'е
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SB_DEBUILDER(AbstractResource):
    """
        sb-market-debuilder bin
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = marketsre


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PHISHING_MODEL_APPLIER(AbstractResource):
    """
        Calculate features and apply phishing model
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['limixis']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ASS_MONGODB(AbstractResource):
    """
        Mongo db for assistant
    """
    releasable = False
    any_arch = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RATELIMITER_BIN(AbstractResource):
    """
        Ratelimiter binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASS_BIN(AbstractResource):
    """
        BAss binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASS_CONFIG(AbstractResource):
    """
        BAss config
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASS_SEARCH_FIXED_ANSWERS(AbstractResource):
    """
        BAss search scenario fixed answers
    """
    releasable = True
    any_arch = True
    executable = False
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BASS_PIPE_LOG_PARSER(AbstractResource):
    """
        BAss pipe log parser
    """
    releasable = True
    any_arch = True
    executable = True
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_DEBUG_INFO(AbstractResource):
    """
        Collections' debug info service
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_USER_INFO_VIEWER(AbstractResource):
    """
        Collections' user info binary
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_VERTICALS_DETECTOR(AbstractResource):
    """
        Collections' vertical detect service
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_BACKUP_UPLOADER(AbstractResource):
    """
        Collections' tool for upload mongodump to sandbox.
    """
    any_arch = False
    auto_backup = True
    releasable = True
    releasers = resource_releasers.collections_releasers
    arcadia_build_path = 'yweb/yasap/pdb/upload_backup/bin/upload_backup'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DISK_STREAMING_PYTHON(AbstractResource):
    """
        Python-based binary for running Disk Videostreaming tasks
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class METRIKA_GEO_DATA(AbstractResource):
    """
        /opt/geo
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class KEYBOARD_DICTIONARY(AbstractResource):
    """
        Binary dictionary for Yandex.Keyboard.
    """
    releasable = True
    releasers = ['karnienko', 'myltsev', 'acvetkov', 'alex-sh']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TEST_ENVIRONMENT_PACKAGE(AbstractResource):
    """
        Python build for Test Environment
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_SUGGESTS_DICTS(AbstractResource):
    """
        Набор текстовых файлов с данными для маркетных саджестов
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VIDEO_POPULAR_CONFIG(AbstractResource):
    """
        Config for video popular service
    """
    auto_backup = True
    readable = True
    releasable = True
    releasers = video_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_MEMCACHED(AbstractResource):
    """
        memcached с -statiс, ванильный, для аркадии
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['artanis', 'nslus']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FRESH_POLIROVKA_QUERIES(AbstractResource):
    """
        Fresh queries to boost in suggest for polirovka
        https://st.yandex-team.ru/SUGGEST-237
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITE_REACHABILITY_RETRAVERSAL_BIN(AbstractResource):
    """
        [SEARCHSPAM-11197] Выставление вердиктов и планирование переобхода заблокированных урлов
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FFMPEG_BIN(AbstractResource):
    """
        ffmpeg binary built in Arcadia
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['toshik', 'eightn', 'hexagonal', 'whitefox', 'antivabo', 'risboo6909', 'intar', 'xoiss', 'rikunov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FFMPEG_BUNDLE(AbstractResource):
    """
        ffmpeg bundle built in Arcadia
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['toshik', 'eightn', 'hexagonal', 'whitefox', 'antivabo', 'risboo6909', 'intar', 'broom', 'nyoroon']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class BENTO4_BUNDLE(AbstractResource):
    """
        Bento4 tools bundle for DRM support in FAAS
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['toshik', 'eightn', 'hexagonal', 'whitefox', 'rikunov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NN_APPLIER_EXECUTABLE(AbstractResource):
    """
        nn_applier binary built in Arcadia
    """
    arcadia_build_name = 'nn_applier'
    arcadia_build_path = 'kernel/dssm_applier/nn_applier'
    any_arch = False
    auto_backup = True
    executable = True
    releasable = True
    releasers = ['borman', 'insight', 'agusakov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YDFADMIN_RESOURCE(AbstractResource):
    """
        Keeping big static objects for YDFAdmin
    """
    auto_backup = True
    releasable = True
    readable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE_REPLICATOR_CONFIG_GENERATOR(AbstractResource):
    """
        News storage replicator config generator
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_STORAGE_REPLICATOR_EXECUTABLE(AbstractResource):
    """
        News storage replicator executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_EXECUTABLE(AbstractResource):
    """
        News.Releaser executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_TEST_LAUNCHES_EXECUTABLE(AbstractResource):
    """
        News.Releaser executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_ENSURE_INDEXES_EXECUTABLE(AbstractResource):
    """
        News.Releaser ensure_indexes executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_DEPLOY_GRAPH_EXECUTABLE(AbstractResource):
    """
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_BAKE_DEPLOY_GRAPHS_EXECUTABLE(AbstractResource):
    """
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_SLAVE_NEWSD_RUNNER(AbstractResource):
    """
    """
    executable = True
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_UNPACKED_GEODATA_TZ_DATA(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_STATIC(AbstractResource):
    """
        News.Releaser static files
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_INSTANCECTL_CONF(AbstractResource):
    """
        Instancectl config for News.Releaser
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_BAKED_DEPLOY_GRAPHS(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_BAKED_DEPLOY_GRAPHS_DIFF(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_RELEASER_DEPLOY_GRAPHS(AbstractResource):
    """
    """
    executable = False
    auto_backup = True
    releasable = True
    releasers = news_service_config_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_GEN_MONGO_CONF_EXECUTABLE(AbstractResource):
    """
        News MongoDb config generator executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_GEN_ZK_CONF_EXECUTABLE(AbstractResource):
    """
        News ZooKeeper config generator executable
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABSCS_LUA_TEMPLATES(AbstractResource):
    """
        lua шаблоны
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAGS_BUILD_MAIN(AbstractResource):
    """
        Главный исполняемый файл процесса построения тегов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_tags_releasers
    release_subscribers = images_tags_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/tags/main/mr_build_tags'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAGS_BUILD_HOMONYMS(AbstractResource):
    """
        Исполняемый файл для построения начальной таблицы омонимов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_tags_releasers
    release_subscribers = images_tags_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/tags/tools/buildhomonyms/buildhomonyms'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAGS_BUILD_GZT(AbstractResource):
    """
        Исполняемый файл для построения статей газеттира из запросов.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = images_tags_releasers
    release_subscribers = images_tags_subscribers
    arcadia_build_path = 'extsearch/images/robot/mrdb/tags/tools/tagsgztcompiler/tagsgztcompiler'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_TAGS_FILTER_STOPWORDS(AbstractResource):
    """
       Питоновский скрипт для фильтрации запросв по стоп словам.
    """
    releasable = True
    any_arch = True
    executable = True
    auto_backup = True
    releasers = images_tags_releasers
    release_subscribers = images_tags_subscribers
    arcadia_path = 'extsearch/images/robot/mrdb/tags/tools/scripts/filterStopWords.py'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_UPBASE_KWFOLDER(AbstractResource):
    """
       Папка с kiwi-триггерами для up base картинок
    """
    releasable = True
    any_arch = False
    releasers = images_releasers
    release_subscribers = images_subscribers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PUSH_STATS_TOOL(AbstractResource):
    """
        PushStatsTool binary to calculate push statistics and send to statFace.
    """
    any_arch = True
    executable = True
    ttl = 'inf'
    releasers = ['antonka', 'dpolukhin']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MASSTRANSIT_GTFS_SOURCE(AbstractResource):
    """
        Public transportation source data
    """

    releasable = True
    auto_backup = True
    releasers = ['robot-gtfs-sources']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_ARCHARDS_EXECUTABLE(AbstractResource):
    """
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_NGINX_CONFIG_GENERATOR_EXECUTABLE(AbstractResource):
    """
    """
    executable = True
    releasable = True
    auto_backup = True
    any_arch = False
    releasers = news_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGET_SHARD_MAP(AbstractResource):
    """big dict shard map for suggest"""
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['temnajab']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGET_SHARD_MAIN_SCRIPT(AbstractResource):
    """main script for build suggest shards"""
    releasable = True
    any_arch = False
    executable = False
    auto_backup = False
    releasers = ['temnajab']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGET_SHARD_FILTERS(AbstractResource):
    """filters for build suggest shards"""
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['temnajab']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGET_SHARD_BUILD_ONE_SHARD(AbstractResource):
    """files for build shard for build suggest shards"""
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['temnajab']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SUGGET_VIDEO_TAGS_FILES(AbstractResource):
    """files for build shard for build suggest shards"""
    releasable = True
    any_arch = True
    executable = False
    auto_backup = False
    releasers = ['temnajab']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HOTTEA_EXECUTABLE(AbstractResource):
    """
    infra/hottea executable for basesearch hotswap
    """
    releasable = True
    auto_backup = True
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITE_REACHABILITY_SPYLOG_HANDLING(AbstractResource):
    """
        Утилита для парсинга spy-логов на предмет возможно-забаненных урлов, новых "заглушек" и пар ip-провайдер
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SITE_REACHABILITY_VIDEO_EXPORT(AbstractResource):
    """
        Утилита для подготовки данных о баннах для экспорта в Видео
    """
    releasable = True
    any_arch = False
    auto_backup = True
    executable = True
    releasers = ['lkozhinov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DELAYED_VIEW_ENTITY_BASE_TRIE(AbstractResource):
    '''
        Трай базы объектного ответа для досмотра в видео-поиске.
    '''
    auto_backup = True
    readable = True
    releasable = True
    releasers = ['vvp', 'palevas', 'alex0512', 'paul7']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class DELAYED_VIEW_SERIAL_BASE_TRIE(AbstractResource):
    '''
        Трай сериальной базы для досмотра в видео-поиске.
    '''
    auto_backup = True
    readable = True
    releasable = True
    releasers = ['vvp', 'palevas', 'alex0512', 'paul7']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LBR_BINARY(AbstractResource):
    """
        LBR binary
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = assistant_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class FINDURL_META_HTML(AbstractResource):
    """
        HTML file with multiple Find Url batches results
    """
    auto_backup = True
    readable = True
    ttl = 30


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_DOWNLOAD_RESOURCE_EXECUTABLE(AbstractResource):
    """
        Resource download binary, images robot
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'extsearch/images/robot/tools/download_resource/download_resource'
    release_subscribers = images_index_subscribers
    releasers = images_index_releasers + cvdup_releasers + images_rim_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MARKET_PERS_OPINIONS_DB(AbstractResource):
    """
        Market H2 DB with opinions
    """
    ttl = 1
    releasable = True
    releasers = market_pers_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class HW_PUSH_TOOL(AbstractResource):
    """
        Hotwater binary to get hotwater data and send pushes.
    """
    any_arch = True
    executable = True
    ttl = 'inf'
    releasers = ['antonka', 'dpolukhin', 'zador']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JAVA_PERF_MAP_AGENT_BUNDLE(AbstractResource):
    """
        Java Perf Map Agent
        https://github.com/jvm-profiling-tools/perf-map-agent
    """
    any_arch = False
    executable = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_VH_FRONTEND_DEV(sdk2.Resource):
    """
        Resource for vh frontend development builds
    """
    pass


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TCY(sdk2.Resource):
    """
        ТИЦ
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_RTYSERVER(AbstractResource):
    """
        RTLine related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.rtline_releasers
    arcadia_build_path = 'rtline/rtyserver/rtyserver'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_SEARCHPROXY(AbstractResource):
    """
        RTLine related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.rtline_releasers
    arcadia_build_path = 'rtline/searchproxy/searchproxy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_INDEXERPROXY(AbstractResource):
    """
        RTLine related resource
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.rtline_releasers
    arcadia_build_path = 'rtline/indexerproxy/indexerproxy'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_DEPLOY_MANAGER(AbstractResource):
    """
        RTLine cluster manager
    """
    releasable = True
    any_arch = False
    executable = True
    releasers = resource_releasers.rtline_releasers
    arcadia_build_path = 'rtline/deploy_manager/deploy_manager'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_LOOP_CONF(AbstractResource):
    """
        RTLine related resource
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.rtline_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RTLINE_LOOP_DATA(AbstractResource):
    """
        RTLine related resource
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.rtline_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class JUDTIER_DUPS_TABLE(AbstractResource):
    """
        Слепок Юпитерной таблицы judtier/dups:
        результаты канонизации всех оценённых урлов в tsv.gz
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class INFECTED_EXTERNAL_CODE(AbstractResource):
    """
        Infected API source code for runtime cloud deployment.
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UWSGI_INFECTED_CODE(AbstractResource):
    """
        UWSGI code for runtime cloud deployment.
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class UPLOAD_TRIE_SCRIPT(AbstractResource):
    """
        upload_script.sh
    """
    releasable = True
    executable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_STATIC_WIZARD_DATA_BUILDER(AbstractResource):
    """
        Yandex.Collections static wizard data builder.
    """
    releasable = True
    executable = True
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class COLLECTIONS_STATIC_WIZARD_DATA_JUNK_WORDS(AbstractResource):
    """
        Junk words for Yandex.Collections static wizard data.
    """
    releasable = True
    executable = False
    any_arch = True
    auto_backup = True
    releasers = resource_releasers.collections_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TESTENV_AUTODUTY_PACKAGE(AbstractResource):
    """
        Python build autoduty for Test Environment
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class IMAGES_UPBASE_SUPPORT_EXECUTABLE(AbstractResource):
    """
        Upbase support binary, images robot
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    arcadia_build_path = 'extsearch/images/robot/upbase/tools/upbase_support'
    release_subscribers = images_index_subscribers
    releasers = images_index_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SBAPI_PLUGIN_CONFIG(AbstractResource):
    """
        Config for SBAPI plugin.
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SBAPI_PLUGIN_STATIC(AbstractResource):
    """
        STATIC Data for SBAPI plugin.
    """
    auto_backup = True
    any_arch = False


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YADI_BINARY(sdk2.Resource):
    """
        Yadi binary
    """
    auto_backup = True
    any_arch = False
    releasable = True
    executable = True
    releasers = ['buglloc']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SELENIUM_ANDROID_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package для Android-эмуляторов в sg.yandex-team.ru
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.selenium_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SELENIUM_CLOUD_SAMOGON_PACKAGE(AbstractResource):
    """
        Samogon package для разворачивания selenium cloud
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.selenium_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class LSD_BACKUP(AbstractResource):
    """
        LSD viewer old calculation backups
    """
    ttl = 360
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_PKG_ROOT_DARWIN(AbstractResource):
    """
        Mobile package root development environment for Mac OS X
        https://wiki.yandex-team.ru/jandekskarty/development/fordevelopers/mobile/infra/newdev/#nastrojjkapackageroot
    """
    ttl = 'inf'
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_PKG_ROOT_LINUX(AbstractResource):
    """
        Mobile package root development environment for Linux
        https://wiki.yandex-team.ru/jandekskarty/development/fordevelopers/mobile/infra/newdev/#nastrojjkapackageroot
    """
    ttl = 'inf'
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_PKG_ROOT_WINDOWS(AbstractResource):
    """
        Mobile package root development environment for Windows
        https://wiki.yandex-team.ru/jandekskarty/development/fordevelopers/mobile/infra/newdev/#nastrojjkapackageroot
    """
    ttl = 'inf'
    executable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_BOSCH_SYSROOT(AbstractResource):
    """
        Sysroot for bosch development
    """
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NLGSEARCH_BINARY(AbstractResource):
    """
        nlgsearch executable
    """
    uploadable = True
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NLGSEARCH_SHARD(AbstractResource):
    """
        nlgsearch shard data
    """
    uploadable = True
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPRAV_COMPANIES_STORAGE_ARCHIVE(AbstractResource):
    """
        tarball from sprav/java/companies-storage
    """
    auto_backup = True
    releasable = True
    releasers = ['montag', 'bezdna']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERSONAL_POI_SQUEEZER_EXECUTABLE(AbstractResource):
    """
        Runner for squeeze log
    """
    executable = True
    releasable = True
    releasers = ['zhshishkin', 'sukhoi']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PERSONAL_POI_GENERATOR_EXECUTABLE(AbstractResource):
    """
        Runner for generate pairs of personal pois
    """
    executable = True
    releasable = True
    releasers = ['zhshishkin', 'sukhoi']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ARCADIA_LFS(AbstractResource):
    """
        Files put in sandbox using Hg LFS extension
    """
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MONIT_SERVER_PACKAGE(AbstractResource):
    """
        Бандл с бинарями extsearch/images/functionality/monit_robot_process/monit_server
    """
    releasable = True
    releasers = ["redwaan"]
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SPEECHKIT_MODEL(AbstractResource):
    """
        Traind models for Yandex.SpeechKit.ModelBox
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class OTT_VH_BACKEND_TEST_PACKAGE(sdk2.Resource):
    """
        Package for OTT vh backend test contour
    """
    releasable = False
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_STATIC_FACTORS_EXECUTABLE(AbstractResource):
    """
        Static factors on yt binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/tools/count_factors/count_factors'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class GEOSEARCH_STATIC_DOWNLOADER_EXECUTABLE(AbstractResource):
    """
        Downloader yt tables and merge to file
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers
    arcadia_build_path = 'extsearch/geo/kernel/static_factors_yt/downloader/static_factors_downloder'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ADFOX_MAKE_SAMPLES_BINARY(AbstractResource):
    """
        A binary file for computing ADFOX daily samples
    """
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PLATFORM_RUN(AbstractResource):
    """
    resource for YA_PACKAGE task to store package platform.run file
    """
    auto_backup = True
    releasable = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PSI_AGENT(AbstractResource):
    """
        psi agent
    """
    releasable = True
    auto_backup = True
    executable = True
    arcadia_build_path = 'infra/psiagent2'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class CALC_METRICS_DAEMON_EXECUTABLE(AbstractResource):
    """
        Resource with calc metric daemon executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YT_BACKUPER_EXECUTABLE(AbstractResource):
    """
        Executable yt-tables backuper.
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TMP_STAT_COLLECTOR_BINARY(AbstractResource):
    """
        Temp stat_collector binary for baobab priemka.
    """
    any_arch = True
    executable = True
    ttl = 10


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TMP_STAT_FETCHER_BINARY(AbstractResource):
    """
        Temp stat_fetcher binary for baobab priemka.
    """
    any_arch = True
    executable = True
    ttl = 10


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class TMP_ABT_CONF(AbstractResource):
    """
        Temp stat_fetcher binary for baobab priemka.
    """
    any_arch = True
    executable = False
    ttl = 20


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SCRIPT_RESULT(AbstractResource):
    """
        arbitrary script results
    """
    any_arch = True
    executable = False
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class EXPCOOKIER_EXECUTABLE(AbstractResource):
    """
        expcookier binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.experiment_releasers + resource_releasers.marty
    release_subscribers = resource_releasers.experiment_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class VOICE_SNR_MODEL(AbstractResource):
    """
        Voice search SNR models
    """
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class ANTISPAM_TMU_RESOURCE(AbstractResource):
    """
        Dicts or models for using in tmu rules
    """
    ttl = 'inf'


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class SOCIAL_IMAGES_MDS_UPLOADER(AbstractResource):
    """
        Executable uploader images from social to mds.
    """
    releasable = True
    executable = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class MAPS_GARDEN_DIRECTORY_RESOURCE(AbstractResource):
    """
       Remote directory resource for Maps Garden.
    """
    releasable = True
    auto_backup = True
    releasers = resource_releasers.geosearch_releasers


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class RFL(AbstractResource):
    """
        RFL files
    """
    any_arch = True
    auto_backup = True
    releasable = True
    releasers = [
        'robot-lemur-learn', 'robot-ukrop-sandbox', 'search-ukrop-rw',
        'andreytert', 'zenoyan', 'alex-mourne', 'nsa6', 'pet67', 'aasleptsov', 'socialgraph',
        'abogutskiy', 'sahdoum', 'zosimov', 'andreypo', 'alexcoach', 'marakasov', 'edik', 'catherineskv', 'kaikash7',
        'qqqtopology', 'psevdoinsaf'
    ]
    release_subscribers = ['zenoyan']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YABS_VH_BACKEND_WEB_SERVICES(AbstractResource):
    releasable = True
    any_arch = False
    auto_backup = True
    releasers = resource_releasers.vh_backend_releasers
    restart_policy = ctr.RestartPolicy.DELETE


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAPPY_STAND_ATTRIBUTES_DUMP(AbstractResource):
    """
    Dumped info about custom yappy stand attributes.
    (Used for RTCC patch generation)
    """
    ttl = 'inf'
    any_arch = True
    auto_backup = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YAPPY_TEST_DATA_ARCHIVE(AbstractResource):
    """
    Various gzipped Yappy test fixtures
    """
    ttl = 'inf'
    auto_backup = True
    any_arch = True


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PANDORA_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл pandora
    """
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['sourcerer', 'direvius', 'skipor']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class PCODE_DOCKER(AbstractResource):
    """
        PCODE docker building
    """


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class NEWS_TKVA_EXECUTABLE(AbstractResource):
    '''
        news tkva executable
    '''
    releasable = True
    executable = True
    auto_backup = True
    releasers = ['sgrb', 'gennadiy', 'yurifrolov', 'k-vukolov']


# Do not add new resource classes in this deprecated module, please. See module description above for details.
class YANDEX_JDK_SET(AbstractResource):
    '''
        many yandex jdk in one resource
    '''
    any_arch = False
    auto_backup = True


class PERF_REPORT(AbstractResource):
    """
        Perf report (https://man7.org/linux/man-pages/man1/perf-report.1.html)
    """
    releasable = False
    executable = False


class SOLOMON_HELPER_PACKAGE_TMP(sdk2.Resource):
    releasable = True
    releasers = ["robot-solomon", "guschin"]


class FINDURL_WORKER(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.findurl_releasers


class FINDURL_PINGER(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.findurl_releasers


class FINDURL_SCHEDULER(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.findurl_releasers


class FINDURL_API_SERVER(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.findurl_releasers


class FINDURL_HORADRIC(sdk2.Resource):
    releasable = True
    releasers = resource_releasers.findurl_releasers
