import base64
import logging
import zlib

from sandbox import sdk2


def fetch(resource_type):
    for resource in resource_type.find(state='READY', attrs={'released': 'stable'}).limit(1):
        resource_data = sdk2.ResourceData(resource)
        return str(resource_data.path)
    return None


def escape_text(data):
    if isinstance(data, unicode):
        data = data.encode('utf-8')
    return base64.b64encode(data)


def share_as_resource(task, data, resource_type, filename, description, compressed=True):
    path = str(task.path(filename))
    resource = resource_type(task, description, path)
    with open(path, 'wb') as f:
        data = base64.b64decode(data)
        if compressed:
            data = zlib.decompress(data)
        f.write(data)
    logging.info('Saved data (%s) to: %s', description, path)
    sdk2.ResourceData(resource).ready()
    return path, resource.http_proxy
