from sandbox import sdk2

import sandbox.projects.common.arcadia.sdk as asdk
import sandbox.projects.review.base as base


class AutocheckReviewBoard(sdk2.resource.AbstractResource):
    """
    ReviewBoard review pre-commit autocheck tool
    """

    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['nslus', 'albazh']


class AutocheckReviewBoardZipatch(sdk2.resource.Resource):
    """
    RB review zipatch
    """

    pass


class AutocheckReviewBoardPatch(sdk2.resource.Resource):
    """
    RB review human-readable patch
    """

    pass


class AutocheckFromReviewBoardSlim(base.AutocheckReview):
    """
    ReviewBoard review pre-commit autocheck
    https://wiki.yandex-team.ru/arcadia/hooks/review
    """

    class Parameters(base.AutocheckReview.Parameters):
        rb_review = sdk2.parameters.Integer('RB review ID', required=True)
        rb_iteration = sdk2.parameters.Integer('RB review iteration', required=True)
        oauth_vault = sdk2.parameters.String('OAuth token Vault key (for Arcanum)')
        arcanum_url = sdk2.parameters.String('Arcanum URL')
        rb_url = sdk2.parameters.String('RB URL (deprecated)')
        rb_creds = sdk2.parameters.String('RB creds (deprecated)')
        rb_creds_token = sdk2.parameters.Bool('RB creds token (deprecated)')

    launcher_resource_type = AutocheckReviewBoard
    patch_resource_type = AutocheckReviewBoardPatch
    zipatch_resource_type = AutocheckReviewBoardZipatch

    def check_params(self):
        return bool(not self.Parameters.report or self.Parameters.oauth_vault)

    def extend_args(self, args):
        args.extend(['--rb-review', str(self.Parameters.rb_review)])
        args.extend(['--rb-review-iteration', str(self.Parameters.rb_iteration)])
        if self.Parameters.arcanum_url:
            args.extend(['--arcanum-url', self.Parameters.arcanum_url])
        if self.Parameters.report and self.Parameters.oauth_vault:
            args.extend(['--yandex-auth', asdk.save_vault(self, self.Parameters.oauth_vault, 'auth-yandex.creds')])
