from sandbox import sdk2

TEAM = ['koorgoo', 'dhmax', 'flyik', 'danichk']


class RexBinary(sdk2.Resource):
    """
        Binary or rex
    """
    releasable = True
    releasers = TEAM
    any_arch = False
    executable = True
    auto_backup = True
    version = sdk2.parameters.String(required=True)


class RexDeploy(sdk2.Resource):
    """
        Tarball of "deploy/" directory in rex repository
    """
    any_arch = True
    auto_backup = True
    executable = False
    releasable = True
    releasers = TEAM
    version = sdk2.parameters.String(required=True)


class PrometheusExporterBinary(sdk2.Resource):
    """
        Binary or Prometheus metrics exporter
    """
    releasable = True
    releasers = TEAM
    any_arch = False
    executable = True
    auto_backup = True
    version = sdk2.parameters.String(required=True)
