import os

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as rr

PATH_TO_RMP_DIR = 'yabs/rmp'
PATH_TO_TOOLS_DIR = os.path.join(PATH_TO_RMP_DIR, 'tools')


class RmpResourceBase(sdk2.Resource):
    releasable = True
    releasers = rr.rmp_releasers
    sync_upload_to_mds = True


class RmpSaasIndexer(RmpResourceBase):
    """
    Script for indexing mobile apps
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'rmp_saas_indexer')
    arcadia_build_name = 'rmp_saas_indexer'
    executable = True


class RmpAppInfoParser(RmpResourceBase):
    """
    Script for indexing downloading and parsing mobile app stores
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'parser')
    arcadia_build_name = 'rmp_app_info_parser'
    executable = True


class RmpAppToUrlMatcher(RmpResourceBase):
    """
    Script for matching mobile app with developer's url
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'app_to_web_urls')
    arcadia_build_name = 'app_to_web_urls'
    executable = True


class RmpYtStatesCleaner(RmpResourceBase):
    """
    Script for cleaning old states on YT
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'yt_states_cleaner')
    arcadia_build_name = 'yt_states_cleaner'
    executable = True


class RmpAppDataBuilder(RmpResourceBase):
    """
    Script for building mobile app data
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'app_data_builder')
    arcadia_build_name = 'app_data_builder'
    executable = True


class RmpNirvanaTmpCleaner(RmpResourceBase):
    """
    Script for cleaning tmp files from nirvana
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'nirvana_tmp_cleaner')
    arcadia_build_name = 'nirvana_tmp_cleaner'
    executable = True


class RmpDataChecker(RmpResourceBase):
    """
    Script for validating RMP tables
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'data_checker')
    arcadia_build_name = 'data_checker'
    executable = True


class RmpAuroraDataBuilder(RmpResourceBase):
    """
    Script for building app data in aurora format
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'aurora_data_builder')
    arcadia_build_name = 'aurora_data_builder'
    executable = True


class RmpAppNames(RmpResourceBase):
    """
    Script for building special dictionary app_id - app names (eg title).
    https://st.yandex-team.ru/RMP-1246
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'app_names')
    arcadia_build_name = 'app_names'
    executable = True


class RmpAuroraUrlSyncer(RmpResourceBase):
    """
    Script for uploading urls from aurora to YDB
    https://st.yandex-team.ru/RMP-1459
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'aurora_url_syncer')
    arcadia_build_name = 'aurora_url_syncer'
    executable = True


class RmpSkNetworkBuilder(RmpResourceBase):
    """
    Build matching for sk ad network by ITunes
    https://st.yandex-team.ru/RMP-1607
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'sk_ad_network_builder')
    arcadia_build_name = 'sk_ad_network_builder'
    executable = True


class RmpGetDeeplinks(RmpResourceBase):
    """
    Script for downloading deeplinks
    https://st.yandex-team.ru/RMP-1131
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'get_deeplinks')
    arcadia_build_name = 'get_deeplinks'
    executable = True


class RmpTablesMonitorings(RmpResourceBase):
    """
    Script for sending monitoring data to solomon
    https://st.yandex-team.ru/RMP-1704
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'tables_monitorings')
    arcadia_build_name = 'tables_monitorings'
    executable = True


class RmpTablesComparator(RmpResourceBase):
    """
    Script for comparing tables and storing diffs
    https://st.yandex-team.ru/RMP-1792
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'tables_comparator')
    arcadia_build_name = 'tables_comparator'
    executable = True


class RmpBannerToAppLinks(RmpResourceBase):
    """
    Script for getting apps urls from banners
    https://st.yandex-team.ru/RMP-1668
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'banner_to_app_links')
    arcadia_build_name = 'banner_to_app_links'
    executable = True


class RmpVideoFactors(RmpResourceBase):
    """
    Script for extracting factors from video
    https://st.yandex-team.ru/RMP-1867
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'video_factors')
    arcadia_build_name = 'video_factors'
    executable = True


class RmpPopularBanners(RmpResourceBase):
    """
    Script for creating tables with popular banners
    https://st.yandex-team.ru/RMP-2050
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'popular_banners')
    arcadia_build_name = 'popular_banners'
    executable = True


class RmpTrackerUrlStat(RmpResourceBase):
    """
    Script for calculating tracker urls statistic
    https://st.yandex-team.ru/RMP-1974
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'tracker_url_stat')
    arcadia_build_name = 'tracker_url_stat'
    executable = True


class RmpClicksDataBuilder(RmpResourceBase):
    """
    Script for creating tables with information about the number of clicks on the application page per day in the store
    https://st.yandex-team.ru/RMP-2038
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'clicks_data_builder')
    arcadia_build_name = 'clicks_data_builder'
    executable = True


class RmpLinearTrendEstimator(RmpResourceBase):
    """
    Script for estimating linear trend for the number of clicks on the application (RmpClicksDataBuilder)
    https://st.yandex-team.ru/RMP-2038
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'linear_trend_estimator')
    arcadia_build_name = 'linear_trend_estimator'
    executable = True


class RmpTrackerUrlRetrier(RmpResourceBase):
    """
    Tool for retrying failed tracker url requests from extstat logs
    https://st.yandex-team.ru/RMP-2131
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'tracker_url_retrier')
    arcadia_build_name = 'tracker_url_retrier'
    executable = True


class RmpRecommendedCost(RmpResourceBase):
    """
    Tool for generate of recommended cost
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'recommended_cost')
    arcadia_build_name = 'recommended_cost'
    executable = True


class RmpBannerToAppBuilder(RmpResourceBase):
    """
    Script for building banner <-> app matching
    https://st.yandex-team.ru/RMP-2460
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'banner_to_app_builder')
    arcadia_build_name = 'banner_to_app_builder'
    executable = True


class RmpFerrymanUploader(RmpResourceBase):
    """
    Script for uploading an index to ferryman
    https://st.yandex-team.ru/RMP-3354
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'ferryman_uploader')
    arcadia_build_name = 'ferryman_uploader'
    executable = True


class RmpDeeplinksMonitoring(RmpResourceBase):
    """
    Script for creating solomon metrics for deeplink
    https://st.yandex-team.ru/RMP-3392
    """
    arcadia_build_path = os.path.join(PATH_TO_TOOLS_DIR, 'app_info', 'deeplinks_monitoring')
    arcadia_build_name = 'deeplinks_monitoring'
    executable = True
