# -*- coding: utf-8 -*-
import os

from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.rmp.uac.resources import (
    UacBackendApiServer,
    UacBackendCeleryWorker,
    UacBackendCeleryBeat,
    UacBackendConfLocalProduction,
    UacBackendConfLocalTesting,
    UacWorkerConfLocalProduction,
    UacWorkerConfLocalTesting,
)


BUILD_RESOURCES = (
    UacBackendApiServer,
    UacBackendCeleryWorker,
    UacBackendCeleryBeat
)


SOURCE_RESOURCES = (
    UacBackendConfLocalProduction,
    UacBackendConfLocalTesting,
    UacWorkerConfLocalProduction,
    UacWorkerConfLocalTesting,
)


class BuildUacBackend(YaMakeTemplate.YaMakeTemplate):
    class Parameters(YaMakeTemplate.get_project_params(BUILD_RESOURCES + SOURCE_RESOURCES)):
        pass

    def _get_artifacts(self, resources):
        return [
            {
                'path': os.path.join(
                    resource.arcadia_build_path, resource.arcadia_build_name
                )
            } for resource in self.target_resource_classes if resource in resources
        ]

    def get_arts(self):
        return self._get_artifacts(BUILD_RESOURCES)

    def get_arts_source(self):
        return self._get_artifacts(SOURCE_RESOURCES)

    def get_resources(self):
        return {
            resource.arcadia_build_name: {
                'resource_type': resource,
                'description': resource.__doc__,
                'resource_path': resource.arcadia_build_name,
            } for resource in self.target_resource_classes
        }
