from sandbox.projects.common.backend_build_pipeline.GenerateExtServicesYasmPanelsBaseTask import GenerateExtServicesYasmPanelsBaseTask


class UacBackendGenerateExtServicesYasmPanels(GenerateExtServicesYasmPanelsBaseTask):
    """
    Task for UAC backend ext services yasm panels generation
    """
    class FailPercentParams(GenerateExtServicesYasmPanelsBaseTask.FailPercentParams):
        SIGNAL_PREFIX = 'uac'

        @classmethod
        def default_fail_codes(cls):
            from uac_yasm.ext_services import EXCEPTIONAL_CODES, FAIL
            return ['4xx', '5xx', FAIL] + list(EXCEPTIONAL_CODES)

        @classmethod
        def all_codes(cls):
            from uac_yasm.ext_services import EXCEPTIONAL_CODES, SUCCESS, FAIL
            return ['{}xx'.format(i) for i in range(1, 6)] + list(EXCEPTIONAL_CODES) + [SUCCESS, FAIL]

    def _get_panel_template(self):
        from uac_yasm.panels import get_ext_services_panel_template
        return get_ext_services_panel_template()

    def _get_ext_services(self):
        from uac_yasm import ExtServicesNames
        return ExtServicesNames

    def _get_tags(self, ctype):
        return {
            'uwsgi': {
                'itype': ['uacuwsgi'],
                'ctype': [ctype],
                'prj': ['uac-backend', 'uac-backend-upload'],
                'geo': ['sas', 'man', 'vla'],
            },
            'celery': {
                'itype': ['uacworker'],
                'ctype': [ctype],
                'prj': ['uac'],
                'geo': ['sas', 'man', 'vla'],
            }
        }

    def _get_ext_services_alerts_config(self, services):
        return {
            service.name: {
                self.FAIL_PERC_ALERT: {
                    'thresholds': self.AlertThresholds(warn=2, crit=5),
                    'signal_kwargs': {
                        'fail_codes': self.FailPercentParams.default_fail_codes(),
                    }
                }
            }
            for service in services
        }


__TASK__ = UacBackendGenerateExtServicesYasmPanels
