import os

from sandbox import sdk2
import sandbox.projects.resource_types.releasers as rr


PATH_TO_UAC_BACKEND_BIN = 'yabs/rmp/backend/bin'


class UacResourceBase(sdk2.Resource):
    releasable = True
    releasers = rr.uac_backend_releasers


class UacBinaryResourceBase(UacResourceBase):
    executable = True
    auto_backup = True


class UacBackendApiServer(UacBinaryResourceBase):
    """
    UAC backend api server
    """
    arcadia_build_path = os.path.join(PATH_TO_UAC_BACKEND_BIN, 'api_server')
    arcadia_build_name = 'api_server'


class UacBackendCeleryWorker(UacBinaryResourceBase):
    """
    UAC backend celery worker
    """
    arcadia_build_path = os.path.join(PATH_TO_UAC_BACKEND_BIN, 'celery_worker')
    arcadia_build_name = 'celery_worker'


class UacBackendCeleryBeat(UacBinaryResourceBase):
    """
    UAC backend celery beat
    """
    arcadia_build_path = os.path.join(PATH_TO_UAC_BACKEND_BIN, 'celery_beat')
    arcadia_build_name = 'celery_beat'


class UacConfigResourceBase(UacResourceBase):
    any_arch = True
    executable = False


class UacBackendInstancectlConfig(UacConfigResourceBase):
    """
    instancectl.conf to run UAC backend
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_backend/instancectl.conf'


class UacBackendUploadInstancectlConfig(UacConfigResourceBase):
    """
    instancectl.conf to run UAC backend upload
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_backend_upload/instancectl.conf'


class UacWorkerInstancectlConfig(UacConfigResourceBase):
    """
    instancectl.conf to run UAC celery worker
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_worker/instancectl.conf'


class UacBeatInstancectlConfig(UacConfigResourceBase):
    """
    instancectl.conf to run UAC celery beat
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_beat/instancectl.conf'


class UacBackendUwsgiConfigBase(UacConfigResourceBase):
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_backend/uwsgi.conf.j2'


class UacBackendUwsgiProductionConfig(UacBackendUwsgiConfigBase):
    """
    uwsgi.conf to run UAC backend in production
    """
    template_params = {
        'env': 'production',
    }


class UacBackendUwsgiTestingConfig(UacBackendUwsgiConfigBase):
    """
    uwsgi.conf to run UAC backend in testing
    """
    template_params = {
        'env': 'testing',
    }


class UacBackendUploadUwsgiConfigBase(UacConfigResourceBase):
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_backend_upload/uwsgi.conf.j2'


class UacBackendUploadUwsgiProductionConfig(UacBackendUploadUwsgiConfigBase):
    """
    uwsgi.conf to run UAC backend upload in production
    """
    pass


class UacWorkerUwsgiConfig(UacConfigResourceBase):
    """
    uwsgi.conf to run UAC celery worker
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_worker/uwsgi.conf'


class UacBeatUwsgiConfig(UacConfigResourceBase):
    """
    uwsgi.conf to run UAC celery beat
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/uac_beat/uwsgi.conf'


class UacPushClientConfigBase(UacConfigResourceBase):
    arcadia_build_path = 'yabs/rmp/backend/configs/logs/push-client.conf.j2'


class UacBackendPushClientProductionConfig(UacPushClientConfigBase):
    """
    push-client.conf for UAC backend in production
    """
    template_params = {
        'env': 'production',
        'app': 'uwsgi',
    }


class UacBackendPushClientTestingConfig(UacPushClientConfigBase):
    """
    push-client.conf for UAC backend in testing
    """
    template_params = {
        'env': 'testing',
        'app': 'uwsgi',
    }


class UacWorkerPushClientProductionConfig(UacPushClientConfigBase):
    """
    push-client.conf for UAC celery worker in production
    """
    template_params = {
        'env': 'production',
        'app': 'celery',
    }


class UacWorkerPushClientTestingConfig(UacPushClientConfigBase):
    """
    push-client.conf for UAC celery worker in testing
    """
    template_params = {
        'env': 'testing',
        'app': 'celery',
    }


class UacPushClientHideSecretsScript(UacConfigResourceBase):
    """
    hide_secrets.py for UAC backend push-client
    """
    arcadia_build_path = 'yabs/rmp/backend/configs/logs/hide_secrets.py'


class UacLogrotateConfigBase(UacConfigResourceBase):
    arcadia_build_path = 'yabs/rmp/backend/configs/logs/logrotate.conf.j2'


class UacLogrotateProductionConfig(UacLogrotateConfigBase):
    """
    logrotate.conf for UAC backend in production
    """
    template_params = {
        'rotate': 2,
        'size': '500M',
    }


class UacLogrotateTestingConfig(UacLogrotateConfigBase):
    """
    logrotate.conf for UAC backend in testing
    """
    template_params = {
        'rotate': 1,
        'size': '100M',
    }


class UacConfLocalBase(UacConfigResourceBase):
    arcadia_build_path = 'yabs/rmp/backend/conf_local'


class UacBackendConfLocalProduction(UacConfLocalBase):
    """
    Conf.local for UAC backend in production
    """
    arcadia_build_name = 'uac_backend.prod.conf'


class UacBackendConfLocalTesting(UacConfLocalBase):
    """
    Conf.local for UAC backend in testing
    """
    arcadia_build_name = 'uac_backend.test.conf'


class UacWorkerConfLocalProduction(UacConfLocalBase):
    """
    Conf.local for UAC celery worker in production
    """
    arcadia_build_name = 'uac_worker.prod.conf'


class UacWorkerConfLocalTesting(UacConfLocalBase):
    """
    Conf.local for UAC celery worker in testing
    """
    arcadia_build_name = 'uac_worker.test.conf'
