# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from sandbox.projects.robot_adapter.achievements import common


class AchievementsError(Exception):
    pass


class AchievementIds:
    Intern = 684


class AchieveryApi:

    # api settings
    API_MODE = common.ApiMode.Test
    API_LIMIT = 100000
    API_URLS = {
        common.ApiMode.Test: 'http://staff.test.yandex-team.ru/api/achievery/',
        common.ApiMode.Production: 'https://staff.yandex-team.ru/api/achievery/',
    }

    @staticmethod
    def api_url():
        return AchieveryApi.API_URLS[AchieveryApi.API_MODE]

    @staticmethod
    def person_achievement(login, achievement_id, headers=None):
        headers = headers or {}
        headers.update({"Accept": "application/json"})
        params = {
            'person.login': login,
            'achievement.id': achievement_id,
            '_fields': 'id,is_active,revision,comment,level,person.login,is_hidden,events',
        }
        url = AchieveryApi.api_url() + 'given/'
        data = common.process_request('get', url=url, params=params, headers=headers)
        if data and data['total'] > 0:
            achievement = data['objects'][0]
            return achievement

    @staticmethod
    def persons_with_achievement(achievement_id, headers=None, **extra_params):
        headers = headers or {}
        headers.update({"Accept": "application/json"})
        params = {
            'achievement.id': achievement_id,
            '_fields': 'id,is_active,revision,comment,level,person.login,is_hidden',
        }
        params.update(extra_params)
        url = AchieveryApi.api_url() + 'given/'
        data = common.process_request('get', url=url, params=params, headers=headers)
        return data

    @staticmethod
    def give_achievement(login, achievement_id, level, comment=None, headers=None, **data):
        headers = headers or {}
        headers.update({"Accept": "application/json"})
        params = {
            'person.login': login,
            'achievement.id': achievement_id,
            'level': level,
        }
        if comment:
            params['comment'] = comment
        params.update(data)
        url = AchieveryApi.api_url() + 'given/'
        return common.process_request('post', url=url, data=params, headers=headers)
