# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
import requests

API_LIMIT = 100000
API_RESPONSE_TIMEOUT = 10000  # Seconds


class ApiMode:
    Production = 'production'
    Test = 'test'


def process_request(method_name,
                    url,
                    params=None,
                    data=None,
                    headers=None,
                    token=None):
    params = params or {}
    data = data or {}
    headers = headers or {}
    if token:
        headers.update({
            'Authorization': 'OAuth {}'.format(token)
        })
    if method_name == 'get':
        params.update({'_limit': API_LIMIT})
    try:
        logging.info(method_name)
        logging.info(url)
        logging.info('PARAMS:' + str(params))
        logging.info('  DATA:' + str(data))
        response = requests.request(
            method=method_name,
            url=url,
            params=params,
            data=data,
            headers=headers,
            timeout=API_RESPONSE_TIMEOUT,
        )
    except (requests.ConnectionError, requests.Timeout):
        logging.exception('Staff achievements API is not responding')
        return

    try:
        data = response.json()
    except ValueError:
        logging.exception('Error during parse json from API achievements API')
        return

    if response.status_code > 399:
        logging.error(
            'Staff achievements API responded with status `{}` for url = `{}` and params = `{}`'
            .format(response.status_code, url, params)
        )
        return

    return data
