# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import logging
from sandbox.projects.robot_adapter.achievements import common


class StaffError(Exception):
    pass


class StaffApi:

    # api settings
    API_MODE = common.ApiMode.Test
    API_RESPONSE_TIMEOUT = 10000  # Seconds
    API_URLS = {
        common.ApiMode.Test: 'http://staff-api.test.yandex-team.ru/v3/persons/',
        common.ApiMode.Production: 'https://staff-api.yandex-team.ru/v3/persons/',
    }

    @staticmethod
    def api_url():
        return StaffApi.API_URLS[StaffApi.API_MODE]

    @staticmethod
    def staff_objects(headers=None):
        logging.info('Loading staff info')
        params = {
            'official.is_robot': False,
            'official.affiliation': 'yandex,yamoney,external',
            '_fields': 'login,id,name.last,name.first,official.join_at,official.quit_at',
        }
        url = StaffApi.api_url()
        data = common.process_request('get', url=url, params=params, headers=headers)
        return data['result']

    @staticmethod
    def person_full_info(login, headers=None):
        logging.info('Loading full info for "%20s"' % login)
        params = {
            '_one': 1,
            'login': login,
        }
        url = StaffApi.api_url()
        data = common.process_request('get', url=url, params=params, headers=headers)
        return data
