# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import os
import datetime
import logging
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import COMMASPACE
from smtplib import SMTP_SSL, SMTPException

from sandbox import sdk2, common

YANDEX_TEAM_EMAIL = '{login}@yandex-team.ru'
ROBOT_LOGIN = 'robot-adapter'
SANDBOX_SECRET_NAME = 'password'


def robot_password():
    try:
        token = sdk2.Vault.data(ROBOT_LOGIN, SANDBOX_SECRET_NAME)
    except common.errors.VaultError as err:
        logging.error(err)
        raise common.errors.TaskFailure(
            'Couldn\'t get password token for @{}'.format(ROBOT_LOGIN))
    return token


def make_attachment(data, filename):
    # type: (Union[str, bytes], Union[str, unicode]) -> MIMEApplication
    attachment = MIMEApplication(data)
    attachment.add_header('Content-Disposition',
                          'attachment',
                          filename=('utf-8', '', filename.encode('utf-8')))
    return attachment


def read_email_template():
    email_template_key = 'email_template.html'
    if common.system.inside_the_binary():
        from library.python import resource
        arcadia_path = 'sandbox/projects/robot_adapter/common'
        resource_key = os.path.join(arcadia_path, email_template_key)
        return resource.find(resource_key)

    template_path = os.path.dirname(os.path.abspath(__file__))
    template_filename = os.path.join(template_path, email_template_key)
    with open(template_filename, 'r') as f:
        return f.read()


def send_email(subject,          # type: str
               to_emails=None,   # type: Optional[List[str]]
               cc_emails=None,   # type: Optional[List[str]]
               bcc_emails=None,  # type: Optional[List[str]]
               text=None,        # type: Optional[str]
               html=None,        # type: Optional[str]
               attachments=None  # type: Optional[List[MIMEApplication]]
               ):
    if attachments is None:
        attachments = []
    if to_emails is None:
        to_emails = []
    if cc_emails is None:
        cc_emails = []
    if bcc_emails is None:
        bcc_emails = []

    from_addr = YANDEX_TEAM_EMAIL.format(login=ROBOT_LOGIN)
    password = robot_password()
    # Preparing a message.
    msg = MIMEMultipart()
    msg['Subject'] = subject
    msg['From'] = 'Адаптационный Эндрю <{}>'.format(from_addr)
    if to_emails:
        msg['To'] = COMMASPACE.join(to_emails)
    if cc_emails:
        msg['Cc'] = COMMASPACE.join(cc_emails)
    if text:
        msg.attach(MIMEText(text, 'plain', 'utf-8'))
    if html:
        msg.attach(MIMEText(html, 'html', 'utf-8'))
    for attachment in attachments:
        msg.attach(attachment)

    # Sending a message.
    try:
        all_emails = to_emails + cc_emails + bcc_emails
        server = SMTP_SSL('smtp.yandex-team.ru', 465)
        server.login(user=from_addr, password=password)
        server.sendmail(from_addr, all_emails,
                        msg.as_string().encode('ascii'))
        logging.info('Message to {} sent at: {}'
                     .format(all_emails, datetime.datetime.now()))
        server.quit()
    except SMTPException as e:
        logging.error('Error on sending an email occurred: {}'.format(e))
        raise
