# -*- coding: utf-8 -*-
import importlib

import sandbox.sdk2 as sdk2
from sandbox.projects.common import binary_task

from sandbox.projects.rope import RunTaskTemplate
from sandbox.projects.rope.examples.resources import RopeExampleBarBinaries
from sandbox.projects.rope.examples.resources import RopeExampleBazBinaries
from sandbox.projects.rope.examples.resources import RopeExampleFooBinaries
from sandbox.projects.rope.examples.task_params import RopeExampleBarParams
from sandbox.projects.rope.examples.task_params import RopeExampleFooParams
from sandbox.projects.rope.examples.task_params import RopeExampleQuxParams


class ReleaseParameters(sdk2.Task.Parameters):
    ext_params = binary_task.binary_release_parameters_list(custom=True)


class RunRopeExampleTasks(RunTaskTemplate.RunTaskTemplate,
                          binary_task.LastBinaryTaskRelease):

    def qux(self, params):
        """
        :type params: RopeExampleQuxParams
        """
        self.set_info('some_string_params = {}'.format(params.some_string_param))

    class Parameters(RunTaskTemplate.get_run_params(
        [
            (RopeExampleFooBinaries, RopeExampleFooParams),
            (RopeExampleBarBinaries, RopeExampleBarParams),
            RopeExampleBazBinaries,
            RunTaskTemplate.FunctionTaskInitializer(
                task_key='qux',
                task_params_class=RopeExampleQuxParams,
                func=lambda p, _: importlib.import_module('sandbox.projects.rope.examples.remote_pylib').qux(p),
            )
        ],
        base_class=ReleaseParameters
    )):
        pass

    def on_execute(self):
        info_msg = (
            'task_name = {}'
            '\ntask_params = {}'
        ).format(self.task_name, self.task_params)
        self.set_info(info_msg)
        self.logger.info(info_msg)

        super(RunRopeExampleTasks, self).on_execute()
