# -*- coding: utf-8 -*-
from sandbox import sdk2

from sandbox.projects import rope
from sandbox.projects.common import binary_task


class SimpleTaskParams(rope.parameters.TaskParams):
    bool_param = rope.parameters.BoolParam('Bool')
    bool_default_false = rope.parameters.BoolParam('Bool default false', default=False)
    bool_default_true = rope.parameters.BoolParam('Bool default true', default=True)

    secret_value = rope.parameters.VaultSecretParam('Some secret value',
                                                    default_vault_name='TEST_VALUE')


class ReleaseParameters(sdk2.Task.Parameters):
    ext_params = binary_task.binary_release_parameters_list(custom=True)


class RopeExampleTask(rope.RunTaskTemplate.TaskParamsTemplate, binary_task.LastBinaryTaskRelease):

    class Requirements(sdk2.Task.Requirements):
        # Use multislot hosts
        # https://wiki.yandex-team.ru/sandbox/cookbook/#cores1multislot
        cores = 1
        ram = 8192

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rope.RunTaskTemplate.get_run_params(SimpleTaskParams,
                                                         base_class=ReleaseParameters)):
        pass

    def on_execute(self):
        info_msg = 'task_params = {}'.format(self.task_params)
        self.set_info(info_msg)
        self.logger.info(info_msg)
