# -*- coding: utf-8 -*-
from sandbox.projects.rope import parameters
import sandbox.sdk2 as sdk2


class RopeExampleFooParams(parameters.TaskParams):
    some_string_param = parameters.StrParam('Some string param', default='foo')
    person = parameters.StrParam(
        'Person (multiple sdk2 param example)',
        default='Leo Tolstoy',
        required=False,
        sdk2_param_class=dict(
            name=sdk2.parameters.String,
            surname=sdk2.parameters.String,
        ),
        sdk2_param_kwargs=dict(
            surname=dict(
                description='optional'
            ),
        ),
        load_from_sdk2_params=lambda p: (
            '{} {}'.format(p['name'], p['surname']) if p['surname'] else p['name']
        )
    )
    vault_secret = parameters.VaultSecretParam('Some vault secret', specify_owner=True)
    yav_secret = parameters.YavSecretParam('Some yav secret', default_yav_secret_key='token')


class RopeExampleBarParams(parameters.TaskParams):
    some_string_param = parameters.StrParam('Some string param', default='bar')


class RopeExampleQuxParams(parameters.TaskParams):
    some_string_param = parameters.StrParam('Some string param', default='qux')
