# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.resource_types import search_priemka_releasers


class StorageBinary(sdk2.Resource):
    """
    Storage model binary.
    """
    releasable = True
    any_arch = False
    releasers = search_priemka_releasers + ["robot-testenv"]
    auto_backup = True
    arcadia_build_path = 'search/rpslimiter/storage/src/model/model'


class BuildRpsStorage(YaMakeTemplate.YaMakeTemplate):
    """
        Build Storage model binary.
    """
    class Parameters(YaMakeTemplate.get_project_params([StorageBinary])):
        pass
