# coding: utf-8

from sandbox import sdk2

import sandbox.projects.resource_types.releasers as rr


class RpsLimiterResource(sdk2.Resource):
    """
    Abstract RpsLimiter resource.
    """
    releasable = True
    any_arch = False
    releasers = rr.rpslimiter_releasers
    auto_backup = True


class RpsLimiterModelBinary(RpsLimiterResource):
    """
    RpsLimiter model binary.
    """
    arcadia_build_path = 'search/rpslimiter/storage/src/model/model'


class RpsLimiterProxyBinary(RpsLimiterResource):
    """
    RpsLimiter proxy binary.
    """
    arcadia_build_path = 'search/rpslimiter/storage/src/proxy/'


class RpsLimiterBinary(RpsLimiterResource):
    """
    RpsLimiter proxy binary.
    """
    arcadia_build_path = 'search/rpslimiter/rpslimiter/rpslimiter'


class RpsLimiterAgentBinary(RpsLimiterResource):
    """
    RpsLimiter proxy binary.
    """
    arcadia_build_path = 'search/rpslimiter/rpslimiter_agent/rpslimiter_agent'


class RpsLimiterBalancerExecutable(RpsLimiterResource):
    """
    Balancer binary for rpslimiter releases.
    """
    arcadia_build_path = 'balancer/daemons/balancer/balancer'


class RpsLimiterUIBundle(RpsLimiterResource):
    """
    Archived RpsLimiterer UI
    """
