# -*- coding: utf-8 -*-
from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.projects.common.build.tasks import YaMakeTemplate
from sandbox.projects.common.ya_deploy import release_integration

from ..resources import (
    DELAY_FOR_SYNC_PROFILES_RT_MONEY_BINARY, HIT_MASTER_RT_MONEY_BINARY,
    EVENT_STREAMER_RT_MONEY_BINARY, SOLOMON_RT_MONEY_BINARY,
    YT_TO_LB_RT_MONEY_BINARY,
    QUEUE_DAEMON_RT_MONEY_BINARY, RESHARDER_RT_MONEY_BINARY,
    RESHARDER_BS_EVENT_LOG_RT_MONEY_BINARY,
    RESHARDER_BS_HIT_LOG_RT_MONEY_BINARY,
    RESHARDER_PROFILE_INFO_RT_MONEY_BINARY,
    SYNC_PROFILES_RT_MONEY_BINARY,
    HIT_PROFILE_STATE_OBSERVERS_RT_MONEY_BINARY,
    CONFIG_GENERATOR_RT_MONEY_BINARY,
)

import os


class BuildRtMoneyBinaries(release_integration.ReleaseToYaDeployTask2, YaMakeTemplate.YaMakeTemplate):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        disk_space = 2048  # 1Gb

    class Parameters(
        YaMakeTemplate.get_project_params(
            build_resources=[
                DELAY_FOR_SYNC_PROFILES_RT_MONEY_BINARY,
                HIT_MASTER_RT_MONEY_BINARY,
                EVENT_STREAMER_RT_MONEY_BINARY,
                YT_TO_LB_RT_MONEY_BINARY,
                SOLOMON_RT_MONEY_BINARY,
                QUEUE_DAEMON_RT_MONEY_BINARY,
                RESHARDER_RT_MONEY_BINARY,
                RESHARDER_BS_EVENT_LOG_RT_MONEY_BINARY,
                RESHARDER_BS_HIT_LOG_RT_MONEY_BINARY,
                RESHARDER_PROFILE_INFO_RT_MONEY_BINARY,
                SYNC_PROFILES_RT_MONEY_BINARY,
                HIT_PROFILE_STATE_OBSERVERS_RT_MONEY_BINARY,
                CONFIG_GENERATOR_RT_MONEY_BINARY,
            ],
        )
    ):
        yp_token_yav_secret_id = sdk2.parameters.YavSecret(
            'YP token yav secret id',
            description='Only for deploy. Default is robot-make-money-yp-token https://yav.yandex-team.ru/secret/sec-01fjbtty2hazk9pcpsr5y3d7gp/explore/versions ',
            default='sec-01fjbtty2hazk9pcpsr5y3d7gp',
            required=False,
        )
        yp_token_yav_secret_key = sdk2.parameters.String("Yav secret key", default='yp-token', required=False)
        result_single_file = True

    def _resource_mapping(
        self, resource_type, resource_path, index=None,
    ):
        resource_description = "Rt Money Resource"
        single_file = index is not None

        resource_name = "{res_type}_art_{index}".format(
            res_type=str(resource_type), index=index,
        ) if single_file else str(resource_type)

        return {
            resource_name: {
                "description": resource_description,
                "resource_path": os.path.join(
                    str(resource_type), os.path.basename(resource_path),
                ),
                "resource_type": resource_type,
            }
        }

    def get_resources(self):
        resources = {}
        single_file_resources = 0
        for resource in self.target_resource_classes:
            if getattr(resource, "single_file", False):
                index = single_file_resources
                single_file_resources += 1
            else:
                index = None

            resources.update(
                self._resource_mapping(
                    resource_type=resource,
                    resource_path=resource.arcadia_build_path,
                    index=index,
                )
            )
        for resource in self.source_classes:
            resource, file_path = resource
            if getattr(resource, "single_file", True):
                index = single_file_resources
                single_file_resources += 1
            else:
                index = None

            resources.update(
                self._resource_mapping(
                    resource_type=resource,
                    resource_path=file_path,
                    index=index,
                ),
            )

        return resources

    def get_yp_oauth_token(self):
        if self.Parameters.yp_token_yav_secret_id:
            yav_key = getattr(self.Parameters, 'yp_token_yav_secret_key', 'yp-token')
            return sdk2.yav.Secret(self.Parameters.yp_token_yav_secret_id.data()[yav_key])
        return super(BuildRtMoneyBinaries, self).get_yp_oauth_token()

    def on_release(self, additional_parameters):
        release_integration.ReleaseToYaDeployTask2.on_release(self, additional_parameters)
        YaMakeTemplate.YaMakeTemplate.on_release(self, additional_parameters)
