# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.user_sessions_rt.resources import HUMAN_RELEASERS


ROBOT_RELEASERS = [
    'robot-make-money',
]

GROUP_RELEASERS = [
    'RELEASE_MACHINE',
]

RELEASERS = HUMAN_RELEASERS + ROBOT_RELEASERS + GROUP_RELEASERS

DEFAULT_RESOURCE_TTL = 7


class BaseResource(sdk2.Resource):
    __abstract__ = True

    releasers = RELEASERS
    ttl = DEFAULT_RESOURCE_TTL


class RT_MONEY_BINARIES(BaseResource):
    __abstract__ = True
    auto_backup = True
    releasable = True
    executable = True
    auto_backup = True
    any_arch = False
    single_file = True


class QUEUE_DAEMON_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'ads/bsyeti/big_rt/queue_daemon/queue_daemon'


class SOLOMON_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'solomon/agent/bin/solomon-agent'


class DELAY_FOR_SYNC_PROFILES_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/delay_for_sync_profiles/money-rt-delay-for-sync-profiles'


class HIT_MASTER_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/hit_master/money-rt-hit-master'


class EVENT_STREAMER_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/event_streamer/money-rt-event-streamer'


class YT_TO_LB_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/yt_to_lb/money-rt-yt-to-lb'


class RESHARDER_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/resharder/money-rt-resharder'


class RESHARDER_PROFILE_INFO_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/resharder/money-rt-resharder'


class RESHARDER_BS_EVENT_LOG_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/resharder/money-rt-resharder'


class RESHARDER_BS_HIT_LOG_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/resharder/money-rt-resharder'


class SYNC_PROFILES_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/sync_profiles/money-rt-sync-profiles'


class HIT_PROFILE_STATE_OBSERVERS_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/processors/hit_profile_state_observers/hit-profile-state-observers'


class TABLE_BALANCER_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/rt/tools/table_balancer/us-rt-table-balancer'


class CONFIG_GENERATOR_RT_MONEY_BINARY(RT_MONEY_BINARIES):
    arcadia_build_path = 'quality/user_sessions/money_rt/packages/rt_money_config_generators/rt_money_config_generators'


class RT_MONEY_UDF(BaseResource):
    auto_backup = True
    calc_md5 = True
    share = True
    auto_backup = True
    releasable = True
    arcadia_build_path = 'yql/udfs/logs/rt_money'
