from sandbox import sdk2


TRANSCODER_RELEASERS = [
    "d-vilkova",
    "ezabolotskikh",
    "iemelyanov",
    "mvtomilov",
    "serjk86",
    "ucrop",
    "robot-testenv",
    "abramov-al",
    "dlukshto",
    "iadobryaev",
    "renkens"
]


class TranscoderResourceBase(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = TRANSCODER_RELEASERS
    ttl = 100


class TranscoderNitcBinary(TranscoderResourceBase):
    """Transcoder nitc binary."""
    pass


class TranscoderGraphs(TranscoderResourceBase):
    """Valhalla graphs for transcoding."""
    pass


class TranscoderDockerImage(TranscoderResourceBase):
    """Some docker image"""
    pass


class TranscoderCmpy(TranscoderResourceBase):
    """cmpy for transcoder CM"""
    pass


class ZenTranscoderCmpy(TranscoderResourceBase):
    """cmpy for ZEN transcoder CM"""
    pass


class TranscoderCmConfigs(TranscoderResourceBase):
    """config files for transcoder CM"""
    pass


class ZenTranscoderCmConfigs(TranscoderResourceBase):
    """config files for ZEN transcoder CM"""
    pass


class TranscoderS2TSignatureCombiner(TranscoderResourceBase):
    """S2T SignatureCombiner"""
    pass


class TranscoderS2TTranscoder(TranscoderResourceBase):
    """S2T Transcoder"""
    pass


class TranscoderSignaturesBin(TranscoderResourceBase):
    """SignaturesBin and Models Transcoder"""
    pass
