
from __future__ import absolute_import, print_function

import os


from sandbox import sdk2
from sandbox.common.types.task import ReleaseStatus
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common.juggler.jclient import send_events_to_juggler


class FlReadySwitches(sdk2.Resource):
    """
        Resource with hosts kernel info
    """


class BuildFlReadySwitches(sdk2.Task):
    """
        Get hosts kernel versions from heartbeat
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 4048
        ram = 4028

    class Parameters(sdk2.Task.Parameters):
        # walle_projects = sdk2.parameters.List("Walle projects")
        walle_tags = sdk2.parameters.List("Walle tags")
        check_diff = sdk2.parameters.Bool("Check diff")
        thresholds = sdk2.parameters.List("Thresholds")

    def on_execute(self):
        # walle_projects = self.Parameters.walle_projects
        walle_tags = self.Parameters.walle_tags
        check_diff = self.Parameters.check_diff
        thresholds = self.Parameters.thresholds

        kernel_info = sdk2.Resource["HOSTS_KERNEL"].find().order(-sdk2.Task.id).first()  # synchronizing resource data on disk
        kernel_info_data = sdk2.ResourceData(kernel_info)  # synchronizing resource data on disk
        kernel_info_path = str(kernel_info_data.path)

        netmon_topology = sdk2.Resource["NETMON_TOPOLOGY"].find().order(-sdk2.Task.id).first()  # synchronizing resource data on disk
        netmon_topology_data = sdk2.ResourceData(netmon_topology)  # synchronizing resource data on disk
        netmon_topology_path = str(netmon_topology_data.path)

        previous_output = sdk2.Resource["FL_READY_SWITCHES"].find().order(-sdk2.Task.id).first()  # synchronizing resource data on disk
        previous_output_data = sdk2.ResourceData(previous_output)  # synchronizing resource data on disk
        previous_output_path = str(previous_output_data.path)

        fl_checker = sdk2.Resource["RTC_TOOL_FL_CHECKER"].find(attrs=dict(released=ReleaseStatus.STABLE)).order(-sdk2.Task.id).first()  # synchronizing resource data on disk
        fl_checker_bin = sdk2.ResourceData(fl_checker)  # synchronizing resource data on disk
        fl_checker_bin_path = os.path.join(str(fl_checker_bin.path), 'fl_checker')
        out_path = str(self.path('fl_switches.msgpack.gz'))

        cmd_line = [fl_checker_bin_path,
                    'short',
                    '-nf', netmon_topology_path,
                    '-kf', kernel_info_path,
                    '-of' , out_path,
                    # '-f', 'by-walle-projects',
                    '-f', 'by-walle-tags',
                    '-fa']
        # cmd_line.extend(walle_projects)
        cmd_line.extend(walle_tags)

        with sdk2.helpers.ProcessLog(self, logger="short_report") as pl:
            pl.logger.propagate = 1
            ret = sp.Popen(cmd_line, stdout=pl.stdout, stderr=sp.STDOUT).wait()
        assert ret == 0, 'expected return code 0, got {}'.format(ret)

        if check_diff:
            cmd_line = [fl_checker_bin_path,
                        'diff',
                        '-p', previous_output_path,
                        '-c' , out_path]
            if thresholds:
                cmd_line.append('--thresholds')
                cmd_line.extend(thresholds)

            with sdk2.helpers.ProcessLog(self, logger="diff") as pl:
                pl.logger.propagate = 1
                ret = sp.Popen(cmd_line, stdout=pl.stdout, stderr=sp.STDOUT).wait()
            if ret == 2:
                send_events_to_juggler('sandbox.rtc.build_fl_ready_switches', 'short_report', 'CRIT', 'Threshold in diff exceeded')
                raise Exception('Threshold in diff exceeded')
            assert ret == 0, 'expected return code 0, got {}'.format(ret)

        output_resource = FlReadySwitches(self, "Switches FL status", out_path)
        sdk2.ResourceData(output_resource).ready()

        send_events_to_juggler('sandbox.rtc.build_fl_ready_switches', 'short_report', 'OK', 'Passed')
