# coding: utf-8
from __future__ import absolute_import, print_function

import gzip
import msgpack

from sandbox import sdk2

from sandbox.projects.common.juggler.jclient import send_events_to_juggler


class HostsKernel(sdk2.Resource):
    """
        Resource with hosts kernel info
    """


class BuildKernelInfo(sdk2.Task):
    """
        Get hosts kernel versions from heartbeat
    """

    class Requirements(sdk2.Task.Requirements):
        disk_space = 128
        ram = 128

    def on_execute(self):
        from api.heartbeat import hostsInfo
        packer = msgpack.Packer()
        hosts_info = hostsInfo()
        kernel_info = [{'fqdn': k, 'kernel': hosts_info[k][2]} for k in hosts_info]

        # HACKS

        # hosts without skynet
        kernel_info.append({'fqdn': 'man1-pgaas-0398.db.yandex.net', 'kernel': '4.19.119-30.2'})
        kernel_info.append({'fqdn': 'man1-pgaas-0402.db.yandex.net', 'kernel': '4.19.119-30.2'})
        kernel_info.append({'fqdn': 'man1-pgaas-0419.db.yandex.net', 'kernel': '4.19.119-30.2'})

        # windows hosts
        kernel_info.append({'fqdn': 'sql-addition2.mast.yandex-team.ru', 'kernel': '4.19.119-30.2'})

        out_path = str(self.path('kernel_info.msgpack.gz'))
        with gzip.GzipFile(out_path, 'wb') as f:
            f.write(packer.pack(kernel_info))
        output_resource = HostsKernel(self, "Hosts kernel info", out_path)
        sdk2.ResourceData(output_resource).ready()

        send_events_to_juggler('sandbox.rtc.build_kernel_info', 'kernel_info', 'OK', 'Passed')
