import os

from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sdk2.helpers import subprocess
from sandbox.sandboxsdk import environments, errors


class NannyDeployTimingsToStat(sdk2.Task):
    """
        RUNTIMECLOUD-5789
        This task:
        1. Checks out script that generates Nanny service deploy timings.
        2. Launches it in subprocess.
        This task is made to be executed by scheduler, every day in the morning
        due to upload previous day data.
    """

    def on_execute(self):
        """ Main executing code. """

        # https://wiki.yandex-team.ru/sandbox/vault/#izkodazadachi
        stat_oauth_token_secret_name = "nanny-robot-stat-oauth-token"
        stat_oauth_token = None
        try:
            stat_oauth_token = sdk2.Vault.data(stat_oauth_token_secret_name)
        except common.errors.VaultError:
            raise common.errors.TaskFailure("Can not read Stat OAuth token")

        yt_oauth_token_secret_name = "nanny-robot-yt-oauth-token"
        yt_oauth_token = None
        try:
            yt_oauth_token = sdk2.Vault.data(yt_oauth_token_secret_name)
        except common.errors.VaultError:
            raise common.errors.TaskFailure("Can not read YT OAuth token")

        arcadia_path = "arcadia:/arc/trunk/arcadia/infra/scripts/nanny_services_deploy_timings_to_stat/nanny_services_deploy_timings_to_stat.py"
        path = "."
        Arcadia.export(arcadia_path, path)

        with environments.VirtualEnvironment() as venv:
            venv.pip("pip==9.0.1")
            venv.pip("yandex-yt")
            venv.pip("numpy")
            venv.pip("requests[security]")
            venv.pip("yandex-yt-yson-bindings-skynet")
            os.environ['YT_TOKEN'] = yt_oauth_token
            os.environ['STAT_OAUTH_TOKEN'] = stat_oauth_token
            os.environ['REQUESTS_CA_BUNDLE'] = "/etc/ssl/certs/"
            retcode = subprocess.call([venv.executable,
                                       "nanny_services_deploy_timings_to_stat.py",
                                       "--upload-to-stat",
                                       "--use-skynet-python"])
            if retcode != 0:
                raise errors.SandboxTaskFailureError("Job failed, please see task logs.")
