import logging
from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments
from sandbox.projects.common.juggler import jclient

J_HOST = 'rtc-sysdev-sandbox'
J_CHECK_NAME = 'reboot_scheduler'
FILTER_HOSTS = {
    'project': ['rtc-testing-mtn', 'rtc-testing'],
    'names': ['sas1-8487.search.yandex.net', 'sas4-6770.search.yandex.net', 'sas1-8555.search.yandex.net', 'iva1-5841.search.yandex.net', 'myt1-1105.search.yandex.net', 'vla3-1682.search.yandex.net'],
    'state': 'assigned',
    'status': ['ready', 'dead']
}
IMPORTANT_CHEKS = ['unreachable', 'ssh', 'check_iss_agent']

logger = logging.getLogger(J_CHECK_NAME)


class RtcExperimentClusterSchedule(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment("wall-e.api>=6.1.4,<7.0.0")
        ]

    @common.utils.singleton_property
    def walle_client(self):
        import walle_api
        oauth_token = sdk2.Vault.data('robot-rtc-autoadmin')
        return walle_api.WalleClient(access_token=oauth_token)

    def get_hosts_need_reboot(self):
        result = []
        for host in self.walle_client.iter_hosts(fields=['inv', 'name', 'health'], **FILTER_HOSTS):
            logger.info(host)
            # Just in case
            if host['name'] not in FILTER_HOSTS['names']:
                continue
            inv = host['inv']
            flag_all_checks_ok = True
            for check in IMPORTANT_CHEKS:
                if host.get('health', {}).get('check_statuses', {}).get(check) != 'passed':
                    logger.info("{} won't restart becase {} isn't passed".format(inv, check))
                    flag_all_checks_ok = False
                    break
            if flag_all_checks_ok:
                result.append(inv)
        return result

    def on_execute(self):
        invs_list = self.get_hosts_need_reboot()
        if not invs_list:
            logger.info('No hosts for reboot')
            return
        for inv in invs_list:
            logger.info('Rebooting {}'.format(inv))
            self.walle_client.reboot_host(inv, ignore_cms=False, reason='RTCNETWORK-235')
        status, description = 'OK', 'Rebooted {} hosts'.format(len(invs_list))
        jclient.send_events_to_juggler(J_HOST, J_CHECK_NAME, status, description)
